/*****************************************************
Copyright Notice & Disclaimer

Copyright  Ascent, Dark Yoda and Otis

Permission to use, copy, modify, and distribute this software
and its documentation for any purpose is hereby granted without
fee, provided that the above copyright notice, author statement
appear in all copies of this software and related documentation.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF
ANY KIND, EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT
LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR A
PARTICULAR PURPOSE.

IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE,
AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION
WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
******************************************************/
//////////////////////////////////////////////////////////////////////
// FILE: ControlCntr.cpp
// PURPOSE: Implementation of the ControlCntr class. 
//////////////////////////////////////////////////////////////////////
// SHORT DESCRIPTION:
// This class implements the Model Control Center (MCC) dialog.
//
//////////////////////////////////////////////////////////////////////
// COPYRIGHTS:
//
// Programmed by:
// Frans 'Otis' Bouma,
// Greg 'Ascent' Dunn,
// Volker 'Dark Yoda' Schnefeld
//
// Code by Otis is (c)1999 Solutions Design, http://www.sd.nl
// Code by Ascent is (c)1999 Greg Dunn.
// Code by Dark Yoda is (c)1999 Volker Schnefeld.
// All rights reserved.
//////////////////////////////////////////////////////////////////////
// VERSION INFORMATION.
//
// 02-april-1999
// Release 2.1
// [OTIS] Added skinbrowsing
// [OTIS] Added disable/enable code for buttons in dialog
// [OTIS] Added flickerselection for textures
//
// 31-mar-1999
// [OTIS] Fixed resize bug
// [OTIS] Included reinit cycle system for texture refresh
// [OTIS] Implemented texture import/export
//
// 25-mar-1999
// [OTIS] Added texture selection, chromeflag toggle
// [OTIS] Added modelsave
// [OTIS] Improved initialize/loading scheme. Now bogus files are not loaded and no view is displayed
//
// 20-mar-1999
// [OTIS] Rewritten code for new naming schedule. Like hungarian.
// [OTIS] Move of iD and Valve c-lib files into the code dir.
// [OTIS] Cleaned up code by removing not used code and definitions.
//
// 16-mar-1999.
//		First public release.
//
// 15-mar-1999. 
//		First Internal Version
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "mdlv2.h"
#include "ControlCntr.h"

// Purpose: Constructor
CControlCntr::CControlCntr(CWnd* pParent /*=NULL*/)
	: CDialog(CControlCntr::IDD, pParent)
{
	//{{AFX_DATA_INIT(CControlCntr)
	m_CurrentSequenceTxt = _T("");
	m_FogEnabled = FALSE;
	m_CurrentSequenceNr = 0;
	m_SequenceLength = 0;
	m_MaxNrSequence = 0;
	m_ZoomFactor = 0;
	m_MaxNrBodies = 0;
	m_CurrentBodyNr = 0;
	m_sCurrentTexture = _T("");
	m_iMaxTexture = 0;
	m_ChromeEnabled = FALSE;
	m_iCurrentSkinNr = 0;
	m_iMaxSkinNr = 0;
	//}}AFX_DATA_INIT
	m_pCurrentDoc=NULL;
}

// Purpose: handles the DDX of vardata to dialogcontrols and vice versa
void 
CControlCntr::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlCntr)
	DDX_Text(pDX, IDC_CURRENTSEQUENCE, m_CurrentSequenceTxt);
	DDX_Check(pDX, IDC_FOG, m_FogEnabled);
	DDX_Text(pDX, IDC_NRCURRENTSEQUENCE, m_CurrentSequenceNr);
	DDX_Text(pDX, IDC_SEQUENCELENGTH, m_SequenceLength);
	DDX_Text(pDX, IDC_MAXNRSEQUENCE, m_MaxNrSequence);
	DDX_Text(pDX, IDC_ZOOMFACTOR, m_ZoomFactor);
	DDX_Text(pDX, IDC_MAXNRBODIES, m_MaxNrBodies);
	DDX_Text(pDX, IDC_CURRENTBODYNR, m_CurrentBodyNr);
	DDX_Text(pDX, IDC_CURTXTNR, m_sCurrentTexture);
	DDX_Text(pDX, IDC_MAXTXT, m_iMaxTexture);
	DDX_Check(pDX, IDC_TXTCHROME, m_ChromeEnabled);
	DDX_Text(pDX, IDC_CURRSKIN, m_iCurrentSkinNr);
	DDX_Text(pDX, IDC_MAXSKIN, m_iMaxSkinNr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CControlCntr, CDialog)
	//{{AFX_MSG_MAP(CControlCntr)
	ON_BN_CLICKED(IDC_PREVSEQUENCE, OnPrevsequence)
	ON_BN_CLICKED(IDC_SETBGCOLOR, OnSetbgcolor)
	ON_BN_CLICKED(IDC_FOG, OnFog)
	ON_BN_CLICKED(IDC_NEXTSEQUENCE, OnNextsequence)
	ON_BN_CLICKED(IDC_NEXTBODY, OnNextBody)
	ON_BN_CLICKED(IDC_RENDERMODE, OnRendermode)
	ON_NOTIFY(UDN_DELTAPOS, IDC_ZOOMINOUT, OnDeltaposZoominout)
	ON_NOTIFY(UDN_DELTAPOS, IDC_FOGDISTANCE, OnDeltaposFogdistance)
	ON_BN_CLICKED(IDC_SETLIGHTCOLOR, OnSetlightcolor)
	ON_BN_CLICKED(IDC_PREVTXT, OnPrevtxt)
	ON_BN_CLICKED(IDC_NEXTTXT, OnNexttxt)
	ON_BN_CLICKED(IDC_TXTCHROME, OnTxtchrome)
	ON_BN_CLICKED(IDC_EXPTXT, OnExptxt)
	ON_BN_CLICKED(IDC_IMPTXT, OnImptxt)
	ON_BN_CLICKED(IDC_NXTSKIN, OnNxtskin)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_TXTNONE, OnTxtnone)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// Purpose: handles click on IDC_PREVSEQUENCE
void 
CControlCntr::OnPrevsequence() 
{
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	// this function will send a message to the current active view and will cause a 
	// previous sequence action.
	CMdlView *pModel;
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	// move to previous sequence..
	pModel->PrevSequence();

	UpdateSequenceInfo(pModel);
}


// Purpose: handles click on IDC_SETBGCOLOR
void 
CControlCntr::OnSetbgcolor() 
{
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}

	int			iResult;
	COLORREF	crCol;
	CMdlView	*pModel;

	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();

	CColorDialog * dlgColorDialog = new CColorDialog( 0, 0, NULL  ); 
	iResult = dlgColorDialog->DoModal( );
	
	if(iResult==IDOK)
	{
		crCol = dlgColorDialog->GetColor();

		// set backgroundcolor...
		pModel->SetBGColor(GetRValue(crCol),GetGValue(crCol),GetBValue(crCol));
	}
}

// Purpose: handles click on IDC_FOG
void 
CControlCntr::OnFog() 
{
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}

	CMdlView *pModel;

	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	
	m_FogEnabled = (m_FogEnabled==false);
	pModel->ToggleFog((bool)m_FogEnabled);
	UpdateViewInfo(pModel);
}

// purpose: handles click in ICD_TXTCHROME
void 
CControlCntr::OnTxtchrome() 
{
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	CMdlView *pModel;

	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	pModel->ToggleCurTextChromeFlag();
	UpdateTextureInfo(pModel);
}


// Purpose: handles click on IDC_NEXTSEQUENCE
void 
CControlCntr::OnNextsequence() 
{
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}

	// this function will send a message to the current active view and will cause a 
	// next sequence action.
	CMdlView *pModel;
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	// move to previous sequence..
	pModel->NextSequence();

	UpdateSequenceInfo(pModel);
}

// Purpose: handles click on IDC_NEXTBODY
void 
CControlCntr::OnNextBody() 
{
	// TODO: Add your control notification handler code here
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}

	// this function will send a message to the current active view and will cause a 
	// next sequence action.
	CMdlView *pModel;
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	// move to next body
	pModel->NextBody();

	UpdateBodyInfo(pModel);
}

// Purpose: handle click on IDC_RENDERMODE
void 
CControlCntr::OnRendermode() 
{
	// TODO: Add your control notification handler code here
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}

	CMdlView *pModel;
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	// toggle rendermode...
	pModel->ToggleRenderMode();
}

// Purpose: handle ESC or close button event, so MCC doesn't get closed
void
CControlCntr::OnCancel()
{
	// do nothing
}

// Purpose: handle click on IDC_ZOOMINOUT
void 
CControlCntr::OnDeltaposZoominout(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CMdlView *pModel;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}

	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	
	if(pNMUpDown->iDelta<0)
	{
		m_ZoomFactor = -2;
	}
	else
	{
		m_ZoomFactor = 2;
	}
	// update dialog...
	CWnd::UpdateData(FALSE);

	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	pModel->Zoom(m_ZoomFactor);
	*pResult = 0;
}

// Purpose: handle click on IDC_FOGDISTANCE
void 
CControlCntr::OnDeltaposFogdistance(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CMdlView *pModel;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();

	if(pNMUpDown->iDelta<0)
	{
		pModel->IncFogDistance();
	}
	else
	{
		pModel->DecFogDistance();
	}
	*pResult = 0;
}


// Purpose: select previous texture. Handle click on IDC_PREVTXT
void CControlCntr::OnPrevtxt() 
{
	CMdlView *pModel;
	int		 iNr;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	iNr = pModel->GetCurrentTextureNr();
	iNr--;
	pModel->SetTextureNr(iNr);
	
	// update the data
	UpdateTextureInfo(pModel);
}


// Purpose: select next texture in line
void CControlCntr::OnNexttxt() 
{
	CMdlView *pModel;
	int		 iNr;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	iNr = pModel->GetCurrentTextureNr();
	iNr++;
	pModel->SetTextureNr(iNr);
	
	// update the data
	UpdateTextureInfo(pModel);
}


// Purpose: deselect all textures and return to texture 0, i.e none selected
void CControlCntr::OnTxtnone() 
{
	CMdlView *pModel;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	pModel->SetTextureNr(0);
	
	// update the data
	UpdateTextureInfo(pModel);
}


void CControlCntr::OnNxtskin() 
{
	CMdlView	*pModel;
	int			iNr;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	iNr=pModel->GetCurrentSkinNr();
	iNr++;
	pModel->SetCurrentSkinNr(iNr);
	UpdateTextureInfo(pModel);
}


void CControlCntr::OnExptxt() 
{
	CMdlView	*pModel;
	int			iNr;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	iNr = pModel->GetCurrentTextureNr();
	if(iNr!=0)
	{
		pModel->ExportCurrentTexture();
	}
}


void CControlCntr::OnImptxt() 
{
	CMdlView	*pModel;
	int			iNr;

	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();
	iNr = pModel->GetCurrentTextureNr();
	if(iNr!=0)
	{
		pModel->ImportCurrentTexture();
	}
}


// Purpose: handle click on IDC_SETLIGHTCOLOR
void 
CControlCntr::OnSetlightcolor() 
{
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	int			iResult;
	COLORREF	crCol;
	CMdlView	*pModel;

	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();

	CColorDialog * dlgColorDialog = new CColorDialog( 0, 0, NULL  ); 
	iResult = dlgColorDialog->DoModal( );
	
	if(iResult==IDOK)
	{
		crCol = dlgColorDialog->GetColor();

		// set light color...
		pModel->SetLightColor(GetRValue(crCol),GetGValue(crCol),GetBValue(crCol));	
	}
}


// Purpose: sets active documentpointer in the MCC and initializes the MCC
void
CControlCntr::ActiveDoc(CMdlv2Doc *pDoc)
{
	m_pCurrentDoc = pDoc;
	InitDialog();
}


// Purpose: marks the currently stored documentpointer as Not Valid
void
CControlCntr::SetNotValid(CMdlv2Doc *pDoc)
{
	if(m_pCurrentDoc==pDoc)
	{
		m_pCurrentDoc=NULL;
		ClearAll();
	}
}


// Purpose: initializes the MCC dialog with data of the currently active marked document if loaded.
void
CControlCntr::InitDialog()
{
	// disable closebutton.
	CMenu* mnu = this->GetSystemMenu(FALSE);
	mnu->ModifyMenu(SC_CLOSE,MF_BYCOMMAND | MF_GRAYED );
	
	if(m_pCurrentDoc==NULL)
	{
		// there is no model open.
		// insert default values.
		ClearAll();
	}
	else
	{
		UpdateAll();
	}
}


// Purpose: forces an update of all the info shown
void
CControlCntr::UpdateAll()
{
	// first check if there is something loaded
	if(m_pCurrentDoc==NULL)
	{
		return;
	}
	CMdlView *pModel;
	// get the mdlview object
	pModel = m_pCurrentDoc->GetMdlView();

	UpdateSequenceInfo(pModel);
	UpdateViewInfo(pModel);
	UpdateBodyInfo(pModel);
	UpdateTextureInfo(pModel);
	// ADD MORE SECTION UPDATE ROUTINES HERE
}


// Purpose: clears all data in controls of MCC
void
CControlCntr::ClearAll()
{
	m_CurrentSequenceTxt = "No Model Loaded...";
	m_FogEnabled = FALSE;
	m_MaxNrSequence=0;
	m_CurrentSequenceNr = 0;
	m_SequenceLength = 0;
	m_CurrentBodyNr = 0;
	m_MaxNrBodies = 0;
	m_ChromeEnabled=FALSE;
	m_iMaxTexture=0;
	m_sCurrentTexture="None";

	// ADD MORE VAR INIT STATEMENTS HERE...

	// update dialog...
	CWnd::UpdateData(FALSE);
}


// Purpose: updates the info in the view frame of the MCC
void 
CControlCntr::UpdateViewInfo(CMdlView *pModel)
{
	// get fogtoggle info.
	m_FogEnabled = pModel->GetFogToggleStatus();
	if(m_FogEnabled)
	{
		// enable fog distance buttons
		ChangeControlState(TRUE,IDC_FOGDISTANCE);
		ChangeControlState(TRUE,IDC_FDSTATIC);
	}
	else
	{
		// disable fog distance buttons
		ChangeControlState(FALSE,IDC_FOGDISTANCE);
		ChangeControlState(FALSE,IDC_FDSTATIC);
	}

	// update dialog...
	CWnd::UpdateData(FALSE);
}


// Purpose: updates the info in the sequence frame of the MCC
void
CControlCntr::UpdateSequenceInfo(CMdlView *pModel)
{
	// will update all the info in the dialog about current sequence.
	// get current sequencename...
	m_CurrentSequenceTxt = pModel->GetCurrentSequenceName();

	// get sequence nr.
	m_CurrentSequenceNr = pModel->GetCurrentSequenceNr();

	// get total # of sequences
	m_MaxNrSequence = pModel->GetMaxSequenceNr();

	// get sequence length
	m_SequenceLength = pModel->GetCurrentSequenceLength();

	if(m_MaxNrSequence<=1)
	{
		// no sequences to choose from -> disable buttons
		ChangeControlState(FALSE,IDC_PREVSEQUENCE);
		ChangeControlState(FALSE,IDC_NEXTSEQUENCE);
	}
	else
	{
		// enable buttons.
		ChangeControlState(TRUE,IDC_PREVSEQUENCE);
		ChangeControlState(TRUE,IDC_NEXTSEQUENCE);
	}

	// update dialog...
	CWnd::UpdateData(FALSE);
}


// Purpose: updates the info in the body frame of the MCC
void
CControlCntr::UpdateBodyInfo(CMdlView *pModel)
{
	m_CurrentBodyNr = pModel->GetCurrentBodyNr();
	m_MaxNrBodies = pModel->GetBodyAmount();
	if(m_MaxNrBodies<=1)
	{
		// no more bodies to choose from. disable button
		ChangeControlState(FALSE,IDC_NEXTBODY);
	}
	else
	{
		// enable button
		ChangeControlState(TRUE,IDC_NEXTBODY);
	}
	CWnd::UpdateData(FALSE);
}


// Purpose: updates the info in the texture frame of the MCC
void
CControlCntr::UpdateTextureInfo(CMdlView *pModel)
{
	int		iCT;
	
	iCT = pModel->GetCurrentTextureNr();
	if(iCT==0)
	{
		m_sCurrentTexture="None";
		// disable several controls...
		// disable import texture
		ChangeControlState(FALSE,IDC_IMPTXT);
		// disable export texture
		ChangeControlState(FALSE,IDC_EXPTXT);
		// disable chrometoggle
		ChangeControlState(FALSE,IDC_TXTCHROME);
	}
	else
	{
		m_sCurrentTexture.Format("%i",iCT);
		// enable several controls...
		// enable import texture
		ChangeControlState(TRUE,IDC_IMPTXT);
		// enable export texture
		ChangeControlState(TRUE,IDC_EXPTXT);
		// enable chrometoggle
		ChangeControlState(TRUE,IDC_TXTCHROME);
	}
	m_iMaxTexture = pModel->GetMaxTextureNr();
	m_ChromeEnabled = (BOOL)pModel->GetCurTextChromeFlag();
	m_iCurrentSkinNr=pModel->GetCurrentSkinNr();
	m_iMaxSkinNr=pModel->GetMaxSkinNr();
	if(m_iMaxSkinNr==1)
	{
		// no use of enabling next skin.. disable
		ChangeControlState(FALSE,IDC_NXTSKIN);
	}
	else
	{
		// enable next skin
		ChangeControlState(TRUE,IDC_NXTSKIN);
	}
	CWnd::UpdateData(FALSE);
}


// Purpose: changes dialog control iID's status, stated in bState
void
CControlCntr::ChangeControlState(BOOL bState, int iID)
{
	CWnd	*pCntrl;

	pCntrl = CWnd::GetDlgItem(iID);
	pCntrl->EnableWindow(bState);
}

