/***
*
*	Copyright (c) 1999, Valve LLC. All rights reserved.
*	
*	This product contains software technology licensed from Id 
*	Software, Inc. ("Id Technology").  Id Technology (c) 1996 Id Software, Inc. 
*	All Rights Reserved.
*
*   Use, distribution, and modification of this source code and/or resulting
*   object code is restricted to non-commercial enhancements to products from
*   Valve LLC.  All other use, distribution, or modification is prohibited
*   without written permission from Valve LLC.
*
****/
//=========================================================
// GameRules.cpp
//=========================================================

#include	"extdll.h"
#include	"util.h"
#include	"cbase.h"
#include	"player.h"
#include	"weapons.h"
#include	"gamerules.h"
#include	"teamplay_gamerules.h"
#include	"skill.h"

extern edict_t *EntSelectSpawnPoint( CBaseEntity *pPlayer );

DLL_GLOBAL CGameRules*	g_pGameRules = NULL;
extern DLL_GLOBAL BOOL	g_fGameOver;
extern int gmsgDeathMsg;	// client dll messages
extern int gmsgScoreInfo;
extern int gmsgMOTD;

//=========================================================
//=========================================================
BOOL CGameRules::CanHaveAmmo( CBasePlayer *pPlayer, const char *pszAmmoName, int iMaxCarry )
{
	int iAmmoIndex;

	if ( pszAmmoName )
	{
		iAmmoIndex = pPlayer->GetAmmoIndex( pszAmmoName );

		if ( iAmmoIndex > -1 )
		{
			if ( pPlayer->AmmoInventory( iAmmoIndex ) < iMaxCarry )
			{
				// player has room for more of this type of ammo
				return TRUE;
			}
		}
	}

	return FALSE;
}

//=========================================================
//=========================================================
edict_t *CGameRules :: GetPlayerSpawnSpot( CBasePlayer *pPlayer )
{
	edict_t *pentSpawnSpot = EntSelectSpawnPoint( pPlayer );

	pPlayer->pev->origin = VARS(pentSpawnSpot)->origin + Vector(0,0,1);
	pPlayer->pev->v_angle  = g_vecZero;
	pPlayer->pev->velocity = g_vecZero;
	pPlayer->pev->angles = VARS(pentSpawnSpot)->angles;
	pPlayer->pev->punchangle = g_vecZero;
	pPlayer->pev->fixangle = TRUE;
	
	return pentSpawnSpot;
}

//=========================================================
//=========================================================
BOOL CGameRules::CanHavePlayerItem( CBasePlayer *pPlayer, CBasePlayerItem *pWeapon )
{
	if ( pWeapon->pszAmmo1() )
	{
		if ( !CanHaveAmmo( pPlayer, pWeapon->pszAmmo1(), pWeapon->iMaxAmmo1() ) )
		{
			// we can't carry anymore ammo for this gun. We can only 
			// have the gun if we aren't already carrying one of this type
			if ( pPlayer->HasPlayerItem( pWeapon ) )
			{
				return FALSE;
			}
		}
	}
	else
	{
		// weapon doesn't use ammo, don't take another if you already have it.
		if ( pPlayer->HasPlayerItem( pWeapon ) )
		{
			return FALSE;
		}
	}

	// note: will fall through to here if GetItemInfo doesn't fill the struct!
	return TRUE;
}

//=========================================================
// load the SkillData struct with the proper values based on the skill level.
//=========================================================
void CGameRules::RefreshSkillData ( void )
{
	int	iSkill;

	iSkill = (int)CVAR_GET_FLOAT("skill");

	if ( iSkill < 1 )
	{
		iSkill = 1;
	}
	else if ( iSkill > 3 )
	{
		iSkill = 3; 
	}

	gSkillData.iSkillLevel = iSkill;

	ALERT ( at_console, "\nGAME SKILL LEVEL:%d\n",iSkill );

	//Agrunt		
	gSkillData.agruntHealth = GetSkillCvar( "sk_agrunt_health" );
	gSkillData.agruntDmgPunch = GetSkillCvar( "sk_agrunt_dmg_punch");

	// Apache 
	gSkillData.apacheHealth = GetSkillCvar( "sk_apache_health");

	// Barney
	gSkillData.barneyHealth = GetSkillCvar( "sk_barney_health");

	// Big Momma
	gSkillData.bigmommaHealthFactor = GetSkillCvar( "sk_bigmomma_health_factor" );
	gSkillData.bigmommaDmgSlash = GetSkillCvar( "sk_bigmomma_dmg_slash" );
	gSkillData.bigmommaDmgBlast = GetSkillCvar( "sk_bigmomma_dmg_blast" );
	gSkillData.bigmommaRadiusBlast = GetSkillCvar( "sk_bigmomma_radius_blast" );

	// Bullsquid
	gSkillData.bullsquidHealth = GetSkillCvar( "sk_bullsquid_health");
	gSkillData.bullsquidDmgBite = GetSkillCvar( "sk_bullsquid_dmg_bite");
	gSkillData.bullsquidDmgWhip = GetSkillCvar( "sk_bullsquid_dmg_whip");
	gSkillData.bullsquidDmgSpit = GetSkillCvar( "sk_bullsquid_dmg_spit");

	// Gargantua
	gSkillData.gargantuaHealth = GetSkillCvar( "sk_gargantua_health");
	gSkillData.gargantuaDmgSlash = GetSkillCvar( "sk_gargantua_dmg_slash");
	gSkillData.gargantuaDmgFire = GetSkillCvar( "sk_gargantua_dmg_fire");
	gSkillData.gargantuaDmgStomp = GetSkillCvar( "sk_gargantua_dmg_stomp");

	// Hassassin
	gSkillData.hassassinHealth = GetSkillCvar( "sk_hassassin_health");

	// Headcrab
	gSkillData.headcrabHealth = GetSkillCvar( "sk_headcrab_health");
	gSkillData.headcrabDmgBite = GetSkillCvar( "sk_headcrab_dmg_bite");

	// Hgrunt 
	gSkillData.hgruntHealth = GetSkillCvar( "sk_hgrunt_health");
	gSkillData.hgruntDmgKick = GetSkillCvar( "sk_hgrunt_kick");
	gSkillData.hgruntShotgunPellets = GetSkillCvar( "sk_hgrunt_pellets");
	gSkillData.hgruntGrenadeSpeed = GetSkillCvar( "sk_hgrunt_gspeed");

	// Houndeye
	gSkillData.houndeyeHealth = GetSkillCvar( "sk_houndeye_health");
	gSkillData.houndeyeDmgBlast = GetSkillCvar( "sk_houndeye_dmg_blast");

	// ISlave
	gSkillData.slaveHealth = GetSkillCvar( "sk_islave_health");
	gSkillData.slaveDmgClaw = GetSkillCvar( "sk_islave_dmg_claw");
	gSkillData.slaveDmgClawrake = GetSkillCvar( "sk_islave_dmg_clawrake");
	gSkillData.slaveDmgZap = GetSkillCvar( "sk_islave_dmg_zap");

	// Icthyosaur
	gSkillData.ichthyosaurHealth = GetSkillCvar( "sk_ichthyosaur_health");
	gSkillData.ichthyosaurDmgShake = GetSkillCvar( "sk_ichthyosaur_shake");

	// Leech
	gSkillData.leechHealth = GetSkillCvar( "sk_leech_health");

	gSkillData.leechDmgBite = GetSkillCvar( "sk_leech_dmg_bite");

	// Controller
	gSkillData.controllerHealth = GetSkillCvar( "sk_controller_health");
	gSkillData.controllerDmgZap = GetSkillCvar( "sk_controller_dmgzap");
	gSkillData.controllerSpeedBall = GetSkillCvar( "sk_controller_speedball");
	gSkillData.controllerDmgBall = GetSkillCvar( "sk_controller_dmgball");

	// Nihilanth
	gSkillData.nihilanthHealth = GetSkillCvar( "sk_nihilanth_health");
	gSkillData.nihilanthZap = GetSkillCvar( "sk_nihilanth_zap");

	// Scientist
	gSkillData.scientistHealth = GetSkillCvar( "sk_scientist_health");

	// Snark
	gSkillData.snarkHealth = GetSkillCvar( "sk_snark_health");
	gSkillData.snarkDmgBite = GetSkillCvar( "sk_snark_dmg_bite");
	gSkillData.snarkDmgPop = GetSkillCvar( "sk_snark_dmg_pop");

	// Zombie
	gSkillData.zombieHealth = GetSkillCvar( "sk_zombie_health");
	gSkillData.zombieDmgOneSlash = GetSkillCvar( "sk_zombie_dmg_one_slash");
	gSkillData.zombieDmgBothSlash = GetSkillCvar( "sk_zombie_dmg_both_slash");

	//Turret
	gSkillData.turretHealth = GetSkillCvar( "sk_turret_health");

	// MiniTurret
	gSkillData.miniturretHealth = GetSkillCvar( "sk_miniturret_health");
	
	// Sentry Turret
	gSkillData.sentryHealth = GetSkillCvar( "sk_sentry_health");

// PLAYER WEAPONS

	// Crowbar whack
	gSkillData.plrDmgCrowbar = GetSkillCvar( "sk_plr_crowbar");

	// Glock Round
	gSkillData.plrDmg9MM = GetSkillCvar( "sk_plr_9mm_bullet");

	// 357 Round
	gSkillData.plrDmg357 = GetSkillCvar( "sk_plr_357_bullet");

	// MP5 Round
	gSkillData.plrDmgMP5 = GetSkillCvar( "sk_plr_9mmAR_bullet");

	// M203 grenade
	gSkillData.plrDmgM203Grenade = GetSkillCvar( "sk_plr_9mmAR_grenade");

	// Shotgun buckshot
	gSkillData.plrDmgBuckshot = GetSkillCvar( "sk_plr_buckshot");

	// Crossbow
	gSkillData.plrDmgCrossbowClient = GetSkillCvar( "sk_plr_xbow_bolt_client");
	gSkillData.plrDmgCrossbowMonster = GetSkillCvar( "sk_plr_xbow_bolt_monster");

	// RPG
	gSkillData.plrDmgRPG = GetSkillCvar( "sk_plr_rpg");

	// Gauss gun
	gSkillData.plrDmgGauss = GetSkillCvar( "sk_plr_gauss");

	// Egon Gun
	gSkillData.plrDmgEgonNarrow = GetSkillCvar( "sk_plr_egon_narrow");
	gSkillData.plrDmgEgonWide = GetSkillCvar( "sk_plr_egon_wide");

	// Hand Grendade
	gSkillData.plrDmgHandGrenade = GetSkillCvar( "sk_plr_hand_grenade");

	// Satchel Charge
	gSkillData.plrDmgSatchel = GetSkillCvar( "sk_plr_satchel");

	// Tripmine
	gSkillData.plrDmgTripmine = GetSkillCvar( "sk_plr_tripmine");

	// MONSTER WEAPONS
	gSkillData.monDmg12MM = GetSkillCvar( "sk_12mm_bullet");
	gSkillData.monDmgMP5 = GetSkillCvar ("sk_9mmAR_bullet" );
	gSkillData.monDmg9MM = GetSkillCvar( "sk_9mm_bullet");

	// MONSTER HORNET
	gSkillData.monDmgHornet = GetSkillCvar( "sk_hornet_dmg");

	// PLAYER HORNET
// Up to this point, player hornet damage and monster hornet damage were both using
// monDmgHornet to determine how much damage to do. In tuning the hivehand, we now need
// to separate player damage and monster hivehand damage. Since it's so late in the project, we've
// added plrDmgHornet to the SKILLDATA struct, but not to the engine CVar list, so it's inaccesible
// via SKILLS.CFG. Any player hivehand tuning must take place in the code. (sjb)
	gSkillData.plrDmgHornet = 7;


	// HEALTH/CHARGE
	gSkillData.suitchargerCapacity = GetSkillCvar( "sk_suitcharger" );
	gSkillData.batteryCapacity = GetSkillCvar( "sk_battery" );
	gSkillData.healthchargerCapacity = GetSkillCvar ( "sk_healthcharger" );
	gSkillData.healthkitCapacity = GetSkillCvar ( "sk_healthkit" );
	gSkillData.scientistHeal = GetSkillCvar ( "sk_scientist_heal" );

	// monster damage adj
	gSkillData.monHead = GetSkillCvar( "sk_monster_head" );
	gSkillData.monChest = GetSkillCvar( "sk_monster_chest" );
	gSkillData.monStomach = GetSkillCvar( "sk_monster_stomach" );
	gSkillData.monLeg = GetSkillCvar( "sk_monster_leg" );
	gSkillData.monArm = GetSkillCvar( "sk_monster_arm" );

	// player damage adj
	gSkillData.plrHead = GetSkillCvar( "sk_player_head" );
	gSkillData.plrChest = GetSkillCvar( "sk_player_chest" );
	gSkillData.plrStomach = GetSkillCvar( "sk_player_stomach" );
	gSkillData.plrLeg = GetSkillCvar( "sk_player_leg" );
	gSkillData.plrArm = GetSkillCvar( "sk_player_arm" );
}

//=========================================================
// instantiate the proper game rules object
//=========================================================

CGameRules *InstallGameRules( void )
{
	SERVER_COMMAND( "exec game.cfg\n" );
	SERVER_EXECUTE( );

	if ( !gpGlobals->deathmatch )
	{
		// generic half-life
		return new CHalfLifeRules;
	}
	else
	{
		if ( CVAR_GET_FLOAT( "mp_teamplay" ) > 0 )
		{
			// teamplay
			return new CHalfLifeTeamplay;
		}
		if ((int)gpGlobals->deathmatch == 1)
		{
			// vanilla deathmatch
			return new CHalfLifeMultiplay;
		}
		else
		{
			// vanilla deathmatch??
			return new CHalfLifeMultiplay;
		}
	}
}



//*>* //not my code... don't give me credit :P
#include "decals.h"

BOOL CHalfLifeMultiplay::ClientCommand(CBasePlayer * pPlayer, const char * pCmd)
{
	static int te = -1;

	if ( FStrEq( pCmd, "menuselect" ) )
	{
		if ( CMD_ARGC() < 2 )
			return TRUE;

		int slot = atoi( CMD_ARGV(1) );

		// select the item from the current menu

		return TRUE;
	}
	else if ( FStrEq(pCmd, "TempEntity"))
	{
		// Temporary Entity Viewer:
		// Coded by Fade from 'The Fixxxer'
		// http://www.contaminated.net/fixxxer/
		int effect;

		if ( CMD_ARGC() >= 2 )
			effect = atoi( CMD_ARGV(1) );
		else
		{
			te++;
			if(te>TE_USERTRACER)
				te = 0;
			else if (te == 30)
				te = 99;
			effect = te;
		}

		CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, UTIL_VarArgs("Spawn Temp Entity %i\n",  effect ));

		TraceResult tr;
		short sprite1, sprite2, sprite3, model;

		UTIL_MakeVectors( pPlayer->pev->v_angle );
		Vector vecDir = gpGlobals->v_forward;

		UTIL_TraceLine( pPlayer->pev->origin, pPlayer->pev->origin+vecDir*256, dont_ignore_monsters, NULL, &tr);
		sprite1 = PRECACHE_MODEL("sprites/steam1.spr");
		sprite2 = PRECACHE_MODEL("sprites/laserbeam.spr");
		sprite3 = PRECACHE_MODEL("sprites/zerogxplode.spr");
		model = PRECACHE_MODEL("models/grenade.mdl");
		
		switch(effect)
		{
		case TE_BEAMPOINTS: // 0
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite2);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
				WRITE_BYTE(128);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_BEAMENTPOINT: // 1
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_SHORT(pPlayer->entindex());
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite2);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
				WRITE_BYTE(128);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_GUNSHOT: // 2
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
			MESSAGE_END();
			break;
		case TE_EXPLOSION: // 3
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite3);
				WRITE_BYTE(10);
				WRITE_BYTE(5);
				WRITE_BYTE(TE_EXPLFLAG_NONE);
			MESSAGE_END();
			break;
		case TE_TAREXPLOSION: // 4
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
			MESSAGE_END();
			break;
		case TE_SMOKE: // 5
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite1);
				WRITE_BYTE(10);
				WRITE_BYTE(10);
			MESSAGE_END();
			break;
		case TE_TRACER: // 6
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
			MESSAGE_END();
			break;
		case TE_LIGHTNING: // 7
			// NOTICE This message does not match it's desciption
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				// EXTRA DATA
				WRITE_SHORT(sprite2); // Sprite to use
			MESSAGE_END();
			break;
		case TE_BEAMENTS: // 8
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Sorry, can't do this one! Requires two entities.\n   This is the same as previous beams, but between two entities!\n");
			break;
		case TE_SPARKS: // 9
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
			MESSAGE_END();
			break;
		case TE_LAVASPLASH: // 10
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
			MESSAGE_END();
			break;
		case TE_TELEPORT: // 11
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
			MESSAGE_END();
			break;
		case TE_EXPLOSION2: // 12
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_BYTE(25);
				WRITE_BYTE(100);
			MESSAGE_END();
			break;
		case TE_BSPDECAL: // 13
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Sorry, not done yet...\n");
			break;
		case TE_IMPLOSION: // 14
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_BYTE(255);
				WRITE_BYTE(50);
				WRITE_BYTE(50);
			MESSAGE_END();
			break;
		case TE_SPRITETRAIL: // 15
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite3);
				WRITE_BYTE(10);
				WRITE_BYTE(50);
				WRITE_BYTE(10);
				WRITE_BYTE(20);
				WRITE_BYTE(10);
			MESSAGE_END();
			break;
		case TE_BEAM: // 16
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat,  "This message is obsolete\n");
			break;
		case TE_SPRITE: // 17
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite3);
				WRITE_BYTE(10);
				WRITE_BYTE(128);
			MESSAGE_END();
			break;
		case TE_BEAMSPRITE: // 18
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite2);
				WRITE_SHORT(sprite1);
			MESSAGE_END();
			break;
		case TE_BEAMTORUS: // 19
			MESSAGE_BEGIN( MSG_BROADCAST, SVC_TEMPENTITY );
				WRITE_BYTE( TE_BEAMTORUS);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z + 32);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z + 32 + 120 * 2 / 20);
				WRITE_SHORT(sprite1);
				WRITE_BYTE( 0 ); // startframe
				WRITE_BYTE( 0 ); // framerate
				WRITE_BYTE( 20 ); // life
				WRITE_BYTE( 12 );  // width
				WRITE_BYTE( 0 );   // noise
				WRITE_BYTE( 255 );   // r, g, b
				WRITE_BYTE( 160 );   // r, g, b
				WRITE_BYTE( 100 );   // r, g, b
				WRITE_BYTE( 255 );	 // brightness
				WRITE_BYTE( 0 );	// speed
			MESSAGE_END();
			break;
		case TE_BEAMDISK: // 20
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(0);
				WRITE_COORD(0);
				WRITE_COORD(128);
				WRITE_SHORT(sprite2);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_BEAMCYLINDER: // 21
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(0);
				WRITE_COORD(0);
				WRITE_COORD(128);
				WRITE_SHORT(sprite2);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
				WRITE_BYTE(100);
				WRITE_BYTE(100);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
				WRITE_BYTE(255);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_BEAMFOLLOW: // 22
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "You need to be moving (backwards) to see the effect of this!\n");
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_SHORT(pPlayer->entindex());
				WRITE_SHORT(sprite1);
				WRITE_BYTE(50);
				WRITE_BYTE(50);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
				WRITE_BYTE(255);
				WRITE_BYTE(128);
			MESSAGE_END();
			break;
		case TE_GLOWSPRITE: // 23
			// NOTICE: This message DOE NOT match it's desciption
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite3);
				WRITE_BYTE(10);
				// EXTRA DATA
				WRITE_BYTE(10);	// Size
				WRITE_BYTE(128);// Brightness
			MESSAGE_END();
			break;
		case TE_BEAMRING: // 24
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Cannot do this message (yet), need two entities!\n");
			break;
		case TE_STREAK_SPLASH: // 25
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(0);
				WRITE_COORD(0);
				WRITE_COORD(1);
				WRITE_BYTE(10);
				WRITE_SHORT(100);
				WRITE_SHORT(100);
				WRITE_SHORT(100);
			MESSAGE_END();
			break;
		case TE_BEAMHOSE: // 26
			ALERT(at_console, "This message is obsolete\n");
			break;
		case TE_DLIGHT: // 27
			// NOTICE Message is different from definition (thanks Mach III for the info!)
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_BYTE(25);

				WRITE_BYTE(0);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				// BRIGHTNESS REMOVED!
				WRITE_BYTE(255);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_ELIGHT: // 28
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_SHORT(pPlayer->entindex());
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(200);
				WRITE_BYTE(0);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(100);
				WRITE_COORD(0);
			MESSAGE_END();
			break;
		case TE_TEXTMESSAGE: // 29
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_SHORT(-1);
				WRITE_SHORT(-1);
				WRITE_BYTE(1);
				WRITE_BYTE(255); // red
				WRITE_BYTE(255); // green
				WRITE_BYTE(255); // blue
				WRITE_BYTE(64);  // alpha (transparancy)
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_SHORT(40);
				WRITE_SHORT(40);
				WRITE_SHORT(40);
				WRITE_STRING("Hello from TE_TEXTMESSAGE");
			MESSAGE_END();
			break;
		case TE_KILLBEAM: // 99
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Killing beams attached to the player...\n");
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_SHORT(pPlayer->entindex());
			MESSAGE_END();
			break;
		case TE_LARGEFUNNEL: // 100
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite1);
				WRITE_SHORT(0);
			MESSAGE_END();
			break;
		case TE_BLOODSTREAM: // 101
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(0);
				WRITE_COORD(0);
				WRITE_COORD(1);
				WRITE_BYTE(BLOOD_COLOR_YELLOW);
				WRITE_BYTE(200);
			MESSAGE_END();
			break;
		case TE_SHOWLINE: // 102
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
			MESSAGE_END();
			break;
		case TE_BLOOD: // 103
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(0);
				WRITE_COORD(0);
				WRITE_COORD(1);
				WRITE_BYTE(BLOOD_COLOR_YELLOW);
				WRITE_BYTE(200);
			MESSAGE_END();
			break;
		case TE_DECAL: // 104
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Not done yet\n");
			break;
		case TE_FIZZ: // 105
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_SHORT(pPlayer->entindex());
				WRITE_SHORT(sprite1);
				WRITE_BYTE(20);
			MESSAGE_END();
			break;
		case TE_MODEL: // 106
			ALERT(at_console, "Look at MP5 shells for a better example...\n");
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(0);
				WRITE_COORD(100);
				WRITE_COORD(100);
				WRITE_ANGLE(25);
				WRITE_SHORT(model);
				WRITE_BYTE(TE_BOUNCE_SHOTSHELL);
				WRITE_BYTE(20);
			MESSAGE_END();
			break;
		case TE_EXPLODEMODEL: // 107
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(100);
				WRITE_SHORT(model);
				WRITE_SHORT(20);
				WRITE_BYTE(150);
			MESSAGE_END();
			break;
		case TE_BREAKMODEL: // 108
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(100);
				WRITE_COORD(100);
				WRITE_COORD(100);
				WRITE_COORD(0);
				WRITE_COORD(0);
				WRITE_COORD(120);
				WRITE_BYTE(10);
				WRITE_SHORT(model);
				WRITE_BYTE(5);
				WRITE_BYTE(25);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_GUNSHOTDECAL: // 109
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "You probably need to be close to a wall for this to work\n");
			if(tr.pHit)
			{
				MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
					WRITE_BYTE(effect);
					WRITE_COORD(tr.vecEndPos.x);
					WRITE_COORD(tr.vecEndPos.y);
					WRITE_COORD(tr.vecEndPos.z);
					WRITE_SHORT((short)ENTINDEX(tr.pHit));
					WRITE_BYTE(0); // Should be correct decal!
				MESSAGE_END();
			}
			break;
		case TE_SPRITE_SPRAY: // 110
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(0);
				WRITE_COORD(0);
				WRITE_COORD(50);
				WRITE_SHORT(sprite3);
				WRITE_BYTE(5);
				WRITE_BYTE(120);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_ARMOR_RICOCHET: // 111
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_BYTE(100);
			MESSAGE_END();
			break;
		case TE_PLAYERDECAL: // 112
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "You probably need to be close to a wall for this to work\n");
			if(tr.pHit)
			{
				MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
					WRITE_BYTE(effect);
					WRITE_BYTE((BYTE)pPlayer->entindex());
					WRITE_COORD(tr.vecEndPos.x);
					WRITE_COORD(tr.vecEndPos.y);
					WRITE_COORD(tr.vecEndPos.z);
					WRITE_SHORT((short)ENTINDEX(tr.pHit));
					WRITE_BYTE(0); // ?
				MESSAGE_END();
			}
			break;
		case TE_BUBBLES: // 113
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(120);
				WRITE_SHORT(sprite1);
				WRITE_BYTE(5);
				WRITE_COORD(100);
			MESSAGE_END();
			break;
		case TE_BUBBLETRAIL: // 114
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_COORD(120);
				WRITE_SHORT(sprite1);
				WRITE_BYTE(5);
				WRITE_COORD(100);
			MESSAGE_END();
			break;
		case TE_BLOODSPRITE: // 115
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(sprite1);
				WRITE_SHORT(sprite1);
				WRITE_BYTE(BLOOD_COLOR_RED);
				WRITE_BYTE(10);
			MESSAGE_END();
			break;
		case TE_WORLDDECAL: // 116
		case TE_WORLDDECALHIGH: // 117
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "You probably need to be close to a wall for this to work\n");
			if(gDecals[0].index > 256)
			{
				MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
					WRITE_BYTE(TE_WORLDDECAL);
					WRITE_COORD(tr.vecEndPos.x);
					WRITE_COORD(tr.vecEndPos.y);
					WRITE_COORD(tr.vecEndPos.z);
					WRITE_BYTE(gDecals[0].index);
				MESSAGE_END();
			}
			else if(sprite1 <= 512)
			{
				MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
					WRITE_BYTE(TE_WORLDDECAL);
					WRITE_COORD(tr.vecEndPos.x);
					WRITE_COORD(tr.vecEndPos.y);
					WRITE_COORD(tr.vecEndPos.z);
					WRITE_BYTE(gDecals[0].index-256);
				MESSAGE_END();
			}
			break;
		case TE_DECALHIGH: // 118
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Couldn't be bothered to do this one, see TE_DECAL\n");
			break;
		case TE_PROJECTILE: // 119
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(vecDir.x*50);
				WRITE_COORD(vecDir.y*50);
				WRITE_COORD(vecDir.z*50);
				WRITE_SHORT(model);
				WRITE_BYTE(100);
				WRITE_BYTE((BYTE)pPlayer->entindex());
			MESSAGE_END();
			break;
		case TE_SPRAY: // 120
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(vecDir.x);
				WRITE_COORD(vecDir.y);
				WRITE_COORD(vecDir.z);
				WRITE_SHORT(sprite1);
				WRITE_BYTE(8);
				WRITE_BYTE(120);
				WRITE_BYTE(0);
				WRITE_BYTE(0);
			MESSAGE_END();
			break;
		case TE_PLAYERSPRITES: // 121
			// NOTICE: This differs from it's definition, there is an extra byte but I am not sure how
			// it is used
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Error occurs on use\n");
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_BYTE((BYTE)pPlayer->entindex());
				WRITE_SHORT(sprite1);
				WRITE_BYTE(10);
				WRITE_BYTE(10);
				WRITE_BYTE(10);
			MESSAGE_END();
			break;
		case TE_PARTICLEBURST: // 122
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(256);
				WRITE_BYTE(148);
				WRITE_BYTE(100);
			MESSAGE_END();
			break;
		case TE_FIREFIELD: // 123
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(tr.vecEndPos.x);
				WRITE_COORD(tr.vecEndPos.y);
				WRITE_COORD(tr.vecEndPos.z);
				WRITE_SHORT(256);
				WRITE_SHORT(sprite1);
				WRITE_BYTE(10);
				WRITE_BYTE(TEFIRE_FLAG_LOOP|TEFIRE_FLAG_SOMEFLOAT|TEFIRE_FLAG_PLANAR);
				WRITE_BYTE(20);
			MESSAGE_END();
			break;
		case TE_PLAYERATTACHMENT: // 124
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Look up!\n");
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_BYTE((BYTE)pPlayer->entindex());
				WRITE_COORD(80);
				WRITE_SHORT(sprite1);
				WRITE_SHORT(50);
			MESSAGE_END();
			break;
		case TE_KILLPLAYERATTACHMENTS: // 125
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Killing player attachments\n");
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_BYTE((BYTE)pPlayer->entindex());
			MESSAGE_END();
			break;
		case TE_MULTIGUNSHOT: // 126
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(vecDir.x);
				WRITE_COORD(vecDir.y);
				WRITE_COORD(vecDir.z);
				WRITE_COORD(100);
				WRITE_COORD(100);
				WRITE_BYTE(10);
				WRITE_BYTE(gDecals[0].index); // ??
			MESSAGE_END();
			break;
		case TE_USERTRACER: // 127
			MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pPlayer->pev->origin);
				WRITE_BYTE(effect);
				WRITE_COORD(pPlayer->pev->origin.x);
				WRITE_COORD(pPlayer->pev->origin.y);
				WRITE_COORD(pPlayer->pev->origin.z);
				WRITE_COORD(vecDir.x*10);
				WRITE_COORD(vecDir.y*10);
				WRITE_COORD(vecDir.z*10);
				WRITE_BYTE(50);
				WRITE_BYTE(0);	
				WRITE_BYTE(255);
			MESSAGE_END();
			break;
		default:
			CLIENT_PRINTF( ENT(pPlayer->pev), print_chat, "Unknown TE!\n");
		}
		return TRUE;
	}

	return FALSE;
}
//*<* end of not my code