#include <stdio.h>
#include <string.h>
#include "..\regex.h"

int main(void)
{
	char str[256],regex[256];
	regex_t comp;
	regmatch_t matches[10];

	while (1)
	{
		int nomatch,err;

		printf("Enter a string: ");
		if (fgets(str,255,stdin)==NULL) return 0;
		str[strlen(str)-1]=0;
		printf("Enter a regex: ");
		if (fgets(regex,255,stdin)==NULL) return 0;
		regex[strlen(regex)-1]=0;
		if (err=regcomp(&comp,regex,REG_EXTENDED))
		{
			char error[256];
			regerror(err,&comp,error,255);
			printf("Error in regcomp: %s\n",error);
			return 1;
		}

		nomatch=regexec(&comp,str,10,matches,0);
		if (!nomatch)
		{
			int x;

			printf("String matched regexp:\n");
			for (x=0;x<10&&(matches[x].rm_so>=0);x++)
			{
				int p=0;
				while (str[p]!=0)
				{
					if (p==matches[x].rm_so) printf("(");
					if (p==matches[x].rm_eo) printf(")");
					if (str[p]=='(') printf("\\(");
					else if (str[p]==')') printf("\\)");
					else printf("%c",str[p]);
					p++;
				}
				if (p==matches[x].rm_eo) printf(")");
				printf("\n");
			}
		} else {			
			char error[256];
			regerror(nomatch,&comp,error,255);
			printf("Error in regexec: %s\n",error);
		}
		regfree(&comp);
	}
}