/*
	Copyright (c) 1999, Cold Ice Modification. 
	
	This code has been written by SlimShady ( darcuri@optonline.net )

    Use, distribution, and modification of this source code and/or resulting
    object code is restricted to non-commercial enhancements to products from
    Valve LLC.  All other use, distribution, or modification is prohibited
    without written permission from Valve LLC and from the Cold Ice team.

    Please if you use this code in any public form, please give us credit.

*/


#ifndef WEAPONS_H
#define WEAPONS_H


class CBasePlayer;
extern int gmsgWeapPickup;

//void DeactivateSatchels( CBasePlayer *pOwner );

class CGrenade : public CBaseMonster
{
public:
	void Spawn( void );

	typedef enum { SATCHEL_DETONATE = 0, SATCHEL_RELEASE } SATCHELCODE;
	
	static CGrenade *ShootContact( entvars_t *pevOwner, Vector vecStart, Vector vecVelocity );
	static CGrenade *ShootSatchelCharge( entvars_t *pevOwner, Vector vecStart, Vector vecVelocity );
	static void UseSatchelCharges( entvars_t *pevOwner, SATCHELCODE code );
	static CGrenade *ShootTimed( entvars_t *pevOwner, Vector vecStart, Vector vecVelocity, float time );
	
	static CGrenade *ShootClusterGrenade( entvars_t *pevOwner, Vector vecStart, Vector vecVelocity, float time );
	static CGrenade *ShootCluster( entvars_t *pevOwner, Vector vecStart, Vector vecVelocity, float time );
	
	void Explode( Vector vecSrc, Vector vecAim );
	void Explode( TraceResult *pTrace, int bitsDamageType );
	void EXPORT Smoke( void );

	void EXPORT ClusterTumbleThink( void );		
	void EXPORT ClusterLaunch( void );
	void EXPORT ClusterDetonate( void );
	entvars_t *clusterOwner;

	void EXPORT BounceTouch( CBaseEntity *pOther );
	void EXPORT SlideTouch( CBaseEntity *pOther );
	void EXPORT ExplodeTouch( CBaseEntity *pOther );
	void EXPORT DangerSoundThink( void );
	void EXPORT PreDetonate( void );
	void EXPORT Detonate( void );
	void EXPORT DetonateUse( CBaseEntity *pActivator, CBaseEntity *pCaller, USE_TYPE useType, float value );
	void EXPORT TumbleThink( void );

	virtual void BounceSound( void );
	virtual int	BloodColor( void ) { return DONT_BLEED; }
	virtual void Killed( entvars_t *pevAttacker, int iGib );

	BOOL m_fRegisteredSound;// whether or not this grenade has issued its DANGER sound to the world sound list yet.
};


// constant items
#define ITEM_HEALTHKIT	     	1
#define ITEM_BATTERY	      	2

#define WEAPON_NONE				0
#define WEAPON_CROWBAR			1
#define WEAPON_KNIFE			2
#define WEAPON_SWORD			3
#define WEAPON_PPK              4
#define WEAPON_MAG60            5
#define WEAPON_M16				6
#define WEAPON_UZI				7
#define WEAPON_MAC10			8
#define WEAPON_DOUBLEUZI		9
#define WEAPON_ASHOTGUN			10
#define WEAPON_SSHOTGUN			11
#define WEAPON_CHAINGUN			12
#define WEAPON_RIFLE			13
#define WEAPON_BOLTGUN			14
#define WEAPON_GRENADEL			15
#define WEAPON_CLUSTERGRENADE	16
#define WEAPON_RAILGUN     		17
#define WEAPON_PULSERIFLE     	18
#define WEAPON_CHUMTOAD			19
#define WEAPON_ROCKETL     		20
#define WEAPON_TNT     		    21
#define WEAPON_TRIPMINE    		22
#define WEAPON_NUKE				23

#define WEAPON_ALLWEAPONS		(~(1<<WEAPON_SUIT))
#define WEAPON_SUIT				31	
#define MAX_WEAPONS			    32


#define MAX_NORMAL_BATTERY	    100


// weapon weight factors (for auto-switching)   (-1 = noswitch)
#define CROWBAR_WEIGHT				0
#define KNIFE_WEIGHT				2
#define SWORD_WEIGHT				4
#define PPK_WEIGHT					10
#define BOLTGUN_WEIGHT				10
#define SSHOTGUN_WEIGHT				12
#define MAG60_WEIGHT				14
#define ASHOTGUN_WEIGHT				15
#define CHAINGUN_WEIGHT				15
#define M16_WEIGHT					15
#define UZI_WEIGHT					15
#define RAILGUN_WEIGHT				16
#define MAC10_WEIGHT				16
#define GRENADEL_WEIGHT				18
#define PULSERIFLE_WEIGHT			18
#define RIFLE_WEIGHT				20
#define DOUBLEUZI_WEIGHT			20
#define ROCKETL_WEIGHT				20
#define TRIPMINE_WEIGHT				20
#define CHUMTOAD_WEIGHT				22
#define CLUSTERGRENADE_WEIGHT		24
#define TNT_WEIGHT					30
#define NUKE_WEIGHT					40

// weapon clip/carry ammo capacities
#define PPK_MAX_CARRY				 64
#define MAG60_MAX_CARRY				 128
#define	M16_MAX_CARRY				 75
#define	UZI_MAX_CARRY				 96
#define	MAC10_MAX_CARRY				 96
#define DOUBLEUZI_MAX_CARRY			 192
#define BUCKSHOT_MAX_CARRY			 96
#define BOLTGUN_MAX_CARRY			 50
#define CHAINGUN_MAX_CARRY			 200
#define RIFLE_MAX_CARRY				 20
#define GRENADEL_MAX_CARRY			 18
#define CLUSTERGRENADE_MAX_CARRY     2
#define TIMED_MAX_CARRY				 8
#define RAILGUN_MAX_CARRY			 100
#define PULSERIFLE_MAX_CARRY		 100
#define CHUMTOAD_MAX_CARRY			 5
#define ROCKETL_MAX_CARRY			 5
#define HELIROCKET_MAX_CARRY		 2
#define TRIPMINE_MAX_CARRY			 2
#define TNT_MAX_CARRY				 1
#define NUKE_MAX_CARRY				 2

// the maximum amount of ammo each weapon's clip can hold
#define WEAPON_NOCLIP			-1
#define PPK_MAX_CLIP            8
#define MAG60_MAX_CLIP			28
#define M16_MAX_CLIP			30
#define UZI_MAX_CLIP			32
#define MAC10_MAX_CLIP			32
#define DOUBLEUZI_MAX_CLIP      64
#define SSHOTGUN_MAX_CLIP		2
#define ASHOTGUN_MAX_CLIP		16
#define CHAINGUN_MAX_CLIP       100
#define RIFLE_MAX_CLIP          10
#define BOLTGUN_MAX_CLIP		30
#define GRENADEL_MAX_CLIP		6
#define ROCKETL_MAX_CLIP		1
#define NUKE_MAX_CLIP			1

// the default amount of ammo that comes with each gun when it spawns
#define PPK_DEFAULT_GIVE            72
#define MAG60_DEFAULT_GIVE			156
#define M16_DEFAULT_GIVE			105
#define UZI_DEFAULT_GIVE			128
#define MAC10_DEFAULT_GIVE			128
#define DOUBLEUZI_DEFAULT_GIVE      64
#define SSHOTGUN_DEFAULT_GIVE		98
#define ASHOTGUN_DEFAULT_GIVE		112
#define CHAINGUN_DEFAULT_GIVE       260
#define RIFLE_DEFAULT_GIVE          30
#define BOLTGUN_DEFAULT_GIVE		105
#define GRENADEL_DEFAULT_GIVE		24
#define CLUSTERGRENADE_DEFAULT_GIVE 1
#define RAILGUN_DEFAULT_GIVE		100
#define PULSERIFLE_DEFAULT_GIVE		100
#define CHUMTOAD_DEFAULT_GIVE	    5
#define ROCKETL_DEFAULT_GIVE		6
#define TRIPMINE_DEFAULT_GIVE	    2
#define TNT_DEFAULT_GIVE	      	1
#define NUKE_DEFAULT_GIVE			3

// The amount of ammo given to a player by an ammo item.
#define AMMO_PPKCLIP_GIVE       24
#define AMMO_MAGCLIP_GIVE		28
#define AMMO_M16CLIP_GIVE		30
#define AMMO_UZICLIP_GIVE		32
#define AMMO_BUCKSHOTBOX_GIVE	24
#define AMMO_CHAINGUNBOX_GIVE	60
#define AMMO_RIFLECLIP_GIVE	    10
#define AMMO_BOLTGUN_GIVE	    30
#define AMMO_RAILSLUG_GIVE		25
#define AMMO_PULSEAMMO_GIVE     25
#define AMMO_CONTACT_GIVE		2
#define AMMO_TIMED_GIVE		    2
#define AMMO_ROCKET_GIVE		2
#define AMMO_NUKECLIP_GIVE		1

// bullet types
typedef	enum
{
	BULLET_NONE = 0,	
	BULLET_PLAYER_CROWBAR, 
	BULLET_PLAYER_9MM, 
	BULLET_PLAYER_MP5,  
	BULLET_PLAYER_765MM,  
	BULLET_PLAYER_BUCKSHOT, 


	BULLET_MONSTER_9MM,
	BULLET_MONSTER_MP5,
	BULLET_MONSTER_12MM,
} Bullet;


#define ITEM_FLAG_SELECTONEMPTY		1
#define ITEM_FLAG_NOAUTORELOAD		2
#define ITEM_FLAG_NOAUTOSWITCHEMPTY	4
#define ITEM_FLAG_LIMITINWORLD		8
#define ITEM_FLAG_EXHAUSTIBLE		16 // A player can totally exhaust their ammo supply and lose this weapon

#define WEAPON_IS_ONTARGET 0x40

typedef struct
{
	int		iSlot;
	int		iPosition;
	const char	*pszAmmo1;	// ammo 1 type
	int		iMaxAmmo1;		// max ammo 1
	const char	*pszAmmo2;	// ammo 2 type
	int		iMaxAmmo2;		// max ammo 2
	const char	*pszName;
	int		iMaxClip;
	int		iId;
	int		iFlags;
	int		iWeight;// this value used to determine this weapon's importance in autoselection.
} ItemInfo;

typedef struct
{
	const char *pszName;
	int iId;
} AmmoInfo;

// Items that the player has in their inventory that they can use
class CBasePlayerItem : public CBaseAnimating
{
public:
	virtual void SetObjectCollisionBox( void );

	virtual int		Save( CSave &save );
	virtual int		Restore( CRestore &restore );
	
	static	TYPEDESCRIPTION m_SaveData[];

	virtual int AddToPlayer( CBasePlayer *pPlayer );	// return TRUE if the item you want the item added to the player inventory
	virtual int AddDuplicate( CBasePlayerItem *pItem ) { return FALSE; }	// return TRUE if you want your duplicate removed from world
	void EXPORT DestroyItem( void );
	void EXPORT DefaultTouch( CBaseEntity *pOther );	// default weapon touch
	void EXPORT FallThink ( void );// when an item is first spawned, this think is run to determine when the object has hit the ground.
	void EXPORT Materialize( void );// make a weapon visible and tangible
	void EXPORT AttemptToMaterialize( void );  // the weapon desires to become visible and tangible, if the game rules allow for it
	CBaseEntity* Respawn ( void );// copy a weapon
	void FallInit( void );
	void CheckRespawn( void );
	virtual int GetItemInfo(ItemInfo *p) { return 0; };	// returns 0 if struct not filled out
	virtual BOOL CanDeploy( void ) { return TRUE; };
	virtual BOOL Deploy( )								// returns is deploy was successful
		 { return TRUE; };

	virtual BOOL CanHolster( void ) { return TRUE; };// can this weapon be put away right now?
	virtual void Holster( );
	virtual void UpdateItemInfo( void ) { return; };

	virtual void ItemPreFrame( void )	{ return; }		// called each frame by the player PreThink
	virtual void ItemPostFrame( void ) { return; }		// called each frame by the player PostThink

	virtual void Drop( void );
	virtual void Kill( void );
	virtual void AttachToPlayer ( CBasePlayer *pPlayer );

	virtual int PrimaryAmmoIndex() { return -1; };
	virtual int SecondaryAmmoIndex() { return -1; };

	virtual int UpdateClientData( CBasePlayer *pPlayer ) { return 0; }

	static ItemInfo ItemInfoArray[ MAX_WEAPONS ];
	static AmmoInfo AmmoInfoArray[ MAX_AMMO_SLOTS ];

	CBasePlayer	*m_pPlayer;
	CBasePlayerItem *m_pNext;
	int		m_iId;												// WEAPON_???

	virtual int iItemSlot( void ) { return 0; }			// return 0 to MAX_ITEMS_SLOTS, used in hud

	int			iItemPosition( void ) { return ItemInfoArray[ m_iId ].iPosition; }
	const char	*pszAmmo1( void )	{ return ItemInfoArray[ m_iId ].pszAmmo1; }
	int			iMaxAmmo1( void )	{ return ItemInfoArray[ m_iId ].iMaxAmmo1; }
	const char	*pszAmmo2( void )	{ return ItemInfoArray[ m_iId ].pszAmmo2; }
	int			iMaxAmmo2( void )	{ return ItemInfoArray[ m_iId ].iMaxAmmo2; }
	const char	*pszName( void )	{ return ItemInfoArray[ m_iId ].pszName; }
	int			iMaxClip( void )	{ return ItemInfoArray[ m_iId ].iMaxClip; }
	int			iWeight( void )		{ return ItemInfoArray[ m_iId ].iWeight; }
	int			iFlags( void )		{ return ItemInfoArray[ m_iId ].iFlags; }

	// int		m_iIdPrimary;										// Unique Id for primary ammo
	// int		m_iIdSecondary;										// Unique Id for secondary ammo
};


// inventory items that 
class CBasePlayerWeapon : public CBasePlayerItem
{
public:
	virtual int		Save( CSave &save );
	virtual int		Restore( CRestore &restore );
	
	static	TYPEDESCRIPTION m_SaveData[];

	// generic weapon versions of CBasePlayerItem calls
	virtual int AddToPlayer( CBasePlayer *pPlayer );
	virtual int AddDuplicate( CBasePlayerItem *pItem );

	virtual int ExtractAmmo( CBasePlayerWeapon *pWeapon ); //{ return TRUE; };			// Return TRUE if you can add ammo to yourself when picked up
	virtual int ExtractClipAmmo( CBasePlayerWeapon *pWeapon );// { return TRUE; };			// Return TRUE if you can add ammo to yourself when picked up

	virtual int AddWeapon( void ) { ExtractAmmo( this ); return TRUE; };	// Return TRUE if you want to add yourself to the player

	// generic "shared" ammo handlers
	BOOL AddPrimaryAmmo( int iCount, char *szName, int iMaxClip, int iMaxCarry );
	BOOL AddSecondaryAmmo( int iCount, char *szName, int iMaxCarry );

	virtual void UpdateItemInfo( void ) {};	// updates HUD state

	int m_iPlayEmptySound;
	int m_fFireOnEmpty;		// True when the gun is empty and the player is still holding down the
							// attack key(s)
	virtual BOOL PlayEmptySound( void );
	virtual void ResetEmptySound( void );

	virtual void SendWeaponAnim( int iAnim );

	virtual BOOL CanDeploy( void );
	virtual BOOL IsUseable( void );
	BOOL DefaultDeploy( char *szViewModel, char *szWeaponModel, int iAnim, char *szAnimExt );
	int DefaultReload( int iClipSize, int iAnim, float fDelay );

	virtual void ItemPostFrame( void );	// called each frame by the player PostThink
	// called by CBasePlayerWeapons ItemPostFrame()
	virtual void PrimaryAttack( void ) { return; }				// do "+ATTACK"
	virtual void SecondaryAttack( void ) { return; }			// do "+ATTACK2"
	virtual void Reload( void ) { return; }						// do "+RELOAD"
	virtual void WeaponIdle( void ) { return; }					// called when no buttons pressed
	virtual int UpdateClientData( CBasePlayer *pPlayer );		// sends hud info to client dll, if things have changed
	virtual void RetireWeapon( void );
	virtual BOOL ShouldWeaponIdle( void ) { return FALSE; };
	virtual void Holster( void );

	
	int	PrimaryAmmoIndex(); 
	int	SecondaryAmmoIndex(); 

	float	m_flNextPrimaryAttack;								// soonest time ItemPostFrame will call PrimaryAttack
	float	m_flNextSecondaryAttack;							// soonest time ItemPostFrame will call SecondaryAttack
	float	m_flTimeWeaponIdle;									// soonest time ItemPostFrame will call WeaponIdle
	int		m_iPrimaryAmmoType;									// "primary" ammo index into players m_rgAmmo[]
	int		m_iSecondaryAmmoType;								// "secondary" ammo index into players m_rgAmmo[]
	int		m_iClip;											// number of shots left in the primary weapon clip, -1 it not used
	int		m_iClientClip;										// the last version of m_iClip sent to hud dll
	int		m_iClientWeaponState;								// the last version of the weapon state sent to hud dll (is current weapon, is on target)
	int		m_fInReload;                                        // Are we in the middle of a reload;
	
	int     menu_on;
	int		m_iDefaultAmmo;                                     // how much ammo you get when you pick up this weapon as placed by a level designer.
};


class CBasePlayerAmmo : public CBaseEntity
{
public:
	virtual void Spawn( void );
	void EXPORT DefaultTouch( CBaseEntity *pOther ); // default weapon touch
	virtual BOOL AddAmmo( CBaseEntity *pOther ) { return TRUE; };

	CBaseEntity* Respawn( void );
	void EXPORT Materialize( void );
};


extern DLL_GLOBAL	short	g_sModelIndexLaser;// holds the index for the laser beam
extern DLL_GLOBAL	const char *g_pModelNameLaser;

extern DLL_GLOBAL	short	g_sModelIndexLaserDot;// holds the index for the laser beam dot
extern DLL_GLOBAL	short	g_sModelIndexFireball;// holds the index for the fireball
extern DLL_GLOBAL	short	g_sModelIndexSmoke;// holds the index for the smoke cloud
extern DLL_GLOBAL	short	g_sModelIndexWExplosion;// holds the index for the underwater explosion
extern DLL_GLOBAL	short	g_sModelIndexBubbles;// holds the index for the bubbles model
extern DLL_GLOBAL	short	g_sModelIndexBloodDrop;// holds the sprite index for blood drops
extern DLL_GLOBAL	short	g_sModelIndexBloodSpray;// holds the sprite index for blood spray (bigger)

extern void ClearMultiDamage(void);
extern void ApplyMultiDamage(entvars_t* pevInflictor, entvars_t* pevAttacker );
extern void AddMultiDamage( entvars_t *pevInflictor, CBaseEntity *pEntity, float flDamage, int bitsDamageType);

extern void DecalGunshot( TraceResult *pTrace, int iBulletType );
extern void SpawnBlood(Vector vecSpot, int bloodColor, float flDamage);
extern int DamageDecal( CBaseEntity *pEntity, int bitsDamageType );
extern void RadiusDamage( Vector vecSrc, entvars_t *pevInflictor, entvars_t *pevAttacker, float flDamage, float flRadius, int iClassIgnore, int bitsDamageType );

typedef struct 
{
	CBaseEntity		*pEntity;
	float			amount;
	int				type;
} MULTIDAMAGE;

extern MULTIDAMAGE gMultiDamage;


#define LOUD_GUN_VOLUME			1000
#define NORMAL_GUN_VOLUME		600
#define QUIET_GUN_VOLUME		200

#define	BRIGHT_GUN_FLASH		512
#define NORMAL_GUN_FLASH		256
#define	DIM_GUN_FLASH			128

#define BIG_EXPLOSION_VOLUME	2048
#define NORMAL_EXPLOSION_VOLUME	1024
#define SMALL_EXPLOSION_VOLUME	512

#define	WEAPON_ACTIVITY_VOLUME	64

#define VECTOR_CONE_1DEGREES	Vector( 0.00873, 0.00873, 0.00873 )
#define VECTOR_CONE_2DEGREES	Vector( 0.01745, 0.01745, 0.01745 )
#define VECTOR_CONE_3DEGREES	Vector( 0.02618, 0.02618, 0.02618 )
#define VECTOR_CONE_4DEGREES	Vector( 0.03490, 0.03490, 0.03490 )
#define VECTOR_CONE_5DEGREES	Vector( 0.04362, 0.04362, 0.04362 )
#define VECTOR_CONE_6DEGREES	Vector( 0.05234, 0.05234, 0.05234 )
#define VECTOR_CONE_7DEGREES	Vector( 0.06105, 0.06105, 0.06105 )
#define VECTOR_CONE_8DEGREES	Vector( 0.06976, 0.06976, 0.06976 )
#define VECTOR_CONE_9DEGREES	Vector( 0.07846, 0.07846, 0.07846 )
#define VECTOR_CONE_10DEGREES	Vector( 0.08716, 0.08716, 0.08716 )
#define VECTOR_CONE_15DEGREES	Vector( 0.13053, 0.13053, 0.13053 )
#define VECTOR_CONE_20DEGREES	Vector( 0.17365, 0.17365, 0.17365 )

//=========================================================
// CWeaponBox - a single entity that can store weapons
// and ammo. 
//=========================================================
class CWeaponBox : public CBaseEntity
{
	void Precache( void );
	void Spawn( void );
	void Touch( CBaseEntity *pOther );
	void KeyValue( KeyValueData *pkvd );
	BOOL IsEmpty( void );
	int  GiveAmmo( int iCount, char *szName, int iMax, int *pIndex = NULL );
	void SetObjectCollisionBox( void );

public:
	void EXPORT Kill ( void );
	int		Save( CSave &save );
	int		Restore( CRestore &restore );
	static	TYPEDESCRIPTION m_SaveData[];

	HasWeapon( CBasePlayerItem *pCheckItem );
	BOOL PackWeapon( CBasePlayerItem *pWeapon );
	BOOL PackAmmo( int iszName, int iCount );
	
	CBasePlayerItem	*m_rgpPlayerItems[MAX_ITEM_TYPES];// one slot for each 

	int m_rgiszAmmo[MAX_AMMO_SLOTS];// ammo names
	int	m_rgAmmo[MAX_AMMO_SLOTS];// ammo quantities

	int m_cAmmoTypes;// how many ammo types packed into this box (if packed by a level designer)
};


#endif // WEAPONS_H
