sub parseConfig
{
    my $configFile = "./halfStats.cfg";
    my @fileContents;
    my $variable = 0;
    my $value = 0;
    my %config = ();
    my $line = 0;
    my $firstChar = 0;
    my $rest = 0;

    open(FILE, "<$configFile") || die "\n\n*** ERROR: $! for $configFile\n\n";
    @fileContents = <FILE>;
    close(FILE);

    # save settings, forget comments and blank space
    foreach $line (@fileContents)
    {
	chomp($line);

	$firstChar = substr($line, 0, 1);

        if($firstChar ne "#" && $firstChar ne "")
        {
            ($variable, $value) = split(/\=/, $line, 2);
	    $config{$variable} = $value;
        }
        else
        {
            # do nothing, this is a comment
        }
    }

    # these are internal halfStats settings
    $config{'mergedLog'}  = "./_mergedLog_.$$";
    $config{'killLog'}    = "./_killLog_.$$";
    $config{'ipLog'}      = "./_ipLog_.$$";
    $config{'tmpFile'}    = "./_tmpFile_.$$";
    $config{'killsFile'}  = "$config{'htmlDir'}/topten-highest_kills.html";
    $config{'deathsFile'} = "$config{'htmlDir'}/topten-highest_deaths.html";
    $config{'kpdFile'}    = "$config{'htmlDir'}/topten-highest_kpd.html";

    if($ARGV[0] eq "-file")
    {
	$config{'skillFile'}  = "$config{'htmlDir'}/$ARGV[1]/$ARGV[3]/$ARGV[2]/index.html";
	$config{'relSkillFile'} = "$ARGV[1]/$ARGV[3]/$ARGV[2]/index.html";
	$config{'playerDir'} = "$ARGV[1]/$ARGV[3]/$ARGV[2]/players";
	$config{'mode'} = "prev";
    }
    else
    {
	$config{'skillFile'}  = "$config{'htmlDir'}/index.html";
	$config{'relSkillFile'} = "index.html";
	$config{'playerDir'} = "players";
	$config{'mode'} = "now";
    }

    if($config{'OS'} ne "unix")
    {
	foreach $key (keys %config)
	{
	    if($key ne "serverBanner")
	    {
		$config{$key} =~ s/\//\\/g;
	    }
	}
    }

    return(\%config);
}

1;
