/***
*
*   Copyright (c) 1999, Valve LLC. All rights reserved.
*   
*   This product contains software technology licensed from Id 
*   Software, Inc. ("Id Technology").  Id Technology (c) 1996 Id Software, Inc. 
*   All Rights Reserved.
*
*   Use, distribution, and modification of this source code and/or resulting
*   object code is restricted to non-commercial enhancements to products from
*   Valve LLC.  All other use, distribution, or modification is prohibited
*   without written permission from Valve LLC.
*
****/
/*

===== util.cpp ========================================================

  Utility code.  Really not optional after all.

*/

#include "extdll.h"
#include "util.h"
#include "cbase.h"


// returns a CBaseEntity pointer to a player by index.  Only returns if the player is spawned and connected
// otherwise returns NULL
// Index is 1 based
CBaseEntity   *UTIL_PlayerByIndex( int playerIndex )
{
   CBaseEntity *pPlayer = NULL;

   if ( playerIndex > 0 && playerIndex <= gpGlobals->maxClients )
   {
      edict_t *pPlayerEdict = INDEXENT( playerIndex );
      if ( pPlayerEdict && !pPlayerEdict->free )
      {
         pPlayer = CBaseEntity::Instance( pPlayerEdict );
      }
   }
   
   return pPlayer;
}


extern int gmsgTextMsg;

void ClientPrint( entvars_t *client, int msg_dest, const char *msg_name, const char *param1, const char *param2, const char *param3, const char *param4 )
{
   MESSAGE_BEGIN( MSG_ONE, gmsgTextMsg, NULL, client );
      WRITE_BYTE( msg_dest );
      WRITE_STRING( msg_name );

      if ( param1 )
         WRITE_STRING( param1 );
      if ( param2 )
         WRITE_STRING( param2 );
      if ( param3 )
         WRITE_STRING( param3 );
      if ( param4 )
         WRITE_STRING( param4 );

   MESSAGE_END();
}


void UTIL_ClientPrintAll( int msg_dest, const char *msg_name, const char *param1, const char *param2, const char *param3, const char *param4 )
{
   MESSAGE_BEGIN( MSG_ALL, gmsgTextMsg );
      WRITE_BYTE( msg_dest );
      WRITE_STRING( msg_name );

      if ( param1 )
         WRITE_STRING( param1 );
      if ( param2 )
         WRITE_STRING( param2 );
      if ( param3 )
         WRITE_STRING( param3 );
      if ( param4 )
         WRITE_STRING( param4 );

   MESSAGE_END();
}


CBaseEntity *UTIL_FindEntityInSphere( CBaseEntity *pStartEntity, const Vector &vecCenter, float flRadius )
{
   edict_t   *pentEntity;

   if (pStartEntity)
      pentEntity = pStartEntity->edict();
   else
      pentEntity = NULL;

   pentEntity = FIND_ENTITY_IN_SPHERE( pentEntity, vecCenter, flRadius);

   if (!FNullEnt(pentEntity))
      return CBaseEntity::Instance(pentEntity);
   return NULL;
}



