#include <direct.h>

#include "extdll.h"

#include "stripper.h"


HINSTANCE h_Library = NULL;


// Required DLL entry point
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
   if (fdwReason == DLL_PROCESS_ATTACH)
   {
   }
   else if (fdwReason == DLL_PROCESS_DETACH)
   {
      if (h_Library)
         FreeLibrary(h_Library);
   }

   return TRUE;
}


enginefuncs_t g_engfuncs;
globalvars_t  *gpGlobals;


typedef int (FAR *GETENTITYAPI)(DLL_FUNCTIONS *, int);
typedef void (DLLEXPORT *GIVEFNPTRSTODLL)(enginefuncs_t *, globalvars_t *);

GETENTITYAPI other_GetEntityAPI;
GIVEFNPTRSTODLL other_GiveFnptrsToDll;

extern int mod_id;


void DLLEXPORT GiveFnptrsToDll( enginefuncs_t* pengfuncsFromEngine, globalvars_t *pGlobals )
{
   int pos;
   char game_dir[256];
   char mod_name[32];

   // get the engine functions from the engine...

   memcpy(&g_engfuncs, pengfuncsFromEngine, sizeof(enginefuncs_t));
   gpGlobals = pGlobals;

   // find the directory name of the currently running MOD...
   (*g_engfuncs.pfnGetGameDir)(game_dir);

   pos = strlen(game_dir) - 1;

   // scan backwards till first directory separator...
   while ((pos) && (game_dir[pos] != '/'))
      pos--;

   if (pos == 0)
   {
      // FIRGURE OUT HOW TO HANDLE ERRORS HERE!!!
   }

   pos++;
   strcpy(mod_name, &game_dir[pos]);

   if (strcmpi(mod_name, "valve") == 0)
   {
      mod_id = VALVE_DLL;
      h_Library = LoadLibrary("valve\\dlls\\hl.dll");
   }
   else if (strcmpi(mod_name, "action") == 0)
   {
      mod_id = ACTION_DLL;
      h_Library = LoadLibrary("action\\dlls\\mp.dll");
   }
   else if (strcmpi(mod_name, "bot") == 0)
   {
      mod_id = BOT_DLL;
      h_Library = LoadLibrary("bot\\dlls\\bot.dll");
   }
   else if (strcmpi(mod_name, "cstrike") == 0)
   {
      mod_id = CSTRIKE_DLL;
      h_Library = LoadLibrary("cstrike\\dlls\\mp.dll");
   }
   else if (strcmpi(mod_name, "goldeneye") == 0)
   {
      mod_id = GOLDENEYE_DLL;
      h_Library = LoadLibrary("goldeneye\\dlls\\mp.dll");
   }
   else if (strcmpi(mod_name, "ice") == 0)
   {
      mod_id = ICE_DLL;
      h_Library = LoadLibrary("ice\\dlls\\mp.dll");
   }
   else if (strcmpi(mod_name, "jumbot") == 0)
   {
      mod_id = JUMBOT_DLL;
      h_Library = LoadLibrary("jumbot\\dlls\\jumbot.dll");
   }
   else if (strcmpi(mod_name, "phineas") == 0)
   {
      mod_id = PHINEAS_DLL;
      h_Library = LoadLibrary("phineas\\dlls\\phineas.dll");
   }
   else if (strcmpi(mod_name, "rhobot") == 0)
   {
      mod_id = RHOBOT_DLL;
      h_Library = LoadLibrary("rhobot\\dlls\\mp.dll");
   }
   else if (strcmpi(mod_name, "si") == 0)
   {
      mod_id = SI_DLL;
      h_Library = LoadLibrary("si\\dlls\\si.dll");
   }
   else if (strcmpi(mod_name, "tfc") == 0)
   {
      mod_id = TFC_DLL;
      h_Library = LoadLibrary("tfc\\dlls\\tfc.dll");
   }

   if (h_Library == NULL)
   {
      // FIRGURE OUT HOW TO HANDLE ERRORS HERE!!!
   }


   other_GetEntityAPI = (GETENTITYAPI)GetProcAddress(h_Library, "GetEntityAPI");

   if (other_GetEntityAPI == NULL)
   {
      // FIRGURE OUT HOW TO HANDLE ERRORS HERE!!!
   }

   other_GiveFnptrsToDll = (GIVEFNPTRSTODLL)GetProcAddress(h_Library, "GiveFnptrsToDll");

   if (other_GiveFnptrsToDll == NULL)
   {
      // FIRGURE OUT HOW TO HANDLE ERRORS HERE!!!
   }

   // give the engine functions to the other DLL...
   (*other_GiveFnptrsToDll)(pengfuncsFromEngine, pGlobals);
}

