
#include "extdll.h"
#include "enginecallback.h"
#include "util.h"
#include "cbase.h"

#include "cvar.h"

typedef int (FAR *GETENTITYAPI)(DLL_FUNCTIONS *, int);

extern GETENTITYAPI other_GetEntityAPI;
extern enginefuncs_t g_engfuncs;
extern globalvars_t  *gpGlobals;


DLL_FUNCTIONS other_gFunctionTable;

int mod_id = 0;

int gmsgTextMsg = 0;


void GameDLLInit( void )
{
   // Register cvars here:

   cvar_register();

   // Register user messages for client.dll here...

   gmsgTextMsg = REG_USER_MSG( "TextMsg", -1 );

   (*other_gFunctionTable.pfnGameInit)();
}

int DispatchSpawn( edict_t *pent )
{
   char *pClassname = (char *)STRING(pent->v.classname);

   if (strcmp(pClassname, "worldspawn") == 0)
   {
      // do level initialization stuff here...
      
   }
   else if (strip_check_cvar(pClassname))
   {
      // if stripping item, return -1 to indicate "error"...
      return -1;
   }

#if 0
   FILE *fp=fopen("spawn.txt", "a");
   fprintf(fp, "Spawning Classname=%s\n", pClassname);
   fclose(fp);
#endif

   return (*other_gFunctionTable.pfnSpawn)(pent);
}

void DispatchThink( edict_t *pent )
{
   (*other_gFunctionTable.pfnThink)(pent);
}

void DispatchUse( edict_t *pentUsed, edict_t *pentOther )
{
   (*other_gFunctionTable.pfnUse)(pentUsed, pentOther);
}

void DispatchTouch( edict_t *pentTouched, edict_t *pentOther )
{
   (*other_gFunctionTable.pfnTouch)(pentTouched, pentOther);
}

void DispatchBlocked( edict_t *pentBlocked, edict_t *pentOther )
{
   (*other_gFunctionTable.pfnBlocked)(pentBlocked, pentOther);
}

void DispatchKeyValue( edict_t *pentKeyvalue, KeyValueData *pkvd )
{
   (*other_gFunctionTable.pfnKeyValue)(pentKeyvalue, pkvd);
}

void DispatchSave( edict_t *pent, SAVERESTOREDATA *pSaveData )
{
   (*other_gFunctionTable.pfnSave)(pent, pSaveData);
}

int DispatchRestore( edict_t *pent, SAVERESTOREDATA *pSaveData, int globalEntity )
{
   return (*other_gFunctionTable.pfnRestore)(pent, pSaveData, globalEntity);
}

void DispatchObjectCollsionBox( edict_t *pent )
{
   (*other_gFunctionTable.pfnSetAbsBox)(pent);
}

void SaveWriteFields( SAVERESTOREDATA *pSaveData, const char *pname, void *pBaseData, TYPEDESCRIPTION *pFields, int fieldCount )
{
   (*other_gFunctionTable.pfnSaveWriteFields)(pSaveData, pname, pBaseData, pFields, fieldCount);
}

void SaveReadFields( SAVERESTOREDATA *pSaveData, const char *pname, void *pBaseData, TYPEDESCRIPTION *pFields, int fieldCount )
{
   (*other_gFunctionTable.pfnSaveReadFields)(pSaveData, pname, pBaseData, pFields, fieldCount);
}

void SaveGlobalState( SAVERESTOREDATA *pSaveData )
{
   (*other_gFunctionTable.pfnSaveGlobalState)(pSaveData);
}

void RestoreGlobalState( SAVERESTOREDATA *pSaveData )
{
   (*other_gFunctionTable.pfnRestoreGlobalState)(pSaveData);
}

void ResetGlobalState( void )
{
   (*other_gFunctionTable.pfnResetGlobalState)();
}

BOOL ClientConnect( edict_t *pEntity, const char *pszName, const char *pszAddress, char szRejectReason[ 128 ]  )
{   
   return (*other_gFunctionTable.pfnClientConnect)(pEntity, pszName, pszAddress, szRejectReason);
}

void ClientDisconnect( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnClientDisconnect)(pEntity);
}

void ClientKill( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnClientKill)(pEntity);
}

void ClientPutInServer( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnClientPutInServer)(pEntity);
}

void ClientCommand( edict_t *pEntity )
{
	const char *pcmd = CMD_ARGV(0);
   CBaseEntity *pMapEnt = NULL;
   float radius = 40;
   char str[80];

	if ( FStrEq(pcmd, "strip_search" ) )
   {
      ClientPrint(&pEntity->v, HUD_PRINTCONSOLE, "searching...\n");

      while ((pMapEnt = UTIL_FindEntityInSphere(pMapEnt, pEntity->v.origin, radius)) != NULL)
      {
         if (pMapEnt->pev->owner == NULL)  // make sure item has no owner...
         {
            if ((strncmp(STRING(pMapEnt->pev->classname), "weapon_", 7) == 0) ||
                (strncmp(STRING(pMapEnt->pev->classname), "ammo_", 5) == 0) ||
                (strncmp(STRING(pMapEnt->pev->classname), "item_", 5) == 0) ||
                (strncmp(STRING(pMapEnt->pev->classname), "func_", 5) == 0))
            {
               sprintf(str, "Found %s at %5.2f %5.2f %5.2f\n",
                       STRING(pMapEnt->pev->classname),
                       pMapEnt->pev->origin.x, pMapEnt->pev->origin.y, pMapEnt->pev->origin.z);
               ClientPrint(&pEntity->v, HUD_PRINTCONSOLE, str);

               FILE *fp=fopen("strip_search.txt", "a");
               fprintf(fp, "ClientCommmand: strip_search %s", str);
               fclose(fp);
            }
         }
      }

      return;
   }

   (*other_gFunctionTable.pfnClientCommand)(pEntity);
}

void ClientUserInfoChanged( edict_t *pEntity, char *infobuffer )
{
   (*other_gFunctionTable.pfnClientUserInfoChanged)(pEntity, infobuffer);
}

void ServerActivate( edict_t *pEdictList, int edictCount, int clientMax )
{
   (*other_gFunctionTable.pfnServerActivate)(pEdictList, edictCount, clientMax);
}

void PlayerPreThink( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnPlayerPreThink)(pEntity);
}

void PlayerPostThink( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnPlayerPostThink)(pEntity);
}

void StartFrame( void )
{
   (*other_gFunctionTable.pfnStartFrame)();
}

void ParmsNewLevel( void )
{
   (*other_gFunctionTable.pfnParmsNewLevel)();
}

void ParmsChangeLevel( void )
{
   (*other_gFunctionTable.pfnParmsChangeLevel)();
}

const char *GetGameDescription( void )
{
   return (*other_gFunctionTable.pfnGetGameDescription)();
}

void PlayerCustomization( edict_t *pEntity, customization_t *pCust )
{
   (*other_gFunctionTable.pfnPlayerCustomization)(pEntity, pCust);
}

void SpectatorConnect( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnSpectatorConnect)(pEntity);
}

void SpectatorDisconnect( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnSpectatorDisconnect)(pEntity);
}

void SpectatorThink( edict_t *pEntity )
{
   (*other_gFunctionTable.pfnSpectatorThink)(pEntity);
}


DLL_FUNCTIONS gFunctionTable = 
{
   GameDLLInit,            //pfnGameInit
   DispatchSpawn,          //pfnSpawn
   DispatchThink,          //pfnThink
   DispatchUse,            //pfnUse
   DispatchTouch,          //pfnTouch
   DispatchBlocked,        //pfnBlocked
   DispatchKeyValue,       //pfnKeyValue
   DispatchSave,           //pfnSave
   DispatchRestore,        //pfnRestore
   DispatchObjectCollsionBox,   //pfnAbsBox

   SaveWriteFields,        //pfnSaveWriteFields
   SaveReadFields,         //pfnSaveReadFields

   SaveGlobalState,        //pfnSaveGlobalState
   RestoreGlobalState,     //pfnRestoreGlobalState
   ResetGlobalState,       //pfnResetGlobalState

   ClientConnect,          //pfnClientConnect
   ClientDisconnect,       //pfnClientDisconnect
   ClientKill,             //pfnClientKill
   ClientPutInServer,      //pfnClientPutInServer
   ClientCommand,          //pfnClientCommand
   ClientUserInfoChanged,  //pfnClientUserInfoChanged
   ServerActivate,         //pfnServerActivate

   PlayerPreThink,         //pfnPlayerPreThink
   PlayerPostThink,        //pfnPlayerPostThink

   StartFrame,             //pfnStartFrame
   ParmsNewLevel,          //pfnParmsNewLevel
   ParmsChangeLevel,       //pfnParmsChangeLevel

   GetGameDescription,     //pfnGetGameDescription    Returns string describing current .dll game.
   PlayerCustomization,    //pfnPlayerCustomization   Notifies .dll of new customization for player.

   SpectatorConnect,       //pfnSpectatorConnect      Called when spectator joins server
   SpectatorDisconnect,    //pfnSpectatorDisconnect   Called when spectator leaves the server
   SpectatorThink,         //pfnSpectatorThink        Called when spectator sends a command packet (usercmd_t)
};


extern "C" _declspec( dllexport) int GetEntityAPI( DLL_FUNCTIONS *pFunctionTable, int interfaceVersion )
{
   // check if engine's pointer is valid and version is correct...

   if ( !pFunctionTable || interfaceVersion != INTERFACE_VERSION )
      return FALSE;

   // pass engine callback function table to engine...
   memcpy( pFunctionTable, &gFunctionTable, sizeof( DLL_FUNCTIONS ) );

   // pass other DLLs engine callbacks to function table...
   if (!(*other_GetEntityAPI)(&other_gFunctionTable, INTERFACE_VERSION))
   {
      return FALSE;  // error initializing function table!!!
   }

   return TRUE;
}

