//
// written by: botman (botman@mailandnews.com)
//
// another fine Half-Life project from http://planethalflife.com/botman/
//
// get_serv connects to the WON Master and downloads the IP address and
// PORT number of all registered Half-Life servers.
//
// (You can use get_info.exe to query a specific Half-Life server about
//  it's details)
//
// Note: if the WON Master doesn't respond, press Ctrl-C and try again
//       or choose the other WON Master and try it.  Sometimes the UDP
//       packets get lost and never make it to the WON Master, so you
//       won't get a response.  I haven't added a timeout for the recv
//       function so it will just hang if there is no response.
//
//
// To compile using Microsoft Visual C++ use:
//    cl get_serv.c wsock32.lib
//

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <winsock.h>

#define BUF_SIZE 2048


void main(int argc, char *argv[])
{
   WSADATA WSAData;
   struct hostent  *hp;
   unsigned int  addr;
   SOCKET        socket_desc;
   SOCKADDR_IN   local_sin;
   SOCKADDR_IN   master_sin;

   union port_u
   {
      unsigned char port_b[2];
      unsigned short port;
   } port_u;      

   FILE *fp;

   unsigned char buffer[BUF_SIZE];
   int  length;
   int  offset, num_nodes, i;
   long unique, *pUnique;


   if (argc < 3)
   {
      printf("usage: %s master_IP_address master_port\n", argv[0]);
      printf("       for example: get_serv half-life.east.won.net 27010\n");
      printf("               or : get_serv half-life.west.won.net 27010\n");
      return;
   }

   // start up the Windows Sockets Interface...
   if (WSAStartup(0x0101, &WSAData))
   {
      printf("Can't start Sockets Interface!\n");
      return;
   }

   socket_desc = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

   if (socket_desc == INVALID_SOCKET)
   {
      printf("Can't create Server socket!: error=%d\n",
              WSAGetLastError());
      return;
   }

   // set up the local socket...
	memset(&local_sin, 0, sizeof(local_sin));

	local_sin.sin_family = AF_INET;
   local_sin.sin_addr.s_addr = INADDR_ANY;
	local_sin.sin_port = htons((u_short)atoi(argv[2]));


   // find the IP address of the master...
   if (isalpha(argv[1][0]))
      hp = gethostbyname(argv[1]);
   else
   {
      addr = inet_addr(argv[1]);
      hp = gethostbyaddr((char *)&addr, 4, AF_INET);
   }

   if (hp == NULL)
   {
      printf("Can't resolve local IP address!: error=%d\n",
              WSAGetLastError());
      return;
   }

   // set up the master socket...
	memset(&master_sin, 0, sizeof(master_sin));

	master_sin.sin_family = AF_INET;
	memcpy(&(master_sin.sin_addr), hp->h_addr, hp->h_length);
	master_sin.sin_port = htons((u_short)atoi(argv[2]));


   printf("binding socket to: %s:%s\n", argv[1], argv[2]);

   if (bind(socket_desc, (struct sockaddr *)&local_sin,
            sizeof(local_sin)) == SOCKET_ERROR)
   {
      printf("Can't bind to Server socket!: error=%d\n",
              WSAGetLastError());

      return;
   }

   buffer[0] = 'e';  // A2M_GET_SERVERS_BATCH;
   buffer[1] = 0;

   sendto(socket_desc, buffer, 2, 0,
          (struct sockaddr *)&master_sin, sizeof(master_sin));

   length = recvfrom(socket_desc, buffer, BUF_SIZE, 0, NULL, NULL);

   if (length > 0)
   {
      printf("opening output file: won.txt\n");
      fp = fopen("won.txt", "w");

      while (length > 0)
      {
         offset = 6;

         pUnique = (long *)&buffer[offset];
         unique = *pUnique;

         num_nodes = (length - 10) / 6;
         offset += 4;

         for (i=0; i < num_nodes; i++)
         {
            port_u.port_b[0] = buffer[offset+5];
            port_u.port_b[1] = buffer[offset+4];

            fprintf(fp, "%d.%d.%d.%d:%d\n",
                    buffer[offset], buffer[offset+1],
                    buffer[offset+2], buffer[offset+3], port_u.port);
            offset += 6;
         }

         if (unique == 0)  // if no more servers left then done...
            break;

         buffer[0] = 'e';  // A2M_GET_SERVERS_BATCH;
         *(int *)&buffer[1] = unique;

         printf("reading data from WON master...\n");
         sendto(socket_desc, buffer, 5, 0,
                (struct sockaddr *)&master_sin, sizeof(master_sin));

         length = recvfrom(socket_desc, buffer, BUF_SIZE, 0, NULL, NULL);
      }

      fclose(fp);
   }

   closesocket(socket_desc);

   printf("done!\n");

}

