//
// written by: botman (botman@mailandnews.com)
//
// another fine Half-Life project from http://planethalflife.com/botman/
//
// get_info connects to a specific Half-Life server and downloads details
// about the server configuration (What MOD is running, how many active
// clients, etc.)
//
// NOTE: If a server doesn't respond, just press Ctrl-C and try another
//       server.  That server may be temporarily unavailable
//
//
// To compile using Microsoft Visual C++ use:
//    cl get_info.c wsock32.lib
//

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <winsock.h>

#define BUF_SIZE 2048


void main(int argc, char *argv[])
{
   WSADATA WSAData;
   struct hostent  *hp;
   unsigned int  addr;
   SOCKET        socket_desc;
   SOCKADDR_IN   local_sin;
   SOCKADDR_IN   host_sin;
   char hostname[32];
   unsigned short port;

   unsigned char buffer[BUF_SIZE];
   int  length, offset;
   char *pos;


   if (argc < 2)
   {
      printf("usage: %s host_IP_address:host_port\n", argv[0]);
      return;
   }

   // start up the Windows Sockets Interface...
   if (WSAStartup(0x0101, &WSAData))
   {
      printf("Can't start Sockets Interface!\n");
      return;
   }

   socket_desc = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);

   if (socket_desc == INVALID_SOCKET)
   {
      printf("Can't create Server socket!: error=%d\n",
              WSAGetLastError());
      return;
   }

   if ((pos = strstr(argv[1], ":")) == NULL)
   {
      printf("invalid IP address:port format!  (use: xxx.xxx.xxx.xxx:nnnnn)\n");
      return;
   }

   *pos = 0;
   strcpy(hostname, argv[1]);
   pos++;
   port = (unsigned short)atoi(pos);

   printf("hostname=%s, port=%d\n", hostname, port);

   // set up the local socket...
	memset(&local_sin, 0, sizeof(local_sin));

	local_sin.sin_family = AF_INET;
   local_sin.sin_addr.s_addr = INADDR_ANY;
	local_sin.sin_port = htons(port);

   // find the IP address of the host...
   if (isalpha(hostname[0]))
      hp = gethostbyname(hostname);
   else
   {
      addr = inet_addr(hostname);
      hp = gethostbyaddr((char *)&addr, 4, AF_INET);
   }

   if (hp == NULL)
   {
      printf("Can't resolve local IP address!: error=%d\n",
              WSAGetLastError());
      return;
   }

   // set up the host socket...
	memset(&host_sin, 0, sizeof(host_sin));

	host_sin.sin_family = AF_INET;
	memcpy(&(host_sin.sin_addr), hp->h_addr, hp->h_length);
	host_sin.sin_port = htons(port);


   if (bind(socket_desc, (struct sockaddr *)&local_sin,
            sizeof(local_sin)) == SOCKET_ERROR)
   {
      printf("Can't bind to Server socket!: error=%d\n",
              WSAGetLastError());

      return;
   }

   *(int *)&buffer[0] = -1;
   strncpy(&buffer[4], "info", 5);  // copy string and null terminator

   sendto(socket_desc, buffer, 9, 0,
          (struct sockaddr *)&host_sin, sizeof(host_sin));

   length = recvfrom(socket_desc, buffer, BUF_SIZE, 0, NULL, NULL);

   if (length > 0)
   {
      printf("got respone from server...\n");
      if (buffer[4] == 'C')
      {
         offset = 5;
         printf("host IP address: %s\n", &buffer[offset]);
         while (buffer[offset]) offset++;
         offset++;
         printf("     server name: %s\n", &buffer[offset]);
         while (buffer[offset]) offset++;
         offset++;
         printf("     server map: %s\n", &buffer[offset]);
         while (buffer[offset]) offset++;
         offset++;
         printf("     server game dir: %s\n", &buffer[offset]);
         while (buffer[offset]) offset++;
         offset++;
         printf("     server description: %s\n", &buffer[offset]);
         while (buffer[offset]) offset++;
         offset++;
         printf("     number of active clients: %d\n",buffer[offset]);
         printf("     number of maximum clients: %d\n",buffer[offset+1]);
      }
      else
         printf("Invalid response from host!\n");
   }

   closesocket(socket_desc);

}

