// botman's Half-Life bot example (http://jump.to/botman/)

#ifndef BOT_H
#define BOT_H

#define LADDER_UP    1
#define LADDER_DOWN  2

#define WANDER_LEFT  1
#define WANDER_RIGHT 2

#define MODEL_HGRUNT    1
#define MODEL_BARNEY    2
#define MODEL_SCIENTIST 3

#define BOT_YAW_SPEED 20  // degrees per 10th of second turning speed

typedef struct  // used in checking if bot can pick up ammo
{
   char *ammo_name;
   char *weapon_name;
   int max_carry;
} ammo_check_t;


void BotDebug( char *buffer );  // print out message to HUD for debugging


class CBot : public CBasePlayer //Derive a bot class from CBasePlayer
{
   public:
      Vector v_prev_origin;   // previous origin (i.e. location)
      float  f_shoot_time;    // next time to shoot weapon at
      float  f_max_speed;     // last sv_maxspeed setting
      float  f_speed_check_time;  // check sv_maxspeed every so often
      float  f_move_speed;    // speed at which the bot will move
      int    ladder_dir;      // direction traveling on ladder (UP or DOWN)
      int    wander_dir;      // randomly wander left or right
      float  f_pause_time;    // timeout for periods when the bot pauses
      float  f_find_item;     // timeout for not looking for items
      char   model_name[20];
      int    bot_model;
      int    bot_skill;       // bot skill level (0=very good, 4=very bad)
      float  f_pain_time;     // time when pain sound can be spoken
      BOOL   b_use_health_station;  // set if bot should "use" health station
      float  f_use_health_time;  // time when b_use_health_station is set
      BOOL   b_use_HEV_station;  // set if bot should "use" HEV station
      float  f_use_HEV_time;  // time when b_use_HEV_station is set
      BOOL   b_use_button;    // set if bot should "use" button
      float  f_use_button_time;  // time when b_use_button is set
      BOOL   b_lift_moving;   // flag set when lift (elevator) is moving
      BOOL   b_see_tripmine;  // set if bot "sees" a tripmine
      BOOL   b_shoot_tripmine;  // set if bot should shoot a tripmine
      Vector v_tripmine;      // origin of tripmine
      float  f_fire_gauss;    // time to release secondary fire on gauss gun
      BOOL   bot_was_paused;  // TRUE if bot was previously "paused"

      CBaseEntity *pBotEnemy; // pointer to bot's enemy
      CBaseEntity *pBotPickupItem;  // pointer to item we are trying to get

      char   message[256];    // buffer for debug messages

      void Spawn( void );
      void Think( void );
      void BotThink( void );
      void Killed(entvars_t *pevAttacker, int iGib);
      void PlayerDeathThink( void );

      // Bots should return FALSE for this, they can't receive NET messages
      virtual BOOL IsNetClient( void ) { return FALSE; }

      int BloodColor() { return BLOOD_COLOR_RED; }
      int TakeDamage( entvars_t *pevInflictor, entvars_t *pevAttacker,
                      float flDamage, int bitsDamageType );

      int BotInFieldOfView( Vector dest );
      BOOL BotEntityIsVisible( Vector dest );
      float BotChangeYaw( float speed );
      void BotOnLadder( float moved_distance );
      void BotUnderWater( void );
      CBaseEntity * BotFindEnemy( void );
      Vector BotBodyTarget( CBaseEntity *pBotEnemy );
      BOOL BotFireWeapon( Vector enemy, int weapon_choice = 0, BOOL primary = TRUE );
      void BotShootAtEnemy( void );
      void BotFindItem( void );
      void BotUseLift( float moved_distance );
      void BotTurnAtWall( TraceResult *tr );
      BOOL BotCantMoveForward( TraceResult *tr );
      BOOL BotCanJumpUp( void );
      BOOL BotCanDuckUnder( void );
      BOOL BotShootTripmine( void );
};

#endif // BOT_H

