alias quakex.help {
  window -al @Help_Menu 500 0 226 330 @Help_Menu arial 12
  titlebar @Help_Menu For QuakeX 
  aline @Help_Menu %quakex.base.color $+ Welcome to the QuakeX help section!
  aline @Help_Menu $str(-,300)
  aline @Help_Menu Double Click A Topic Below
  aline @Help_Menu $str(-,300)
  aline @Help_Menu %quakex.fill-in.color $+ Quake Drive?
  aline @Help_Menu %quakex.fill-in.color $+ Quake Folder?
  aline @Help_Menu %quakex.fill-in.color $+ Quakeworld Type?
  aline @Help_Menu %quakex.fill-in.color $+ Server IP Number?
  aline @Help_Menu %quakex.fill-in.color $+ Server Password?
  aline @Help_Menu %quakex.fill-in.color $+ Observe Server?
  aline @Help_Menu %quakex.fill-in.color $+ Addon Color?
  aline @Help_Menu %quakex.fill-in.color $+ Logging System?
  aline @Help_Menu %quakex.fill-in.color $+ Advertising System
  aline @Help_Menu %quakex.fill-in.color $+ Quake Configuration?
  aline @Help_Menu %quakex.fill-in.color $+ Gamespy?
  aline @Help_Menu %quakex.fill-in.color $+ F-Key System?
  aline @Help_Menu %quakex.fill-in.color $+ Hidden Shortcuts?
  aline @Help_Menu %quakex.fill-in.color $+ Uninstall Addon?
  aline @Help_Menu $str(-,300)
  aline @Help_Menu %quakex.base.color $+ Exit Help
}
menu @Help_Menu {
  dclick { 
    if ($1 < 4) { halt } 
    set %quakex.qmenu $1 
    help.menu %quakex.qmenu
  }  
  QuakeX Launcher { quakex }
  QuakeX Options { quakex.options }
  -
  Close Window { window -c @Help_Menu }
}
alias help.menu {
  if ($1 == 5) { help.drive }
  elseif ($1 == 6) { help.folder }
  elseif ($1 == 7) { help.type }
  elseif ($1 == 8) { help.number }
  elseif ($1 == 9) { help.pass }
  elseif ($1 == 10) { help.observe }
  elseif ($1 == 11) { help.color }
  elseif ($1 == 12) { help.logging }
  elseif ($1 == 13) { help.Advertising }
  elseif ($1 == 14) { help.configuration }
  elseif ($1 == 15) { quakex.gamespy.help }
  elseif ($1 == 16) { quakex.fkey.help }
  elseif ($1 == 17) { help.shortcuts }
  elseif ($1 == 18) { help.uninstall }
  elseif ($1 == 19) { halt }
  elseif ($1 == 20) { 
    if ($active(@Help) == $active) { window -c @Help }
    window -c @Help_Menu 
  }
}
alias help.drive {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Quake Drive
  aline 4 @Help This is the part of the addon in which
  aline 4 @Help you tell QuakeX what drive quake is 
  aline 4 @Help on.  You would double click on this 
  aline 4 @Help field and enter the drive letter followed
  aline 4 @Help by a colon. For example I would type in
  aline 4 @Help D: because my quake folder is on 
  aline 4 @Help drive D!
}
menu @Help {
  dclick { window -c @Help }
  Close Window { window -c @Help }
}
alias help.folder {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Quake Folder
  aline 4 @Help This is the part of the addon in which
  aline 4 @Help you tell QuakeX what folder quake is 
  aline 4 @Help in.  You would double click on this 
  aline 4 @Help field and enter the folder your quake
  aline 4 @Help is in.  95% of the time it is in the folder
  aline 4 @Help QUAKE! If this is true then in this field
  aline 4 @Help you would type \Quake proceeding 
  aline 4 @Help the word quake with a backslash.
}
alias help.type {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Quakeworld Type
  aline 4 @Help This is the part of the addon in which
  aline 4 @Help you tell QuakeX what type of Quakeworld
  aline 4 @Help you use. If you play normal quakeworld, the
  aline 4 @Help type you use is qwcl.exe, but if the type you
  aline 4 @Help use is GL Quakeworld, then the type you use
  aline 4 @Help is glqwcl.exe.  You would know if you use GL
  aline 4 @Help because you need an Open GL graphics card,
  aline 4 @Help and the qraphics would be very well done.  If
  aline 4 @Help you are still unsure which you use, go with the 
  aline 4 @Help qwcl.exe because it will work either way.  GL
  aline 4 @Help will only work if you have a GL enabled card.
}
alias help.number {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Server Ip Number
  aline 4 @Help This is the part of the addon in which
  aline 4 @Help the server IP number is placed in order
  aline 4 @Help to join the server.  You must find an IP 
  aline 4 @Help number through the Net, a buddy, 
  aline 4 @Help gamespy etc... and place it in this field.
  aline 4 @Help an IP number has 4 sets of numbers
  aline 4 @Help seperated by a period and sometimes 
  aline 4 @Help another number at the end seperated
  aline 4 @Help by a colon.  This is an example for you
  aline 4 @Help 120.12.3.144:27500
}
alias help.pass {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Server Password
  aline 4 @Help This is a VERY simple field.  If the 
  aline 4 @Help server you wish to join uses a
  aline 4 @Help password, this is the place you type 
  aline 4 @Help it in.  Once you close the Quake Setup
  aline 4 @Help window then re-opon it, all fields will be
  aline 4 @Help the same as when you closed except
  aline 4 @Help the password field.  I did this because 
  aline 4 @Help not all servers use passwords and 
  aline 4 @Help because I wouldn't have to add a clear
  aline 4 @Help password field.  Make it less cluttered,
  aline 4 @Help and easier for the user.
}
alias help.observe {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Observe Server
  aline 4 @Help This is another simple field.  If yes is
  aline 4 @Help entered in this field, you will observe the
  aline 4 @Help server you are connecting to.  You can
  aline 4 @Help not play on this server...only watch others.
  aline 4 @Help Great for seeing how players do things.
  aline 4 @Help Good for testing new clan members also!
}
alias help.color {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Custom Color
  aline 4 @Help In this section, you the user define the
  aline 4 @Help colors you want the addon to use.  You 
  aline 4 @Help will find Addon Colors under the options
  aline 4 @Help menu.  It's there to help make the addon
  aline 4 @Help blend with your current script...or just to
  aline 4 @Help mess with and have fun.
}
alias help.logging {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Logging
  aline 4 @Help With this system turned On, every time
  aline 4 @Help you join a server of some sort through
  aline 4 @Help QuakeX, it will log the server, pass ( if any )
  aline 4 @Help and full date to help you keep track of 
  aline 4 @Help things.  I found it nice after I joined a server
  aline 4 @Help then got disconnected!
}
alias help.advertising {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Advertising
  aline 4 @Help This area is where you can set and
  aline 4 @Help advertise your ICQ number and clan
  aline 4 @Help info!  I am always asked my clans web
  aline 4 @Help page or my ICQ number...so I added this
  aline 4 @Help stuff to QuakeX.  When you first double
  aline 4 @Help click on one of these items, it will ask you
  aline 4 @Help for the info...the next time you double click
  aline 4 @Help one it will advertise it.
}
alias help.configuration {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Config File 
  aline 4 @Help This is simple.  This is the section where
  aline 4 @Help you add your custom keyboard configuration
  aline 4 @Help to QuakeX!  If you are not sure what this is,
  aline 4 @Help it's where you bind all your keys in your own
  aline 4 @Help way.
}
alias help.uninstall {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Uninstalling Addon
  aline 4 @Help Ok, here is the bad news...when you
  aline 4 @Help double click on this, it uninstalls this
  aline 4 @Help addon. Bummer huh?  There are also
  aline 4 @Help two other ways of uninstalling this
  aline 4 @Help addon.  The first is 1/qunload4
  aline 4 @Help and this is done at the command line.
  aline 4 @Help The second way you can do IF you
  aline 4 @Help have the F-Key option enabled. Do  
  aline 4 @Help it this way by pressing 1Shift + F12 
  aline 4 @Help Please note that when you uninstall
  aline 4 @Help this addon, everything that was added 
  aline 4 @Help to your current copy of mirc, will be
  aline 4 @Help removed!  That way no left over settings  
  aline 4 @Help or configurations will remain, causing
  aline 4 @Help possible conflicts with other addons!
}

alias quakex.options {
  window -al @Options 300 200 230 210 @Options arial 12
  titlebar @Options Menu
  aline @Options Double Click To Edit Options
  aline @Options $str(-,230) 
  aline @Options %quakex.fill-in.color $+ Addon Colors
  aline @Options %quakex.fill-in.color $+ Logging System
  aline @Options %quakex.fill-in.color $+ Advertising System
  aline @Options %quakex.fill-in.color $+ Quake Configuration
  aline @Options $str(-,230)
  aline @Options %quakex.base.color $+ Uninstall Addon
  aline @Options $str(-,230)
  aline @Options %quakex.fill-in.color ? $+ %quakex.base.color $+ Help $+ %quakex.fill-in.color $+ ?
  aline @Options $str(-,230)
  aline @Options %quakex.base.color Exit
}
menu @Options {
  dclick {
    if ($1 < 2) { halt }
    else set %quakex.opt $1
    quakex.options.menu %quakex.opt
  }
  QuakeX Launcher { quakex }
  Run Gamespy { qspy }
  -
  Close Window { window -c @Options }
}

alias quakex.options.menu {
  if ($1 == 3) { quakex.colors }
  elseif ($1 == 4) { quakex.logging }
  elseif ($1 == 5) { quakex.advertising }
  elseif ($1 == 6) { quakex.config }
  elseif ($1 == 7) { halt }
  elseif ($1 == 8) { qunload }
  elseif ($1 == 9) { halt }
  elseif ($1 == 10) { quakex.help }
  elseif ($1 == 11) { halt }
  elseif ($1 == 12) { window -c @Options }
}
alias quakex.colors {
  window -al @Color 250 250 230 240 @Color arial 12
  titlebar @Color Appearance
  aline @Color 1This section changes the color
  aline @Color 1that this addon uses. 
  aline @Color $str(-,230)
  aline @Color 1Please double click the text to edit
  aline @Color $str(-,230)
  aline @Color 1Addon's Base Text
  aline @Color 1Addon's Fill-In Text
  aline @Color $str(-,230)
  aline @Color %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here
  aline @Color $str(-,230)
  aline @Color 1All windows currently open, must
  aline @Color 1be closed before changes occur!
  aline @Color $str(-,230)
  aline @Color %quakex.base.color $+ Exit
}
menu @Color {
  dclick {
    if ($1 < 5) { halt }
    else set %quakex.color.temp $1
    quakex.color.menu %quakex.color.temp
  }
  Close Window { window -c @Color }
}

alias quakex.color.menu {
  if ($1 == 6) { base.color }
  elseif ($1 == 7) { fill-in.color }
  elseif ($1 == 8) { halt }
  elseif ($1 == 11) { halt }
  elseif ($1 == 12) { halt }
  elseif ($1 == 13) { halt }
  elseif ($1 == 14) { window -c @Color }
}

alias base.color {
  window -al @Base 250 0 240 285 @Base arial 12
  titlebar @Base Color Options
  aline @Base Please Choose A Color ( Double Click It )
  aline @Base $str(-,230)
  aline @Base 1Black Text
  aline @Base 11Light Cyan
  aline @Base 10Dark Cyan
  aline @Base 12Light Blue
  aline @Base 2Dark Blue
  aline @Base 9Light Green
  aline @Base 3Dark Green
  aline @Base 4Light Red
  aline @Base 5Dark Red
  aline @Base 13Light Purple
  aline @Base 6Dark Purple
  aline @Base 7Orange
  aline @Base 14Dark Gray
  aline @Base $str(-,240)
  aline @Base Exit
}
menu @Base {
  dclick {
    if ($1 < 2) { halt }
    else set %quakex.base.choice $1
    base.color.menu %quakex.base.choice
  }
  Close Window { window -c @Base }
}

alias base.color.menu {
  if ($1 == 3) { set %quakex.base.color 1 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 4) { set %quakex.base.color 11 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 5) { set %quakex.base.color 10 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 6) { set %quakex.base.color 12 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 7) { set %quakex.base.color 2 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 8) { set %quakex.base.color 9 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 9) { set %quakex.base.color 3 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 10) { set %quakex.base.color 4 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 11) { set %quakex.base.color 5 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 12) { set %quakex.base.color 13 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 13) { set %quakex.base.color 6 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 14) { set %quakex.base.color 7 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 15) { set %quakex.base.color 14 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Base }
  elseif ($1 == 16) { halt }
  elseif ($1 == 17) { window -c @Base }
}
alias fill-in.color {
  window -al @Fill-In 250 0 240 285 @Fill-In arial 12
  titlebar @Fill-In Color Options
  aline @Fill-In Please Choose A Color ( Double Click It )
  aline @Fill-In $str(-,230)
  aline @Fill-In 1Black Text
  aline @Fill-In 11Light Cyan
  aline @Fill-In 10Dark Cyan
  aline @Fill-In 12Light Blue
  aline @Fill-In 2Dark Blue
  aline @Fill-In 9Light Green
  aline @Fill-In 3Dark Green
  aline @Fill-In 4Light Red
  aline @Fill-In 5Dark Red
  aline @Fill-In 13Light Purple
  aline @Fill-In 6Dark Purple
  aline @Fill-In 7Orange
  aline @Fill-In 14Dark Gray
  aline @Fill-In $str(-,240)
  aline @Fill-In Exit
}
menu @Fill-In {
  dclick {
    if ($1 < 2) { halt }
    else set %quakex.fill-in.choice $1
    fill-in.color.menu %quakex.fill-in.choice
  }
  Close Window { window -c @Fill-In }
}

alias fill-in.color.menu { 
  if ($1 == 3) { set %quakex.fill-in.color 1 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 4) { set %quakex.fill-in.color 11 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 5) { set %quakex.fill-in.color 10 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 6) { set %quakex.fill-in.color 12 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 7) { set %quakex.fill-in.color 2 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 8) { set %quakex.fill-in.color 9 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 9) { set %quakex.fill-in.color 3 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 10) { set %quakex.fill-in.color 4 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 11) { set %quakex.fill-in.color 5 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 12) { set %quakex.fill-in.color 13 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 13) { set %quakex.fill-in.color 6 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 14) { set %quakex.fill-in.color 7 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 15) { set %quakex.fill-in.color 14 | rline @Color 9 %quakex.base.color $+ Preview Text: %quakex.fill-in.color $+ Shown Here | window -c @Fill-In }
  elseif ($1 == 16) { halt }
  elseif ($1 == 17) { window -c @Fill-In }
}
alias quakex.logging {
  window -al @Logging 250 0 250 135 @Logging arial 12
  titlebar @Logging System For QuakeX
  aline @Logging 1Double Click To Edit
  aline @Logging $str(-,230)
  aline @Logging %quakex.base.color $+ Logging System: %quakex.fill-in.color $+ %quakex.logging.status
  aline @Logging %quakex.base.color $+ View Log
  aline @Logging %quakex.base.color $+ Delete Log
  aline @Logging $str(-,230)
  aline @Logging 1Exit
}
menu @Logging {
  dclick {
    if ($1 < 2) { halt }
    else set %quakex.logging.choice $1
    quakex.log.status %quakex.logging.choice
  }
  Close Window { window -c @Logging }
}
alias quakex.log.status {
  if ($1 == 3) { 
    if (%quakex.logging.status == Off) {
      set %quakex.log.temp $?!="Do you wish to log your connections.  Good to keep track of servers joined...Turn On?" {
        if (%quakex.log.temp == $true) { set %quakex.logging.status On | rline @Logging 3 %quakex.base.color $+ Logging System: %quakex.fill-in.color $+ %quakex.logging.status }
        elseif (%quakex.log.temp == $false) { set %quakex.logging.status Off | rline @Logging 3 %quakex.base.color $+ Logging System: %quakex.fill-in.color $+ %quakex.logging.status }
      }
    }
    elseif (%quakex.logging.status == On) {
      set %quakex.log.temp $?!="Do you wish to stop logging your connections?" {
        if (%quakex.log.temp == $true) { set %quakex.logging.status Off | rline @Logging 3 %quakex.base.color $+ Logging System: %quakex.fill-in.color $+ %quakex.logging.status }
        elseif (%quakex.log.temp == $false) { set %quakex.logging.status On | rline @Logging 3 %quakex.base.color $+ Logging System: %quakex.fill-in.color $+ %quakex.logging.status }
      }
    }
  }
  elseif ($1 == 4) { run $mircdir $+ quakex_log.txt }
  elseif ($1 == 5) { set %quakex.logging.temp $?!="Are you sure you want to delete?" {
      if (%quakex.logging.temp == $true) { write -c quakex_log.txt }
      if (%quakex.logging.temp == $false) { halt }
    }
  }
  elseif ($1 == 6) { halt }
  elseif ($1 == 7) { window -c @Logging }
}
alias quakex.advertising {
  window -al @Advertising 230 0 320 165 @Advertising arial 12
  titlebar @Advertising Menu
  aline @Advertising 1Double Click To Set Or Advertise
  aline @Advertising 1Right Click To Clear A Setting
  aline @Advertising $str(-,230)
  aline @Advertising %quakex.base.color ICQ Number: %quakex.fill-in.color %quakex.icq
  aline @Advertising %quakex.base.color Clan Webpage: %quakex.fill-in.color %quakex.clan.webpage
  aline @Advertising %quakex.base.color Clan Channel: %quakex.fill-in.color %quakex.clan.channel
  aline @Advertising %quakex.base.color E-Mail: %quakex.fill-in.color %quakex.email.addy
  aline @Advertising $str(-,230)
  aline @Advertising %quakex.base.color Exit
}
menu @Advertising {
  dclick {
    if ($1 < 3) { halt }
    else set %quakex.advertise.click $1
    quakex.advertise.menu %quakex.advertise.click
  }
  Clear Item
  .ICQ Number { set %quakex.icq Empty | rline @Advertising 4 %quakex.base.color ICQ Number: %quakex.fill-in.color %quakex.icq }
  .-
  .Clan Webpage URL { set %quakex.clan.webpage Empty | rline @Advertising 5 %quakex.base.color Clan Webpage: %quakex.fill-in.color %quakex.clan.webpage }
  .-
  .Clan Channel { set %quakex.clan.channel Empty | rline @Advertising 6 %quakex.base.color Clan Channel: %quakex.fill-in.color %quakex.clan.channel }
  .-
  .E-Mail { set %quakex.email.addy Empty | rline @Advertising 7 %quakex.base.color E-Mail Address: %quakex.fill-in.color %quakex.email.addy }
  -
  Close Window { window -c @Advertising }
}
alias quakex.advertise.menu {
  if ($1 == 4) { 
    if (%quakex.icq == $null) || (%quakex.icq == Empty) { set %quakex.icq $$?="Enter Your ICQ Number" | rline @Advertising 4 %quakex.base.color ICQ Number: %quakex.fill-in.color %quakex.icq }
    else {
      set %quakex.q.i $chan(0) 
      if (%quakex.q.i == 0) { halt }
      :loop
      set %quakex.q.chan $chan(%quakex.q.i)
      msg %quakex.q.chan %quakex.base.color My Icq number is: %quakex.fill-in.color %quakex.icq
      dec %quakex.q.i | if (%quakex.q.i > 0) { goto loop }
    }
  }  
  elseif ($1 == 5) { 
    if (%quakex.clan.webpage == $null) || (%quakex.clan.webpage == Empty) { set %quakex.clan.webpage $$?="Please enter your clan's homepage url" | rline @Advertising 5 %quakex.base.color Clan Webpage: %quakex.fill-in.color %quakex.clan.webpage }
    else {
      set %quakex.q.i $chan(0) 
      if (%quakex.q.i == 0) { halt }
      :loop
      set %quakex.q.chan $chan(%quakex.q.i)
      msg %quakex.q.chan %quakex.base.color My Clans Webpage is at: %quakex.fill-in.color %quakex.clan.webpage
      dec %quakex.q.i | if (%quakex.q.i > 0) { goto loop }
    }
  }
  elseif ($1 == 6) {
    if (%quakex.clan.channel == $null) || (%quakex.clan.channel == Empty) { set %quakex.clan.channel $$?="Please enter your clan's channel ( example #DH )" | rline @Advertising 6 %quakex.base.color Clan Channel: %quakex.fill-in.color %quakex.clan.channel }
    else {
      set %quakex.q.i $chan(0) 
      if (%quakex.q.i == 0) { halt }
      :loop
      set %quakex.q.chan $chan(%quakex.q.i)
      msg %quakex.q.chan %quakex.base.color Hey...come check out: %quakex.fill-in.color %quakex.clan.channel
      dec %quakex.q.i | if (%quakex.q.i > 0) { goto loop }
    }
  }
  elseif ($1 == 7) {
    if (%quakex.email.addy == $null) || (%quakex.email.addy == Empty) { set %quakex.email.addy $$?="Please enter your E-Mail address" | rline @Advertising 7 %quakex.base.color E-Mail Address: %quakex.fill-in.color %quakex.email.addy }
    else {
      set %quakex.q.i $chan(0) 
      if (%quakex.q.i == 0) { halt }
      :loop
      set %quakex.q.chan $chan(%quakex.q.i)
      msg %quakex.q.chan %quakex.base.color My E-Mail Address is: %quakex.fill-in.color %quakex.email.addy
      dec %quakex.q.i | if (%quakex.q.i > 0) { goto loop }
    }
  }  
  elseif ($1 == 8) { halt }
  elseif ($1 == 9) { window -c @Advertising }
}
alias quakex.config {
  window -al @Configuration 230 0 200 120 @Configuration arial 12
  titlebar @Configuration File 
  aline @Configuration 1Double Click To Edit
  aline @Configuration $str(-,230)
  aline @Configuration %quakex.base.color Config File: %quakex.fill-in.color %quakex.cfg
  aline @Configuration %quakex.base.color Edit File
  aline @Configuration $str(-,230)
  aline @Configuration %quakex.base.color Exit
}
menu @Configuration {
  dclick {
    if ($1 < 2) { halt }
    else set %quakex.temp.config $1
    quakex.config.menu %quakex.temp.config
  }
  Close Window { window -c @Configuration }
}
alias quakex.config.menu {
  if ($1 == 3) { if ((%quakex.cfg == $null) || (%quakex.cfg == Empty)) { set %quakex.cfg $$?="Enter the name of your custom configuration file ( example dh.cfg )" | rline @Configuration 3 %quakex.base.color Config File: %quakex.fill-in.color %quakex.cfg }
  }
  elseif ($1 == 4) { 
    if (%quakex.qdir1 == Empty) { set %quakex.qdir1 $$?="Please enter the drive letter in which quake is installed ( example D: )" }
    set %quakex.temp.temp $?!="This might take a sec...continue?" {
      if %quakex.temp.temp == $true) { set %quakex.find.temp $findfile(%quakex.qdir1,%quakex.cfg,1) | run notepad %quakex.find.temp }
      elseif (%quakex.temp.temp == $false) { halt }
    }
  }
  elseif ($1 == 5) { halt }
  elseif ($1 == 6) { window -c @Configuration }
}
alias help.shortcuts {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Keyboard Commands
  aline @Help ************* SHORTCUT HELP ***************
  aline 4 @Help $str(-,260)
  aline @Help 1Some Keyboard Shortcuts
  aline 4 @Help $str(-,230)
  aline @Help 1Open QuakeX Launcher Menu - /quakex
  aline @Help 1Open QuakeX Help Menu -/qhelp
  aline @Help 1Open QuakeX Options Menu-/qoptions
  aline @Help 1Uninstall Addon-/qunload
  aline @Help 1Start Gamespy-/qspy
  aline 4 @Help $str(-,260)
  aline @Help 1F-Key Shortcuts ( If Enabled )
  aline 4 @Help $str(-,260)
  aline @Help 1Open QuakeX Launcher Menu = ( Shift + F1 )
  aline @Help 1Start Gamespy = ( Shift + F2 )
  aline @Help 1Open QuakeX Options Menu = ( Shift + F3 )
  aline @Help 1Open QuakeX Help Menu = ( Shift + F4 )
  aline @Help 1Uninstall Addon =  ( Shift + F12 )
  aline @Help 1Connect To Last Ip = ( Control + F1 )
  aline 4 @Help $str(-,260)
}
alias quakex.fkey.help {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Fkey Commands
  aline @Help 1F-Key Shortcuts ( If Enabled )
  aline 4 @Help $str(-,260)
  aline @Help 1Open QuakeX Launcher Menu = ( Shift + F1 )
  aline @Help 1Start Gamespy = ( Shift + F2 )
  aline @Help 1Open QuakeX Options Menu = ( Shift + F3 )
  aline @Help 1Open QuakeX Help Menu = ( Shift + F4 )
  aline @Help 1Uninstall Addon =  ( Shift + F12 )
  aline @Help 1Connect To Last Ip = ( Control + F1 )
  aline 4 @Help $str(-,260)
  aline 4 @Help If you enable this system, you can quickly
  aline 4 @Help access the main sections of QuakeX with
  aline 4 @Help a quick hit of a button.  This system was 
  aline 4 @Help designed to use F-Keys F1 - F4 + F12 with
  aline 4 @Help the Shift key and F1 with the control key!
  aline 4 @Help Most script only use the normal f-keys by 
  aline 4 @Help themselves.  So I thought this way, more
  aline 4 @Help people could enable this feature!!!
  aline 4 @Help $str(-,260) 
  aline 4 @Help To turn on and off in the command line...type:
  aline 4 @Help Turn On = 1/qkey-on
  aline 4 @Help Turn Off = 1/qkey-off
  aline 4 @Help Bring this help menu up = 1/qkey
}
alias quakex.gamespy.help {
  if ($active(@Help) == $active) { window -c @help }
  window -al @Help 0 0 260 500 @Help arial 12
  titlebar @Help With Gamespy
  aline 4 @Help In order to use gamespy, you must
  aline 4 @Help first have it installed on your system!
  aline 4 @Help If you do not have it, you can go
  aline 4 @Help download it at 1www.gamespy.com
  aline 4 @Help If you do already have it, this command
  aline 4 @Help will quickly start gamespy without you
  aline 4 @Help having to go into the start menu, or
  aline 4 @Help find your shortcut somewhere.  It makes
  aline 4 @Help it quick and easy!!!
  aline @Help $str(-,260)
  aline 4 @Help Command Line = 1/qspy
  aline 4 @Help F-Key Option = 1Shift + F2
  aline 4 @Help Also in the channel popups
}
