/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

/*
#pragma off (unreferenced)
static char rcsid[] = "$Id: inferno.c 2.36 1996/01/05 16:52:16 john Exp $";
static char copyright[] = "DESCENT   COPYRIGHT (C) 1994,1995 PARALLAX SOFTWARE CORPORATION";
#pragma on (unreferenced)
*/

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "gr.h"
#include "ui.h"
#include "mono.h"
#include "key.h"
#include "timer.h"
#include "3d.h"
#include "bm.h"
#include "inferno.h"
#include "error.h"
#include "cflib.h"
// #include "div0.h"
#include "game.h"
#include "segment.h"		//for Side_to_verts
#include "mem.h"
#include "textures.h"
#include "segpoint.h"
#include "screens.h"
#include "texmap.h"
#include "texmerge.h"
#include "menu.h"
#include "wall.h"
#include "switch.h"
#include "polyobj.h"
#include "effects.h"
#include "digi.h"
#include "iff.h"
#include "pcx.h"
#include "palette.h"
#include "args.h"
#include "sounds.h"
#include "titles.h"
#include "player.h"
#include "text.h"
#include "ipx.h"
#include "newdemo.h"
#include "victor.h"
#include "network.h"
#include "modem.h"
#include "gamefont.h"
#include "kconfig.h"
#include "arcade.h"
#include "coindev.h"
#include "mouse.h"
#include "joy.h"
#include "newmenu.h"
#include "desc_id.h"
#include "config.h"
#include "joydefs.h"
#include "multi.h"
#include "iglasses.h"
#include "songs.h"
#include "cfile.h"
#include "cdrom.h"
#include "gameseq.h"
#include "music.h"
#include "intrface.h"

#ifdef EDITOR
#include "editor/editor.h"
#include "editor/kdefs.h"
#endif

#include "vers_id.h"

extern int Game_simuleyes_flag;

static const char desc_id_checksum_str[] = DESC_ID_CHKSUM;
char desc_id_exit_num = 0;

int Function_mode=FMODE_MENU;		//game or editor?
int Screen_mode=-1;					//game screen or editor screen?

#ifdef EDITOR
int Inferno_is_800x600_available = 0;
#endif

#ifndef NDEBUG
void do_heap_check()
{
}
#endif

int registered_copy=0;
char name_copy[sizeof(DESC_ID_STR)];

void check_id_checksum_and_date(void);
int init_graphics(void);
int init_gameport(void);
void change_to_dir(char *cmd_line);
void mem_int_to_string( int number, char *dest );
void check_memory(void);
void check_joystick_calibration(void);
void show_order_form(void);


void
check_id_checksum_and_date(void)
{
	const char name[] = DESC_ID_STR;
	char time_str[] = DESC_DEAD_TIME;
	int i, found;
	unsigned long *checksum, test_checksum;
	time_t current_time, saved_time;

	saved_time = (time_t)strtol(&(time_str[strlen(time_str) - 10]), NULL, 16);
	if (saved_time == (time_t)0)
		return;

	strcpy(name_copy,name);
	registered_copy = 1;

	current_time = time(NULL);
	if (current_time >= saved_time)
		desc_id_exit_num = 1;

	test_checksum = 0;
	for (i = 0; i < strlen(name); i++) {
		found = 0;	  
		test_checksum += name[i];
		if (((test_checksum / 2) * 2) != test_checksum)
			found = 1;
		test_checksum = test_checksum >> 1;
		if (found)
			test_checksum |= 0x80000000;
	}
	checksum = (unsigned long *)&(desc_id_checksum_str[0]);
	if (test_checksum != *checksum)
		desc_id_exit_num = 2;

	printf ("%s %s\n", TXT_REGISTRATION, name);
}

int init_graphics(void)
{
	int result;

	result=gr_check_mode(SM_320x200C);
#ifdef EDITOR
	if ( result==0 )	
		result=gr_check_mode(SM_800x600V);
#endif

	switch( result )	{
		case  0:		//Mode set OK
#ifdef EDITOR
						Inferno_is_800x600_available = 1;
#endif
						break;
		case  1:		//No VGA adapter installed
						printf("%s\n", TXT_REQUIRES_VGA );
						return 1;
		case 10:		//Error allocating selector for A0000h
						printf( "%s\n",TXT_ERROR_SELECTOR );
						return 1;
		case 11:		//Not a valid mode support by gr.lib
						printf( "%s\n", TXT_ERROR_GRAPHICS );
						return 1;
#ifdef EDITOR
		case  3:		//Monitor doesn't support that VESA mode.
		case  4:		//Video card doesn't support that VESA mode.

						printf( "Your VESA driver or video hardware doesn't support 800x600 256-color mode.\n" );
						break;
		case  5:		//No VESA driver found.
						printf( "No VESA driver detected.\n" );
						break;
		case  2:		//Program doesn't support this VESA granularity
		case  6:		//Bad Status after VESA call/
		case  7:		//Not enough DOS memory to call VESA functions.
		case  8:		//Error using DPMI.
		case  9:		//Error setting logical line width.
		default:
						printf( "Error %d using 800x600 256-color VESA mode.\n", result );
						break;
#endif
	}

	return 0;
}

extern fix fixed_frametime;

// Returns 1 if ok, 0 if failed...
int init_gameport(void)
{
	// FIXME add joystick module support
  return 1;
}

void change_to_dir(char *cmd_line)
{
	chdir(cmd_line);
}

#define NEEDED_DOS_MEMORY   		( 300*1024)		// 300 K
#define NEEDED_LINEAR_MEMORY 		(7680*1024)		// 7.5 MB
#define LOW_PHYSICAL_MEMORY_CUTOFF	(5*1024*1024)		// 5.0 MB
#define NEEDED_PHYSICAL_MEMORY		(2000*1024)		// 2000 KB

extern int piggy_low_memory;

void mem_int_to_string( int number, char *dest )
{
#if 1
	/* Render the division markers directly in the user's locale.  */
	sprintf(dest, "%'d", number);
#else
	int i,l,c;
	char buffer[20],*p;

	sprintf( buffer, "%d", number );

	l = strlen(buffer);
	if (l<=3) {
		// Don't bother with less than 3 digits
		sprintf( dest, "%d", number );
		return;
	}

	c = l % 3;
	p=dest;
	for (i=0; i<l; i++ ) {
		if (c==0) {
			if (i) *p++=',';
			c = 3;
		}
		c--;
		*p++ = buffer[i];
	}
	*p++ = '\0';
#endif
}

void check_memory(void)
{
}


int Inferno_verbose = 0;

extern int digi_timer_rate;

int descent_critical_error = 0;
unsigned descent_critical_deverror = 0;
unsigned descent_critical_errcode = 0;

extern int Network_allow_socket_changes;

extern void vfx_set_palette_sub(ubyte *);

extern int Game_vfx_flag;
extern int Game_victor_flag;
extern int Game_vio_flag;
extern int Game_3dmax_flag;
extern int VR_low_res;
extern void vfx_init();

#ifdef USE_CD
char destsat_cdpath[128] = "";
int find_descent_cd();
#endif

extern int Config_vr_type;
extern int Config_vr_tracking;

int main(int argc,char **argv)
{
	int i,t;
	ubyte title_pal[768];

	error_init(NULL);

	setbuf(stdout, NULL);	// unbuffered output via printf
		
	InitArgs( argc,argv );

	if ( FindArg( "-verbose" ) )
		Inferno_verbose = 1;

	//change_to_dir(argv[0]);

	// DPMI... bah! -- PCM
	// Initialize DPMI before anything else!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	// (To check memory size and availbabitliy and allocate some low DOS memory)
	if (Inferno_verbose) printf( "%s... ", TXT_INITIALIZING_DPMI);
	if (Inferno_verbose) printf( "\n" );

	if (Inferno_verbose) printf( "\n%s...", TXT_INITIALIZING_CRIT);
	// _harderr((void *) descent_critical_error_handler );
	//Above line modified by KRB, added (void *) cast
	//for the compiler.

#ifdef USE_CD
	i=find_descent_cd();
	if ( i>0 )		{
		sprintf( destsat_cdpath, "%c:\\descent\\", i +'a' - 1  );
		cfile_use_alternate_hogdir( destsat_cdpath );
	} 
#ifdef REQUIRE_CD
	else {		// NOTE ABOVE LINK!!!!!!!!!!!!!!!!!!
		printf( "\n\n" );
#ifdef DEST_SAT
		printf("Couldn't find the 'Descent: Destination Saturn' CD-ROM.\n" );
#else
		printf("Couldn't find the Descent CD-ROM.\n" );
#endif
		printf("Please make sure that it is in your CD-ROM drive and\n" );
		printf("that your CD-ROM drivers are loaded correctly.\n" );
		exit(1);
	}
#endif
#endif

	load_text();

//	set_exit_message("\n\n%s", TXT_THANKS);

	printf("\nDESCENT   %s\n", VERSION_NAME);
	printf("%s\n%s\n",TXT_COPYRIGHT,TXT_TRADEMARK);	

	check_id_checksum_and_date();

	interface_init();

	if (FindArg( "-?" ) || FindArg( "-help" ) || FindArg( "?" ) )	{

		printf( "%s\n", TXT_COMMAND_LINE_0 );

		printf("  -SimulEyes     %s\n",
				"Enables StereoGraphics SimulEyes VR stereo display" );

		printf("  -Iglasses      %s\n", TXT_IGLASSES );
		printf("  -VioTrack <n>  %s n\n",TXT_VIOTRACK );
		printf("  -3dmaxLo       %s\n",TXT_KASAN );
		printf("                 %s\n",TXT_KASAN_2 );
		printf("  -3dmaxHi       %s\n",TXT_3DMAX );
		printf( "%s\n", TXT_COMMAND_LINE_1 );
		printf( "%s\n", TXT_COMMAND_LINE_2 );
		printf( "%s\n", TXT_COMMAND_LINE_3 );
		printf( "%s\n", TXT_COMMAND_LINE_4 );
		printf( "%s\n", TXT_COMMAND_LINE_5 );
//		printf( "\n");
		printf( "%s\n", TXT_COMMAND_LINE_6 );
		printf( "%s\n", TXT_COMMAND_LINE_7 );
		printf( "%s\n", TXT_COMMAND_LINE_8 );
//		printf( "\n");
		printf( "\n%s\n",TXT_PRESS_ANY_KEY3);
		getc(stdin);
		printf( "\n" );
		printf( "%s\n", TXT_COMMAND_LINE_9);
		printf( "%s\n", TXT_COMMAND_LINE_10);
		printf( "%s\n", TXT_COMMAND_LINE_11);
		printf( "%s\n", TXT_COMMAND_LINE_12);
		printf( "%s\n", TXT_COMMAND_LINE_13);
		printf( "%s\n", TXT_COMMAND_LINE_14);
		printf( "%s\n", TXT_COMMAND_LINE_15);
		printf( "%s\n", TXT_COMMAND_LINE_16);
		printf( "%s\n", TXT_COMMAND_LINE_17);
		printf( "%s\n", TXT_COMMAND_LINE_18);
      printf( "  -DynamicSockets %s\n", TXT_SOCKET);
      printf( "  -NoFileCheck    %s\n", TXT_NOFILECHECK);
      printf( "  -GamePort       %s\n", "Use Colorado Spectrum's Notebook Gameport" );
		printf( "  -NoDoubleBuffer %s\n", "Use only one page of video memory" );
		printf( "  -LCDBios        %s\n", "Enables LCDBIOS for using LCD shutter glasses" );
		printf( "  -JoyNice        %s\n", "Joystick poller allows interrupts to occur" );
		set_exit_message("");
		return(0);
	}

	printf("\n%s\n", TXT_HELP);	

	#ifdef PASSWORD
	if ((t = FindArg("-pswd")) != 0) {
		int	n;
		byte	*pp = Side_to_verts;
		int ch;
		for (n=0; n<6; n++)
			for (ch=0; ch<strlen(Args[t+1]); ch++)
				*pp++ ^= Args[t+1][ch];
	}
	else 
		Error("Invalid processor");		//missing password
	#endif

	if ( FindArg( "-autodemo" ))
		Auto_demo = 1;

	#ifndef RELEASE
	if ( FindArg( "-noscreens" ) )
		Skip_briefing_screens = 1;
	#endif

	Lighting_on = 1;

	strcpy(Menu_pcx_name, "menu.pcx");	//	Used to be menu2.pcx.

	if (init_graphics()) return 1;

	#ifdef EDITOR
	if (!Inferno_is_800x600_available)	{
		printf( "The editor will not be available, press enter to start game...\n" );
		Function_mode = FMODE_MENU;
		getchar();
	}
	#endif

	#ifndef NDEBUG
		minit();
		mopen( 0, 9, 1, 78, 15, "Debug Spew");
		mopen( 1, 2, 1, 78,  5, "Errors & Serious Warnings");
	#endif

	//lib_init("INFERNO.DAT");

	if (Inferno_verbose) printf ("%s", TXT_VERBOSE_1);
	ReadConfigFile();
	if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_2);

	timer_init();
	timer_set_rate( digi_timer_rate );			// Tell our timer how fast to go (120 Hz)
	joy_set_timer_rate( digi_timer_rate );	 	// Tell joystick how fast timer is going

	if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_3);
	key_init();
	if (!FindArg( "-nomouse" ))	{
		if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_4);
		if (FindArg( "-nocyberman" ))
			mouse_init(0);
		else
			mouse_init(1);
	} else {
	 	if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_5);
	}
	if (!FindArg( "-nojoystick" ))	{
		if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_6);
		joy_init();
		if ( FindArg( "-joyslow" ))	{
			if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_7);
			joy_set_slow_reading(JOY_SLOW_READINGS);
		}
		if ( FindArg( "-joypolled" ))	{
			if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_8);
			joy_set_slow_reading(JOY_POLLED_READINGS);
		}
		if ( FindArg( "-joybios" ))	{
			if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_9);
			joy_set_slow_reading(JOY_BIOS_READINGS);
		}
		if ( FindArg( "-joynice" ))	{
			if (Inferno_verbose) printf( "\n%s", "Using nice joystick poller..." );
			joy_set_slow_reading(JOY_FRIENDLY_READINGS);
		}
		if ( FindArg( "-gameport" ))	{
			if ( init_gameport() )	{			
				joy_set_slow_reading(JOY_BIOS_READINGS);
			} else {
				Error( "\nCouldn't initialize the Notebook Gameport.\nMake sure the NG driver is loaded.\n" );
			}
		}
	} else {
		if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_10);
	}
	if (Inferno_verbose) printf( "\n%s", TXT_VERBOSE_11);
	// div0_init(DM_ERROR); <-- We don need no steenking /0

	//------------ Init sound ---------------
	if (!FindArg( "-nosound" ))	{
		if (digi_init())	{
			printf( "\n%s\n", TXT_PRESS_ANY_KEY3);
			key_getch();
		}
	} else {
		if (Inferno_verbose) printf( "\n%s",TXT_SOUND_DISABLED );
	}

	if (!FindArg( "-nonetwork" ))	{
		int socket=0, showaddress=0;
		int ipx_error;
		if (Inferno_verbose) printf( "\n%s ", TXT_INITIALIZING_NETWORK);
		if ((t=FindArg("-socket")))
			socket = atoi( Args[t+1] );
		if ( FindArg("-showaddress") ) showaddress=1;
		if ((ipx_error=ipx_init(IPX_DEFAULT_SOCKET+socket,showaddress))==0)	{
  			if (Inferno_verbose) printf( "%s %d.\n", TXT_IPX_CHANNEL, socket );
			Network_active = 1;
		} else {
			switch( ipx_error )	{
			case 3: 	if (Inferno_verbose) printf( "%s\n", TXT_NO_NETWORK); break;
			case -2: if (Inferno_verbose) printf( "%s 0x%x.\n", TXT_SOCKET_ERROR, IPX_DEFAULT_SOCKET+socket); break;
			case -4: if (Inferno_verbose) printf( "%s\n", TXT_MEMORY_IPX ); break;
			default:
				if (Inferno_verbose) printf( "%s %d", TXT_ERROR_IPX, ipx_error );
			}
			if (Inferno_verbose) printf( "%s\n",TXT_NETWORK_DISABLED);
			Network_active = 0;		// Assume no network
		}
		ipx_read_user_file( "descent.usr" );
		ipx_read_network_file( "descent.net" );
		if ( FindArg( "-dynamicsockets" ))
			Network_allow_socket_changes = 1;
		else
			Network_allow_socket_changes = 0;
	} else {
		if (Inferno_verbose) printf( "%s\n", TXT_NETWORK_DISABLED);
		Network_active = 0;		// Assume no network
	}

	if (!FindArg("-noserial"))
	{
		serial_active = 1;
	}
	else 
	{
		serial_active = 0;
	}

	i = FindArg( "-vfxtrak" );
	if ( i > 0 )
		kconfig_sense_init();
	else if ((Config_vr_type==1)&&(Config_vr_tracking>0))
		kconfig_sense_init();
		
	i = FindArg( "-maxxtrak" );
	if ( i > 0)	
		victor_init_tracking( atoi(Args[i+1]) );
	else if ((Config_vr_type==2)&&(Config_vr_tracking>0))
		victor_init_tracking( Config_vr_tracking );

	// i = FindArg( "-viotrack" );
	{
		int screen_mode = SM_320x200C;
		int screen_width = 320;
		int screen_height = 200;
		int vr_mode = VR_NONE;
		int screen_compatible = 1;
		int use_double_buffer = 0;

		if ( FindArg( "-320x240" ))	{
			if (Inferno_verbose) printf( "Using 320x240 ModeX...\n" );
			screen_mode = SM_320x240U; 
			screen_width = 320;	
			screen_height = 240;
			screen_compatible = 0;
			use_double_buffer = 1;
		}
		if ( FindArg( "-320x400" ))	{
			if (Inferno_verbose) printf( "Using 320x400 ModeX...\n" );
			screen_mode = SM_320x400U; 
			screen_width = 320;	
			screen_height = 400;
			screen_compatible = 0;
			use_double_buffer = 1;
		}

		if (!Game_simuleyes_flag && FindArg( "-640x400" ))	{
			if (Inferno_verbose) printf( "Using 640x400 VESA...\n" );
			screen_mode = SM_640x400V; 
			screen_width = 640;	
			screen_height = 400;
			screen_compatible = 0;
			use_double_buffer = 1;
		}

		if (!Game_simuleyes_flag && FindArg( "-640x480" ))	{
			if (Inferno_verbose) printf( "Using 640x480 VESA...\n" );
			screen_mode = SM_640x480V; 
			screen_width = 640;	
			screen_height = 480;
			screen_compatible = 0;
			use_double_buffer = 1;
		}
		if ( FindArg( "-320x100" ))	{
			if (Inferno_verbose) printf( "Using 320x100 VGA...\n" );
			screen_mode = 19; 
			screen_width = 320;	
			screen_height = 100;
			screen_compatible = 0;
		}

		if (FindArg( "-800x600" )) {
			if (Inferno_verbose) printf( "Using 800x600...\n" );
			screen_mode = SM_800x600V; 
			screen_width = 800;	
			screen_height = 600;
		}
		if (FindArg( "-1024x768" )) {
			if (Inferno_verbose) printf( "Using 1024x768...\n" );
			screen_mode = SM_1024x768V;
			screen_width = 1024;
			screen_height = 768;
		}

		if ( FindArg( "-nodoublebuffer" ) )	{
			if (Inferno_verbose)
				printf( "Double-buffering disabled...\n" );
			use_double_buffer = 0;
		}

		if ( vr_mode == VR_INTERLACED ) 
			screen_height /= 2;
		game_init_render_buffers(screen_mode, screen_width, screen_height, use_double_buffer, vr_mode, screen_compatible );
	}

	if (Game_victor_flag) {
		char *vswitch = getenv( "CYBERMAXX" );
		if ( vswitch )	{
			char *p = strstr( vswitch, "/E:R" ); 
			if ( p )	{
				VR_switch_eyes = 1;
			} else 
				VR_switch_eyes = 0;
		} else {		
		 	VR_switch_eyes = 0;
		}
	}


#ifdef ARCADE
	i = FindArg( "-arcade" );
	if (i > 0 )	{
		arcade_init();
		coindev_init(0);
	}
#endif

#ifdef NETWORK
//	i = FindArg( "-rinvul" );
//	if (i > 0) {
//		int mins = atoi(Args[i+1]);
//		if (mins > 314)
//			mins = 314;
// 	control_invul_time = mins/5;
//	}
	control_invul_time = 0;
#endif

	i = FindArg( "-xcontrol" );
	if ( i > 0 )	{
		kconfig_init_external_controls( strtol(Args[i+1], NULL, 0), strtol(Args[i+2], NULL, 0) );
	}

	if (Inferno_verbose) printf( "\n%s\n\n", TXT_INITIALIZING_GRAPHICS);
	if ((t=gr_init( SM_ORIGINAL ))!=0)
		Error(TXT_CANT_INIT_GFX,t);
	// Load the palette stuff. Returns non-zero if error.
	mprintf( (0, "Going into graphics mode..." ));
	gr_set_mode(SM_320x200C);
	mprintf( (0, "\nInitializing palette system..." ));
	gr_use_palette_table( "PALETTE.256" );
	mprintf( (0, "\nInitializing font system..." ));
	gamefont_init();	// must load after palette data loaded.
	songs_play_song( SONG_TITLE, 1 );

	//#ifndef RELEASE
	if ( !FindArg( "-notitles" ) ) 
	//#endif
	  {
	    mprintf((0,"\nUsing titles...\n"));
	    
	    //NOTE LINK TO ABOVE!
		    show_title_screen( "iplogo1.pcx", 1 );
		show_title_screen( "logo.pcx", 1 );
#ifdef HAVE_X11
		(*int_gr_update)();
#endif
	}

	{
		//grs_bitmap title_bm;
		int pcx_error;
		char filename[14];

		strcpy(filename, "descent.pcx");

		if ((pcx_error=pcx_read_bitmap( filename, &grd_curcanv->cv_bitmap, grd_curcanv->cv_bitmap.bm_type, title_pal ))==PCX_ERROR_NONE)	{
			//vfx_set_palette_sub( title_pal );
			gr_palette_clear();
			//gr_bitmap( 0, 0, &title_bm );
			gr_palette_fade_in( title_pal, 32, 0 );
			//free(title_bm.bm_data);
		} else {
			gr_close();
			Error( "Couldn't load pcx file '%s', PCX load error: %s\n",filename, pcx_errormsg(pcx_error));
		}
	}

#ifdef EDITOR
	if ( !FindArg("-nobm") )
		bm_init_use_tbl();
	else
		bm_init();
#else
		bm_init();
#endif

	if ( FindArg( "-norun" ) )
		return(0);

	mprintf( (0, "\nInitializing 3d system..." ));
	g3_init();
	mprintf( (0, "\nInitializing texture caching system..." ));
	texmerge_init( 10 );		// 10 cache bitmaps
	mprintf( (0, "\nRunning game...\n" ));
	set_screen_mode(SCREEN_MENU);

	init_game();
	set_detail_level_parameters(Detail_level);

	Players[Player_num].callsign[0] = '\0';
	if (!Auto_demo) 	{
		key_flush();
		RegisterPlayer();		//get player's name
	}

	gr_palette_fade_out( title_pal, 32, 0 );

	//check for special stamped version
	if (registered_copy) {
		nm_messagebox("EVALUATION COPY",1,"Continue",
			"This special evaluation copy\n"
			"of DESCENT has been issued to:\n\n"
			"%s\n"
			"\n\n    NOT FOR DISTRIBUTION",
			name_copy);

		gr_palette_fade_out( gr_palette, 32, 0 );
	}

	//kconfig_load_all();

	Game_mode = GM_GAME_OVER;

	if (Auto_demo)	{
		newdemo_start_playback("DESCENT.DEM");		
		if (Newdemo_state == ND_STATE_PLAYBACK )
			Function_mode = FMODE_GAME;
	}

	build_mission_list(0);		// This also loads mission 0.

	while (Function_mode != FMODE_EXIT)
	{
		switch( Function_mode )	{
		case FMODE_MENU:
			if ( Auto_demo )	{
				newdemo_start_playback(NULL);		// Randomly pick a file
				if (Newdemo_state != ND_STATE_PLAYBACK)	
					Error("No demo files were found for autodemo mode!");
			} else {
				check_joystick_calibration();
				DoMenu();									 	
#ifdef EDITOR
				if ( Function_mode == FMODE_EDITOR )	{
					create_new_mine();
					SetPlayerFromCurseg();
				}
#endif
			}
			break;
		case FMODE_GAME:
			#ifdef EDITOR
				keyd_editor_mode = 0;
			#endif
			// kbd_update();
			game();
			if ( Function_mode == FMODE_MENU )
				songs_play_song( SONG_TITLE, 1 );
			break;
		#ifdef EDITOR
		case FMODE_EDITOR:
			keyd_editor_mode = 1;
			editor();
			#ifdef __WATCOMC__
			_harderr( (void *)descent_critical_error_handler );		// Reinstall game error handler
			#endif
			if ( Function_mode == FMODE_GAME ) {
				Game_mode = GM_EDITOR;
				editor_reset_stuff_on_level();
				N_players = 1;
			}
			break;
		#endif
		default:
			Error("Invalid function mode %d",Function_mode);
		}
	}

	WriteConfigFile();

#ifndef ROCKWELL_CODE
	#ifndef RELEASE
	if (!FindArg( "-notitles" ))
	#endif
		//NOTE LINK TO ABOVE!!
	#ifndef EDITOR
		show_order_form();
	#endif
#endif

#ifdef WANT_MUSIC
        kill_ipc();
#endif

	#ifndef NDEBUG
	if ( FindArg( "-showmeminfo" ) )
//		show_mem_info = 1;		// Make memory statistics show
	#endif

	return(0);		//presumably successful exit
}


void check_joystick_calibration(void)	{
	int x1, y1, x2, y2, c;
	fix t1;

	if ( (Config_control_type!=CONTROL_JOYSTICK) &&
		  (Config_control_type!=CONTROL_FLIGHTSTICK_PRO) &&
		  (Config_control_type!=CONTROL_THRUSTMASTER_FCS) &&
		  (Config_control_type!=CONTROL_GRAVIS_GAMEPAD)
		) return;

	joy_get_pos( &x1, &y1 );

	t1 = timer_get_fixed_seconds();
	while( timer_get_fixed_seconds() < t1 + F1_0/100 )
		;

	joy_get_pos( &x2, &y2 );

	// If joystick hasn't moved...
	if ( (abs(x2-x1)<30) &&  (abs(y2-y1)<30) )	{
		if ( (abs(x1)>30) || (abs(x2)>30) ||  (abs(y1)>30) || (abs(y2)>30) )	{
			c = nm_messagebox( NULL, 2, TXT_CALIBRATE, TXT_SKIP, TXT_JOYSTICK_NOT_CEN );
			if ( c==0 )	{
				joydefs_calibrate();
			}
		}
	}

}

void show_order_form(void)
{
	int pcx_error;
	char title_pal[768];
	char	exit_screen[16];

	gr_set_current_canvas( NULL );
	gr_palette_clear();

	key_flush();		

#ifdef SHAREWARE
	strcpy(exit_screen, "order01.pcx");
#else
	#ifdef DEST_SAT
		strcpy(exit_screen, "order01.pcx");
	#else
		strcpy(exit_screen, "warning.pcx");
	#endif
#endif
	if ((pcx_error=pcx_read_bitmap( exit_screen, &grd_curcanv->cv_bitmap, grd_curcanv->cv_bitmap.bm_type, title_pal ))==PCX_ERROR_NONE) {
		//vfx_set_palette_sub( title_pal );
		gr_palette_fade_in( title_pal, 32, 0 );
#if 0
		{
			int done=0;
			fix time_out_value = timer_get_approx_seconds()+i2f(60*5);
			while(!done)	{
				if ( timer_get_approx_seconds() > time_out_value ) done = 1;
				if (key_inkey()) done = 1;
			}
		}
#endif
		gr_palette_fade_out( title_pal, 32, 0 );		
	}
	key_flush();		
}

