// Interface to the rest of the game.
//
// Fri Jan 30 19:30:51 EST 1998
// Patrick McCarthy
// Time of creation.

#ifndef INTERFACE_H
#define INTERFACE_H

#define INTERFACE_SVGALIB	1
#define INTERFACE_GGI		2
#define INTERFACE_X11		3

extern int		cur_interface;

extern int		(*int_gr_set_mode)(int mode);
extern void		(*int_gr_get_palette)(char *pal);
extern void		(*int_gr_set_palette)(char *pal);
extern void		(*int_gr_set_drawing_page)(int page);
extern void		(*int_gr_set_viewing_page)(int page);
extern void		(*int_gr_bank)(int bank);
extern void		(*int_gr_modex_plane)(int plane);
extern void		(*int_gr_update)(void);
extern int		(*int_gr_get_gran)(void);
extern unsigned char *	(*int_gr_get_buffer)(void);
extern int		(*int_gr_bm_type)(void);
extern void		(*int_kbd_init)(void);
extern void		(*int_kbd_update)(void);
extern void		(*int_kbd_close)(void);
/* Initialize mouse. Returns 0 if ok, != 0 for error. */
extern int		(*int_mouse_init)(void);
/* Get mouse status. dx,dy is mickeys moved since last call, buttons */
/* is a bitmask of the pressed buttons in the order 0,1,2=left,right,mid */
extern void		(*int_mouse_update)(int *dx, int *dy, int *buttons);
extern void		(*int_mouse_close)(void);

#ifdef HAVE_X11
extern int		x11_set_mode(int mode);
extern void		x11_get_palette(char *pal);
extern void		x11_set_palette(char *pal);
extern void		x11_set_drawing_page(int page);
extern void		x11_set_viewing_page(int page);
extern void		x11_bank(int bank);
extern void		x11_modex_plane(int plane);
extern int		x11_get_gran(void);
extern unsigned char *	x11_get_buffer(void);
extern int		x11_bm_type(void);
extern void		x11_keyboard_init(void);
extern void		x11_keyboard_update(void);
extern void		x11_keyboard_close(void);
extern int		x11_mouse_init(void);
extern void		x11_mouse_update(int *dx, int *dy, int *buttons);
extern void		x11_mouse_close(void);
extern void             x11_close_down(void);
/* game or menu-mode (needed for text-display) */
extern int              x11_game_mode;
#endif

#ifdef HAVE_GGI
extern int		dggi_set_mode(int mode);
extern void		dggi_get_palette(char *pal);
extern void		dggi_set_palette(char *pal);
extern void		dggi_set_drawing_page(int page);
extern void		dggi_set_viewing_page(int page);
extern void		dggi_bank(int bank);
extern void		dggi_modex_plane(int plane);
extern void		dggi_update(void);
extern int		dggi_get_gran(void);
extern unsigned char *	dggi_get_buffer(void);
extern int		dggi_bm_type(void);
extern void		dggi_keyboard_init(void);
extern void		dggi_keyboard_update(void);
extern void		dggi_keyboard_close(void);
extern int		dggi_mouse_init(void);
extern void		dggi_mouse_update(int *dx, int *dy, int *buttons);
extern void		dggi_mouse_close(void);
#endif

#ifdef HAVE_SVGALIB
extern int		svgalib_set_mode(int mode);
extern void		svgalib_get_palette(char *pal);
extern void		svgalib_set_palette(char *pal);
extern void		svgalib_set_drawing_page(int page);
extern void		svgalib_set_viewing_page(int page);
extern void		svgalib_bank(int bank);
extern void		svgalib_modex_plane(int plane);
extern void		svgalib_update(void);
extern int		svgalib_get_gran(void);
extern unsigned char *	svgalib_get_buffer(void);
extern int		svgalib_bm_type(void);
extern void		svgalib_keyboard_init(void);
extern void		svgalib_keyboard_update(void);
extern void		svgalib_keyboard_close(void);
extern int		svgalib_mouse_init(void);
extern void		svgalib_mouse_update(int *dx, int *dy, int *buttons);
extern void		svgalib_mouse_close(void);
#endif

extern void		interface_init(void);

#endif
