// Interface to the rest of the game.
//
// Fri Jan 30 19:20:54 EST 1998
// Patrick McCarthy
// Time of creation.

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include "intrface.h"
#include "key.h"
#include "timer.h"
#include "error.h"

int		cur_interface=0;

int		(*int_gr_set_mode)(int mode);
void		(*int_gr_get_palette)(char *pal);
void		(*int_gr_set_palette)(char *pal);
void		(*int_gr_set_drawing_page)(int page);
void		(*int_gr_set_viewing_page)(int page);
void		(*int_gr_bank)(int bank);
void		(*int_gr_modex_plane)(int plane);
void		(*int_gr_update)(void);
int		(*int_gr_get_gran)(void);
unsigned char *	(*int_gr_get_buffer)(void);
int		(*int_gr_bm_type)(void);
void		(*int_kbd_init)(void);
void		(*int_kbd_update)(void);
void		(*int_kbd_close)(void);
int		(*int_mouse_init)(void);
void		(*int_mouse_update)(int *dx, int *dy, int *buttons);
void		(*int_mouse_close)(void);

void interface_init(void) {
  
  // At some point in time we're going to want to put checking code in.
#ifdef HAVE_X11
	if (getenv("DISPLAY") || FindArg("-display")) {
		cur_interface=INTERFACE_X11;
		int_gr_set_mode=x11_set_mode;
		int_gr_get_palette=x11_get_palette;
		int_gr_set_palette=x11_set_palette;
		int_gr_set_drawing_page=x11_set_drawing_page;
		int_gr_set_viewing_page=x11_set_viewing_page;
		int_gr_bank=x11_bank;
		int_gr_modex_plane=x11_modex_plane;
		int_gr_update=NULL;
		int_gr_get_gran=x11_get_gran;
		int_gr_get_buffer=x11_get_buffer;
		int_gr_bm_type=x11_bm_type;
		int_kbd_init=x11_keyboard_init;
		int_kbd_update=x11_keyboard_update;
		int_kbd_close=x11_keyboard_update;
		int_mouse_init=x11_mouse_init;
		int_mouse_update=x11_mouse_update;
		int_mouse_close=x11_mouse_close;
		fprintf(stdout,"Using XLib.\n");
		return;
	}
#endif
#ifdef HAVE_GGI
                // I *think* ggi_'s are reserved by the lib itself pretty much
		// so I'll put in dggi's instead. (Descent GGI)
		cur_interface=INTERFACE_GGI;
		int_gr_set_mode=dggi_set_mode;
		int_gr_get_palette=dggi_get_palette;
		int_gr_set_palette=dggi_set_palette;
		int_gr_set_drawing_page=dggi_set_drawing_page;
		int_gr_set_viewing_page=dggi_set_viewing_page;
		int_gr_bank=dggi_bank;
		int_gr_modex_plane=dggi_modex_plane;
		int_gr_update=dggi_update;
		int_gr_get_gran=dggi_get_gran;
		int_gr_get_buffer=dggi_get_buffer;
		int_gr_bm_type=dggi_bm_type;
		int_kbd_init=dggi_keyboard_init;
		int_kbd_update=dggi_keyboard_update;
		int_kbd_close=dggi_keyboard_update;
		int_mouse_init=dggi_mouse_init;
		int_mouse_update=dggi_mouse_update;
		int_mouse_close=dggi_mouse_close;
		fprintf(stdout,"Using GGI.\n");
		return;
#endif
#ifdef HAVE_SVGALIB
		cur_interface=INTERFACE_SVGALIB;
		int_gr_set_mode=svgalib_set_mode;
		int_gr_get_palette=svgalib_get_palette;
		int_gr_set_palette=svgalib_set_palette;
		int_gr_set_drawing_page=svgalib_set_drawing_page;
		int_gr_set_viewing_page=svgalib_set_viewing_page;
		int_gr_bank=svgalib_bank;
		int_gr_modex_plane=svgalib_modex_plane;
		int_gr_update=svgalib_update;
		int_gr_get_gran=svgalib_get_gran;
		int_gr_get_buffer=svgalib_get_buffer;
		int_gr_bm_type=svgalib_bm_type;
		int_kbd_init=svgalib_keyboard_init;
		int_kbd_update=svgalib_keyboard_update;
		int_kbd_close=svgalib_keyboard_update;
		int_mouse_init=svgalib_mouse_init;
		int_mouse_update=svgalib_mouse_update;
		int_mouse_close=svgalib_mouse_close;
		fprintf(stdout,"Using SVGALib.\n");
		return;
#endif

    // fall through if no compatible display drivers found
	Error("No compatible display drivers found!"
#ifdef HAVE_X11
		 " (set the DISPLAY variabele to use X)"
#endif
		 );
	
	// Down here we'd split off the sound server..
}

// Stub vars/procs for the keyboard.
	volatile	keyboard	key_data;
			unsigned char	keyd_buffer_type;
			unsigned char	keyd_repeat;
			unsigned char	keyd_editor_mode;
	volatile	unsigned char	keyd_last_pressed;
	volatile	unsigned char	keyd_last_released;
	volatile	unsigned char	keyd_pressed[256];
	volatile	int		keyd_time_when_last_pressed;
static			unsigned char	kbd_installed=0;

unsigned char ascii_table[128] =
{ 255, 255, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=',255,255,
  'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', 255, 255,
  'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', 39, '`',
  255, '\\', 'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/', 255,'*',
  255, ' ', 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,255,255,
  255, 255, 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255 };

unsigned char shifted_ascii_table[128] =
{ 255, 255, '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+',255,255,
  'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', 255, 255,
  'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', '"', '~',
  255, '|', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '<', '>', '?', 255,255,
  255, ' ', 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,255,255,
  255, 255, 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255 };

unsigned char key_to_ascii(int keycode) {
	int shifted;
	shifted=keycode&KEY_SHIFTED; keycode&=0x7f;
	if (shifted) return shifted_ascii_table[keycode];
	return ascii_table[keycode];
}

void key_clear_bios_buffer_all() { }
void key_clear_bios_buffer() { }

void key_flush() {
	int i;
	fix curtime;
	
	key_data.keyhead=key_data.keytail=0;
	
	for (i=0;i<KEY_BUFFER_SIZE;i++) {
		key_data.keybuffer[i]=0;
		key_data.time_pressed[i]=0;
	}
	
	curtime=timer_get_fixed_secondsX();
	
	for (i=0;i<256;i++) {
		keyd_pressed[i]=0;
		key_data.TimeKeyWentDown[i]=curtime;
		key_data.TimeKeyHeldDown[i]=0;
		key_data.NumDowns[i]=0;
		key_data.NumUps[i]=0;
	}
}

int add_one(int n) {
	n++;
	if (n>=KEY_BUFFER_SIZE) n=0;
	return n;
}

int key_checkch() {
	int is_one_waiting=0;
	int_kbd_update();
	if (key_data.keytail!=key_data.keyhead)
		is_one_waiting=1;
	return is_one_waiting;
}

int key_inkey() {
	int key=0;
	int_kbd_update();
	if (key_data.keytail!=key_data.keyhead) {
		key=key_data.keybuffer[key_data.keyhead];
		key_data.keyhead=add_one(key_data.keyhead);
	}
	return key;
}

int key_inkey_time(fix *time) {
	int key=0;
	int_kbd_update();
	if (key_data.keytail!=key_data.keyhead) {
		key=key_data.keybuffer[key_data.keyhead];
		*time=key_data.time_pressed[key_data.keyhead];
		key_data.keyhead=add_one(key_data.keyhead);
	}
	return key;
}

int key_peekkey() {
	int key=0;
	int_kbd_update();
	if (key_data.keytail!=key_data.keyhead)
		key=key_data.keybuffer[key_data.keyhead];
	return key;
}

int key_getch() {
	if (!kbd_installed) return getc(stdin);
	while (!key_checkch())
		usleep(100);	// This is better than dummy++;   ;)
	return key_inkey();
}

unsigned int key_get_shift_status() {
	int_kbd_update();
	return
		 ((keyd_pressed[KEY_LSHIFT]||keyd_pressed[KEY_RSHIFT])?KEY_SHIFTED:0)
#ifndef NDEBUG
		|((keyd_pressed[KEY_DELETE])?KEY_DEBUGGED:0)
#endif
		|((keyd_pressed[KEY_LALT]||keyd_pressed[KEY_RALT])?KEY_ALTED:0)
		|((keyd_pressed[KEY_LCTRL]||keyd_pressed[KEY_RCTRL])?KEY_CTRLED:0);
}

fix key_down_time(int scancode) {
	fix time_down, time;
	
	if (scancode<0||scancode>255) return 0;
#ifndef NDEBUG
	if (keyd_editor_mode&&key_get_shift_status)
		return 0;
#endif

	if (!keyd_pressed[scancode]) {
		time_down=key_data.TimeKeyHeldDown[scancode];
		key_data.TimeKeyHeldDown[scancode]=0;
	} else {
		time=timer_get_fixed_secondsX();
		time_down=time-key_data.TimeKeyWentDown[scancode];
		key_data.TimeKeyWentDown[scancode]=time;
	}
	
	return time_down;
}

unsigned int key_down_count(int scancode) {
	int n;
	
	if (scancode<0||scancode>255) return 0;
	n=key_data.NumDowns[scancode];
	key_data.NumDowns[scancode]=0;
	return n;
}

unsigned int key_up_count(int scancode) {
	int n;
	
	if (scancode<0||scancode>255) return 0;
	n=key_data.NumUps[scancode];
	key_data.NumUps[scancode]=0;
	return n;
}

void key_init() {
	if (kbd_installed) return;
	int_kbd_init();
	kbd_installed=1;
}

void key_close() {
	if (!kbd_installed) return;
	int_kbd_close();
	kbd_installed=0;
}

// Stub procs for the mouse.
#define MOUSE_MAX_BUTTONS 3
struct mouse_data {
	int installed;
	int buttons;
	int x, y;
	int dx, dy;
	fix down_time[MOUSE_MAX_BUTTONS];
	int down_count[MOUSE_MAX_BUTTONS];
	int min_x, min_y, max_x, max_y;
};
static struct mouse_data mouse;

int mouse_init(int enable_cyberman) {
	memset(&mouse, 0, sizeof(mouse));
	
	if (int_mouse_init()) {
		printf("No mouse installed.\n");
		return 0;
	}
	printf("Mouse installed.\n");
	mouse.installed = 1;
	return 1;
}

void mouse_close() { 
	if (mouse.installed)
		int_mouse_close();
}

int mouse_set_limits(int x1, int y1, int x2, int y2) {
	mouse.min_x = x1;
	mouse.min_y = y1;
	mouse.max_x = x2;
	mouse.max_y = y2;
    return 0;
}

static void do_mouse_poll() {
	int delta_x, delta_y, i, newbuttons, x, y;
	fix time;

	if (!mouse.installed)
		return;
	int_mouse_update(&delta_x, &delta_y, &newbuttons);

	time = timer_get_fixed_seconds();
	for (i = 0; i < MOUSE_MAX_BUTTONS; i++)
		if (((newbuttons ^ mouse.buttons) >> i) & 1) {
			if ((newbuttons >> i) & 1) {
				mouse.down_count[i]++;
				mouse.down_time[i] = time;
			} else
				mouse.down_time[i] = time - mouse.down_time[i];
		}
	mouse.buttons = newbuttons;
   
	mouse.dx += delta_x;
	mouse.dy += delta_y;

	x = mouse.x + delta_x;
	y = mouse.y + delta_y;
	if (x > mouse.max_x)
		x = mouse.max_x;
	if (x < mouse.min_x)
		x = mouse.min_x;
	if (y > mouse.max_y)
		y = mouse.max_y;
	if (y < mouse.min_y)
		y = mouse.min_y;
	mouse.x = x;
	mouse.y = y;
}

void mouse_get_pos(int *x, int *y) {
	do_mouse_poll();
	*x = mouse.x;
	*y = mouse.y;
}

void mouse_get_delta(int *dx, int *dy) {
	do_mouse_poll();
	*dx = mouse.dx;
	*dy = mouse.dy;
	mouse.dx = mouse.dy = 0;
}

int mouse_get_btns() {
	do_mouse_poll();
	return mouse.buttons;
}

void mouse_set_pos(int x, int y) {
	mouse.x = x;
	mouse.y = y;
}

void mouse_flush() {
	int i;

	do_mouse_poll(); /* process all pending events */
	mouse.buttons = 0;
	for (i = 0; i < MOUSE_MAX_BUTTONS; i++)
		mouse.down_count[i] = mouse.down_time[i] = 0;
}

int mouse_button_state(int button) { 
	do_mouse_poll();
	return (mouse.buttons >> button) & 1;
}

fix mouse_button_down_time(int button) {
	fix ret, now;
	do_mouse_poll();
	if (mouse.buttons & (1 << button)) {
		now = timer_get_fixed_seconds();
		ret = now - mouse.down_time[button];
		mouse.down_time[button] = now;
	} else {
		ret = mouse.down_time[button];
		mouse.down_time[button] = 0;
	}
	return ret;
}

int mouse_button_down_count(int button) {
	int ret;
	do_mouse_poll();
	ret = mouse.down_count[button]; 
	mouse.down_count[button] = 0;
	return ret;
}

void mouse_get_cyberman_pos(int *x, int *y) { }

// Generic output functions (from mono.c)
// Supposed to be for mono color stuff, but it's really a debugging tool
// used by the original Descent programmers.
void mputc(short n, char c) { fprintf(stderr,"%c",c); }
void mputc_at(short n,short row, short col, char c) { mputc(n,c); }
void scroll(short n) { }
void _mprintf(short n, char * format, ...) {
	va_list args;
	va_start(args,format);
	vfprintf(stderr,format,args);
}
void _mprintf_at(short n, short row, short col, char * format, ...) {
	va_list args;
	va_start(args,format);
	vfprintf(stderr,format,args);
}
void drawbox(short n) { }
void mclear(short n) { }
void mclose(short n) { }
void mrefresh(short n) { }
int mono_present();
void mopen(short n, short row, short col, short width, short height, char * title) { }
int minit() { return -1; }

// EOF
