/*
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF PARALLAX
SOFTWARE CORPORATION ("PARALLAX").  PARALLAX, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.  
COPYRIGHT 1993-1998 PARALLAX SOFTWARE CORPORATION.  ALL RIGHTS RESERVED.
*/

#include "mem.h"
#include "gr.h"
#include "grdef.h"
#include "intrface.h"

unsigned char gr_ugpixel( grs_bitmap * bitmap, int x, int y )
{
	switch(bitmap->bm_type) {
	case BM_LINEAR:
		return bitmap->bm_data[ bitmap->bm_rowsize*y + x ];
	case BM_MODEX: {
			int offset=(bitmap->bm_rowsize*y)+(x>>2);
			int_gr_modex_plane(x&3);
			return bitmap->bm_data[offset];
		}
	case BM_SVGA: {
			int offset=(long)bitmap->bm_data+(bitmap->bm_rowsize*y)+x;
			int gran=int_gr_get_gran();
			int bank=offset/gran;
			int newoff=offset%gran;
			int_gr_bank(bank);
			return gr_video_memory[newoff];
		}
	}

	return 0;
}

unsigned char gr_gpixel( grs_bitmap * bitmap, int x, int y )
{
	if ((x<0) || (y<0) || (x>=bitmap->bm_w) || (y>=bitmap->bm_h)) return 0;

	switch(bitmap->bm_type) {
	case BM_LINEAR:
		return bitmap->bm_data[ bitmap->bm_rowsize*y + x ];
	case BM_MODEX: {
			int offset=(bitmap->bm_rowsize*y)+(x>>2);
			int_gr_modex_plane(x&3);
			return bitmap->bm_data[offset];
		}
	case BM_SVGA: {
			int offset=(long)bitmap->bm_data+(bitmap->bm_rowsize*y)+x;
			int gran=int_gr_get_gran();
			int bank=offset/gran;
			int newoff=offset%gran;
			int_gr_bank(bank);
			return gr_video_memory[newoff];
		}
	}

	return 0;
}
