//Header file for the class CVQAFile, the interface to VQA files.

#pragma once

#include "vqadll.h"
#include "basefile.h"
#include "structures.h"

//For internal use, must be declared
typedef struct
{
	unsigned char *cbf;
	unsigned char *cbp;
	int cbplen;
	int numcbp;
	unsigned char *cpl;
	unsigned char *vpt;
} framestruct8;

typedef struct
{
	unsigned char *cbf;
	unsigned char *vptr;
	unsigned char *frame;
	
} framestruct15;
//END of internal use

class VQADLL_API CVQAFile:public CBasefile
{
public:
	CVQAFile();
	void close();
	void set_offset(int offset); //If the VQA file is whithin a mix, set the starting offset
	
	int verify(); //Verifies a file, must be called before
	void readheader(); //Reads the header of the VQA file, must called before
	void readframeindex(); //Read the frame positions, must be called before the functions below
	int *getindextable(); //Returns the indextable read by readframeindex
	unsigned char *decode_sound_chunk(int &len); //Decodes a sound chunk
	unsigned char *decode_vqfr_chunk(); //Decodes a video chunk
	vqa_chunk_info get_chunk_info(); //Get the info of a chunk
	void seekframe(int frame);  //Seek to the beginning of a frame
	void skip_chunk(); //Skip a chunk
	void decode_vqfl_chunk(); //Decode a VQFL chunk. It is only uses in high-color VQAs
	
	//Header functions
	h_getwidth(); //Get the width of the VQA
	h_getheight(); //Get the height of the VQA
	vqa_header getheader(); //Returns the header read by readheader
	
	//Before you call the functions decode_sound_chunk, decode_vqfr_chunk and decode_vqfl_chunk,
	//you have to call get_chunk_info. If for example vqa_chunk_info.id==VQA_SND_CHUNK, then you may
	//call decode_sound_chunk(vqa_chunk_info.len). For the other two functions, the constants for 
	//id are: VQA_VQFR_CHUNK and VQA_VQFL_CHUNK
	

private:
	void write_block(unsigned char* out, int v, int count, int& x, int y) const;
	vqa_chunk_info *m_chunk_info;
	unsigned char *get8bitframe();
	unsigned char *get15bitframe();
	void fillblock(int posx, int block);

	int m_isvqa;
	int m_offset;
	vqa_header *m_pHeader;
	int *m_pIndextable;
	framestruct8 m_framedata8;
	framestruct15 m_framedata15;
};
