//Containing all defined constants and structures you need to use this library
#pragma once

#define SYNTAX_ERROR 777 //returned if you pass invalid parameters, like BFILE_NOTOPEN for CBasefile::open
//BaseFile defines

	//Filemodes
	#define BFILE_READ 1
	#define BFILE_WRITE 2
	
	//Seekmodes
	#define BFILE_BEGIN 3
	#define BFILE_CUR 4
	#define BFILE_END 5
	//Return Values
	#define BFILE_NOTOPEN 6
	#define BFILE_ALREADYOPEN 7
	#define BFILE_NOSEEK 8
	#define BFILE_SEEK 9

//VQAFile defines


	//VQAType
	#define VQA_8BIT 8
	#define VQA_15BIT 15
	#define VQA_NOVQA 10
	#define VQA_ISVQA 11

	//CHUNKINFO
	#define VQA_SND_CHUNK 1000
	#define VQA_VQFR_CHUNK 1001
	#define VQA_VQFL_CHUNK 1002
	#define VQA_ELSE 1111


//MixFile define
	#define MIX_NOMIX 7
	#define MIX_ISMIX 8
	#define MIX_GAME_TD 0
	#define MIX_GAME_RA 1
	#define MIX_GAME_TS 2

	#define cb_mix_key 56
	#define cb_mix_key_source 80
	#define cb_mix_checksum 20
	#define MIX_HAS_CHECKSUM 0x00010000 //unused
	#define MIX_IS_ENCRYPTED 0x00020000


//CMixDatabase defines
	#define TYPE_ELSE 0
	#define TYPE_VQA 1
	#define TYPE_MIX 2


//CMixDatabase structures and
//CMixFile structures
typedef struct 
{
	int pos;
	int len;
	unsigned int ID;
	char FileName[13];
	char Desc[100];
	char type;
} mix_headerentry_long; //Full Mix entry, as returned by CMixDatabase

typedef struct
{
	mix_headerentry_long *data;
	int numfiles;
} mix_header_full;//Full header of a mix file, describes all files in Mix

#pragma pack(push, 1)

typedef struct 
{
    unsigned __int32 id;
    __int32 offset;
    __int32 size;
} mix_headerentry_short; //As stored within mix header

#pragma pack(pop)

//CVQAFile structures

typedef struct 
{
	short numframes;
	short width;
	short height;
	char wx;
	char wy;
	unsigned short soundfreq;
	char channels;
	int indexpos;
	char version;
	char bpp;
} vqa_header;

typedef struct
{
	int len;
	int id;
	int compressed;
} vqa_chunk_info;