#include "vqadll.h"
#include "basefile.h"
#include "structures.h"

#pragma once

#pragma pack(push, 1)

union shortheader
{
	struct 
	{
		__int16 numfiles;
		__int32 size;
	};
	__int32 flags;
};

#pragma pack(pop)

class VQADLL_API CMixFile :public CBasefile
{
public:
	CMixFile();
	void close(); //Do I need to explain it?
	int getlen();
	void setoffset(int index); //If MIX within a MIX, set offset of the MIX file
	void set_rmix(int size); //Sets the length of the file if within a mix
	int verify(); //Verifies the MIX file, must be called before all functions below
	void readheader(); //reads the header, must be called before the functions below
	mix_header_full *getmixinfo(); //returns the (decrypted) header, needs to be called before 
								   //the functions below
	
	//mixinfo
	int getnumfiles() const; //Returns the number of files within a MIX file
	int getoffset(int index) const; //Returns the offset of the file specified by index.
	                                //0<=index<getnumfiles()
	
private:
	int m_rmix;
	int m_ismix;
	int m_offset;
	int m_game;
	int m_is_encrypted;
	int m_has_checksum;
	mix_header_full m_mixinfo;
};
