//Header file for the class CBasefile, used for file operations

#pragma once

#include "vqadll.h"
#include "structures.h"
//#include "windows.h" //Remove first to chars if you get the compiler error "HANDLE - Not declared identifier"

class VQADLL_API CBasefile
{
public:
	CBasefile();
	~CBasefile();
	int open(const char *FileName,int mode=BFILE_READ); //Opens a file, BFILE_READ and 
														//BFILE_WRITE are possible
	int seek(int pos, int mode=BFILE_BEGIN); //Seeks to the specified position within the file
	int read(void *buffer, int len);  //Reads len bytes from file into buffer
									  //Returns BFILE_NOTOPEN if no file open, SYNTAX_ERROR if
									  //buffer==NULL of len==0
	int write(void *buffer, int len); //Writes len bytes from buffer into file
									  //Returns BFILE_NOTOPEN if no file open, SYNTAX_ERROR if
									  //buffer==NULL of len==0
	int setbuffer(void *buffer,int pos,int len); //For file buffering, you should not use it
	int getpos(); //Gets the len of a file, returns -1 if no file open
	int getlen(); //Gets the pos whithin a file, returns -1 if no file open
	void close(); //closes an open file
	int isopen();//Returns the file-mode (BFILE_NOTOPEN, BFILE_READ,BFILE_WRITE)
	
protected:
	void *m_buffer;
	int m_bufferpos;
	int m_bufferlen;
	int m_fpos;
	char *m_FileName;
	int m_isopen;
	HANDLE hFile;
};
