// mission1.cpp
// NobleCE@aol.com
// Thanks to Brad from Pandemic for providing BTest, a sample mission that this is
// based on.  Without it, it would not have been obvious how to use several features
// like BTest::Execute().

// Notes:
// SucceedMission()
// Call it once, NOT repeatedly.  The first parameter is the time when you wish
// the mission to end.  If you pass GetTime()+1, it'll end in a second - if you
// repeatedly call this with that param, it will continually seek to end the game
// 1 second into the future and the game never ends!  You can pass a text file name to
// it as second parameter which specifies the debriefing text.

#include "scriptutils.h"
#include "SPMission.h"

Handle player;

class BTest : public SPMission {
public:
	BTest(void)
	{
		b_count = &b_last - &b_first - 1;
		b_array = &b_first + 1;

		f_count = &f_last - &f_first - 1;
		f_array = &f_first + 1;

		h_count = &h_last - &h_first - 1;
		h_array = &h_first + 1;

		i_count = &i_last - &i_first - 1;
		i_array = &i_first + 1;
	}

	void Setup(void);
	void AddObject(Handle h);
	void Execute(void);

	// bools
	bool
		b_first,
		firstFrame,
		missionOver,
		b_last;

	// floats
	float
		f_first,
		timeOut,
		f_last;

	// handles
	Handle
		h_first,
		enemyHandle,
		h_last;

	// integers
	int
		i_first,
		enemyCount,
		i_last;
};

void BTest::Setup(void)
{
	// init vars here
	firstFrame = true;
	enemyHandle = 0;
	enemyCount = 0;
	missionOver = false;
}

// This function is the one that makes things happen
void BTest::Execute(void)
{
	player = GetPlayerHandle();

	if (firstFrame) {
		firstFrame = false;
		// first frame stuff here
		const int secsPerMin = 60;
		timeOut = GetTime() + (5 * secsPerMin);		// left over from Brad's test mission.
	}

	if (!IsAlive(enemyHandle)) {
			// probably no spawn point in mission
			Vector pos;
			// just build a center of map
			switch( enemyCount )
			{
			case 0:
				pos.x = pos.y = pos.z = 0;
				enemyHandle = BuildObject("fvsent", 2, pos);
				AddObjective("This is mission was created by\nNobleCE@aol.com.", WHITE );
				AddObjective("Kill the Sentry near the middle\nof the map.", GREEN );
				// after adding these Attacks() it sure made a difference in the enemy's
				// attitude!
				Attack(enemyHandle, player);
				enemyCount++;
				break;
			case 1:
				ClearObjectives( );
				pos.x = pos.y = pos.z = 0;
				enemyHandle = BuildObject("fvtank", 2, pos);
				StartEarthQuake(4.0f);
				AddObjective("Now kill the Warrior.", GREEN );
				Attack(enemyHandle, player);
				enemyCount++;
				break;
			case 2:
				missionOver = true;
				StopEarthQuake();
				ClearObjectives( );
				SucceedMission(GetTime() + 1);
				enemyCount++;			//make count 3 so this doesn't execute again.
				break;
			}
	}

}

void BTest::AddObject(Handle h)
{

	SPMission::AddObject( h );
}


// every mission must have one of these - it's not in the core files provided by
// Pandemic (on purpose of course) - you have to derive your mission class and
// create an instance of it.
BTest dllBase;

// every mission must have one of these - it's not in the core files provided by
// Pandemic (on purpose of course).
DLLBase *BuildMission(void)
{

	return &dllBase;

}
