VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsCob"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'TA Cob Class'
'Written by Alan Croll and Warman2097 (Decompile function)'
'Option Explicit
'Variables'
Private Header As COBHeader
Private Type COBHeader
    Version As Long
    NumScripts As Long
    NumPieces As Long
    EndOfCode As Long
    NumStatics As Long
    Always0 As Long ' Always 0 '
    OffsetScriptCodeIndexArray As Long
    OffsetScriptNameOffsetArray As Long
    OffsetPieceNameOffsetArray As Long
    OffsetScriptCode As Long
    OffsetFirstScriptName As Long ' Points to the first script name. '
End Type
'Uncobble variables'
Private Script() As Long 'Actual Script Code'
Private ScriptNameindex() As String 'Name's of the scripts'
Private ScriptCodeindex() As Long 'Offset's to the scripts
Private ScriptNameOffset() As Long

Private PieceNameIndex() As Long
Private Pieces() As String
'Constants'
Private Const AngularConst = 182 'Cob Constant'
Private Const LinearConst = 163840 'Cob Constants'
'User Accessible Variables'
Public TxtStr As String 'Decompiled Bos Script'
Public ErrorMsg As String 'If there is an error!, dump this into the txtbox'
Private FH As Integer 'File Handle'

Public Sub LoadCob(filename As String)
FH = FreeFile
If filename = "" Then
        Exit Sub
End If
Open filename For Binary As FH
    Get FH, , Header
Select Case Header.Version
        Case 6 'Total Annihilation Kingdoms'
                TxtStr = "// Beta Version of Uncobble -" & App.Major & "." & App.Minor & "." & App.Revision & "//" & vbCrLf
                LoadPieces  'Load all the piece Names'
                LoadScripts 'Load all the script names'
                DECOMPILECOB 'Decompile the Cob'
        Case 4 'Total Annihilation '
                TxtStr = "// Beta Version of Uncobble -" & App.Major & "." & App.Minor & "." & App.Revision & "//" & vbCrLf
                LoadPieces
                LoadScripts
                DECOMPILECOB
        Case Else 'Unknown'
                TxtStr = ""
                Exit Sub
End Select
End Sub
Private Sub LoadPieces()

Dim index As Long
Dim Buffer As Byte
Dim Position As Long
Dim flag As Boolean
    
    ReDim Pieces(Header.NumPieces - 1)
    ReDim PieceNameIndex(Header.NumPieces - 1)
    TxtStr = TxtStr & "piece "
    Position = Header.OffsetPieceNameOffsetArray + 1
    Get FH, Position, PieceNameIndex()
    For index = 0 To UBound(Pieces)
        Position = PieceNameIndex(index) + 1
        Get FH, Position, Buffer
        Do While Buffer <> 0
            Pieces(index) = Pieces(index) & Chr(Buffer)
            Get FH, , Buffer
        Loop
        If index = UBound(Pieces) Then
                        flag = True
                Else
                        flag = False
        End If
        Select Case index
                Case UBound(Pieces)
                        If flag = True Then
                                        TxtStr = TxtStr & Pieces(index) & ";"
                                Else
                                        TxtStr = TxtStr & Pieces(index) & ", "
                        End If
                Case Else
                        TxtStr = TxtStr & Pieces(index) & ","
        End Select
    Next
'Write Static Variables'
For index = 0 To Header.NumStatics
    TxtStr = TxtStr & ""
Next

End Sub

Private Sub LoadScripts()
' Load scripts. '
Dim Position As Long
Dim index As Long
Dim Buffer As Byte

ReDim Scripts(Header.NumScripts - 1)
ReDim ScriptCodeindex(Header.NumScripts - 1)
ReDim ScriptNameindex(Header.NumScripts - 1)
ReDim ScriptNameOffset(Header.NumScripts - 1)

'Get Script Code Offsets'
Position = Header.OffsetScriptCodeIndexArray + 1
Get FH, Position, ScriptCodeindex()
'Get Name Offsets'
Position = Header.OffsetScriptNameOffsetArray + 1
Get FH, Position, ScriptNameOffset()
'Get Script Offsets'
Position = Header.OffsetScriptCodeIndexArray + 1
Get FH, Position, ScriptCodeindex()
'Set up pointers to ScriptCode'
For index = 0 To UBound(ScriptCodeindex)
    ScriptCodeindex(index) = Header.OffsetScriptCode + (ScriptCodeindex(index) * 4) + 1
Next
'Get Script Names'
For index = 0 To UBound(ScriptNameindex)
    Position = ScriptNameOffset(index) + 1
    Get FH, Position, Buffer
    Do While Buffer <> 0
        ScriptNameindex(index) = ScriptNameindex(index) & Chr(Buffer)
        Get FH, , Buffer
    Loop
Next

End Sub
Private Sub DECOMPILECOB() 'Actual Decompilation Function'

Dim I As Long
Dim cscr As String 'Current Script'
Dim Position As Long
Dim index As Long
Dim Count As Long
Dim counter As Long
Dim Buffer As Long
Dim cpl As Long 'Add TO count'
Dim Temp As Long 'Temporary long value'
Dim Axis As String 'what axis a movement is on' 0=x 1=y 2=z '
Dim Calcvalue As String 'calculation value'
Dim Calcstr As String 'calculation string'
Dim IndentCount As Long 'Number of TAB's (char 9's) to put before current line'
'Added by Warman2097
Dim SpValue As String 'Speed Value for TurnPiece
Dim Comparaison As String

Position = ScriptCodeindex(index)
Seek FH, Position
TxtStr = TxtStr & vbCrLf
'Get FH, Position, Script(I)
For index = 0 To UBound(ScriptCodeindex)
    If index = UBound(ScriptCodeindex) Then
            I = 0
            Do Until Loc(FH) >= Header.EndOfCode
                For counter = 0 To UBound(ScriptCodeindex)
                    If Loc(FH) = ScriptCodeindex(counter) Then
                            Exit Do
                    End If
                Next
                ReDim Preserve Script(I)
                Get FH, , Script(I)
                I = I + 1
            Loop
        Else
            I = 0
            Do Until Loc(FH) >= ScriptCodeindex(index + 1)
                For counter = 0 To UBound(ScriptCodeindex)
                    If Loc(FH) = ScriptCodeindex(counter) Then
                            Exit Do
                    End If
                Next
                ReDim Preserve Script(I)
                Get FH, , Script(I)
                I = I + 1
            Loop
    End If
    TxtStr = TxtStr & ScriptNameindex(index) & "()" & vbCrLf
    
    
    For Count = 0 To UBound(Script)
    
    If Count = 0 Then
        cscr = Chr(9) & "{" & vbCrLf
    End If
    Axis = "" 'remove value in axis'
    Calcvalue = ""
    SpValue = ""
    Calcstr = ""
    Select Case Script(Count)
            Case &H1000B000 'Move_Piece_Now'
                Axis = WhatAxis(Script(Count + 2))
                Calcvalue = Script(Count - 1) / LinearConst
                If Calcvalue <> 0 Then
                        Calcstr = Format(Calcvalue, "0.00")
                    Else
                        Calcstr = "0"
                End If
                cscr = cscr & Chr(9) & "MOVE " & Pieces(Script(Count + 1)) & " TO" & Axis & "<" & Calcstr & ">" & " NOW;" & vbCrLf
                cpl = 2
            Case &H1000C000 'turn_piece_now'
                Axis = WhatAxis(Script(Count + 2))
                Calcvalue = Script(Count - 1) / LinearConst
                If Calcvalue <> 0 Then
                        Calcstr = Format(Calcvalue, "0.00")
                    Else
                        Calcstr = "0"
                End If
                cscr = cscr & Chr(9) & "TURN " & Pieces(Script(Count + 1)) & " to" & Axis & "<" & Calcstr & ">" & " NOW;" & vbCrLf
                cpl = 2
            Case &H1000E000 'dont shade'
                If Count <> UBound(Script) Then
                    Temp = Script(Count + 1)
                    cscr = cscr & Chr(9) & "DONT-SHADE " & Pieces(Temp) & ";" & vbCrLf
                    cpl = 1
                End If
            Case &H1000F000 'emit_sfx_from_piece'
                cscr = cscr & Chr(9) & "Emit_SFX" & vbCrLf
                cpl = 1
            Case &H10001000 'move_piece'
                SpValue = Format(Script(Count - 3) / LinearConst, "0.00")    'SPEED
                Axis = WhatAxis(Script(Count + 2))      'AXIS
                Calcvalue = Format(Script(Count - 1) / LinearConst, "0.00")       'DISTANCE
                
                cscr = cscr & Chr(9) & "MOVE " & Pieces(Script(Count + 1)) & " TO" & Axis & "<" & Calcvalue & "> " & "SPEED <" & SpValue & ">;" & vbCrLf
                cpl = 2
            Case &H10002000 'turn_piece'
                Axis = WhatAxis(Script(Count + 2))    'AXIS
                Calcvalue = Script(Count - 1) / AngularConst   'DISTANCE
                Calcstr = IIf(Calcvalue <> 0, Format(Calcvalue, "0.00"), "0")    'DISTANCE FORMAT
                SpValue = Format(Script(Count - 3) / AngularConst, "0.00")        'SPEED
                 
                cscr = cscr & Chr(9) & "TURN " & Pieces(Script(Count + 1)) & " TO" & Axis & "<" & Calcstr & ">" & " SPEED " & "<" & SpValue & ">;" & vbCrLf
                cpl = 2

            Case &H10003000 'spin_piece'
                Axis = WhatAxis(Script(Count + 2))  'name of axis
                Temp = Format(Script(Count - 1) / AngularConst, "0.00")              ' speed of spinning
                cscr = cscr & Chr(9) & "SPIN " & Pieces(Script(Count + 1)) & " around" & Axis & "SPEED <" & Temp & ">" & vbCrLf
                cpl = 2
            Case &H10004000 'sTOp_spin'
                cscr = cscr & Chr(9) & "STOP-SPIN " & Pieces(Script(Count + 1)) & vbCrLf
                cpl = 2
            Case &H10005000 'show'
                If Count <> UBound(Script) Then
                    Temp = Script(Count + 1)
                    cscr = cscr & Chr(9) & "SHOW " & Pieces(Temp) & ";" & vbCrLf
                    cpl = 1
                End If
            Case &H10006000 'hide'
                If Count <> UBound(Script) Then
                    Temp = Script(Count + 1)
                    cscr = cscr & Chr(9) & "HIDE " & Pieces(Temp) & ";" & vbCrLf
                    cpl = 1
                End If
            Case &H10007000 'cache'
                If Count <> UBound(Script) Then
                    Temp = Script(Count + 1)
                    cscr = cscr & Chr(9) & "CACHE " & Pieces(Temp) & ";" & vbCrLf
                    cpl = 1
                End If
            Case &H10008000 'dont_cache'
                If Count <> UBound(Script) Then
                    Temp = Script(Count + 1)
                    cscr = cscr & Chr(9) & "DONT-CACHE " & Pieces(Temp) & ";" & vbCrLf
                    cpl = 1
                End If
            Case &H10011000 'wait_for_turn'
                Axis = WhatAxis(Script(Count + 2))
                cscr = cscr & Chr(9) & "WAIT-FOR-TURN " & Pieces(Script(Count + 1)) & " AROUND" & Axis & ";" & vbCrLf
                cpl = 2
            Case &H10012000 'wait_for_move'
                cscr = cscr & Chr(9) & "WAIT-FOR-MOVE" & vbCrLf
                cpl = 2
            Case &H10013000 'sleep'
                Calcstr = Script(Count - 1)
                cscr = cscr & Chr(9) & "sleep" & " <" & Calcstr & ">;" & vbCrLf
                cpl = 0
            'Case &H10021001 'push_constant'
            '    cscr = cscr & "push constant" & vbCrLf
            '    cpl = 1
            'Case &H10021002 'Push_var'
            '    cscr = cscr & Chr(9) & "Push Variable " & vbCrLf
            '    cpl = 1
            'Case &H10021004 'Push_static_var'
                'Don't need to be dispayed
                'cscr = cscr & Chr(9) & "Push_static_var" & vbCrLf
            '    cpl = 1
            'Case &H10022000 'Stack_allocate'
            '    cscr = cscr & Chr(9) & "Stack_Allocate" & vbCrLf
            '    cpl = 0
            'Case &H10023002 'Pop_var'
            '    cscr = cscr & Chr(9) & "VARIABLE(" & Script(Count + 1) & ") = " & Script(Count - 1) & ";" & vbCrLf
            '    cpl = 1
            'Case &H10023004 'Pop_static_var'
            '    Temp = Script(Count - 1)
            '    Calcstr = Script(Count + 1)
            '    cscr = cscr & Chr(9) & "Static(" & Calcstr & ") = " & Temp & vbCrLf
            '    cpl = 1
            Case &H10031000 'add'
                cscr = cscr & Chr(9) & "Add" & vbCrLf
                cpl = 0
            Case &H10032000 'Subtract'
                cscr = cscr & Chr(9) & "Subtract" & vbCrLf
                cpl = 0
            Case &H10033000 'multiply'
    
                cscr = cscr & Chr(9) & "multiply" & vbCrLf
                cpl = 0
            Case &H10034000 'divide'
                cscr = cscr & Chr(9) & "divide" & vbCrLf
                cpl = 0
            Case &H10036000 'bitwise_or'
                cscr = cscr & Chr(9) & "BITWISE_OR" & vbCrLf
                cpl = 0
            Case &H10041000 'rand'
                cscr = cscr & Chr(9) & "RAND" & vbCrLf
                cpl = 0
            'Case &H10042000 'get_unit_value'
            '    cscr = cscr & Chr(9) & "GET_UNIT_VALUE" & " <" & Script(Count - 1) & ">;" & vbCrLf
            '    cpl = 0
            Case &H10042000 'get_unit_value'
                cscr = cscr & Chr(9) & "get" & " <" & GetWhat(Script(Count - 1)) & ">;" & vbCrLf
                cpl = 0
            'Case &H10043000 'get'
            '    cscr = cscr & Chr(9) & "GET" & vbCrLf
            '    cpl = 0
            Case &H10051000 'compare_less'
                Calcstr = Script(Count - 1)
                Calcvalue = Script(Count - 2)
                Comparaison = Calcvalue & " < " & Calcstr

                'cscr = cscr & Chr(9) & "COMPARE_LESS" & vbCrLf
                cpl = 0
            Case &H10052000 'compare_less_equal'
                Calcstr = Script(Count - 1)
                Calcvalue = Script(Count - 2)
                Comparaison = Calcvalue & " <= " & Calcstr

                'cscr = cscr & Chr(9) & "COMPARE_LESS_EQUAL" & vbCrLf
                cpl = 0
            Case &H10055000 'compare_equal'
                Calcstr = Script(Count - 1)
                Calcvalue = Script(Count - 2)
                Comparaison = Calcvalue & " == " & Calcstr
                'cscr = cscr & Chr(9) & "COMPARE_EQUAL" & vbCrLf
                cpl = 0
            Case &H10056000 'compare_not_equal'
                Calcstr = Script(Count - 1)
                Calcvalue = Script(Count - 2)
                Comparaison = Calcvalue & " != " & Calcstr

                'cscr = cscr & Chr(9) & "COMPARE_NOT_EQUAL" & vbCrLf
                cpl = 0
            Case &H10057000 'compare_AND'
                cscr = cscr & Chr(9) & "COMPARE_AND" & vbCrLf
                cpl = 0
            Case &H10058000 'compare_OR'
                cscr = cscr & Chr(9) & "COMPARE_OR" & vbCrLf
                cpl = 0
            Case &H1005A000 'compare_NOT'
                cscr = cscr & Chr(9) & "COMPARE_NOT" & vbCrLf
                cpl = 0
            Case &H10061000 'Start_script'
                cscr = cscr & Chr(9) & "START-SCRIPT " & ScriptNameindex(Script(Count + 1)) & "();" & vbCrLf
                cpl = 2
            Case &H10062000 'Call_script'
                If Count <> UBound(Script) Then
                    Temp = Script(Count + 1)
                    cscr = cscr & Chr(9) & "CALL-SCRIPT " & ScriptNameindex(Temp) & "();" & vbCrLf  'CStr(Script(count + 2)) & vbCrLf
                    cpl = 2
                End If
            Case &H10064000 'jump'
                cscr = cscr & Chr(9) & "JUMP <" & Script(Count + 1) & ">;" & vbCrLf
                cpl = 1
            'Case &H10065000 'return'
            '    cscr = cscr & Chr(9) & "RETURN (" & Script(Count - 1) & ");" & vbCrLf
            '    cpl = 0
            Case &H10066000 'jump_if_false'
                If Comparaison = "" Then Comparaison = "True"
                cscr = cscr & Chr(9) & "IF NOT " & Comparaison & ", JUMP TO <" & Script(Count + 1) & ">;" & vbCrLf
                Comparaison = ""
                cpl = 1
            Case &H10067000 'signal'
                cscr = cscr & Chr(9) & "SIGNAL" & "<" & Script(Count - 1) & ">;" & vbCrLf
                cpl = 0
            Case &H10068000 'set signal mask'
                cscr = cscr & Chr(9) & "SET SIGNAL MASK" & "<" & Script(Count - 1) & ">;" & vbCrLf
                cpl = 0
            Case &H10071000 'explode'
                cscr = cscr & Chr(9) & "EXPLODE " & Script(Count + 1) & "AS TYPE " & Script(Count - 1) & ";" & vbCrLf
                cpl = 1
            Case &H10082000 'set_value'
                cscr = cscr & Chr(9) & "SET VALUE" & vbCrLf
                cpl = 0
            Case &H10083000 'Attach_unit'
                cscr = cscr & Chr(9) & "ATTACH UNIT" & vbCrLf
                cpl = 0
            Case &H10084000 'drop unit'
                cscr = cscr & Chr(9) & "DROP UNIT" & vbCrLf
                cpl = 0
            Case &H0
                'ignore'
                cpl = 0
            Case &H6C697542 'Cobbler Script _ignore it, 37 longs'
                ' This doesn't need TO be here, but it speeds up'
                ' the process'
                cpl = 37
            'Case Else
            '    cscr = cscr & Chr(9) & "UNKNOWN: " & Script(Count) & " [STACK:" & Script(Count - 1) & "][STACK_A:" & Script(Count + 1) & "][STACK_B:" & Script(Count + 2) & "]" & vbCrLf
            '    cpl = 0
        End Select
        Debug.Print cscr
        If Count = UBound(Script) Then
            cscr = cscr & Chr(9) & "}" & vbCrLf
        End If
        Count = Count + cpl 'count plus'
        If Count > UBound(Script) Then
            Exit For
        End If
    Next
    TxtStr = TxtStr & cscr & vbCrLf
Next
End Sub
Private Function CreateIndent(NumTabs As Long) As String
Dim index As Long
Dim tempstr As String
For index = 0 To NumTabs
    tempstr = tempstr & Chr(9)
Next
End Function
Private Function WhatAxis(AxisBin As Long) As String
Select Case AxisBin
    Case 0
        WhatAxis = " x-axis "
    Case 1
        WhatAxis = " y-axis "
    Case 2
        WhatAxis = " z-axis "
End Select
End Function
Private Function GetWhat(BinBuffer As Long) As String
Select Case BinBuffer
    Case 1
        GetWhat = "ACTIVATION"
    Case 2
        GetWhat = "STANDINGMOVEORDERS"
    Case 3
        GetWhat = "STANDINGFIREORDERS"
    Case 4
        GetWhat = "HEALTH"
    Case 5
        GetWhat = "INBUILDSTANCE"
    Case 6
        GetWhat = "BUSY"
    Case 7
        GetWhat = "PIECE_XY"
    Case 8
        GetWhat = "PIECE_Y"
    Case 9
        GetWhat = "UNIT_XZ"
    Case 10
        GetWhat = "UNIT_Y"
    Case 11
        GetWhat = "UNIT_HEIGHT"
    Case 12
        GetWhat = "XZ_ATAN"
    Case 13
        GetWhat = "XZ_HYPOT"
    Case 14
        GetWhat = "ATAN"
    Case 15
        GetWhat = "HYPOT"
    Case 16
        GetWhat = "GROUND_HEIGHT"
    Case 17
        GetWhat = "BUILD_PERCENT_LEFT"
    Case 18
        GetWhat = "YARD_OPEN"
    Case 19
        GetWhat = "BUGGER_OFF"
    Case 20
        GetWhat = "ARMORED"
End Select
End Function

'===================================================================================================================================================================================================='
'Compiling Routines'
'===================================================================================================================================================================================================='
'Function: Compile'
'Arguments:     OutputFile(long) - The file handle to compile to'
'               Updates(TextBox) - Textbox to show compile status'
'Returns:               long - if not 0 then check ErrorMsg'
Public Function CompileMacro(OutputFile As Long, updates As TextBox) As Long  'Compiles a macro->Compiled macro'
'Initialize Variables'
Dim rt As Long 'Return Value'
Dim FinalBosScript As String 'Script to compile (After being preprocessed)'
Dim Buffer As String 'Buffer string'
Dim Bufferlocation As Long 'Location of the buffer string'
Dim counter As Long 'counter 2'
Dim charbuffer As String 'A single Character buffer'
Dim LineBuffer As String 'Buffer of the current str'
Dim filebuffer As String 'Filename to open by preprocessor'
Dim templong As Long 'Temporary long value'
Dim StrArray() As String 'Preprocessor puts every line into this buffer then analyses it'
'Sort Memory'
updates.Text = "Starting the preprocessor..."
'Organise all lines into the strArray and preprocess'
For index = 0 To Len(TxtStr)
    charbuffer = Mid(TxtStr, index, 1)
    Select Case charbuffer
        Case "/" 'Looks to be a comment'
            Select Case Mid(TxtStr, index + 1, 1)
                Case "/" 'it is a comment'
                Case "*" 'it is a "special" type of comment'
            End Select
        Case "#" 'Looks to be a Preprocesser line'
            Select Case Mid(TxtStr, index, 4)
                'Preprocesser statements: #include, #define, #ifdef, #ifndef,#elseif'
                Case "#inclu" '#include'
                    templong = 1
                    Do Until templong = 0
                        'load in the filename string then load the file then preprocess the file'
                    Loop
                    
                Case "#defin" '#define'
                Case "#ifdef" '#ifdef'
                Case "#ifnde" '#ifndef'
                Case "#elsei" '#elseif'
            End Select
        Case Chr(13)
            If Mid(TxtStr, index + 1, 1) = Chr(10) Then
                'Create a new line in the array'
                ReDim Preserve StrArray(UBound(StrArray) + 1)
            End If
    End Select
Next
'Preprocessor'
updates.Text = "Running Preprocessor..."


End Function
'Function: PreProcessBosScript'
'Arguments:     none'
'Returns: 1 on error 0 if no error'
'Notes: uses a binary search, (slower)'
Private Function PreProcessMacroScript() As Long 'PreProcessor (removes comments and unnecessary code, includes include files etc)'
'Initialize Variables'
'Note that TXTSTR is where the macro to be compiled should be'

End Function



Public Sub CopyBuffer(Source As String, Dest() As String)
    Dim First As Long, Last As Long
    Dim Count As Long
    
    ReDim Dest(0)
    First = 1
    Last = InStr(First, Source, CRLF)
    Do While Last <> 0
        ReDim Preserve Dest(Count)
        Dest(Count) = Mid(Source, First, Last - First)
        Count = Count + 1
        First = Last + 2
        Last = InStr(First, Source, CRLF)
    Loop
    Last = Len(Source)
    If First < Last Then
        ReDim Preserve Dest(Count)
        Dest(Count) = Mid(Source, First, Last - First + 1)
    End If
End Sub










