VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   Caption         =   "HPI Demo"
   ClientHeight    =   4740
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7845
   LinkTopic       =   "Form1"
   ScaleHeight     =   4740
   ScaleWidth      =   7845
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton NoPackButton 
      Caption         =   "&No Pack"
      Height          =   420
      Left            =   4440
      TabIndex        =   16
      Top             =   3810
      Width           =   1005
   End
   Begin VB.CommandButton ZLibPackButton 
      Caption         =   "&Zlib Pack"
      Height          =   420
      Left            =   6600
      TabIndex        =   15
      Top             =   3810
      Width           =   1005
   End
   Begin VB.ListBox StatList 
      Height          =   1230
      Left            =   4410
      TabIndex        =   14
      Top             =   2430
      Width           =   3165
   End
   Begin VB.CommandButton LZ77PackButton 
      Caption         =   "&LZ77 Pack"
      Height          =   420
      Left            =   5520
      TabIndex        =   10
      Top             =   3810
      Width           =   1005
   End
   Begin VB.TextBox PackDirText 
      Height          =   285
      Left            =   1755
      TabIndex        =   9
      Text            =   "c:\temp"
      Top             =   4185
      Width           =   2625
   End
   Begin VB.TextBox HPIText 
      Height          =   285
      Left            =   1755
      TabIndex        =   7
      Text            =   "c:\test.ufo"
      Top             =   3825
      Width           =   2625
   End
   Begin VB.ListBox DirList 
      Height          =   2010
      Left            =   3735
      TabIndex        =   4
      Top             =   360
      Width           =   3600
   End
   Begin MSComDlg.CommonDialog ComDlg 
      Left            =   3735
      Top             =   2520
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327680
   End
   Begin VB.CommandButton CloseButton 
      Caption         =   "&Close"
      Height          =   435
      Left            =   1665
      TabIndex        =   2
      Top             =   2475
      Width           =   1455
   End
   Begin VB.CommandButton OpenButton 
      Caption         =   "&Open"
      Height          =   435
      Left            =   90
      TabIndex        =   1
      Top             =   2475
      Width           =   1455
   End
   Begin VB.ListBox HPIList 
      Height          =   2010
      Left            =   90
      TabIndex        =   0
      Top             =   360
      Width           =   3510
   End
   Begin VB.Label TotalLabel 
      AutoSize        =   -1  'True
      Height          =   195
      Left            =   90
      TabIndex        =   13
      Top             =   3555
      Width           =   45
   End
   Begin VB.Label FileLabel 
      AutoSize        =   -1  'True
      Height          =   195
      Left            =   90
      TabIndex        =   12
      Top             =   3285
      Width           =   45
   End
   Begin VB.Label StatLabel 
      AutoSize        =   -1  'True
      Height          =   195
      Left            =   90
      TabIndex        =   11
      Top             =   3015
      Width           =   45
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Directory to pack"
      Height          =   195
      Left            =   45
      TabIndex        =   8
      Top             =   4230
      Width           =   1215
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Destination HPI File"
      Height          =   195
      Left            =   45
      TabIndex        =   6
      Top             =   3870
      Width           =   1395
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "This is filled using HPIDir"
      Height          =   195
      Left            =   3735
      TabIndex        =   5
      Top             =   90
      Width           =   1740
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "This is filled using HPIGetFiles"
      Height          =   195
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   2115
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const FILE_ATTRIBUTE_DIRECTORY = &H10
Private Const FILE_ATTRIBUTE_NORMAL = &H80
Private Const INVALID_HANDLE_VALUE = -1
Private Const MAX_PATH = 260

Dim HPI As Long
Dim HPIName As String
Dim TADirectory As String

Private Type FILETIME
        dwLowDateTime As Long
        dwHighDateTime As Long
End Type

Private Type WIN32_FIND_DATA
        dwFileAttributes As Long
        ftCreationTime As FILETIME
        ftLastAccessTime As FILETIME
        ftLastWriteTime As FILETIME
        nFileSizeHigh As Long
        nFileSizeLow As Long
        dwReserved0 As Long
        dwReserved1 As Long
        cFileName As String * MAX_PATH
        cAlternate As String * 14
End Type

Private Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long

Sub CloseHPIFile()

If HPI <> 0 Then
  Call HPIClose(HPI)
  HPIList.Clear
  DirList.Clear
  HPI = 0
  Me.Caption = "HPI Demo"
End If

End Sub

Sub FillDirList()

Call GetHPIDir("", 0)

End Sub

Sub FillList()

Dim NextFile As Long
Dim FileName As String
Dim FileType As Long
Dim FileSize As Long

NextFile = 0

FileName = Space$(255)
NextFile = HPIGetFiles(HPI, NextFile, FileName, FileType, FileSize)
While NextFile <> 0
  FileName = StripNull(FileName)
  HPIList.AddItem FileName
  HPIList.ItemData(HPIList.NewIndex) = FileType
  FileName = Space$(255)
  NextFile = HPIGetFiles(HPI, NextFile, FileName, FileType, FileSize)
Wend

End Sub
Sub GetHPIDir(DirName As String, Depth As Long)

Dim NextDir As Long
Dim FileName As String
Dim FileType As Long
Dim FileSize As Long
Dim DName As String

NextDir = 0

FileName = Space$(255)
NextDir = HPIDir(HPI, NextDir, DirName, FileName, FileType, FileSize)
While NextDir <> 0
  FileName = StripNull(FileName)
  DirList.AddItem Space$(Depth) + FileName + " " + CStr(FileType) + " " + CStr(FileSize)
  If FileType = 1 Then
    If DirName = "" Then
      DName = FileName
    Else
      DName = DirName + "\" + FileName
    End If
    Call GetHPIDir(DName, Depth + 2)
  End If
  FileName = Space$(255)
  NextDir = HPIDir(HPI, NextDir, DirName, FileName, FileType, FileSize)
Wend

End Sub

Sub PackThemFiles(HPI As Long, PackPath As String, HPIPath As String)

'
' I use the Windows API calls instead of Dir$ because they can be called
' recursively, and I'm too lazy to mess with working around that limit
' with Dir$.
'

Dim FileSpec As String
Dim hFind As Long
Dim FindData As WIN32_FIND_DATA
Dim PackSubPath As String
Dim HPISubPath As String
Dim Result As Long
Dim FName As String

FileSpec = PackPath + "\*.*"

hFind = FindFirstFile(FileSpec, FindData)

If hFind = INVALID_HANDLE_VALUE Then Exit Sub

Do
  FName = StripNull(FindData.cFileName)
  If PackPath <> "" Then
    PackSubPath = PackPath + "\" + FName
  Else
    PackSubPath = FName
  End If
  If HPIPath <> "" Then
    HPISubPath = HPIPath + "\" + FName
  Else
    HPISubPath = FName
  End If
  'MsgBox "'" + PackSubPath + "'"
  If (FindData.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY) Then
    If (FName <> ".") And (FName <> "..") Then
      Result = HPICreateDirectory(HPI, HPISubPath)
      Call PackThemFiles(HPI, PackSubPath, HPISubPath)
    End If
  Else
    Result = HPIAddFile(HPI, HPISubPath, PackSubPath)
    If Result = 0 Then
      MsgBox "Error on HPIAddFile " + PackSubPath
    End If
  End If
  Result = FindNextFile(hFind, FindData)
Loop While Result <> 0

Call FindClose(hFind)

End Sub

Sub Extract(FileNo As Integer)

' the file lists should be synchronized

Dim FileName As String
Dim X As Integer
Dim DataPtr As Long
Dim ExtractName As String

If FileNo < 0 Then Exit Sub

If HPIList.ItemData(FileNo) <> 0 Then
  MsgBox "That's a directory, not a file"
  Exit Sub
End If

FileName = HPIList.List(FileNo)

On Error Resume Next

ComDlg.CancelError = True
ComDlg.DefaultExt = vbNullString
ComDlg.DialogTitle = "Save As"
ComDlg.FileName = ""
ComDlg.Filter = "All Files (*.*)|*.*"
ComDlg.FilterIndex = 1
ComDlg.Flags = cdlOFNExplorer Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist
ComDlg.InitDir = TADirectory

Err = 0
ComDlg.ShowSave
If Err <> 0 Then Exit Sub

ExtractName = ComDlg.FileName

X = HPIExtractFile(HPI, FileName, ExtractName)
If X Then
  MsgBox FileName + " extracted to " + ExtractName
Else
  MsgBox "Error extracting " + FileName + " to " + ExtractName
End If

End Sub

Private Sub CloseButton_Click()

Call CloseHPIFile

End Sub

Private Sub DirList_DblClick()

Call Extract(DirList.ListIndex)

End Sub



Private Sub Form_Load()

HPI = 0
TADirectory = Space$(255)
Call GetTADirectory(TADirectory)

TADirectory = StripNull(TADirectory)

End Sub
Private Sub Form_Unload(Cancel As Integer)

Call CloseHPIFile

End Sub


Private Sub HPIList_DblClick()

Call Extract(HPIList.ListIndex)

End Sub



Private Sub NoPackButton_Click()

Dim HPI As Long
Dim HPIName As String
Dim PackPath As String
Dim Result As Long

HPIName = HPIText.Text
PackPath = PackDirText.Text

HPI = HPICreate(HPIName, AddressOf HPICallBack)
If HPI = 0 Then
  MsgBox "Error on HPICreate"
  Exit Sub
End If

Call PackThemFiles(HPI, PackPath, "")

Result = HPIPackArchive(HPI, NO_COMPRESSION)
If Result = 0 Then
  MsgBox "Error on HPIPackArchive"
End If

End Sub

Private Sub OpenButton_Click()

On Error Resume Next

ComDlg.CancelError = True
ComDlg.DefaultExt = vbNullString
ComDlg.DialogTitle = "Select HPI or UFO file"
ComDlg.FileName = HPIName
ComDlg.Filter = "HPI Files (*.hpi;*.ufo;*.gpf)|*.ufo;*.hpi;*.gpf|All Files (*.*)|*.*"
ComDlg.FilterIndex = 1
ComDlg.Flags = cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist
ComDlg.InitDir = TADirectory

Err = 0
ComDlg.ShowOpen
If Err <> 0 Then Exit Sub

Call CloseHPIFile

HPIName = ComDlg.FileName

HPI = HPIOpen(HPIName)

If HPI = 0 Then
  MsgBox "Error opening " + HPIName
  Exit Sub
End If

Me.Caption = HPIName

Call FillList
Call FillDirList

End Sub

Private Sub LZ77PackButton_Click()

Dim HPI As Long
Dim HPIName As String
Dim PackPath As String
Dim Result As Long

HPIName = HPIText.Text
PackPath = PackDirText.Text

HPI = HPICreate(HPIName, AddressOf HPICallBack)
If HPI = 0 Then
  MsgBox "Error on HPICreate"
  Exit Sub
End If

Call PackThemFiles(HPI, PackPath, "")

Result = HPIPackArchive(HPI, LZ77_COMPRESSION)
If Result = 0 Then
  MsgBox "Error on HPIPackArchive"
End If


End Sub

Private Sub ZLibPackButton_Click()

Dim HPI As Long
Dim HPIName As String
Dim PackPath As String
Dim Result As Long

HPIName = HPIText.Text
PackPath = PackDirText.Text

HPI = HPICreate(HPIName, AddressOf HPICallBack)
If HPI = 0 Then
  MsgBox "Error on HPICreate"
  Exit Sub
End If

Call PackThemFiles(HPI, PackPath, "")

Result = HPIPackArchive(HPI, ZLIB_COMPRESSION)
If Result = 0 Then
  MsgBox "Error on HPIPackArchive"
End If

End Sub
