
package org.ml.bp.totala.hpi;

// SubsetInputStream - read a range of bytes within a larger ScrambledRandomAccessFile
//
// Copyright (C) 1997 by Barry Pederson <bpederson@geocities.com>.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

 
import java.io.*;

/**
 * Read a range of bytes from within a larger file
 * 
 */
 
final class SubsetInputStream extends java.io.InputStream 
	{
	ScrambledRandomAccessFile fSRAF;
	int fPosition;
	int fEndPosition;
	
/**
 * This method was created by a SmartGuide.
 */
SubsetInputStream (ScrambledRandomAccessFile sraf, int offset, int length) throws IOException
	{
	fSRAF = sraf;
	fPosition = offset;
	fEndPosition = offset + length;
	}
/**
 * This method was created by a SmartGuide.
 * @return int
 */
public int available() throws IOException
	{
	return fEndPosition - fPosition;
	}
/**
 * This method was created by a SmartGuide.
 */
public void close() throws IOException
	{
	fSRAF = null;
	fPosition = 0;
	fEndPosition = 0;
	}
/**
 * read method comment.
 */
public int read() throws java.io.IOException 
	{
	if (fPosition >= fEndPosition)
		return -1;

	int result;
	// this is somewhat inefficient, but necessary in case
	// more than one HAPIInputStreams is being read at a time
	synchronized (fSRAF)
		{
		fSRAF.seek(fPosition);		
		result = fSRAF.read();
		}
		
	fPosition++;
	return result;
	}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param b byte[]
 */
public int read(byte[] b) throws IOException
	{
	return read(b, 0, b.length);
	}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param b byte[]
 * @param off int
 * @param len int
 */
public int read(byte[] b, int off, int len) throws IOException
	{
	if (fPosition >= fEndPosition)
		return -1;

	len = Math.min(len, available());
	int nRead;
	
	// this is somewhat inefficient, but necessary in case
	// more than one HAPIInputStreams is being read at a time
	synchronized (fSRAF)
		{
		fSRAF.seek(fPosition);		
		nRead = fSRAF.read(b, off, len);
		}
		
	fPosition += nRead;
	return nRead;
	}
}