
package org.ml.bp.totala.hpi;

// HPIEntry - represents an entry in a HPIFile
//
// Copyright (C) 1997 by Barry Pederson <bpederson@geocities.com>.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

import java.io.File;

/**
 * Each instance of this class represents an entry in a .HPI archive file's
 * catalog.<p>
 *
 * The design is similar to java.io.File, with many methods having
 * the same names and functions.<p>
 *
 * A HPIEntry relates to a HPIFile similar to how a
 * java.util.zip.ZipEntry relates to a java.util.zip.ZipFile
 * 
 */

public class HPIEntry 
	{
	HPIFile fFile;
	boolean fIsDirectory;
	String fParent;
	String fName;
	int fDataOffset;
	int fDataSize;
	HPIEntry[] fSubDir;
	
/**
 * This method was created by a SmartGuide.
 * @param name java.lang.String
 * @param offset int
 * @param size int
 */
HPIEntry (HPIFile hf, String parentName, String name, int offset, int size) 
	{
	fFile = hf;
	fParent = parentName;
	fName = name;
	fDataOffset = offset;
	fDataSize = size;
	}
/**
 * @return The name of the file, with directory names omitted
 */
public String getName() 
	{
	return fName;
	}
/**
 * @return The directory of the file (null for root entries)
 */
public String getParent() 
	{
	return fParent;
	}
/**
 * @return The full name of the file, including directories<p>
 *		<i>Directories are separated by the default system file separator, so
 *       on a Windows machine, you would get something like "foo\bar\baz.xxx"
 *		and on a Unix box, you'd get "foo/bar/baz.xxx"</i>
 */
public String getPath() 
	{
	if (fParent == null)
		return fName;
	else
		return fParent + File.separator + fName;
	}
/**
 * @return True if this entry represents a directory, false if it's a file
 */
public boolean isDirectory() 
	{
	return fIsDirectory;
	}
/**
 * @return True if this entry represents a file, false if it's a directory
 */
public boolean isFile() 
	{
	return !fIsDirectory;
	}
/**
 * @return Length of the file this Entry represents (directories will return 0)
 */
public int length() 
	{
	return fDataSize;
	}
/**
 * @return Array of Entries representing files stored in this directory entry
 * (null if this entry represents a file)<p>
 *
 * <i>java.io.File.list() returns an array of Strings, which I think is a mistake - it would 
 * have been better for it to return an array of java.io.File objects.</i>
 */
public HPIEntry[] list() 
	{
	return fSubDir;
	}
}