/*
 * Decompiled with CFR 0.152.
 */
package org.ml.bp.totala.hpi;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class ScrambledRandomAccessFile {
    private RandomAccessFile fRAF;
    private long fPosition;
    private int fScrambleKey;
    private boolean fIsScrambled;

    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l = this.fPosition;
        int n3 = this.fRAF.read(byArray, n, n2);
        if (this.fIsScrambled) {
            int n4 = 0;
            while (n4 < n3) {
                byArray[n4] = (byte)(((long)this.fScrambleKey ^ (long)n4 + l ^ (long)(~byArray[n4])) & 0xFFL);
                ++n4;
            }
        }
        this.fPosition += (long)n3;
        return n3;
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public void seek(long l) throws IOException {
        this.fRAF.seek(l);
        this.fPosition = l;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        int n = this.fRAF.read();
        if (n == -1) {
            return -1;
        }
        if (this.fIsScrambled) {
            n = (this.fScrambleKey ^ (int)this.fPosition ^ ~n) & 0xFF;
        }
        ++this.fPosition;
        return n;
    }

    public void setKey(int n) {
        this.fScrambleKey = ~(n << 2 | n >> 6);
        this.fIsScrambled = true;
    }

    ScrambledRandomAccessFile(File file) throws IOException {
        this.fRAF = new RandomAccessFile(file, "r");
    }

    public boolean enableKey() {
        boolean bl = this.fIsScrambled;
        this.fIsScrambled = true;
        return bl;
    }

    public void close() throws IOException {
        this.fRAF.close();
    }

    public long getFilePointer() throws IOException {
        return this.fRAF.getFilePointer();
    }

    public long length() throws IOException {
        return this.fRAF.length();
    }

    public boolean disableKey() {
        boolean bl = this.fIsScrambled;
        this.fIsScrambled = false;
        return bl;
    }

    public String readASCIIZ() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) >= 1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

