/*
 * Decompiled with CFR 0.152.
 */
package org.ml.bp.totala.hpi;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class SQSHInputStream
extends FilterInputStream {
    private static final int BUFFER_SIZE = 1024;
    private byte[] fInputBuffer;
    private int fInputLow;
    private int fInputHigh;
    private byte[] fOutputBuffer;
    private int fOutputLow;
    private int fOutputHigh;
    private byte[] fDictionary;
    private int fDictionaryPtr;
    private int fBitTest;
    private int fField;
    private int fAvailable;
    private int fInputCount;
    private boolean fScrambled;
    private boolean fNoMore;

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5 = n;
        int n6 = n + n2;
        if (this.fOutputLow < this.fOutputHigh) {
            n4 = Math.min(this.fOutputHigh - this.fOutputLow, n6 - n5);
            System.arraycopy(this.fOutputBuffer, this.fOutputLow, byArray, n5, n4);
            this.fOutputLow += n4;
            this.fAvailable -= n4;
            if ((n5 += n4) >= n6 || this.fAvailable < 1) {
                return n5 - n;
            }
        }
        int n7 = this.fillBuffer(byArray, n5, n6 - n5);
        this.fAvailable -= n7;
        if ((n5 += n7) < n6 && this.fOutputLow < this.fOutputHigh) {
            n4 = Math.min(this.fOutputHigh - this.fOutputLow, n6 - n5);
            System.arraycopy(this.fOutputBuffer, this.fOutputLow, byArray, n5, n4);
            this.fOutputLow += n4;
            n5 += n4;
            this.fAvailable -= n4;
        }
        return (n3 = n5 - n) < 1 ? -1 : n3;
    }

    public int available() {
        return this.fAvailable;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        if (this.fOutputLow < this.fOutputHigh) {
            --this.fAvailable;
            return this.fOutputBuffer[this.fOutputLow++] & 0xFF;
        }
        this.fOutputLow = 0;
        this.fOutputHigh = this.fillBuffer(this.fOutputBuffer, 0, 992);
        if (this.fOutputLow < this.fOutputHigh) {
            --this.fAvailable;
            return this.fOutputBuffer[this.fOutputLow++] & 0xFF;
        }
        return -1;
    }

    public synchronized void mark(int n) {
    }

    protected SQSHInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        int n = this.readInt();
        if (n != 1213419859) {
            throw new IOException(String.valueOf("Invalid signature in SQSH header: 0x") + Integer.toHexString(n));
        }
        int n2 = inputStream.read();
        n2 = inputStream.read();
        this.fScrambled = inputStream.read() == 1;
        int n3 = this.readInt();
        this.fAvailable = this.readInt();
        n2 = this.readInt();
        this.fDictionary = new byte[4096];
        this.fDictionaryPtr = 1;
        this.fInputBuffer = new byte[1024];
        this.fInputLow = 0;
        this.fInputHigh = 0;
        this.fOutputBuffer = new byte[1024];
        this.fOutputLow = 0;
        this.fOutputHigh = 0;
        this.fBitTest = 1;
        this.fField = this.nextByte();
    }

    private int fillBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n3 + Math.min(n2, this.fAvailable);
        this.fOutputHigh = 0;
        this.fOutputLow = 0;
        while (n3 < n4) {
            int n5;
            if ((this.fField & this.fBitTest) == 0) {
                n5 = this.nextByte();
                byArray[n3++] = n5;
                this.fDictionary[this.fDictionaryPtr++] = n5;
                this.fDictionaryPtr &= 0xFFF;
            } else {
                byte by;
                int n6;
                n5 = this.nextByte() & 0xFF;
                int n7 = this.nextByte() & 0xFF;
                int n8 = n7 << 4 | n5 >> 4;
                int n9 = (n5 & 0xF) + 2;
                if (n9 <= 0) {
                    return n3 - n;
                }
                if (n9 > n4 - n3 && byArray != this.fOutputBuffer) {
                    n4 = n3;
                    n6 = 0;
                    while (n6 < n9) {
                        by = this.fDictionary[n8++];
                        n8 &= 0xFFF;
                        this.fOutputBuffer[this.fOutputHigh++] = by;
                        this.fDictionary[this.fDictionaryPtr++] = by;
                        this.fDictionaryPtr &= 0xFFF;
                        ++n6;
                    }
                } else {
                    n6 = 0;
                    while (n6 < n9) {
                        by = this.fDictionary[n8++];
                        n8 &= 0xFFF;
                        byArray[n3++] = by;
                        this.fDictionary[this.fDictionaryPtr++] = by;
                        this.fDictionaryPtr &= 0xFFF;
                        ++n6;
                    }
                }
            }
            this.fBitTest <<= 1;
            if (this.fBitTest != 256) continue;
            this.fBitTest = 1;
            this.fField = this.nextByte();
        }
        return n3 - n;
    }

    public void close() throws IOException {
        this.in.close();
        this.fDictionary = null;
        this.fOutputBuffer = null;
        this.fInputBuffer = null;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l && this.read() >= 0) {
            ++l2;
        }
        return l2;
    }

    private int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.read();
        if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
            throw new EOFException();
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    private byte nextByte() throws IOException {
        if (this.fInputLow < this.fInputHigh) {
            return this.fInputBuffer[this.fInputLow++];
        }
        this.fInputLow = 0;
        this.fInputHigh = this.in.read(this.fInputBuffer, 0, 1024);
        if (this.fScrambled) {
            int n = 0;
            while (n < this.fInputHigh) {
                this.fInputBuffer[n] = (byte)((this.fInputBuffer[n] - this.fInputCount ^ this.fInputCount) & 0xFF);
                ++this.fInputCount;
                ++n;
            }
        }
        if (this.fInputLow < this.fInputHigh) {
            return this.fInputBuffer[this.fInputLow++];
        }
        this.fNoMore = true;
        return 0;
    }
}

