/*
 * Decompiled with CFR 0.152.
 */
package org.ml.bp.totala.hpi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;
import org.ml.bp.totala.hpi.HPIEntry;
import org.ml.bp.totala.hpi.SQSHInputStream;
import org.ml.bp.totala.hpi.ScrambledRandomAccessFile;
import org.ml.bp.totala.hpi.SubsetInputStream;

public class HPIFile {
    private static ScrambledRandomAccessFile fSRAF;
    private HPIEntry fContents;
    private HPIEntry[] fFlatList;
    private Vector fTempVector;

    private HPIEntry readDirectoryInfo(String string, String string2, int n) throws IOException {
        Vector<HPIEntry> vector = new Vector<HPIEntry>();
        String string3 = string == null ? string2 : String.valueOf(string) + File.separator + string2;
        fSRAF.seek(n);
        int n2 = fSRAF.readInt();
        int n3 = fSRAF.readInt();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = fSRAF.readInt();
            int n6 = fSRAF.readInt();
            int n7 = fSRAF.read();
            long l = fSRAF.getFilePointer();
            fSRAF.seek(n5);
            String string4 = fSRAF.readASCIIZ();
            fSRAF.seek(n6);
            switch (n7) {
                case 0: {
                    vector.addElement(this.readFileInfo(string3, string4, n6));
                    break;
                }
                case 1: {
                    vector.addElement(this.readDirectoryInfo(string3, string4, n6));
                    break;
                }
                default: {
                    System.out.println(String.valueOf(string3) + File.separator + string4 + " (Unknown entry type: " + n7 + ")");
                }
            }
            fSRAF.seek(l);
            ++n4;
        }
        Object[] objectArray = new HPIEntry[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        HPIEntry hPIEntry = new HPIEntry(this, string, string2, 0, 0);
        hPIEntry.fIsDirectory = true;
        hPIEntry.fSubDir = objectArray;
        return hPIEntry;
    }

    public HPIFile(File file) throws IOException {
        fSRAF = new ScrambledRandomAccessFile(file);
        if (fSRAF.length() < 20L) {
            fSRAF.close();
            throw new IOException("Too short to be a HAPI file");
        }
        int n = fSRAF.readInt();
        if (n != 1229996360) {
            fSRAF.close();
            throw new IOException("Invalid signature for a HAPI file");
        }
        int n2 = fSRAF.readInt();
        if (n2 == 1263419714) {
            fSRAF.close();
            throw new IOException("Sorry, saved games not supported");
        }
        int n3 = fSRAF.readInt();
        int n4 = fSRAF.readInt();
        int n5 = fSRAF.readInt();
        fSRAF.setKey(n4);
        this.fTempVector = new Vector();
        this.fContents = this.readDirectoryInfo(null, null, n5);
        this.fFlatList = new HPIEntry[this.fTempVector.size()];
        this.fTempVector.copyInto(this.fFlatList);
        this.fTempVector = null;
    }

    private HPIEntry readFileInfo(String string, String string2, int n) throws IOException {
        int n2 = fSRAF.readInt();
        int n3 = fSRAF.readInt();
        HPIEntry hPIEntry = new HPIEntry(this, string, string2, n2, n3);
        this.fTempVector.addElement(hPIEntry);
        return hPIEntry;
    }

    public void close() throws IOException {
        fSRAF.close();
    }

    public HPIFile(String string) throws IOException {
        this(new File(string));
    }

    public HPIEntry[] getEntries() {
        return this.fContents.fSubDir;
    }

    public HPIEntry[] getEntriesFlattened() {
        return this.fFlatList;
    }

    public InputStream getInputStream(HPIEntry hPIEntry) throws IOException {
        int n;
        if (hPIEntry.fFile != this) {
            throw new IOException("The HPIEntry doesn't correspond to this HPIFile");
        }
        if (!hPIEntry.isFile()) {
            throw new IOException("This HPIEntry doesn't represent a file (it may be a directory)");
        }
        Vector<Integer> vector = new Vector<Integer>();
        ScrambledRandomAccessFile scrambledRandomAccessFile = fSRAF;
        synchronized (scrambledRandomAccessFile) {
            fSRAF.seek(hPIEntry.fDataOffset);
            while ((n = fSRAF.readInt()) != 1213419859) {
                vector.addElement(new Integer(n));
            }
        }
        int n2 = hPIEntry.fDataOffset + vector.size() * 4;
        Vector<SQSHInputStream> vector2 = new Vector<SQSHInputStream>(vector.size());
        n = 0;
        while (n < vector.size()) {
            int n3 = (Integer)vector.elementAt(n);
            SubsetInputStream subsetInputStream = new SubsetInputStream(fSRAF, n2, n3);
            vector2.addElement(new SQSHInputStream(subsetInputStream));
            n2 += n3;
            ++n;
        }
        return new SequenceInputStream(vector2.elements());
    }
}

