/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ml.bp.misc.Wildcard;
import org.ml.bp.totala.hpi.HPIEntry;
import org.ml.bp.totala.hpi.HPIFile;

public class UnHPI {
    private static final int BUFFER_SIZE = 16384;
    private static byte[] fBuffer;
    private static boolean fAbort;

    private static void extractFile(HPIFile hPIFile, HPIEntry hPIEntry, boolean bl) {
        Object object;
        Object object2;
        String string;
        if (bl) {
            string = hPIEntry.getName();
        } else {
            object2 = new File(hPIEntry.getParent());
            if (!((File)object2).exists()) {
                ((File)object2).mkdirs();
            }
            string = hPIEntry.getPath();
        }
        File file = new File(string);
        if (file.exists()) {
            System.err.print(String.valueOf(string) + " already exists, replace? (y/N/q) ");
            object2 = new DataInputStream(System.in);
            try {
                object = ((DataInputStream)object2).readLine();
                if (object == null || ((String)object).length() < 1) {
                    System.out.println(String.valueOf("  Skipped: ") + string);
                    return;
                }
                if (((String)object).equalsIgnoreCase("q")) {
                    System.out.println("  Quitting");
                    fAbort = true;
                    return;
                }
                if (!((String)object).equalsIgnoreCase("y")) {
                    System.out.println(String.valueOf("  Skipped: ") + string);
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        System.out.print(String.valueOf("Extracting: ") + string + " ");
        try {
            int n;
            object2 = new FileOutputStream(file);
            object = hPIFile.getInputStream(hPIEntry);
            while ((n = ((InputStream)object).read(fBuffer)) > 0) {
                ((FileOutputStream)object2).write(fBuffer, 0, n);
                System.out.print('.');
            }
            ((InputStream)object).close();
            ((FileOutputStream)object2).close();
            System.out.println(String.valueOf(" (") + hPIEntry.length() + " bytes) done");
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf("Error writing ") + string + " : " + iOException.getMessage());
            return;
        }
    }

    private static String rightAlign(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, ' ');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        File file;
        System.out.println("UnHPI v1.1  1997-12-12  Barry Pederson <bpederson@geocities.com>");
        System.out.println("");
        if (stringArray.length < 1) {
            System.out.println("Usage: UnHPI [option] HPI-file [file file file ...]");
            System.out.println("    -v     View contents");
            System.out.println("    -j     Junk pathnames and extract files");
            System.out.println("    -d     Extract with directories (default)");
            System.out.println("");
            System.out.println("Wildcards * and ? are permitted when you specify files to extract");
            System.out.println("(filenames are case-insensitive)");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (stringArray[0].charAt(0) == '-') {
            if (stringArray[0].length() != 2) {
                System.out.println(String.valueOf("Illegal option: ") + stringArray[0]);
                return;
            }
            n = 1;
            switch (stringArray[0].charAt(1)) {
                case 'v': {
                    bl2 = true;
                    break;
                }
                case 'j': {
                    bl = true;
                    break;
                }
                case 'd': {
                    break;
                }
                default: {
                    System.out.println(String.valueOf("Unknown option: ") + stringArray[0]);
                    return;
                }
            }
        }
        if (!(file = new File(stringArray[n])).canRead()) {
            System.err.println(String.valueOf("Can't read ") + file.getPath());
            return;
        }
        try {
            HPIFile hPIFile = new HPIFile(file);
            HPIEntry[] hPIEntryArray = hPIFile.getEntriesFlattened();
            if (bl2) {
                System.out.println("   Length   Name");
                System.out.println("   ------   ----");
            } else {
                fBuffer = new byte[16384];
            }
            int n2 = 0;
            int n3 = 0;
            fAbort = false;
            int n4 = 0;
            while (!fAbort && n4 < hPIEntryArray.length) {
                boolean bl3 = stringArray.length == n + 1;
                int n5 = n + 1;
                while (!bl3 && n5 < stringArray.length) {
                    bl3 = Wildcard.match(bl ? hPIEntryArray[n4].getName() : hPIEntryArray[n4].getPath(), stringArray[n5]);
                    ++n5;
                }
                if (bl3) {
                    if (bl2) {
                        System.out.println(String.valueOf(UnHPI.rightAlign(hPIEntryArray[n4].length(), 9)) + "   " + hPIEntryArray[n4].getPath());
                    } else {
                        UnHPI.extractFile(hPIFile, hPIEntryArray[n4], bl);
                    }
                    ++n3;
                    n2 += hPIEntryArray[n4].length();
                }
                ++n4;
            }
            if (bl2) {
                System.out.println("   ------   ----");
                System.out.println(String.valueOf(UnHPI.rightAlign(n2, 9)) + "   " + n3);
            }
            hPIFile.close();
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf("Error reading HPI file: ") + iOException.getMessage());
            return;
        }
    }
}

