Unit VgaGraf; Interface
Uses ASMUtils;
{

 VGAGRAF/256 by Saruman / DFR Research & Engineering 

 CODE IS *UNDOCUMENTED* AND *UNSUPPORTED*

 If it sucks, don't complain - rewrite!

}

type
 RIXHeaderRec = Record
  Marker          :Array[1..4] of Byte;
  Width,Height,
  Dummy           :Word;
 end;

 BMPHeaderRec = Record
  ID              :Array[1..2] of Char;        { 'BM' }
  FileSize,
  Reserved,                                    { Set to ZERO! }
  HeaderSize,
  InfoSize,
  Width,
  Height          :LongInt;
  Planes,
  Bits            :Word;
  Compression,
  ImageSize,
  xPelsPerMeter,
  yPelsPerMeter,
  ClrUsed,
  ClrImportant    :LongInt;
 end;

 PCXHeaderRec = record
  Signature,
  Version,
  Encoding,
  BitsPerPixel    :Byte;
  XMin,YMin,
  XMax,YMax,
  HRes,VRes       :Word;
  OldPCXPalette   :Array [0..47] of byte;
  Reserved,
  Planes          :Byte;
  BytesPerLine,
  PaletteType     :Word;
  Filler          :Array [0..57] of byte;
 end;

 { 256 Color Palette Type: Array[0..255*3] of Byte }
 PaletteType            = Array[1..256*3] of Byte;

const
 YTable: Array[0..199] of Word=(
0,320,640,960,1280,1600,1920,2240,2560,2880,3200,3520,3840,4160,4480,4800,5120,5440,5760,
6080,6400,6720,7040,7360,7680,8000,8320,8640,8960,9280,9600,9920,10240,10560,10880,11200,
11520,11840,12160,12480,12800,13120,13440,13760,14080,14400,14720,15040,15360,15680,16000,
16320,16640,16960,17280,17600,17920,18240,18560,18880,19200,19520,19840,20160,20480,20800,
21120,21440,21760,22080,22400,22720,23040,23360,23680,24000,24320,24640,24960,25280,25600,
25920,26240,26560,26880,27200,27520,27840,28160,28480,28800,29120,29440,29760,30080,30400,
30720,31040,31360,31680,32000,32320,32640,32960,33280,33600,33920,34240,34560,34880,35200,
35520,35840,36160,36480,36800,37120,37440,37760,38080,38400,38720,39040,39360,39680,40000,
40320,40640,40960,41280,41600,41920,42240,42560,42880,43200,43520,43840,44160,44480,44800,
45120,45440,45760,46080,46400,46720,47040,47360,47680,48000,48320,48640,48960,49280,49600,
49920,50240,50560,50880,51200,51520,51840,52160,52480,52800,53120,53440,53760,54080,54400,
54720,55040,55360,55680,56000,56320,56640,56960,57280,57600,57920,58240,58560,58880,59200,
59520,59840,60160,60480,60800,61120,61440,61760,62080,62400,62720,63040,63360,63680);

var
 VGA     :Byte absolute $A000:0000; { Denotes VGA-memory }

Function LoadDATA(var Data;const Filename: String): LongInt;
 { Load a file into a dataarea, returns the number of bytes read. }

Procedure FileBlockRead(var F: File;BASEOFS,X,Y,RW,RH,W,H: LongInt;VAR data: Pointer);
Procedure FileBlockWrite(var F: File;BASEOFS,X,Y,RW,RH,W,H: LongInt;data: Pointer);

Procedure SetScreen(mode: byte);
 { Enter <mode> screenmode. 3 = 80*25 Textmode, $13= 320*200 MCGA }

Function  VGAPresent: Boolean;
 { Returns TRUE if an VGA Adapter is installed }

Function  SetVESAMode(mode: Word): Byte;
 { Enter <mode> Vesamode. ** FILL IN TABLE }

Procedure Plot(X,Y :Word;Color :Byte);
 { Plot a dot at X,Y using <color>. This routine is
   optimized for 320*200 and will only work in that mode. }

Procedure PlotTab(X,Y :Word; C: Byte);
 { Plot a dot at X,Y using <color>. This routine is
   optimized for 320*200 and will only work in that mode.
   This routine is furthermor optimized by using a
   lookuptable for the Y multiplication. }

Procedure VESAPlot(x,y:integer; color:byte);
 { Plot a dot at X,Y using <color>. This routine uses
   the VESA adapter, and thus should work in all VESA screenmodes. }

{Procedure Plot(x,y,color: Word);}

Function  Point(x,y: Word): Byte;
 { Returns the color of the point at X,Y [ASM#1] }

Function  Point2(x,y :Word): Byte;
 { Returns the color of the point at X,Y [ASM#2] }

Function  GMouseX: Word;
 { Returns the XPosition of the mousepointer in Graphicsmode }

Function  GMouseY: Word;
 { Returns the YPosition of the mousepointer in Graphicsmode }

Procedure SetPalette(var Palette);
 { Set the Palette using the using a 256*3 bytes table }
 { ** Add <start> & <len> parameters }

Procedure SetColor(const nr,r,g,b :Byte);
 { Redefine a color in the palette. nr=0..255, R,G,B=0..63 }

Procedure GetColor(ColorNr: Byte; Var R,G,B: Byte);
 { Return the RGB value of a color in the palette }

Procedure BIOSWrite(Str :String;Color :Byte);
 { Write a Character to a graphics screen using BIOS routines }

{Procedure WaitVbl;
 { Wait for Vertical blanking }
Procedure WaitVBL; inline(
  $BA/$DA/$03/  {  mov  dx,$3DA  }
  $B4/$08/      {  mov  ah,8     }
                { @inside:       }
  $EC/          {  in   al,dx    }
  $84/$E0/      {  test al,ah    }
  $75/$FB/      {  jnz  @inside  }
                { @outside:      }
  $EC/          {  in   al,dx    }
  $84/$E0/      {  test al,ah    }
  $74/$FB);     {  jz   @outside }

Function  Iterate(x,y:Real;mn:Word) :Word;
 { Used in Fractals. Iterates the point X,Y (imaginary) MN=MaxN
   This routine was written by Fredrik "RETU" }

(*
Procedure PutBob(X1,Y1,XSize,YSize,ObjSeg,ObjOfs: Word);
 { Copy the "rectangular" memoryblock at ObjSeg:ObjOfs to
   X1,Y1 of the VGAscreen ($A000).

   See Also: #PutGFX#, #PutGFXTrans#, #PutImage#, #GetImage#, #CutBob# }

Procedure CutBob(X,Y,XSize,YSize,ObjSeg,ObjOfs,SourceSeg: Word);
 { Copy a "rectangular" memoryblock from the SourceSeg (which
   can be a virtual screen or the VGAmemory) to ObjSeg:ObjOfs

   See Also: #PutGFX#, #PutGFXTrans#, #PutImage#, #GetImage#, #PutBob# }
*)

Procedure PutGFX(X1,Y1,XSize,YSize,ObjSeg,ObjOfs,DestSeg: Word);
 { Copy a "rectangular" memoryblock denoted by ObjSeg:ObjOfs and
   XSize/YSize to DestSeg (virtual screen or VGAmemory) at X1,Y1
   This function _WILL_ copy color zero too, ie it's *NOT* a
   transperent PutGFX routine.

   See Also: #PutGFXTrans#, #PutImage#, #GetImage# }

Procedure PutGFXTrans(X1,Y1,XSize,YSize,ObjSeg,ObjOfs,DestSeg: Word);
 { Copy a "rectangular" memoryblock denoted by ObjSeg:ObjOfs and
   XSize/YSize to DestSeg (virtual screen or VGAmemory) at X1,Y1
   This function _WILL NOT_ copy color zero too, ie it a
   transperent PutGFX routine.

   See Also: #PutGFX#, #PutImage#, #GetImage# }

Procedure GetImage(ImgPtr: Pointer; XOfs,YOfs,XSize,YSize,SourceSeg: Word);
 { Get an Image from <SourceSeg>

    Example:

    GetMem(Bob.Data,XSize*YSize+4);
    GetImage(Bob.Data,Bob.X,Bob.Y,Bob.XZ,Bob.YZ,VirtSeg);

    See Also: #PutImage#
  }

Procedure PutImage(ImgPtr: Pointer; XOfs,YOfs,DestSeg: Word);
 { Put an Image from onto <DestSeg>

    Example:

    PutImage(Bob.Data,Bob.X,Bob.Y,$A000);

    See Also: #GetImage#
  }

Procedure PaintBlock(x,y,Size,DestSeg :Word;Color :Byte);
 { Paint a rectangular block using <color> }

Procedure Line(x,y,x2,y2:word; co :Byte);
 { Draw a line for X,Y to X2,Y2 using color <co>
   Works in 320*200*256 only }

Procedure Line2(X1,Y1,X2,Y2:Word; Color:Byte);
{ Draw a line in VGA memory - easily changed to draw in VirtRAM }

Function MostUsedColor(X,Y,XSize,YSize: Word): Word;
 { Returns the most used color in the
   region defined by X,Y to X+XSize,Y+YSize }

Procedure Smooth(x1,y1,x2,y2 :Word);
 { Fredrik "RETU"'s Nikalas Smooth routine... }

Procedure ShiftPalette(StartC,EndC: Byte);
 { Shift the palette }

Procedure SetPaletteFromFile(PaletteFile: String);
{ Set the palette from a binary palettefile }

Procedure SetPaletteFromPALFile(PaletteFile: String);
{ Set the palette from a textbased palettefile "PAL\n\<entries>\n\r g b\n.. }

Procedure SavePaletteFromRix(RIXPicture,PaletteFile: String);
{ Save down the palette from a RIX/SCX picture to a file (binary) }

Procedure DumpPaletteAsConst(FileName: String);
{ Save the current palette to a file (binary) }

Procedure PaletteSHL2(var Palette);
Procedure PaletteSHR2(var Palette);

Procedure Bar(segm,x1,y1,x2,y2: word; c: byte);
{ Draw a filled block in segment <segm> using color <c> }

Procedure ShowMouse;
 { Enables the mouse cursor.

   See also: #HideMouse# }

Procedure HideMouse;
 { Disables the mouse cursor.

   See also: #ShowMouse# }

Function  MouseKey: Word;
 { Returns a bitpattern of current mousekey status. }

Function MeasureLine(const a,b,c,d: Integer): Word;
 { Use this function to measure a line from a,b to c,d in pixels.

   See Also: #LineBufRead#, #LineBufWrite# }

Procedure LineBufRead(a,b,c,d: Word;var Buffer);
{
  Read a strip of the screen (a,b-c,d) into a buffer.

  The buffers format is:

    BufSizeInBytes           :Word;
    OriginalX                :Word;
    OriginalY                :Word;  2+2+2 = 6 bytes header
     AddXY                   :Byte;  1 = Add one to X; 2=Add one to Y, 3 = Add Both
     Color                   :Byte;  2 bytes per pixel
     [..repeat..]

  The buffer must be pre-allocated, and its size should be
  atleast #MeasureLine#(a,b,c,d)*2+6

  See Also: #LineBufWrite#, #MeasureLine#
}

Procedure LineBufWrite(X,Y: Word;var Buffer);
 { Draw a strip saved with #LineBufRead# onto the screen. }

Procedure RIX_ReadHeader(const Filename: String;var Palette;var Width,Height: Word);

Procedure RIX_WriteHeader(const Filename: String;var Palette;Width,Height: Word);

Procedure RIX_Load(const FileName: String;Destination: Pointer;var Palette;ReSetPalette: Boolean);
 { Load a a RiXpicture into <destination>

   Example:

   var
    Palette     :Array[1..256*3] of Byte;

    GetMem(VirScr,64000);
    RiX_Load('PLAYGRD.SCX',VirScr,Palette,True);  (* Set palette *)
 }

Procedure RIX_Save(const FileName: String;Source: Pointer;var Palette;Width,Height: Word);
{
 Write a set of data into the format of a RIX/SCX picture

 Example:

 RIX_Save('testut.rix',@vga,Palette,320,200);
}

Procedure RIX_Show_Interactive(const Filename: String);

Procedure BMP_WritePalette(var F: File;var Palette);
 { Write palette to file }
Procedure BMP_SetupHeader(var BH: BMPHeaderRec;Width,Height: LongInt);
 { Setup a correct BMP header structure }

Procedure PCX_SetPalette(var Palette);
 { Setup the palette using a "PCX" palette (shl 2 coded) }
Procedure PCX_SetupHeader(var PCXHeader: PCXHeaderRec;Width,Height: Word);
 { Setup a correct PCX header structure }
Procedure PCX_WritePalette(var F: File;var Palette);
 { Write 2_shifted palette to file }
Procedure PCX_WriteStream(var F:File;var DATA;Len: Word);
 { Write a stream of packed data to file }
Procedure PCX_Load(const Filename:String; Destination :Pointer;var Palette;ReSetPalette: Boolean);
 { PCX_Load('C:\ZAKLEK\TESTPCX.PCX',@VGA,Palette,True); }

Function IFFPack(var InBuf,UtBuf;BufSize: Word): Word;
 { RLE-pack buffer, returns the size of the packed buffer }
Function IFFunPack(var InBuf,UtBuf;BufSize: Word): Word;
 { RLE-unpack buffer, returns the size of the unpacked buffer }

Procedure Object_Get(const X,Y,Width,Height: Word;const Source,Destination: Pointer);
{ Get 'rectangular' data from Source[(Y*320)+X] of and put it at destination.
  Destination buffer will start with two words containing Width & Height
  followed by the data.
}

Procedure Object_Put(const X,Y: Word;const Source,Destination: Pointer);
{ See #Object_Get# for info }

Procedure Object_PutT(const X,Y: Word;const Source,Destination :Pointer);
{ Object_PutTransperent. See #Object_Get# for info }

IMPLEMENTATION

Function Va(const s: string): Longint;
var
 code:   Integer;
 vas:    Longint;
begin
 Val(s,vas,code);
 Va:=vas
end;

Function Hex(W: Byte): String;
const
 hexChars: Array [0..$F] of Char='0123456789ABCDEF';
begin
 Hex:=(hexChars[w shr 4])+(hexChars[w and $F])
end;

(******************************)

Function LoadDATA(var data;const Filename: String): LongInt;
var
 F              :File;
 L              :LongInt;
 LUT            :Word;
begin
 Assign(F,FileName);
 Reset(F,1);
 L:=FileSize(F);
 BlockRead(F,Data,L,LUT);
 Close(F);
 LoadDATA:=LUT;
end;

Procedure FileBlockRead(var F: File;BASEOFS,X,Y,RW,RH,W,H: LongInt;VAR data: Pointer);
var
 loop           :LongInt;
 BytesRead      :Word;
begin
 for loop:=0 to RH-1 do
  begin
   Seek(F,BASEOFS+((Y*W)+X)+(loop*W));
   BlockRead(F,Mem[Seg(data^):Ofs(data^)+(loop*RW)],RW,BytesRead);
  end;
end;

Procedure FileBlockWrite(var F: File;BASEOFS,X,Y,RW,RH,W,H: LongInt;data: Pointer);
var
 loop           :LongInt;
 BytesRead      :Word;
begin
 for loop:=0 to RH-1 do
  begin
   Seek(F,BASEOFS+((Y*W)+X)+(loop*W));
   BlockWrite(F,Mem[Seg(data^):Ofs(data^)+(loop*RW)],RW,BytesRead);
  end;
end;


Procedure SetScreen(mode: byte); Assembler;      { $13=MCGA, $3=80x25}
 Asm
  mov ah,0
  mov al,mode
  int $10
 end;

Function SetVESAMode(mode: Word): Byte; Assembler;
asm
 mov ax,4F02h
 mov bx,mode
 int 10h
end;

{Procedure Plot(x,y,color: Word);
begin
 Mem[$A000:(x-1)+(y-1)*320]:=Color;
end;}

(*
procedure Plot(X,Y :Word;Color :Byte); Assembler;
asm
 mov ax, 0a000h
 mov es, ax
 mov ax, [Y]
 mov bx, 320

{ xor ah,al
 mov bx,ax
 shr ax,2
 add ax,bx
 add ax,[X] { <> MUL BX !!! }

 mul bx

 add ax, [X]
 mov di, ax
 mov al, [Color]
 stosb
end;
*)

Procedure Plot(X,Y: Word;Color: Byte); Assembler;
asm
 mov ax,0a000h
 mov es,ax
 mov di,x
 mov ax,y
 xchg ah,al          { multiply Y by 320 }
 add di,ax
 shr ax,2
 add di,ax
 mov al,color
 stosb
end;

Procedure PlotTab(X,Y :Word; C: Byte); Assembler;
{ Fast putpixel using lookuptable:
  for i:=0 to 199 do YTable[i]:=i*320;
}
asm
 mov bx,y
 add bx,bx
 mov ax,0A000h
 mov es,ax
 mov bx,word ptr YTable[bx]
 mov cx,x
 add bx,cx
 mov al,c
 mov byte ptr es:[bx],al
end;

Function Point(X,Y: Word): Byte; Assembler;
asm
 push ds
 mov ax,0a000h
 mov ds,ax
 mov si,x
 mov ax,y
 xchg ah,al          { multiply Y by 320 }
 add si,ax
 shr ax,2
 add si,ax
 lodsb
 pop ds
end;

Function Point2(x,y :Word): Byte; Assembler;
asm
 push  ds
 mov   ax,0a000h
 mov   ds,ax
 mov   ax,y
 shl   ax,6
 mov   si,ax
 shl   ax,2
 add   si,ax
 add   si,x
 lodsb
 pop   ds
end;

(*
Function Point(x,y :Word): Byte;
begin
 Point:=Mem[$a000:x+(y*320)];
end;

Function Point(x,y: Word): Byte;
begin
Point:=Mem[$A000:(x-1)+(y-1)*320];
end; *)

Function GMouseX: Word;
var
 mus:   Word;
begin
 asm
  mov ax,$3
  int $33
  mov mus,cx;
 end;
GMouseX:=mus;
end;

Function GMouseY: Word;
var
 mus:   Word;
begin
 asm
  mov ax,$3
  int $33
  mov mus,dx;
 end;
GMouseY:=mus;
end;

Procedure SetPalette(var Palette); Assembler;
asm
 mov     bx,ds
 mov     dx,3c8h
 xor     al,al
 out     dx,al
 lds     si,Palette
 mov     dx,3c9h
 mov     cx,300h
 @SetPalette:
 mov     al,[si]
 out     dx,al
 inc     si
 loop    @SetPalette
 mov     ds,bx
end;

Procedure RIX_Load(const FileName: String;Destination: Pointer;var Palette;ReSetPalette: Boolean);
var
 F              :File;
 RIX            :RIXHeaderRec;
Begin
 Assign(F,FileName);
 Reset(F,1);
 BlockRead(F,RIX,SizeOf(RIX));
if ReSetPalette then
 begin
  BlockRead(F,Palette,256*3);
  SetPalette(Palette);
 end else Seek(F,256*3);
 BlockRead(F,Destination^,RIX.Width*RIX.Height);
 Close(F);
end;

Procedure RIX_ReadHeader(const Filename: String;var Palette;var Width,Height: Word);
var
 F              :File;
 RIX            :RIXHeaderRec;
 BytesRead      :Word;
begin
 Assign(F,FileName);
 Reset(F,1);
 BlockRead(F,RIX,SizeOf(RIX),BytesRead);
 BlockRead(F,Palette,256*3,BytesRead);
 Height:=RIX.Height;
 Width:=RIX.Width;
 Close(F);
end;

Procedure RIX_WriteHeader(const Filename: String;var Palette;Width,Height: Word);
var
 F              :File;
 RIX            :RIXHeaderRec;
 BytesRead      :Word;

begin
 RIX.Marker[1]:=Ord('R');
 RIX.Marker[2]:=Ord('I');
 RIX.Marker[3]:=Ord('X');
 RIX.Marker[4]:=Ord('3');
 RIX.Width:=Width;
 RIX.Height:=Height;
 RIX.Dummy:=$AF; { ?? }
 Assign(F,FileName);
 ReWrite(F,1);
 BlockWrite(F,RIX,SizeOf(RIX),BytesRead);
 BlockWrite(F,Mem[Seg(Palette):Ofs(Palette)],256*3,BytesRead);
 Close(F);
end;

Procedure RIX_Save(const FileName: String;Source: Pointer;var Palette;Width,Height: Word);
Var
 F              :File;
 RIX            :RIXHeaderRec;
 BytesRead      :Word;
begin
 RIX_WriteHeader(Filename,Palette,Width,Height);
 Assign(F,Filename);
 Reset(F,1);
 Seek(F,778);
 BlockWrite(F,Source^,Width*Height,BytesRead);
 Close(F);
{ for Loop:=1 to 256 do begin GetColor(Loop,R,G,B); S:=Chr(R)+Chr(G)+Chr(B); BlockWrite(F,S[1],3,BytesRead); end; }
end;

Procedure RIX_Show_Interactive(const Filename: String);
const
 StepX          = 32;
 StepY          = 32;
var
 oldxx,oldyy,
 XX,YY          :LongInt;
 W,H            :Word;
 F              :File;
 Ch             :Char;
 VScreen        :Pointer;
 fastblt        :Boolean;
 Palette        :Array[0..255*3] of byte;
 BytesRead      :Word;
begin
 RIX_ReadHeader(Filename,Palette,W,H);

 Assign(F,Filename);
 Reset(F,1);
 GetMem(VScreen,320*200);
 FillChar(VScreen^,320*200,0);
 SetScreen($13);
 SetPalette(Palette);
 if (W>319) or (H>199) then BEGIN
 XX:=0;
 YY:=0;
 FileBlockRead(F,778,XX,YY,320,200,W,H,VScreen);
 Repeat
  oldXX:=XX;
  oldYY:=YY;
  Move32(Vscreen^,VGA,320*200);
  Ch:=ReadKey;
   if Ch=#0 then
   begin
    Ch:=ReadKey;
    oldxx:=XX;
    oldyy:=YY;
    if Ch=#71 then {home}
     begin
      XX:=0;
      YY:=0;
     end;
    if Ch=#79 then {end}
     begin
      XX:=W-320;
      YY:=H-200;
     end;

    if Ch=#81 then Inc(YY,199);
    if Ch=#73 then Dec(YY,199);
    if Ch=#77 then Inc(XX,StepX);
    if Ch=#80 then Inc(YY,StepY);
    if Ch=#72 then Dec(YY,StepY);
    If Ch=#75 then Dec(XX,StepX);
    if XX>W-320 then XX:=W-320;
    if YY>H-200 then YY:=H-200;
    if YY<0 then YY:=0;
    if XX<0 then XX:=0;
    if (oldxx<>XX) OR (oldyy<>YY) then FileBlockRead(F,778,XX,YY,320,200,W,H,VScreen);
   end;
 Until Ch=#27;
 end else
 begin
  Seek(F,778);
  BlockRead(F,VScreen^,W*H,BytesRead);
  oldxx:=160-(W div 2);
  oldyy:=100-(H div 2);
  for YY:=0 to H-1 do
   begin
    Move32(Mem[seg(Vscreen^):Ofs(Vscreen^)+(YY*W)],Mem[Seg(VGA):Ofs(VGA)+(YY*320)],W);
   end;
  WaitKey;
 end;
 FreeMem(VScreen,320*200);
 Close(F);
end;


Procedure PCX_SetPalette(var Palette); Assembler;
asm
     push DS
     lds  BX,palette
     mov  DX, 03C8h
     mov  AL, 00h
     out  DX, AL
     inc  DX
     mov  CX, 255
@r4: mov  AL, [BX]
     shr  AL, 2
     out  DX, AL
     mov  AL, [BX+1]
     shr  AL, 2
     out  DX, AL
     mov  AL, [BX+2]
     shr  AL, 2
     out  DX, AL
     add  BX, 3
     loop @r4
     pop  DS
end;

Procedure BIOSWrite(Str : String; Color : Byte); Assembler;
Asm
  les  di, Str
  mov  cl, es:[di]     { cl = longueur chane }
  inc  di              { es:di pointe sur 1er caractre }
  xor  ch, ch          { cx = longueur chane }
  mov  bl, Color       { bl:=coul }
  jcxz @ExitBW         { sortie si Length(s)=0 }
 @BoucleBW:
  mov  ah, 0eh         { sortie TTY }
  mov  al, es:[di]     { al=caractre  afficher }
  int  10h             { et hop }
  inc  di              { caractre suivant }
  loop @BoucleBW
 @ExitBW:
end ;

Procedure SetColor(const nr,r,g,b: Byte); Assembler;
asm
 mov al,nr
 mov dx,$3c8
 out dx,al
 inc dx
 mov al,r
 out dx,al
 mov al,g
 out dx,al
 mov al,b
 out dx,al
end;

(*
Procedure WaitVBL; Assembler;
Asm
 MOV  DX, $03DA
 MOV  AH, 8
@Wau:
 IN   AL, DX
 TEST AL, AH
 JNZ  @Wau     { wait Until out of retrace }
@Wai:
 IN   AL, DX
 TEST AL, AH
 JZ   @Wai     { wait Until inside retrace }
end;
*)
Function Iterate(x,y:Real;mn:Word) :Word;
var
 x1,y1,x2,y2,dx,dy : LongInt;  {By Fredrik Nikala}
 n                 : Word;     {Thanx Fredrik... I use this alot! ;-) }

begin
x1:= 0;
y1:= 0;
n:=0;
dx:=trunc(x * $400);
dy:=trunc(y * $400);
repeat
 x2:=((x1 * x1) div $400) - ((y1 * y1) div $400) + dx;
 y2:=((x1 * y1) div $200) + dy;
 inc(n);
 x1:=x2;
 y1:=y2;
UNTIL (x1 * x1 + y1 * y1 > $400000) OR (n = mn);
iterate:=n;
end;

Procedure SetPaletteFromFile(PaletteFile: String);
var
 F           :File;
 RGB         :Array[0..2] of Byte;
 Loop        :Byte;
 Slask       :Word;
begin
 Assign(F,PaletteFile);
 Reset(F,1);
 Loop:=0;
 While NOT Eof(F) do
  begin
   BlockRead(F,RGB,3,Slask);
   SetColor(loop,RGB[0],RGB[1],RGB[2]);
   Inc(Loop);
  end;
 Close(F);
end;

Procedure SetPaletteFromPALFile(PaletteFile: String);
var
 F           :Text;
 RGB         :Array[0..2] of Byte;
 S           :String[15];
 Loop        :Byte;

begin
 Assign(F,PaletteFile);
 Reset(F);
 ReadLn(F,S);     {="PAL" }
 ReadLn(F,S);     {=number of entries (=256)}

 Loop:=0;
 While NOT Eof(F) do
  begin
   ReadLn(F,S);
   RGB[0]:=Va(Copy(S,1,3));
   RGB[1]:=Va(Copy(S,5,3));
   RGB[2]:=Va(Copy(S,9,3));
   SetColor(loop,RGB[0],RGB[1],RGB[2]);
   Inc(Loop);
  end;
 Close(F);
end;



Procedure VESAPlot(x,y:integer; color:byte); Assembler;
Asm
  mov bh,0
  mov cx,x     { sets x coordinate }
  mov dx,y     { sets y coordinate }
  mov al,color { sets color (0-255) }
  mov ah,0Ch   { tells video to plot a point }
  int 10h
End;

Procedure PaintBlock(x,y,Size,DestSeg :Word;Color :Byte); Assembler;
asm
{ cmp x,300
 jz @o
 cmp y,190
 jz @o}
 mov cx,DestSeg
 mov es,cx

 mov bx,y
 mov ax,320
 mul bx
 mov di,ax
 add di,x
 mov al,Color

 mov bx,Size
@1:
  mov cx,Size
  rep stosb
  add di,320
  sub di,Size
  dec bx
  jnz @1
@o:
end;

Procedure Line(x,y,x2,y2 :word; co : Byte); Assembler;
asm
 mov cx,$a000
 mov es,cx

 mov bx,x
 mov ax,y
 mov cx,x2
 mov si,y2

 cmp bx,cx
 jbe @NO
 xchg bx,cx
 xchg ax,si
@NO:

 cmp ax,si
 jbe @NO_SWAP   {always draw downwards}
 xchg bx,cx
 xchg ax,si
@NO_SWAP:
 sub si,ax         {yd (pos)}
 sub cx,bx         {xd (+/-)}
 cld               {set up direction flag}
 jns @H_ABS
 neg cx      {make x positive}
 std
@H_ABS:
 mov di,320
 mul di
 mov di,ax
 add di,bx   {di:adr}
 or si,si
 jnz @NOT_H

{horizontal line}
 cld
 mov al,co
 inc cx
 rep stosb
 jmp @EXIT

@NOT_H:
 or cx,cx
 jnz @NOT_V

{vertical line}
 cld
 mov al,co
 mov cx,si
 inc cx
 mov bx,320-1
@VLINE_LOOP:
 stosb
 add di,bx
 loop @VLINE_LOOP
 jmp @EXIT

@NOT_V:
 cmp cx,si    {which is greater distance?}
 lahf         {then store flags}
 ja @H_IND
 xchg cx,si   {swap for redundant calcs}
@H_IND:
 mov dx,si    {inc2 (adjustment when decision var rolls over)}
 sub dx,cx
 shl dx,1
 shl si,1     {inc1 (step for decision var)}
mov bx,si    {decision var, tells when we need to go secondary direction}
 sub bx,cx
 inc cx
 push bp      {need another register to hold often-used constant}
 mov bp,320
 mov al,co    {Hr!!!!!!!!}
 sahf         {restore flags}
 jb @DIAG_V
{mostly-horizontal diagonal line}
 or bx,bx     {set flags initially, set at end of loop for other iterations}
@LH:
 stosb        {plot and move x, doesn't affect flags}
 jns @SH      {decision var rollover in bx?}
 add bx,si
 loop @LH   {doesn't affect flags}
 jmp @X
@SH:
 add di,bp
 add bx,dx
 loop @LH   {doesn't affect flags}
 jmp @X
@DIAG_V:
{mostly-vertical diagonal line}
 or bx,bx    {set flags initially, set at end of loop for other iterations}
@LV:
 mov es:[di],al   {plot, doesn't affect flags}
 jns @SV          {decision var rollover in bx?}
 add di,bp        {update y coord}
 add bx,si
 loop @LV         {doesn't affect flags}
 jmp @X
@SV:
 scasb            {sure this is superfluous but it's a quick way to inc/dec x coord!}
 add di,bp        {update y coord}
 add bx,dx
 loop @LV         {doesn't affect flags}
@X:
 pop bp
@EXIT:
end;

Procedure Line2(X1,Y1,X2,Y2:Word; Color:Byte); Assembler;
var
 DeX,DeY  :Integer;
 IncF     :Integer;
 Offset   :Word;
asm
    Mov  AX,[X2]
    Sub  AX,[X1]
    JNC  @@Dont1
    Neg  AX
  @@Dont1:
    Mov  [DeX],AX
    Mov  AX,[Y2]
    Sub  AX,[Y1]
    JNC  @@Dont2
    Neg  AX
  @@Dont2:
    Mov  [DeY],AX

    Cmp  AX,[DeX]
    JBE  @@OtherLine

    Mov  AX,[Y1]
    Cmp  AX,[Y2]
    JBE  @@DontSwap1
    Mov  BX,[Y2]
    Mov  [Y1],BX
    Mov  [Y2],AX
    Mov  AX,[X1]
    Mov  BX,[X2]
    Mov  [X1],BX
    Mov  [X2],AX
  @@DontSwap1:
    Mov  [IncF],1
    Mov  AX,[X1]
    Cmp  AX,[X2]
    JBE  @@SkipNegate1
    Neg  [IncF]
  @@SkipNegate1:
    Mov  AX,[Y1]
    Mov  BX,320
    Mul  BX
    Mov  DI,AX
    Add  DI,[X1]        {Offset in DI}
    Mov  BX,[DeY]       {RefVar in BX}
    Mov  CX,BX
    Mov  AX,$A000
    Mov  ES,AX          {Video segment}
    Mov  DL,[Color]
    Mov  SI,[DeX]
  @@DrawLoop1:
    Mov  ES:[DI],DL
    Add  DI,320
    Sub  BX,SI
    JNC  @@GoOn1
    Add  BX,[DeY]
    Add  DI,[IncF]
  @@GoOn1:
    Loop @@DrawLoop1
    Jmp  @@ExitLine

  @@OtherLine:
    Mov  AX,[X1]
    Cmp  AX,[X2]
    JBE  @@DontSwap2
    Mov  BX,[X2]
    Mov  [X1],BX
    Mov  [X2],AX
    Mov  AX,[Y1]
    Mov  BX,[Y2]
    Mov  [Y1],BX
    Mov  [Y2],AX
  @@DontSwap2:
    Mov  [IncF],320
    Mov  AX,[Y1]
    Cmp  AX,[Y2]
    JBE  @@SkipNegate2
    Neg  [IncF]
  @@SkipNegate2:
    Mov  AX,[Y1]
    Mov  BX,320
    Mul  BX
    Mov  DI,AX
    Add  DI,[X1]        {Offset in DI}
    Mov  BX,[DeX]       {RefVar in BX}
    Mov  CX,BX
    Mov  AX,$A000
    Mov  ES,AX          {Video segment}
    Mov  DL,[Color]
    Mov  SI,[DeY]
  @@DrawLoop2:
    Mov  ES:[DI],DL
    Inc  DI
    Sub  BX,SI
    JNC  @@GoOn2
    Add  BX,[DeX]
    Add  DI,[IncF]
  @@GoOn2:
    Loop @@DrawLoop2

  @@ExitLine:
End;

Function MostUsedColor(X,Y,XSize,YSize: Word): Word;
var
 Colors         :Array[0..255] of Byte;
 MaxCol,MaxPos  :Word;
 Loop           :Word;
 XX,YY          :Word;

begin
 FillChar(Colors,SizeOf(Colors),0);
 MaxCol:=0;
 MaxPos:=0;
for YY:=Y to Y+YSize do
 for XX:=X to X+XSize do Inc(Colors[Point(XX,YY)]);
 for loop:=0 to 255 do if Colors[loop]>=MaxCol then
  begin
   MaxCol:=Colors[loop];
   MaxPos:=loop;
  end;
 MostUsedColor:=MaxPos;
end;

Procedure Smooth(x1,y1,x2,y2 :Word);
(*============================================================*)
(* Detta r RETU's _mycket_ hemliga Shifting-Smooth-Algorithm *)
(*============================================================*)
var
 x,y       :Word;

begin
  asm
   mov ax,y1                 {initiera variabel y              }
   mov y,ax

@yloop:
   mov ax,y
   inc ax
   mov y,ax
   mov bx,y2
   cmp ax,bx
   jz  @yslut                {hoppa om y har ntt y2           }

   mov ax,x1                 {initiera vaiable x               }
   mov x,ax

@xloop:
   mov ax,x
   inc ax
   mov x,ax
   mov bx,x2
   cmp ax,bx
   jz  @yloop

   mov bx,y                  {y                                }
   mov ax,320                {320                              }
   dec bx                    {y-1                              }
   mul bx                    {320*(y-1)                        }
   mov bx,x                  {x                                }
   dec bx                    {x-1                              }
   add ax,bx                 {320*(y-1)+x-1                    }
   mov di,ax                 {pos:=... >di                     }

   xor ax,ax
   xor bx,bx
   mov ax,$a000              {bildkrmsminnet                  }
   mov es,ax

   mov bx,es:[di]            {                                 }
   xor bh,bh
   mov ax,bx
   inc di                    {ver pixeln}

   mov bx,es:[di]
   xor bh,bh
   add ax,bx
   inc di                    {ver och till hger om pixeln    }

   mov bx,es:[di]
   xor bh,bh
   add ax,bx
   add di,318                {till vnster om pixeln           }

   mov bx,es:[di]
   xor bh,bh
   add ax,bx
   inc di
   inc di                    {till hger om pixeln             }

   mov bx,es:[di]
   xor bh,bh
   add ax,bx
   add di,318                {under och till vnster on pixeln }

   mov bx,es:[di]
   xor bh,bh
   add ax,bx
   inc di                    {under pixeln                     }

   mov bx,es:[di]
   xor bh,bh
   add ax,bx
   inc di                    {under och till hger om pixeln   }

   mov bx,es:[di]
   xor bh,bh
   add ax,bx
   shr ax,3                  {shift hger tre steg = div 8     }

   sub di,321
   mov es:[di],al
   jmp @xloop
@yslut:
  end;
end;

Procedure ShiftPalette(StartC,EndC: Byte);
var
 i,r,g,b :Byte;

begin
for i:=StartC to EndC do
 begin
 port[$3c8]:=i;
 r:=port[$3c9];
 g:=port[$3c9];
 b:=port[$3c9];
 port[$3c8]:=i;
 port[$3c9]:=r;
 port[$3c9]:=g;
 port[$3c9]:=b;
 end;
end;

Procedure SavePaletteFromRix(RIXPicture,PaletteFile: String);
var
 F              :File;
 Palette        :Array[1..256*3] of Byte;
begin
 Assign(F,RIXPicture);
 Reset(F,1);
 Seek(F,10);
 BlockRead(F,Palette,256*3);
 Close(F);
 Assign(F,PaletteFile);
 ReWrite(F,1);
 BlockWrite(F,Palette,SizeOf(Palette));
 Close(F);
end;

Procedure DumpPaletteAsConst(FileName: String);
var
 F              :Text;
 Loop,R,G,B     :Byte;

begin
 Assign(F,FileName);
 ReWrite(F);
 WriteLn(F,'Palette        :Array[0..767] of Byte=(');
   for loop:=0 to 255 do
   begin
    Port[$3c7]:=loop;
    R:=Port[$3c9];
    G:=Port[$3c9];
    B:=Port[$3c9];
    Write(F,'$',Hex(R),',$',Hex(G),',$',Hex(B));
{    Write(F,PadLeft(St(R),3,' '),',',PadLeft(St(G),3,' '),',',PadLeft(St(B),3,' '));}
    if Loop<>255 then Write(F,',');
    if loop mod 6=5 then WriteLn(F,'')
   end;
 WriteLn(F,');');
 Close(F);
end;

(*
Procedure CutBob(X,Y,Xsize,YSize,ObjSeg,ObjOfs,SourceSeg: Word); Assembler;
asm
   push ds
   cld

   mov cx,ObjSeg
   mov es,cx
   mov di,ObjOfs

   mov cx,SourceSeg { $a000 }
   mov ds,cx

{  mov bx,y
   mov ax,320
   mul bx
   mov si,ax}

   mov dx,y
   shl dx,8
   mov si,dx
   mov dx,y
   shl dx,6
   add si,dx

   add si,x
   mov dx,YSize
@2:
    mov cx,XSize { /2 }
    rep movsb    { W }
    add si,320; sub si,XSize
    dec dx
    jnz @2

pop ds
end;

Procedure PutBob(X1,Y1,XSize,YSize,ObjSeg,ObjOfs: Word); Assembler;
asm
 push ds
 mov dx,$A000
 mov es,dx

 mov bx,320;
 mov ax,y1;
 mul bx;
 add ax,x1;
 mov di,ax

 mov dx,ObjSeg; mov ds,dx; mov si,ObjOfs;
 mov dx,YSize

@LOOP:
 mov cx,XSize
 rep movsb
 add di,320; sub di,XSize
 dec dx
 jnz @LOOP
 pop ds
end;
*)

Procedure PutGFX(X1,Y1,XSize,YSize,ObjSeg,ObjOfs,DestSeg: Word); Assembler;
{ Non-Transperent PutObject, variable destination }
ASM
 push ds
 mov dx,DestSeg
 mov es,dx

 mov bx,320;
 mov ax,y1;
 mul bx;
 add ax,x1;
 mov di,ax

 mov dx,ObjSeg; mov ds,dx; mov si,ObjOfs;
 mov dx,YSize

@LOOP:
 mov cx,XSize
 rep movsb
 add di,320; sub di,XSize
 dec dx
 jnz @LOOP
 pop ds
end;

Procedure PutGFXTrans(X1,Y1,XSize,YSize,ObjSeg,ObjOfs,DestSeg: Word); Assembler;
{ Transperent PutObject, variable destination }
ASM
 push ds
 mov dx,DestSeg
 mov es,dx
 mov bx,320; mov ax,y1; mul bx; add ax,x1; mov di,ax
 mov dx,ObjSeg; mov ds,dx; mov si,ObjOfs;
 mov cx,XSize
 mov ax,YSize

@LOOP:
 mov bh,byte ptr DS:[SI]
 cmp bh,0
 je @nextbyte
 mov byte ptr ES:[DI],bh
@nextbyte:
 inc si
 inc di
 dec cx
 jz  @NewScanLine
 jmp @Loop

@NewScanLine:
 mov cx,Xsize
 add di,320
 sub di,cx
 dec Ysize
 jnz @LOOP
 pop ds
end;

Procedure GetImage(ImgPtr: Pointer; XOfs,YOfs,XSize,YSize,SourceSeg: Word); Assembler;
asm
 PUSH DS
 MOV AX,SourceSeg
 MOV DS,AX
 LES DI,Imgptr

 MOV BX,YOfs
 XCHG BH,BL
 MOV DX,BX
 SHR BX,2
 ADD DX,BX
 ADD DX,XOfs

 MOV AX,xsize
 STOSW
 MOV BX,AX
 MOV AX,ysize
 STOSW

@JP1:
 MOV SI,DX
 MOV CX,BX
 shr cx,1
 jnc @Jp2
 movsb
@Jp2:
 repz movsw
 ADD DX,0140h
 DEC AX
 JNZ @JP1
 POP DS
end;

Procedure PutImage(ImgPtr: Pointer; XOfs,YOfs,DestSeg: Word); Assembler;
asm
 PUSH DS
 MOV AX,DestSeg
 MOV ES,AX
 LDS SI,ImgPtr

 MOV BX,YOfs
 XCHG BH,BL
 MOV CX,BX
 SHR BX,2
 ADD CX,BX
 ADD CX,XOfs

 lodsw
 or ax,ax
 jz @Exit
 mov dx,ax
 lodsw
 or ax,ax
 jz @Exit
 mov bx,ax
 mov ax,cx

@JP1:
 MOV DI,AX
 MOV CX,DX
 SHR CX,1
 JNC @JP2
 MOVSB
@JP2:
 REPZ MOVSW
 ADD AX,140h
 DEC BX
 JNZ @JP1
@Exit:
 POP DS
end;

Function VGAPresent: Boolean; Assembler;
{ Returns TRUE if VGA Graphics adapter is present. }
Asm
 MOV     AH,1Ah
 INT     10h
 CMP     AL,1Ah
 MOV     AL,True
 JE      @OUT
 DEC     AX
@OUT:
end;

Procedure GetColor(ColorNr: Byte; Var R,G,B: Byte);
{ Return the RGB value of a color in the palette }
begin
 Port[$3c8]:=ColorNr;
 R:=Port[$3c9];
 G:=Port[$3c9];
 B:=Port[$3c9];
end;

Procedure Bar(segm,x1,y1,x2,y2: word; c: byte); Assembler;
var
 LineC, Width: Word;
{label lines,drawwords,pixels,exit;}
asm
   mov DI,[y1]             {Calculate screenaddress}
   mov BX,DI
   shl BX,6
   shl DI,8
   add DI,BX
   add DI,[x1]
   mov CX,[y2]             {Calculate number of lines}
   sub CX,[y1]
   mov [linec],CX
   mov CX,[x2]             {Calculate width of square}
   sub CX,[x1]
   mov [width],CX
   mov ES,[segm]           {Output segment}
   mov AL,[c]              {Pixel color}
   mov AH,AL
@lines:
   mov CX,[width]          {Load pixelcounter}
   mov SI,DI               {Load addresscounter}
   add DI,320              {Increase linestartaddress}
   mov BX,SI
   and BX,1                {odd?}
   jz @drawwords
   mov ES:[SI],AL          {then draw one pixel}
   inc SI
   dec CX
   jz @exit                 {No more pixels}
@drawwords:
   mov BX,CX
   shr CX,1                {Words=bytes/2}
   jz @exit
@pixels:
   mov ES:[SI],AX
   add SI,2
   loop @pixels
   and BX,1                {Last odd pixel?}
   jz @exit
   mov ES:[SI],AL
@exit:
   dec [linec]
   jnz @lines
end;

Procedure ShowMouse; Assembler;
asm
 mov ax,$1
 int $33
end;

Procedure HideMouse; Assembler;
asm
 mov ax,$2
 int $33
end;

Function MouseKey: Word; Assembler;
asm
 mov ax,$3
 int $33
 mov ax,bx
end;

Procedure SetMouseImage(hotx,hoty :Integer; Image :Pointer); Assembler;
{ Change mouse pointer image.
 Hotspot ranges from -16 to 16.
 "Image" is 16 words of mask + 16 words of image (bitmapped)
{
   Image       Mask       Result
     0    +     0          Black Pixel
     0    +     1          Transperent
     1    +     0          White Pixel
     1    +     1          Add to color? }
asm
 mov ax,$0009
 mov bx,hotx
 mov cx,hoty
 les dx,Image
 int $33
end;

Function MeasureLine(const a,b,c,d: Integer): Word;

Function sgn(A: Real): ShortInt;
begin
 if a>0 then sgn:=+1 else
 if a<0 then sgn:=-1 else sgn:=0;
end;

var u,s,v,d1x,d1y,d2x,d2y,m,n:real;
    i:integer;
BEGIN
 u:=c-a;
 v:=d-b;
 d1x:=SGN(u);
 d1y:=SGN(v);
 d2x:=SGN(u);
 d2y:=0;
 m:=ABS(u);
 n:=ABS(v);
  if NOT (m>n) then begin
   d2x:=0;
   d2y:=SGN(v);
   m:=ABS(v);
   n:=ABS(u);
  end;
 s:=INT(m/2);
(*
  for i:=0 to Round(m) do begin
{   Inc(len);}
   plot(a,b,col);
   s:=s+n;
   if NOT (s<m) then begin
        s:=s-m;
        Inc(A,Round(d1x));
        Inc(B,Round(d1y));
      end else begin
        Inc(A,Round(d2x));
        Inc(B,Round(d2y));
       end;
  end; *)
 MeasureLine:=Round(m)+1;
end;

Procedure LineBufRead(a,b,c,d: Word;var Buffer);
 Function SGN(A: Real): ShortInt;
 begin
  if a>0 then sgn:=+1 else
  if a<0 then sgn:=-1 else sgn:=0;
 end;

VAR
 u,s,v,d1x,d1y,d2x,d2y,m,n:real;
 i           :Word;
 OrgA,OrgB   :Word;
 LastX,LastY :Word;
 Ut          :Byte;
 Offs        :Word;
BEGIN
 OrgA:=A;
 OrgB:=B;
 MemW[seg(Buffer):Ofs(Buffer)+2]:=orgA;
 MemW[seg(Buffer):Ofs(Buffer)+4]:=orgB;
 Offs:=6;
 u:=c-a;
 v:=d-b;
 d1x:=SGN(u);
 d1y:=SGN(v);
 d2x:=SGN(u);
 d2y:=0;
 m:=ABS(u);
 n:=ABS(v);
  if NOT (m>n) then begin
   d2x:=0;
   d2y:=SGN(v);
   m:=ABS(v);
   n:=ABS(u);
  end;
 s:=INT(m/2);
  LastX:=A; { Set them up }
  LastY:=B; { for the first pass }
  for i:=0 to Round(m) do begin
   Ut:=0;
   if LastX<>A then Inc(Ut);
   if LastY<>B then Inc(Ut,2);
   Mem[seg(Buffer):Ofs(Buffer)+Offs]:=Ut;           { Store addbitmap }
   Mem[seg(Buffer):Ofs(Buffer)+Offs+1]:=Point(A,B); { Store Color }
   Inc(Offs,2);
   s:=s+n;
   LastX:=A;
   LastY:=B;
   if NOT (s<m) then begin
        s:=s-m;
        Inc(A,Round(d1x));
        Inc(B,Round(d1y));
      end else begin
        Inc(A,Round(d2x));
        Inc(B,Round(d2y));
       end;
  end;
 MemW[seg(Buffer):Ofs(Buffer)]:=Round(M)*2+6; { Write BufferLen }
end;

Procedure LineBufWrite(X,Y: Word;var Buffer);
var
 Offs,
 Loop    :Word;
 Len     :Word;

begin
 Offs:=6;
 Len:=(MemW[Seg(Buffer):Ofs(Buffer)] div 2)-6;
 For loop:=1 to Len do
  begin
   if Mem[Seg(Buffer):Ofs(Buffer)+Offs]=1 then Inc(X) else
   if Mem[Seg(Buffer):Ofs(Buffer)+Offs]=2 then Inc(Y) else
   if Mem[Seg(Buffer):Ofs(Buffer)+Offs]=3 then begin Inc(X); Inc(Y); end;
   PlotTab(X,Y,Mem[Seg(Buffer):Ofs(Buffer)+Offs+1]);
   Inc(Offs,2);
  end;
end;

Procedure BMP_SetupHeader(var BH: BMPHeaderRec;Width,Height: LongInt);
var
 RasterSize,
 ImageSize,
 PalSize
               :LongInt;
begin
 FillChar(BH,SizeOf(BMPHeaderRec),0);
 RasterSize:=Width;
{
 if RasterSize AND 3=3 then
  begin
   RasterSize:=RasterSize OR 3;
   Inc(RasterSize);
  end;
 }

 ImageSize:=RasterSize*Height; { Must be EVEN?! }
 PalSize:=256*4;

 BH.ID[1]:='B';
 BH.ID[2]:='M';
 BH.FileSize:=SizeOf(BMPHeaderRec)+ImageSize+PalSize;
 BH.Reserved:=0;
 BH.HeaderSize:=SizeOf(BMPHeaderRec)+PalSize;
 BH.InfoSize:=$28;
 BH.Width:=Width;
 BH.Height:=Height;
 BH.Planes:=1;
 BH.Bits:=8;
 BH.ImageSize:=ImageSize
end;

Procedure BMP_WritePalette(var F: File;var Palette);
type
 RGBF = Record
  B,G,R,FI      :Byte;
 end;
var
 Loop           :Word;
 Pal            :RGBF;
begin
 PAL.FI:=0;
 for loop:=0 to 255 do
  begin
   PAL.R:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3)+0] shl 2;
   PAL.G:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3)+1] shl 2;
   PAL.B:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3)+2] shl 2;
   BlockWrite(F,PAL,SizeOf(PAL));
  end;
end;

Procedure PCX_SetupHeader(var PCXHeader: PCXHeaderRec;Width,Height: Word);
begin
 PCXHeader.Signature:=10;
 PCXHeader.Version:=5;
 PCXHeader.Encoding:=1;
 PCXHeader.BitsPerPixel:=8;
 PCXHeader.Xmin:=0;
 PCXHeader.Ymin:=0;
 PCXHeader.Xmax:=Width-1;
 PCXHeader.Ymax:=Height-1;
 PCXHeader.Hres:=Width;
 PCXHeader.Vres:=Height;
 FillChar(PCXHeader.OLDPCXPalette,48,0);
 PCXHeader.Reserved:=0;
 PCXHeader.Planes:=1;
 PCXHeader.BytesPerLine:=Width;
 PCXHeader.PaletteType:=0;
 FillChar(PCXHeader.Filler,58,0);
end;

Procedure PCX_WritePalette(var F: File;var Palette);
type
 RGB = Record
  R,G,B        :Byte;
 end;
var
 Loop           :Word;
 Pal            :RGB;
begin
 Loop:=12;
 BlockWrite(F,Loop,1); { 256 color MARKER }
 for loop:=0 to 255 do
  begin
   PAL.R:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3)+0] shl 2;
   PAL.G:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3)+1] shl 2;
   PAL.B:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3)+2] shl 2;
   BlockWrite(F,PAL,SizeOf(PAL));
  end;
end;

Procedure PCX_WriteStream(var F:File;var DATA;Len: Word);
var
 i,j,t          :Word;
 a              :Byte;
 utPOS          :Word;
 utS            :Array[1..640] of byte;

begin
 j:=0; t:=0; utPOS:=0;

 While t<Len do begin
   I:=0;                                                                          {320}
   While ((Mem[seg(DATA):Ofs(DATA)+T+I]=Mem[seg(DATA):Ofs(DATA)+T+I+1]) and ((T+I)<LEN) and (I<63)) do Inc(I);

 if I>0 then begin
  A:=I or 192;
  Inc(utpos); UtS[utpos]:=A;
  Inc(utpos); UtS[utpos]:=Mem[seg(DATA):Ofs(DATA)+T];
  Inc(T,I); Inc(J,2);
 end else begin
   if (Mem[seg(DATA):Ofs(DATA)+T] and 192)=192 then
    begin
     A:=193; Inc(UtPos); UtS[utpos]:=A; Inc(J);
    end;
   Inc(UtPos); UtS[utpos]:=Mem[seg(DATA):Ofs(DATA)+T]; Inc(T); Inc(J);
   end;
  end;
 BlockWrite(F,UTS[1],UtPos);
end;

Function HowManySameInARow(var InBuf;Start,BufEnd: Word): Word;
var
 Count          :Word;
begin
 Count:=0;
 While
  (Mem[Seg(InBuf):Ofs(InBuf)+Start+Count]=
   Mem[Seg(InBuf):Ofs(InBuf)+Start+Count+1]) AND (Start+Count+1<=BufEnd)
   AND (Count<127) do Inc(Count);
 HowManySameInARow:=Count+1;
end;

Function HowManyDifferentInARow(var InBuf;Start,BufEnd: Word): Word;
var
 Count          :Word;
begin
 Count:=0;
 While
  (Mem[Seg(InBuf):Ofs(InBuf)+Start+Count]<>
   Mem[Seg(InBuf):Ofs(InBuf)+Start+Count+1]) AND (Start+Count+1<=BufEnd)
   AND (Count<128) do Inc(Count);
 HowManyDifferentInARow:=Count;
end;

Function IFFunPack(var InBuf,UtBuf;BufSize: Word): Word;
var
 InPek         :Word;
 UtPek         :Word;
 B             :Byte;
 Loop          :Byte;

begin
 UtPek:=0;
 InPek:=0;

 REPEAT
  B:=Mem[Seg(InBuf):Ofs(InBuf)+InPek];
   if B>127 then { Output original/different bytes }
    begin
     Dec(B,127);
{     WriteLn('Output bytes: ',B);}
 {    for loop:=1 to B do Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek+Loop-1]:=Mem[Seg(InBuf):Ofs(InBuf)+InPek+Loop];}
     Move(Mem[Seg(InBuf):Ofs(InBuf)+InPek+1],Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek],B);
     Inc(UtPek,B);
     Inc(InPek,B+1);
    end else begin { Output repeated byte }
     Inc(B);
{     WriteLn('Repeat: ',B);}
     FillChar(Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek],B,Mem[Seg(InBuf):Ofs(InBuf)+InPek+1]);
     Inc(UtPek,B);
     Inc(InPek,2);
    end;

 UNTIL InPek>=BufSize;
IFFunPack:=UtPek;
end;

Function IFFPack(var InBuf,UtBuf;BufSize: Word): Word;
var
 InPek         :Word;
 UtPek         :Word;
 Done          :Boolean;
 B             :Byte;
 L1,L2         :Word;

begin
 InPek:=0; UtPek:=0;

 Done:=False;
 REPEAT
  B:=Mem[Seg(InBuf):Ofs(InBuf)+InPek];
  L1:=HowManySameInARow(InBuf,InPek,BufSize);
  L2:=HowManyDifferentInARow(InBuf,InPek,BufSize);

  if (L1>L2) then
   begin
{ WriteLn('Pack:  0+',L1,'=',L1,'==',Hex(L1));}
    Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek]:=L1-1; { 0-127 = repeat }
    Inc(UtPek);
    Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek]:=B;
    Inc(UtPek);
    Inc(InPek,L1);
   end else begin
{ WriteLn('Org: 127+',L2,'=',127+L2,'==',Hex(127+L2));}
    Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek]:=127+L2; { 128-255 = output original }
    Inc(UtPek);
    if L2>0 then Move(Mem[Seg(InBuf):Ofs(InBuf)+InPek],Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek],L2);
{ for B:=0 to L2-1 do Mem[Seg(UtBuf):Ofs(UtBuf)+UtPek+B]:=Mem[Seg(InBuf):Ofs(InBuf)+InPek+B]; }
    Inc(UtPek,L2);
    Inc(InPek,L2);
   end;

  if InPek>=BufSize then done:=True;
 UNTIL Done;

 IffPack:=UtPek;
end;

Procedure PaletteSHL2(var Palette);
var
 Loop           :Word;
begin
 for loop:=0 to 255 do
  begin
   Mem[Seg(Palette):Ofs(Palette)+(Loop*3+0)]:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3+0)] shl 2;
   Mem[Seg(Palette):Ofs(Palette)+(Loop*3+1)]:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3+1)] shl 2;
   Mem[Seg(Palette):Ofs(Palette)+(Loop*3+2)]:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3+2)] shl 2;
  end;
end;

Procedure PaletteSHR2(var Palette);
var
 Loop           :Word;
begin
 for loop:=0 to 255 do
  begin
   Mem[Seg(Palette):Ofs(Palette)+(Loop*3+0)]:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3+0)] shr 2;
   Mem[Seg(Palette):Ofs(Palette)+(Loop*3+1)]:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3+1)] shr 2;
   Mem[Seg(Palette):Ofs(Palette)+(Loop*3+2)]:=Mem[Seg(Palette):Ofs(Palette)+(Loop*3+2)] shr 2;
  end;
end;

Procedure PCX_Load(const Filename:String;Destination :Pointer;var Palette;ReSetPalette: Boolean);
var
 F     :File;
 Res   :Word;
 Temp  :Pointer;

BEGIN
 Assign(F,Filename);
 Reset(F,1);

 if ReSetPalette then
  begin
   Seek(F,FileSize(F)-768);
   BlockRead(F,Palette,768);
   PCX_SetPalette(Palette);
  end;

 Seek(F,128);
 Res:=FileSize(F)-768-128;
 GetMem(Temp,Res);
 BlockRead(F,Temp^,Res);
 Close(F);

  asm
    push ds
    les  di,destination
{    mov  ax,segment
    mov  es,ax}
    xor  di,di
    xor  ch,ch
    lds  si,temp
@Loop1 :
    lodsb
    mov  bl,al
    and  bl,$c0
    cmp  bl,$c0
    jne  @Single

    mov  cl,al
    and  cl,$3f
    lodsb
    rep  stosb
    jmp  @Fin
@Single:
    stosb
@Fin:
    cmp  di,63999
    jbe  @Loop1
    pop  ds
  END;
 FreeMem(Temp,Res);
END;

Procedure Object_Get(const X,Y,Width,Height: Word;const Source,Destination: Pointer); Assembler;
{ Created 96-05-21 by Eddy L O Jansson 2:206/233 (saruman@saru.ct.se) }
asm
   push ds
   lds si,Source
   les di,Destination

   mov dx,Y
   shl dx,8
   add si,dx
   mov dx,Y
   shl dx,6
   add si,dx
   add si,X

   cld
   mov ax,Width
   stosw                   { Save Width }
   mov dx,ax
   mov bx,320d
   sub bx,ax               { Setup Add+offset }
   and ax,1
   jnz  @odd               { test against a shr ax,1 instead .. ? }

   mov ax,dx
   shr ax,1
   mov Width,ax
   mov ax,Height
   stosw
@evenloop:
   mov cx,width
   rep movsw
   add si,320
   sub si,dx
   dec ax
   jnz @evenloop
   jmp @exit
{   pop ds
   leave
   retn $10 _or_ retf $10 (if you put it in a unit, then RETurnFar }

@odd:
   mov ax,dx
   shr ax,1
   mov Width,ax
   mov ax,Height
   stosw                   { Save Height }
@oddloop:
   mov cx,width
   rep movsw
       movsb
   add si,bx
   dec ax
   jnz @oddloop
@exit:
   pop ds
end;

Procedure Object_Put(const X,Y: Word;const Source,Destination: Pointer); Assembler;
{ Created 96-05-21 by Eddy L O Jansson 2:206/233 (saruman@saru.ct.se) }
asm
   push ds                { Sorry, no free register available for you .. }
   lds si,Source
   les di,Destination

   mov dx,Y
   shl dx,8               { dx*256 }
   add di,dx
   mov dx,Y
   shl dx,6               { dx*64 }
   add di,dx              { destination=destination+DX*320 }
   add di,X               { destination=destination+X }

   cld
   lodsw                  { get width }
   mov dx,ax              { store in dx }
   mov bx,320d
   sub bx,ax              { Setup 'next scanline' offset }
   and ax,1               { check if width is even }
   jnz @odd               { no? gotta use the special routine (jump=3 clocks, no jump=1 }

   shr dx,1               { divide width by 2 }
   lodsw                  { get height (into AX) }
@evenloop:
   mov cx,dx              { load CX with width/2 }
   rep movsw              { move from source => destination }
   add di,bx              { goto next scanline }
   dec ax                 { decrement 'height' counter }
   jnz @evenloop          { another scanline? }
   jmp @exit
{   pop ds
   leave
   retn $0C _or_ retf $0C (if you put it in a unit, then RETurnFar }

@odd:
   shr dx,1               { divide width by 2 }
   lodsw                  { get height (into AX) }
@oddloop:
   mov cx,dx              { load CX with width/2 }
   rep movsw              { move from source => destination }
       movsb              { fixup for the odd byte }
   add di,bx              { goto next scanline }
   dec ax                 { decrement 'height' counter }
   jnz @oddloop           { another scanline? }
@exit:
   pop ds                 { .. if I only had one spare register... :-( }
end;

Procedure Object_PutT(const X,Y: Word;const Source,Destination :Pointer); Assembler;
asm
   push ds                { Sorry, no free register available for you .. }
   lds si,Source
   les di,Destination
   mov dx,Y
   shl dx,8               { dx*256 }
   add di,dx
   mov dx,Y
   shl dx,6               { dx*64 }
   add di,dx              { destination=destination+DX*320 }
   add di,X               { destination=destination+X }
   cld
   lodsw                  { get width }
   mov dx,ax              { store in dx }
   lodsw                  { get height (into AX) }
   mov bx,ax              { store in bx }
@nextline:
   mov cx,dx              { load CX with width }
@again:
   lodsb
   or  al,al
   je  @trans
   mov byte ptr [es:di],al
@trans:
   inc di
   dec cx
   jnz @again
   add di,320d
   sub di,dx              { goto next scanline }
   dec bx                 { decrement 'height' counter }
   jnz @nextline          { another scanline? }
   pop ds
end;

Procedure Object_PutSRM(Const X,Y:Word;const Source,Destination: Pointer); Assembler;
{
 (=========================================================================)
  SRM-Compressed Graphics Object Put Routine, developed by Eddy L O Jansson
   ** Please contact me at saruman@saru.ct.se (2:206/233) with comments **

  If you choose to use this code in any of your projects, please greet me in
   your credits, this is GreetWare! [Saruman / DFR Research & Development]
 (==========================================================================)

  SRMRLE01 Format;

  object.width,
  object.height     :Word;   ;info only

  command (word)  param (word)
  0000            Add this to DI (=transparent parts & goto next scanline)
  0001            Number of words - _NOT_ containing color zero - to blit
                  using a mov cx,PARAM; rep movsw
  0002            Number of bytes - may contain zero - to blit using the
                  slow; lodsb, compare, "move", inc routine...
                    NOTE: Should always be EVEN amount of bytes to keep
                          the data WORD aligned!
  0003            Number of words to fill with (next word is pattern)
                    NOTE: fill using AX = fill with 2 pixel pattern
 ?0004?           4 bytes data to be MOVSD'd
  FFFF            End-Of-Object

note:

 Once an object has been created with this structure (and _that_ is
 quite tricky if you want it to be _optimal_) it can =easily= be converted
 to a Compiled-BitMap(CBM) for optimal speed but at the cost of additional
 memory.

}
asm
   mov bx,ds
   lds si,Source
   les di,Destination
   mov dx,Y
   shl dx,8               { dx*256 }
   add di,dx
   mov dx,Y
   shl dx,6               { dx*64 }
   add di,dx              { destination=destination+DX*320 }
   add di,X               { destination=destination+X }

   { lodsw                { get width }
   { lodsw                { get height }
   add si,4;              { skip width & height }

   cld
@readcmd:
   lodsw                  { Get _CMD into AX }
   cmp ax,0000
   je @do_transparent
   cmp ax,0001
   je @do_wordblt
   cmp ax,0002
   je @do_byteblt
   cmp ax,0003
   je @do_wordfill
{   cmp ax,0004
   je @do_longwordblt}

{ if here then invalid command _OR_ $FFFF - Let's exit! }
   jmp @exit

{ == Byte Blitter == }
@do_byteblt:
   lodsw
   mov cx,ax
@next_byte:
   lodsb
   or al,al
   je @is_trans
   mov byte ptr [es:di],al
@is_trans:
   inc di
   dec cx
   jnz @next_byte
   jmp @readcmd

{ == Skip transparent parts == }
@do_transparent:
   lodsw
   add di,ax
   jmp @readcmd

{ == Word Blitter == }
@do_wordblt:
   lodsw
   mov cx,ax
   rep movsw
   jmp @readcmd

{ == Word Filler == }
@do_wordfill:
   lodsw
   mov cx,ax
   lodsw
   rep stosw
   jmp @readcmd

{@do_longwordblt:
   db $66; movsw
   jmp @readcmd}

@exit:
   mov ds,bx
end;


end.
