// serverLog.cpp: implementation of the serverLog class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "StdAfx.h"
#include "serverLog.h"
#include "myLog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

/* ********************* constructor ******************************* */
serverLog::serverLog(char *serverLogName, char *serverStatusFile)
{
	_numread = 0;
	strcpy(_serverLogName, serverLogName);
	strcpy(_serverStatusFile, serverStatusFile);
	openServerLog();
}

/* ********************* destructor  ******************************* */
serverLog::~serverLog()
{
	fclose(_logPtr);
}

/* ********************* open the server log ********************** */
int serverLog::openServerLog()
{
   char temp[STRMAX+1];

   if ( (_logPtr = fopen(_serverLogName,"r")) == (FILE *)NULL ) {
		sprintf(temp, "Error opening %s",_serverLogName);
		writeerror(temp);
		cout<<temp<<endl;
		exit(1);
   }

return TRUE;
}

/* ********************* read 1 entry in the server log ************ */
int serverLog::readServerEntry()
{
	char str[10000+1], *newLine;

	if ( fgets(str, 10000, _logPtr)) {

		// get rid of the '\n'
		newLine = strchr(str,'\n');
		if (newLine)
			*newLine = '\0';
		strncpy(_serverEntry,str,STRMAX);
		_serverEntry[STRMAX] = '\0';

		return TRUE;
	}
	else {
		return FALSE;
	}
}

/* ********************* parse the server log enty for kill messages */
int  serverLog::parseEntry(killMsg *km)
{
	int match = FALSE; 
	killmsg *kmsg;
	char *str1, *str2, delim1, delim2;

	km->setToTopOfList();
	
	while ( (kmsg = km->getNextKillMsg()) != (killmsg *)NULL ) {
		str1 = km->getString1(kmsg);
		str2 = km->getString2(kmsg);
		_winner = km->getWinner(kmsg);
		delim1 = km->getDelim1(kmsg);
		delim2 = km->getDelim2(kmsg);
        
		if (findkillMessage(str1, str2, delim1, delim2)) {
			match = TRUE;
			break;
		}
	}

	return match;
}

/* ********************* find a kill message ************************* */
/* compare the server log entry against the kill message templates *** */
int serverLog::findkillMessage(char *pattern1, char *pattern2, char delim1, char delim2)
{
	unsigned int lenE = strlen(_serverEntry), 
		len1 = strlen(pattern1),
		len2 = strlen(pattern2);
	char *cur = _serverEntry, *beg = _serverEntry, *tok;
	int match1 = FALSE, match2 = FALSE;
	//int endof1st = 0;

	_name1pos = 0;
	_name2pos = 0;
	_name1len = 0;
	_name2len = 0;

	if (lenE < len1 || lenE < len2) 
		return FALSE;

	// try to find the 1st string
	while (strlen(cur) > 0) {
	   tok = strchr(cur,delim1);
	   if (tok == (char *)NULL)
		   break;
	   if (strlen(cur) < len1)
		   break;
	   if ( strncmp(cur,pattern1,len1) == 0) {
		   _name1pos = 1;           // for now not always 1st in the log
		   match1 = TRUE;
		   break;
	   }
	   else {
		   _name1len = tok - beg;
		   cur += tok - cur +1;
		   continue;
	   }

	}

	if (match1) {
	   _name2pos = len1 + _name1len + 2;
	   beg = _serverEntry + _name2pos;
	   if ((unsigned) _name2pos > strlen(_serverEntry)) {
		   cur = (char *)NULL;
		   _name2pos = 0;
	   }
	   else
	      cur = _serverEntry + _name2pos;

   	   while (cur != (char *)NULL && strlen(cur) > 0) {
		  // there is no second pattern so length of the name is the rest of the string
		  if ( delim2 == '\0' && (pattern2 == (char *)NULL || strcmp(pattern2,"") == 0)) {
			   _name2len = strlen(cur);
			   if (strlen(cur) > 0)
				   match2 = TRUE;
			   break;
		  }
	      tok = strchr(cur,delim2);
		  if (tok == (char *)NULL)
			  break;
		  if (strlen(cur) < len2)
			  break;
	      if ( strncmp(tok+1,pattern2,len2) == 0) {
			  _name2len = tok - beg;
		      match2 = TRUE;
		      break;
		  }
	      else {
		     cur += tok-cur +1;
		     continue;
		  }

		}
	}

	if (!match1) {
		_name1pos = 0;
		_name1len = 0;
	}

	if (!match2) {
		_name2pos = 0;
		_name2len = 0;
	}

   // there is no second pattern john
    if ( delim2 == '\0' && (pattern2 == (char *)NULL || strcmp(pattern2,"") == 0)) {
		return match1;
	}
	else {
		return (match1 & match2);
	}

}


/* ********* update the player List  ******************************* */
void serverLog::updateList(playerList *pl, returnMsg *pReturn)
{

	if (pReturn->winner == 1) {
		if (strlen(pReturn->winname) > 0) {
			pl->updateList(pReturn->winname, 0, 1, 0, 0);
		}
		if (strlen(pReturn->losename) > 0) {
			pl->updateList(pReturn->losename, 1, 0, 0, 0);
	   }
	}
	else if (pReturn->winner == 2) {
		if (strlen(pReturn->winname) > 1) {
			pl->updateList(pReturn->winname, 0, 1, 0, 0);
		}
	   if (strlen(pReturn->losename) > 0) {
			pl->updateList(pReturn->losename, 1, 0, 0, 0);
	   }
	}
	else if (pReturn->winner == 3) {
		if (strlen(pReturn->winname) > 0) {
			pl->updateList(pReturn->winname, 0, 0, 1, 0);
		}
	}
	else if (pReturn->winner == 4) {
		if (strlen(pReturn->winname) > 0) {
			pl->updateList(pReturn->winname, 0, 0, 0, 1);
		}
	}
  }


/* ************ Process the server log **************************** */
//int serverLog::processServerLog(killMsg *kmPtr, playerList *ml, playerList *dl)
int serverLog::processServerLog(PFNPARSELINE pfnParseLine, playerList *ml, playerList *dl)
{ 
   myLog pLog;
   int retCode = 0;
   long counter;
   returnMsg returnValue;

   _serverEntry[0] = '\0';
   _numread = 0;
   _numLastRead = 0;

   pLog.openMyLog(_serverLogName, _serverStatusFile, &_numLastRead);
   counter = _numLastRead;

   if (!pLog.logDateIsNewer())
	   return TRUE;

	// if we have already done this before we need to start after the stuff we 
	// already processed
	if (counter > 0) {  // added
	    while ( (retCode = readServerEntry()) == TRUE && counter > 1) {
		counter--;
	    }
	}

	// if we don't find the last line that was read previously the it must be 
	// a new log so start at the beginning
    if ( (counter > 1 && retCode == FALSE )||
		(counter == 1  &&  pLog.isThisTheOne(_serverEntry) == FALSE)) {
       fseek(_logPtr, 0L, SEEK_SET);
	   _numLastRead = 0;
    }

	_numread += _numLastRead;
	while ( readServerEntry() == TRUE) {
		_numread++;
		//if ( parseEntry(kmPtr) ) {
		if ( pfnParseLine(_serverEntry, &returnValue) == TRUE ) {
	// cout<<" insert "<<_serverEntry<<endl;
			updateList(ml, &returnValue);
			updateList(dl, &returnValue);
		}
	}
    
	// write how many we processed so when we run again we know where to start in 
	// the server's log

	pLog.writeMyLog(_numread, _serverEntry);

	return TRUE;
}

