#include "g_local.h"



/*
======================================================================

INTERMISSION

======================================================================
*/

void MoveClientToIntermission (edict_t *ent)
{
	if (deathmatch->value || coop->value)
		ent->client->showscores = true;
	VectorCopy (level.intermission_origin, ent->s.origin);
	ent->client->ps.pmove.origin[0] = level.intermission_origin[0]*8;
	ent->client->ps.pmove.origin[1] = level.intermission_origin[1]*8;
	ent->client->ps.pmove.origin[2] = level.intermission_origin[2]*8;
	VectorCopy (level.intermission_angle, ent->client->ps.viewangles);
	ent->client->ps.pmove.pm_type = PM_FREEZE;
	ent->client->ps.gunindex = 0;
	ent->client->ps.blend[3] = 0;
	ent->client->ps.rdflags &= ~RDF_UNDERWATER;

	// clean up powerup info
	ent->client->quad_framenum = 0;
	ent->client->invincible_framenum = 0;
	ent->client->breather_framenum = 0;
	ent->client->enviro_framenum = 0;
	ent->client->grenade_blew_up = false;
	ent->client->grenade_time = 0;

	ent->viewheight = 0;
	ent->s.modelindex = 0;
	ent->s.modelindex2 = 0;
	ent->s.modelindex3 = 0;
	ent->s.modelindex = 0;
	ent->s.effects = 0;
	ent->s.sound = 0;
	ent->solid = SOLID_NOT;
//TIMM
	ent->client->ps.rdflags &= ~RDF_IRGOGGLES;		// PGM
	ent->client->ir_framenum = OUTBR_IRG_OFF;					// PGM

	// add the layout
	if (deathmatch->value || coop->value)
	{
		DeathmatchScoreboardMessage (ent, NULL);
		gi.unicast (ent, true);
	}

}

void BeginIntermission (edict_t *targ)
{
	int		i, n, kfound, pfound, nfound, sel;
	edict_t	*ent, *client, *spot=NULL;
	
	if (level.intermissiontime)
		return;		// already activated
	//TIMM
	kfound = pfound = nfound = 0;
	level.outbreak_trigger=OUTBR_TRIGGER_CLOSED; // So dass wir im nchsten level neu ffnen
	ent=NULL;
	//TIMM

	game.autosaved = false;

	// respawn any dead clients
	for (i=0 ; i<maxclients->value ; i++)
	{
		client = g_edicts + 1 + i;
		if (!client->inuse)
			continue;
		if (client->health <= 0)
			respawn(client);
	}

	level.intermissiontime = level.time;
	level.changemap = targ->map;

	if (strstr(level.changemap, "*"))
	{
		if (coop->value)
		{
			for (i=0 ; i<maxclients->value ; i++)
			{
				client = g_edicts + 1 + i;
				if (!client->inuse)
					continue;
				// strip players of all keys between units
				for (n = 0; n < MAX_ITEMS; n++)
				{
					if (itemlist[n].flags & IT_KEY)
						client->client->pers.inventory[n] = 0;
				}
			}
		}
	}
	else
	{
		if (!deathmatch->value)
		{
			level.exitintermission = 1;		// go immediately to the next level
			return;
		}
	}

	level.exitintermission = 0;

	//TIMM
	// find an intermission spot
//TIMMS neue ROUTINE
	
	sel=1;
	while((ent = G_Find (ent, FOFS(classname), "info_player_intermission"))!=NULL)
	{
		if(ent->targetname)
		{
			if(!Q_strcasecmp(ent->targetname, "PRISONERS"))
				pfound++;
			else if(!Q_strcasecmp(ent->targetname, "KEEPERS"))
				kfound++;
			else
				nfound++;
		}
		else
			nfound++;
	}

	ent=NULL;
	
	if((level.winner == OUTBR_WINNER_PRIS) && (pfound))
	{
		sel += rand() % pfound;
		while((ent = G_Find (ent, FOFS(classname), "info_player_intermission"))!=NULL)
		{
			if(ent->targetname)
			{
				if(!Q_strcasecmp(ent->targetname, "PRISONERS"))
					sel--;
			}
			if(!sel)
				break;
		}
	}
	else
	{
		if(kfound)
			sel += rand() % kfound;
		else
			sel += rand() % nfound;
		while((ent = G_Find (ent, FOFS(classname), "info_player_intermission"))!=NULL)
		{
			if(ent->targetname)
			{
				if((kfound)&&!(Q_strcasecmp(ent->targetname, "KEEPERS")))
					sel--;
				if(!kfound&&((Q_strcasecmp(ent->targetname, "PRISONERS")||!pfound)))
					sel--;
			}
			if(!sel)
				break;
		}
	}
	//TIMM
	if (!ent)
	{	// the map creator forgot to put in an intermission point...
		ent = G_Find (NULL, FOFS(classname), "info_player_start");
		if (!ent)
			ent = G_Find (NULL, FOFS(classname), "info_player_deathmatch");
	}
	//else
	//{	// chose one of four spots
	//	i = rand() & 3;
	//	while (i--)
	//	{
	//		ent = G_Find (ent, FOFS(classname), "info_player_intermission");
	//		if (!ent)	// wrap around the list
	//			ent = G_Find (ent, FOFS(classname), "info_player_intermission");
	//	}
	//}

	VectorCopy (ent->s.origin, level.intermission_origin);
	VectorCopy (ent->s.angles, level.intermission_angle);

	OUTBRMoveBackToPrison();
	// move all clients to the intermission point
	if(level.winner==OUTBR_WINNER_KEEP)
			OUTBRGoBackToPrison();

	for (i=0 ; i<maxclients->value ; i++)
	{
		client = g_edicts + 1 + i;
		if (!client->inuse)
			continue;
//TIMM
		if(level.winner == OUTBR_WINNER_PRIS)
		{
			CopyToBodyQue (client);
		
		}
//		if(level.winner == OUTBR_WINNER_KEEP && client->client->resp.outbr_team == OUTBR_PRISONERS)
//		{
//OUTBREAKFIX		}
//		else
			MoveClientToIntermission (client);
	}
	if(level.winner == OUTBR_WINNER_PRIS)
	{
		while ((spot = G_Find (spot, FOFS(targetname), "OUTBREAKENDP")) != NULL)
		{
			spot->use (spot, NULL, NULL);	
		}
	}
	else
	{
		while ((spot = G_Find (spot, FOFS(targetname), "OUTBREAKENDK")) != NULL)
		{
			spot->use (spot, NULL, NULL);	
		}
	}

}


/*
==================
DeathmatchScoreboardMessage

==================
*/

void DeathmatchScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength = 0;
	int		anteil_keep = 0;
	int		i, j, k;
	int		score,  totalclients, time;
    int		picnum;
	int		y;
	int		num_keep, num_pris;

	gclient_t	*cl;
	edict_t		*cl_ent;
	char	*tag, *tag2;

	int		sorted_keep[12];
	int		sortedscores_keep[12];
	int		sorted_pris[12];
	int		sortedscores_pris[12];
	totalclients = 0;
	time  = 0;
	num_keep = 0;
	num_pris = 0;
	


	//
	//  Zhlt 
	//  a) keepers: num_keep
	//  b) prisoners: num_pris
	//  c) totale im Spiel(!= spectator): totalclients
		

	//
	// Auslastung der Anzeige
	// Wenn beide mehr als die Hlft von 14/24 dann genau geteilt,
	// ansonsten grerer = max - kleinerer
	//


	// sort the clients by score

	//
	// Sortieren
	//
	
	for (i = 0 ; i < game.maxclients ; i++)
	{
			cl_ent = g_edicts + 1 + i;
			if (!cl_ent->inuse || game.clients[i].resp.spectator)
					continue;
			score = game.clients[i].resp.score;
			if(game.clients[i].resp.outbr_team == OUTBR_KEEPERS)
			{
					for (j = 0 ; j < num_keep ; j++)
					{
							if (score > sortedscores_keep[j])
									break;
					}
					for (k = num_keep ; k > j ; k--)
					{
							sorted_keep[k] = sorted_keep[k - 1];
							sortedscores_keep[k] = sortedscores_keep[k - 1];
					}
					sorted_keep[j] = i;
					sortedscores_keep[j] = score;
					num_keep++;
			}
			else if(game.clients[i].resp.outbr_team == OUTBR_PRISONERS)
			{
					for (j = 0 ; j < num_pris ; j++)
					{
							if (score > sortedscores_pris[j])
									break;
					}
					for (k = num_pris; k > j ; k--)
					{
							sorted_pris[k] = sorted_pris[k - 1];
							sortedscores_pris[k] = sortedscores_pris[k - 1];
					}
					sorted_pris[j] = i;
					sortedscores_pris[j] = score;
					num_pris++;

			}
			totalclients++;
	}

	// ^
	// Ende Keeper&&Pris Sortierung 
	//


	// print level name and exit rules
	string[0] = 0;

	stringlength = strlen(string);

	
	
	/////////////////////////////////////////////////
	//
	//LAYOUT BEGINNT
	//
	/////////////////////////////////////////////////
	if(totalclients > 24)
	{
		totalclients = 24;
	}
	if((num_keep)||(num_pris))
	{
		anteil_keep = 920 * num_keep / (num_keep + num_pris);
	}
	else
	{
		anteil_keep = 512;
	}
// j ist hier 104, daher 920 und nicht 1024


	Com_sprintf(entry, sizeof(entry), 
		"xv 32 yt 32 string2 \"Name \" "
        "xv 136 string2 \"->Frags->Ping->Time\" " 
		"xv 32 yt 40 string2 \"--KEEPER--------------PRISONER--\" "); 			

	j = strlen(entry); 
	if (stringlength + j < 1024) 
	{ 
		strcpy (string + stringlength, entry); 
		stringlength += j; 
	}
	

	
	for (i = 0; i < num_keep; i++)
	{
			cl = &game.clients[sorted_keep[i]];
			cl_ent = g_edicts + 1 + sorted_keep[i];
			time = (level.framenum - cl->resp.enterframe) / 600;
			if(time > 99)
				time = 99;
			y = 48 + 8 * i; 
			if (cl_ent == ent || cl_ent == killer) //wenn selbst oder killer andere farbe
			{
					Com_sprintf(entry, sizeof(entry), 
						"xv 0 yt %i string \"%s\" " 
						"xv 80 string \"%3i %3i %2i\" ", 
						y, cl->pers.netname, 
						cl->resp.score, 
						cl->ping, 
						time); 
			}
			else 
			{
					Com_sprintf(entry, sizeof(entry), 
						"xv 0 yt %i string2 \"%s\" " 
						"xv 80 string \"%3i %3i %2i\" ", 
						y, cl->pers.netname, 
						cl->resp.score, 
						cl->ping, 
						time); 
			}

			j = strlen(entry); 
			if (stringlength + j > anteil_keep) 
	               break; 
					
			strcpy (string + stringlength, entry); 
	        stringlength += j; 	
	}
// Ende Keeper - Beginn Prisoner

	for (i = 0; i < num_pris; i++)
	{
			cl = &game.clients[sorted_pris[i]];
			cl_ent = g_edicts + 1 + sorted_pris[i];
			time = (level.framenum - cl->resp.enterframe) / 600;
			if(time > 99)
				time=99;

			y = 48 + 8 * i; 
			if (cl_ent == ent || cl_ent == killer) //s.o.
			{
					Com_sprintf(entry, sizeof(entry), 
						"xv 160 yt %i string \"%s\" " 
						"xv 240 string \"%3i %3i %2i\" ", 
						y, cl->pers.netname, 
						cl->resp.score, 
						cl->ping, 
						time);	
			}
			else
			{
					Com_sprintf(entry, sizeof(entry), 
						"xv 160 yt %i string2 \"%s\" " 
						"xv 240 string \"%3i %3i %2i\" ", 
						y, cl->pers.netname, 
						cl->resp.score, 
						cl->ping, 
						time);	
			}

			j = strlen(entry); 
			if (stringlength + j > 1024) 
				break; 
			strcpy (string + stringlength, entry); 
			stringlength += j; 	
		}


	
	gi.WriteByte (svc_layout);
	gi.WriteString (string);


}


/*
==================
DeathmatchScoreboard

Draw instead of help message.
Note that it isn't that hard to overflow the 1400 byte message limit!
==================
*/
void DeathmatchScoreboard (edict_t *ent)
{
	DeathmatchScoreboardMessage (ent, ent->enemy);
	gi.unicast (ent, true);
}


/*
==================
Cmd_Score_f

Display the scoreboard
==================
*/
void Cmd_Score_f (edict_t *ent)
{
	ent->client->showinventory = false;
	ent->client->showhelp = false;
//TIMM
	if (ent->client->menu)
		return;
//TIMM

	if (!deathmatch->value && !coop->value)
		return;

	if (ent->client->showscores)
	{
		ent->client->showscores = false;
		return;
	}

	ent->client->showscores = true;
	DeathmatchScoreboard (ent);
}


/*
==================
HelpComputer

Draw help computer.
==================
*/
void HelpComputer (edict_t *ent)
{
	char	string[1024];
	char	*sk;

	if (skill->value == 0)
		sk = "easy";
	else if (skill->value == 1)
		sk = "medium";
	else if (skill->value == 2)
		sk = "hard";
	else
		sk = "hard+";

	// send the layout
	Com_sprintf (string, sizeof(string),
		"xv 32 yv 8 picn help "			// background
		"xv 202 yv 12 string2 \"%s\" "		// skill
		"xv 0 yv 24 cstring2 \"%s\" "		// level name
		"xv 0 yv 54 cstring2 \"%s\" "		// help 1
		"xv 0 yv 110 cstring2 \"%s\" "		// help 2
		"xv 50 yv 164 string2 \" kills     goals    secrets\" "
		"xv 50 yv 172 string2 \"%3i/%3i     %i/%i       %i/%i\" ", 
		sk,
		level.level_name,
		game.helpmessage1,
		game.helpmessage2,
		level.killed_monsters, level.total_monsters, 
		level.found_goals, level.total_goals,
		level.found_secrets, level.total_secrets);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
	gi.unicast (ent, true);
}


/*
==================
Cmd_Help_f

Display the current help message
==================
*/
void Cmd_Help_f (edict_t *ent)
{
	// this is for backwards compatability
	if (deathmatch->value)
	{
		Cmd_Score_f (ent);
		return;
	}

	ent->client->showinventory = false;
	ent->client->showscores = false;

	if (ent->client->showhelp && (ent->client->pers.game_helpchanged == game.helpchanged))
	{
		ent->client->showhelp = false;
		return;
	}

	ent->client->showhelp = true;
	ent->client->pers.helpchanged = 0;
	HelpComputer (ent);
}


//=======================================================================

/*
===============
G_SetStats
===============
*/
void G_SetStats (edict_t *ent)
{
	gitem_t		*item;
	int			index, cells;
	int			power_armor_type;
//TIMM

	int			lefttime;
	if(ent->client->resp.outbr_team != OUTBR_NOTEAM)
	{
		lefttime = ent->client->resp.lefttime - level.time;
	}

	ent->client->ps.stats[STAT_OUTBR_CRH] = gi.imageindex("none");
	OUTBRSetCrosshair(ent);
//TIMM
	//
	// health
	//
	ent->client->ps.stats[STAT_HEALTH_ICON] = level.pic_health;
	ent->client->ps.stats[STAT_HEALTH] = ent->health;

//TIMM
	ent->client->ps.stats[STAT_OUTBR_ICO_PR] = gi.imageindex("o_prisoner");
	if((int)(outbreak_mode->value) == OUTBR_MODE_CTF)
	{
		ent->client->ps.stats[STAT_OUTBR_TF_PR] = level.outbr_captures;
	}
	else
	{
		ent->client->ps.stats[STAT_OUTBR_TF_PR] = level.totalfragsprisoners;
	}
	ent->client->ps.stats[STAT_OUTBR_ICO_KE] = gi.imageindex("o_keeper");
	if((int)(outbreak_mode->value) == OUTBR_MODE_CTF)
	{
		ent->client->ps.stats[STAT_OUTBR_TF_KE] = level.outbr_returns;
	}
	else
	{
		ent->client->ps.stats[STAT_OUTBR_TF_KE] = level.totalfragskeepers;
	}
	ent->client->ps.stats[STAT_OUTBR_TIME_MIN]=(int)(outbreaktime)/60;
	ent->client->ps.stats[STAT_OUTBR_TIME_SEC_1] = ((int)(outbreaktime)/10)%6;
	ent->client->ps.stats[STAT_OUTBR_TIME_SEC_2] = (int)(outbreaktime)%10;
	ent->client->ps.stats[STAT_OUTBR_TIME_DP]=gi.imageindex("num_minus");

//TIMM
		if((ent->client->resp.outbr_team == OUTBR_KEEPERS)
			&& (ent->client->resp.lefttime)
			&& !(level.intermissiontime)
			&& (ent->deadflag != DEAD_DEAD))
		{
			ent->client->ps.stats[STAT_OUTBR_KEEP_MIN]= (int)((lefttime)/60);
			ent->client->ps.stats[STAT_OUTBR_KEEP_SEC_1] = ((int)((lefttime)/10))%6;
			ent->client->ps.stats[STAT_OUTBR_KEEP_SEC_2] = ((int)(lefttime))%10;
		}
		else if((ent->client->resp.outbr_team == OUTBR_PRISONERS)
			&& (ent->client->resp.lefttime)
			&& !(level.intermissiontime)
			&& (ent->deadflag != DEAD_DEAD))
		{
			ent->client->ps.stats[STAT_OUTBR_KEEP_MIN]= (int)((lefttime)/60);
			ent->client->ps.stats[STAT_OUTBR_KEEP_SEC_1] = ((int)((lefttime)/10))%6;
			ent->client->ps.stats[STAT_OUTBR_KEEP_SEC_2] = ((int)(lefttime))%10;
		}
		else
		{
			ent->client->ps.stats[STAT_OUTBR_KEEP_MIN]= 0;
			ent->client->ps.stats[STAT_OUTBR_KEEP_SEC_1] = 0;
			ent->client->ps.stats[STAT_OUTBR_KEEP_SEC_2] = 0;
		}

	//
	// ammo
	//
	if (!ent->client->ammo_index /* || !ent->client->pers.inventory[ent->client->ammo_index] */)
	{
		ent->client->ps.stats[STAT_AMMO_ICON] = 0;
		ent->client->ps.stats[STAT_AMMO] = 0;
	}
	else
	{
		item = &itemlist[ent->client->ammo_index];
		ent->client->ps.stats[STAT_AMMO_ICON] = gi.imageindex (item->icon);
		ent->client->ps.stats[STAT_AMMO] = ent->client->pers.inventory[ent->client->ammo_index];
	}
	
	//
	// armor
	//
	power_armor_type = PowerArmorType (ent);
	if (power_armor_type)
	{
		cells = ent->client->pers.inventory[ITEM_INDEX(FindItem ("cells"))];
		if (cells == 0)
		{	// ran out of cells for power armor
			ent->flags &= ~FL_POWER_ARMOR;
			gi.sound(ent, CHAN_ITEM, gi.soundindex("misc/power2.wav"), 1, ATTN_NORM, 0);
			power_armor_type = 0;;
		}
	}

	index = ArmorIndex (ent);
	if (power_armor_type && (!index || (level.framenum & 8) ) )
	{	// flash between power armor and other armor icon
		ent->client->ps.stats[STAT_ARMOR_ICON] = gi.imageindex ("i_powershield");
		ent->client->ps.stats[STAT_ARMOR] = cells;
	}
	else if (index)
	{
		item = GetItemByIndex (index);
		ent->client->ps.stats[STAT_ARMOR_ICON] = gi.imageindex (item->icon);
		ent->client->ps.stats[STAT_ARMOR] = ent->client->pers.inventory[index];
	}
	else
	{
		ent->client->ps.stats[STAT_ARMOR_ICON] = 0;
		ent->client->ps.stats[STAT_ARMOR] = 0;
	}

	//
	// pickup message
	//
	if (level.time > ent->client->pickup_msg_time)
	{
		ent->client->ps.stats[STAT_PICKUP_ICON] = 0;
		ent->client->ps.stats[STAT_PICKUP_STRING] = 0;
	}

	//
	// timers
	//
	if (ent->client->quad_framenum > level.framenum)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_quad");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->quad_framenum - level.framenum)/10;
	}
	else if (ent->client->invincible_framenum > level.framenum)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_invulnerability");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->invincible_framenum - level.framenum)/10;
	}
	else if (ent->client->enviro_framenum > level.framenum)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_envirosuit");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->enviro_framenum - level.framenum)/10;
	}
	else if (ent->client->breather_framenum > level.framenum)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_rebreather");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->breather_framenum - level.framenum)/10;
	}
	else
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = 0;
		ent->client->ps.stats[STAT_TIMER] = 0;
	}

	//
	// selected item
	//
	if (ent->client->pers.selected_item == -1)
		ent->client->ps.stats[STAT_SELECTED_ICON] = 0;
	else
		ent->client->ps.stats[STAT_SELECTED_ICON] = gi.imageindex (itemlist[ent->client->pers.selected_item].icon);

	ent->client->ps.stats[STAT_SELECTED_ITEM] = ent->client->pers.selected_item;

	//
	// layouts
	//
	ent->client->ps.stats[STAT_LAYOUTS] = 0;

	if (deathmatch->value)
	{
		if (ent->client->pers.health <= 0 || level.intermissiontime
			|| ent->client->showscores)
			ent->client->ps.stats[STAT_LAYOUTS] |= 1;
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2;
	}
	else
	{
		if (ent->client->showscores || ent->client->showhelp)
			ent->client->ps.stats[STAT_LAYOUTS] |= 1;
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2;
	}

	//
	// frags
	//
	ent->client->ps.stats[STAT_FRAGS] = ent->client->resp.score;

	//
	// help icon / current weapon if not shown
	//
	if (ent->client->pers.helpchanged && (level.framenum&8) )
		ent->client->ps.stats[STAT_HELPICON] = gi.imageindex ("i_help");
	else if ( (ent->client->pers.hand == CENTER_HANDED || ent->client->ps.fov > 91)
		&& ent->client->pers.weapon)
		ent->client->ps.stats[STAT_HELPICON] = gi.imageindex (ent->client->pers.weapon->icon);
	else
		ent->client->ps.stats[STAT_HELPICON] = 0;

	ent->client->ps.stats[STAT_SPECTATOR] = 0;
}

/*
===============
G_CheckChaseStats
===============
*/
void G_CheckChaseStats (edict_t *ent)
{
	int i;
	gclient_t *cl;

	for (i = 1; i <= maxclients->value; i++) {
		cl = g_edicts[i].client;
		if (!g_edicts[i].inuse || cl->chase_target != ent)
			continue;
		memcpy(cl->ps.stats, ent->client->ps.stats, sizeof(cl->ps.stats));
		G_SetSpectatorStats(g_edicts + i);
	}
}

/*
===============
G_SetSpectatorStats
===============
*/
void G_SetSpectatorStats (edict_t *ent)
{
	gclient_t *cl = ent->client;

	if (!cl->chase_target)
		G_SetStats (ent);

	cl->ps.stats[STAT_SPECTATOR] = 1;

	// layouts are independant in spectator
	cl->ps.stats[STAT_LAYOUTS] = 0;
	if (cl->pers.health <= 0 || level.intermissiontime || cl->showscores)
		cl->ps.stats[STAT_LAYOUTS] |= 1;
	if (cl->showinventory && cl->pers.health > 0)
		cl->ps.stats[STAT_LAYOUTS] |= 2;

	if (cl->chase_target && cl->chase_target->inuse)
		cl->ps.stats[STAT_CHASE] = CS_PLAYERSKINS + 
			(cl->chase_target - g_edicts) - 1;
	else
		cl->ps.stats[STAT_CHASE] = 0;
}

