#include "g_local.h"

void OUTBR_TurrRocket(vec3_t org);
void OUTBR_TurrMach(vec3_t org);
void OUTBRTurretRocket_Think(edict_t *self);
void OUTBRTurretMach_Think(edict_t *self);

void OUTBR_TestTurrRocket(edict_t *ent)
{
	FILE *ent_file;
	char entry[270];
	int	type = 1;

	Com_sprintf(entry, sizeof(entry), 
	"outbreak\\ob5\\%s.ob5",
	level.mapname
	);	
	
	if (ent_file = fopen(entry, "a"))
	{
		fwrite(&type, sizeof( int ), 1, ent_file);
		fwrite(ent->s.origin, sizeof( float ), 3, ent_file);
		//		fprintf(ent_file, "%i %f %f %f ", 1, ent->s.origin[0], ent->s.origin[1], ent->s.origin[2]);
		fclose(ent_file);
	}

}


void OUTBR_TestTurrMach(edict_t *ent)
{
	FILE *ent_file;
	char entry[270];
	int type = 2;

	Com_sprintf(entry, sizeof(entry), 
	"outbreak\\ob5\\%s.ob5",
	level.mapname
	);		
	
	if (ent_file = fopen(entry, "a"))
	{
//		fprintf(ent_file, "%i %f %f %f ", 2, ent->s.origin[0], ent->s.origin[1], ent->s.origin[2]);
		fwrite(&type, sizeof( int ), 1, ent_file);
		fwrite(ent->s.origin, sizeof( float ), 3, ent_file);
	
		fclose(ent_file);
	}
}


void outbreak_recover (edict_t *self)
{
	switch(self->count)
	{
	case 0:
		self->think = OUTBRTurretRocket_Think;
		break;
	case 1:
		self->think = OUTBRTurretMach_Think;
		break;
	}
	self->health = self->max_health;
	self->nextthink = level.time + FRAMETIME;
	self->deadflag = DEAD_NO;
	self->takedamage = DAMAGE_AIM;
	self->s.sound = gi.soundindex("world/electro.wav");
	self->s.effects &= ~EF_COLOR_SHELL;
	self->s.renderfx &= ~(RF_SHELL_RED|RF_SHELL_GREEN|RF_SHELL_BLUE);
	gi.sound (self, CHAN_AUTO, gi.soundindex("world/fusein.wav"), 1, ATTN_NORM, 0);

}

void outbreak_turret_pain (edict_t *self, edict_t *other, float kick, int damage)
{
	if(other == self)
		return;

	if(other != self->owner->enemy || !self->owner->enemy)
	{
		if(self->owner->enemy)
		{
			if(other->health < self->owner->enemy->health)
				self->owner->enemy = other;
		}
		else
			self->owner->enemy = other;
	}
}

void outbreak_turret_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{

	self->deadflag = DEAD_DEAD;
	VectorClear(self->avelocity);
	self->think = outbreak_recover;
	self->nextthink = level.time + 30.0;
	self->takedamage = DAMAGE_NO;
	self->s.sound = 0;
	self->s.effects |= EF_COLOR_SHELL;
	self->s.renderfx |= (RF_SHELL_RED|RF_SHELL_GREEN|RF_SHELL_BLUE);

	gi.sound (self, CHAN_AUTO, gi.soundindex("world/fuseout.wav"), 1, ATTN_NORM, 0);
}



void MakeEnt(int type, vec3_t org)
{
	edict_t *outbreakflag;

	if(type == 1)
	{
		OUTBR_TurrRocket(org);
	}
	else if(type == 2)
	{
		OUTBR_TurrMach(org);
	}
	else if(!type)
	{
		outbreakflag = G_Spawn();
		outbreakflag->classname = "item_flag_outbreak";
		outbreakflag->s.origin[0] = org[0];
		outbreakflag->s.origin[1] = org[1];
		outbreakflag->s.origin[2] = org[2];
		ED_CallSpawn (outbreakflag);
		OUTBRFlagSetup(outbreakflag);
		outbr_flag = FindItemByClassname("item_flag_outbreak");

	}
	else
		gi.dprintf("Outbreak:Unknown type: %i", type);
}


void AnglesNormalize(vec3_t vec)
{
	while(vec[0] > 360)
		vec[0] -= 360;
	while(vec[0] < 0)
		vec[0] += 360;
	while(vec[1] > 360)
		vec[1] -= 360;
	while(vec[1] < 0)
		vec[1] += 360;
}

void OUTBRViewTarget(edict_t *self, pmenu_t *pm);

void OUTBRTurretRocket_Think (edict_t *self)
{
	edict_t	*ent;
	vec3_t	current_angles;
	vec3_t	delta;
	vec3_t	f, r, u;
	vec3_t	start;
	vec3_t	temp1;
	int		damage;
	int		speed;


	if(self->deadflag != DEAD_NO || (level.intermissiontime))
	{
		VectorClear(self->avelocity);
		return;
	}

	VectorCopy (self->s.angles, current_angles);
	AnglesNormalize(current_angles);

	if(self->monsterinfo.aiflags == AI_NOSTEP && (VectorCompare(current_angles, self->move_angles)))
	{
		self->move_angles[0] = 0;
		self->move_angles[1] = current_angles[1] - 12.25;
	}

	AnglesNormalize(self->move_angles);
	if (self->move_angles[PITCH] > 180)
		self->move_angles[PITCH] -= 360;

	// clamp angles to mins & maxs
	if (self->move_angles[PITCH] > self->pos1[PITCH])
		self->move_angles[PITCH] = self->pos1[PITCH];
	else if (self->move_angles[PITCH] < self->pos2[PITCH])
		self->move_angles[PITCH] = self->pos2[PITCH];

	if ((self->move_angles[YAW] < self->pos1[YAW]) || (self->move_angles[YAW] > self->pos2[YAW]))
	{
		float	dmin, dmax;

		dmin = fabs(self->pos1[YAW] - self->move_angles[YAW]);
		if (dmin < -180)
			dmin += 360;
		else if (dmin > 180)
			dmin -= 360;
		dmax = fabs(self->pos2[YAW] - self->move_angles[YAW]);
		if (dmax < -180)
			dmax += 360;
		else if (dmax > 180)
			dmax -= 360;
		if (fabs(dmin) < fabs(dmax))
			self->move_angles[YAW] = self->pos1[YAW];
		else
			self->move_angles[YAW] = self->pos2[YAW];
	}

	VectorSubtract (self->move_angles, current_angles, delta);
	if (delta[0] < -180)
		delta[0] += 360;
	else if (delta[0] > 180)
		delta[0] -= 360;
	if (delta[1] < -180)
		delta[1] += 360;
	else if (delta[1] > 180)
		delta[1] -= 360;
	delta[2] = 0;

	if (delta[0] > self->speed * FRAMETIME)
		delta[0] = self->speed * FRAMETIME;
	if (delta[0] < -1 * self->speed * FRAMETIME)
		delta[0] = -1 * self->speed * FRAMETIME;
	if (delta[1] > self->speed * FRAMETIME)
		delta[1] = self->speed * FRAMETIME;
	if (delta[1] < -1 * self->speed * FRAMETIME)
		delta[1] = -1 * self->speed * FRAMETIME;

	VectorScale (delta, 1.0/FRAMETIME, self->avelocity);

	self->nextthink = level.time + FRAMETIME;


	// if we have adriver, adjust his velocities

		if (self->spawnflags & 65536)
		{

			VectorCopy (self->s.origin, temp1);
			AngleVectors (self->s.angles, f, r, u);
			temp1[2] -= 16;
			VectorMA (temp1, self->move_origin[0], f, start);
			VectorMA (start, self->move_origin[1], r, start);
			VectorMA (start, self->move_origin[2], u, start);

			damage = 100 + random() * 50;
			speed = 800 + 200 * skill->value;
			fire_rocket (self, start, f, damage, speed, 120 + 20 * (int)(skill->value), damage);
			gi.positioned_sound (start, self, CHAN_WEAPON, gi.soundindex("weapons/rocklf1a.wav"), 1, ATTN_NORM, 0);
			self->spawnflags &= ~65536;
		}

}

void OUTBRTurretRocket_Start (edict_t *self)
{

	
	self->s.modelindex = gi.modelindex ("models/turrets/r_turr.md2");
	self->count = 0;
	self->speed = 600;
	self->pos1[PITCH] = 80;
	self->pos1[YAW]   = 0;
	self->pos2[PITCH] = -65;
	self->pos2[YAW]   = 360;
	self->move_angles[0] = 0;
	self->move_angles[1] = self->s.angles[2] - 6.125;
	self->monsterinfo.aiflags = AI_NOSTEP;
	self->think = OUTBRTurretRocket_Think;
	self->nextthink = level.time + FRAMETIME;
	self->deadflag = DEAD_NO;
	self->takedamage = DAMAGE_AIM;
	self->health = 250;
	self->max_health = self->health;
	self->die = outbreak_turret_die;
	self->pain = outbreak_turret_pain;
	self->svflags |= SVF_MONSTER;
	self->s.sound = gi.soundindex ("world/electro.wav");



	gi.linkentity(self);
}


void OUTBRTurretRocket_ControlThink(edict_t *self)
{
	vec3_t	target;
	vec3_t	dir;
	float	reaction_time;


	edict_t	*ignore;
	vec3_t	start;
	vec3_t	end;
	trace_t	tr;
	vec3_t	point;
	vec3_t	last_movedir;
	int		count;

	if(level.intermissiontime)
		return;

	self->nextthink = level.time + FRAMETIME;

	if (self->spawnflags & 0x80000000)
		count = 8;
	else
		count = 4;

	ignore = self;
	VectorCopy (self->s.origin, start);
	VectorMA (start, 2048, self->movedir, end);
	while(1)
	{
		tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);
		tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);
//TIMM ?

		if (!tr.ent)
			break;

		// hurt it if we can
		if ((tr.ent->takedamage) && !(tr.ent->flags & FL_IMMUNE_LASER))
			T_Damage (tr.ent, self, self->activator, self->movedir, tr.endpos, vec3_origin, self->dmg, 1, DAMAGE_ENERGY, MOD_TARGET_LASER);

		// if we hit something that's not a monster or player or is immune to lasers, we're done
		if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
		{
			if (self->spawnflags & 0x80000000)
			{
				self->spawnflags &= ~0x80000000;
				gi.WriteByte (svc_temp_entity);
				gi.WriteByte (TE_LASER_SPARKS);
				gi.WriteByte (count);
				gi.WritePosition (tr.endpos);
				gi.WriteDir (tr.plane.normal);
				gi.WriteByte (self->s.skinnum);
				gi.multicast (tr.endpos, MULTICAST_PVS);
			}
			break;
		}

		ignore = tr.ent;
		VectorCopy (tr.endpos, start);
	}

	VectorCopy (tr.endpos, self->s.old_origin);

	if(self->owner->deadflag != DEAD_NO)
		return;

	if (self->enemy && (!self->enemy->inuse || self->enemy->health <= 0 || self->enemy->deadflag != DEAD_NO))
		self->enemy = NULL;

	if (!self->enemy)
	{
		if (level.sight_client == NULL)
		{
			self->owner->monsterinfo.aiflags = AI_NOSTEP;
			return;
		}
		else
			self->enemy = level.sight_client;
		if(!visible(self->owner, self->enemy) || !infront(self->owner, self->enemy) || self->enemy->count == OUTBR_CHAN_SKIN)
		{
			self->enemy = NULL;
			self->owner->monsterinfo.aiflags = AI_NOSTEP;
			return;
		}
		self->monsterinfo.attack_finished = level.time + 1.7;
		gi.sound (self, CHAN_AUTO, gi.soundindex("world/klaxon2.wav"), 1, ATTN_NONE, 0);

	}

	if (!visible (self->owner, self->enemy))
	{
		self->enemy = NULL;
		self->owner->monsterinfo.aiflags = AI_NOSTEP;
		return;
	}
	self->owner->monsterinfo.aiflags = 0;
	// let the turret know where we want it to aim
	
	VectorCopy (self->enemy->s.origin, target);
	VectorSubtract (target, self->owner->s.origin, dir);
	vectoangles (dir, self->owner->move_angles);

	// decide if we should shoot
	if (level.time < self->monsterinfo.attack_finished)
		return;

	reaction_time = 1.0;

	if(!self->count)
	{
		self->count = 25;
		gi.sound (self, CHAN_AUTO, gi.soundindex("world/x_light.wav"), 1, ATTN_NORM, 0);
		self->monsterinfo.attack_finished = level.time + 1.0;
		return;
	}


	self->count--;
	//FIXME how do we really want to pass this along?
	self->owner->spawnflags |= 65536;
	if(!self->count)
	{
		self->monsterinfo.attack_finished = level.time + 15.0;
	}
	else
	{
		self->monsterinfo.attack_finished = level.time + reaction_time + 0.3;
	}

}

void OUTBRTurretRocket_ControlStart(edict_t *self)
{
	self->nextthink = level.time + FRAMETIME;
	self->think = OUTBRTurretRocket_ControlThink;

	self->movetype = MOVETYPE_NONE;
	self->solid = SOLID_NOT;
	self->s.renderfx |= RF_BEAM|RF_TRANSLUCENT;
	self->s.modelindex = 1;			// must be non-zero

	self->s.frame = 4;

	self->s.skinnum = 0xf2f2f0f0;
	self->movedir[2] = 1;
	self->count = 25;
	self->dmg = 100;
	target_laser_on(self);

	VectorSet (self->mins, -8, -8, -8);
	VectorSet (self->maxs, 8, 8, 8);
	gi.linkentity (self);


}

void OUTBR_TurrRocket(vec3_t org)
{
	edict_t *turr, *contr;
	
	if((int)(outbreak_weapons) == 0)
		return;

	
	turr = G_Spawn();
	turr->solid = SOLID_BBOX;
	turr->movetype = MOVETYPE_PUSH;
	turr->classname = "outbreak_turret";
	VectorSet (turr->mins, -11, -13, -34);
	VectorSet (turr->maxs, 33, 14, 4);

	turr->s.origin[0] = org[0];
	turr->s.origin[1] = org[1];
	turr->s.origin[2] = org[2];

	turr->s.frame = 0;
	turr->think = OUTBRTurretRocket_Start;
	turr->nextthink = level.time + 0.3;

//	turr->enemy = ent;
	contr = G_Spawn();
	contr->owner = turr;
	contr->classname = "turret_outbreak_rock_control";
	contr->think = OUTBRTurretRocket_ControlStart;
	contr->nextthink = level.time + 0.5;
	contr->s.origin[0] = turr->s.origin[0];
	contr->s.origin[2] = turr->s.origin[2];
	contr->s.origin[1] = turr->s.origin[1];
	turr->owner = contr;

	
}


void OUTBRTurretMach_Think (edict_t *self)
{
	edict_t	*ent;
	vec3_t	current_angles;
	vec3_t	delta;
	vec3_t	f, r, u;
	vec3_t	start;
	vec3_t	temp1;
	int		damage;
	int		speed;

	if(self->deadflag != DEAD_NO || (level.intermissiontime))
	{
		VectorClear(self->avelocity);
		return;
	}

	VectorCopy (self->s.angles, current_angles);
	AnglesNormalize(current_angles);

	if(self->monsterinfo.aiflags == AI_NOSTEP && (VectorCompare(current_angles, self->move_angles)))
	{
		self->move_angles[0] = 0;
		self->move_angles[1] = current_angles[1] + 12.25;
	}

	AnglesNormalize(self->move_angles);
	if (self->move_angles[PITCH] > 180)
		self->move_angles[PITCH] -= 360;

	// clamp angles to mins & maxs
	if (self->move_angles[PITCH] > self->pos1[PITCH])
		self->move_angles[PITCH] = self->pos1[PITCH];
	else if (self->move_angles[PITCH] < self->pos2[PITCH])
		self->move_angles[PITCH] = self->pos2[PITCH];

	if ((self->move_angles[YAW] < self->pos1[YAW]) || (self->move_angles[YAW] > self->pos2[YAW]))
	{
		float	dmin, dmax;

		dmin = fabs(self->pos1[YAW] - self->move_angles[YAW]);
		if (dmin < -180)
			dmin += 360;
		else if (dmin > 180)
			dmin -= 360;
		dmax = fabs(self->pos2[YAW] - self->move_angles[YAW]);
		if (dmax < -180)
			dmax += 360;
		else if (dmax > 180)
			dmax -= 360;
		if (fabs(dmin) < fabs(dmax))
			self->move_angles[YAW] = self->pos1[YAW];
		else
			self->move_angles[YAW] = self->pos2[YAW];
	}

	VectorSubtract (self->move_angles, current_angles, delta);
	if (delta[0] < -180)
		delta[0] += 360;
	else if (delta[0] > 180)
		delta[0] -= 360;
	if (delta[1] < -180)
		delta[1] += 360;
	else if (delta[1] > 180)
		delta[1] -= 360;
	delta[2] = 0;

	if (delta[0] > self->speed * FRAMETIME)
		delta[0] = self->speed * FRAMETIME;
	if (delta[0] < -1 * self->speed * FRAMETIME)
		delta[0] = -1 * self->speed * FRAMETIME;
	if (delta[1] > self->speed * FRAMETIME)
		delta[1] = self->speed * FRAMETIME;
	if (delta[1] < -1 * self->speed * FRAMETIME)
		delta[1] = -1 * self->speed * FRAMETIME;

	VectorScale (delta, 1.0/FRAMETIME, self->avelocity);

	self->nextthink = level.time + FRAMETIME;


	// if we have adriver, adjust his velocities

		if (self->spawnflags & 65536)
		{

			VectorCopy (self->s.origin, temp1);
			AngleVectors (self->s.angles, f, r, u);
			temp1[2] -= 16;
			VectorMA (temp1, self->move_origin[0], f, start);
			VectorMA (start, self->move_origin[1], r, start);
			VectorMA (start, self->move_origin[2], u, start);

			fire_bullet (self, start, f, 12, 1, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_MACHINEGUN);
			gi.positioned_sound (start, self, CHAN_WEAPON, gi.soundindex("weapons/machgf1b.wav"), 1, ATTN_NORM, 0);

			gi.WriteByte (svc_muzzleflash);
			gi.WriteShort (self-g_edicts);
			gi.WriteByte (MZ_MACHINEGUN);
			gi.multicast (self->s.origin, MULTICAST_PVS);

			self->spawnflags &= ~65536;
		}

}

void OUTBRTurretMach_Start (edict_t *self)
{

	
	self->s.modelindex = gi.modelindex ("models/turrets/l_turr.md2");
	self->count = 1;
	self->speed = 600;
	self->pos1[PITCH] = 80;
	self->pos1[YAW]   = 0;
	self->pos2[PITCH] = -65;
	self->pos2[YAW]   = 360;
	self->move_angles[0] = 0;
	self->s.sound = gi.soundindex ("world/electro.wav");
	self->move_angles[1] = self->s.angles[2] + 6.125;
	self->monsterinfo.aiflags = AI_NOSTEP;
	self->think = OUTBRTurretMach_Think;
	self->nextthink = level.time + FRAMETIME;
	self->deadflag = DEAD_NO;
	self->takedamage = DAMAGE_AIM;
	self->health = 250;
	self->max_health = self->health;
	self->die = outbreak_turret_die;
	self->pain = outbreak_turret_pain;
	self->svflags |= SVF_MONSTER;

	gi.linkentity(self);
}


void OUTBRTurretMach_ControlThink(edict_t *self)
{
	vec3_t	target;
	vec3_t	dir;
	float	reaction_time;


	edict_t	*ignore;
	vec3_t	start;
	vec3_t	end;
	trace_t	tr;
	vec3_t	point;
	vec3_t	last_movedir;
	int		count;

	if(level.intermissiontime)
		return;
	
	self->nextthink = level.time + FRAMETIME;

	
	if (self->spawnflags & 0x80000000)
		count = 8;
	else
		count = 4;

	ignore = self;
	VectorCopy (self->s.origin, start);
	VectorMA (start, 2048, self->movedir, end);
	while(1)
	{
		tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);
		tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);
//TIMM ?

		if (!tr.ent)
			break;

		// hurt it if we can
		if ((tr.ent->takedamage) && !(tr.ent->flags & FL_IMMUNE_LASER))
			T_Damage (tr.ent, self, self->activator, self->movedir, tr.endpos, vec3_origin, self->dmg, 1, DAMAGE_ENERGY, MOD_TARGET_LASER);

		// if we hit something that's not a monster or player or is immune to lasers, we're done
		if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
		{
			if (self->spawnflags & 0x80000000)
			{
				self->spawnflags &= ~0x80000000;
				gi.WriteByte (svc_temp_entity);
				gi.WriteByte (TE_LASER_SPARKS);
				gi.WriteByte (count);
				gi.WritePosition (tr.endpos);
				gi.WriteDir (tr.plane.normal);
				gi.WriteByte (self->s.skinnum);
				gi.multicast (tr.endpos, MULTICAST_PVS);
			}
			break;
		}

		ignore = tr.ent;
		VectorCopy (tr.endpos, start);
	}

	VectorCopy (tr.endpos, self->s.old_origin);

	if(self->owner->deadflag != DEAD_NO)
		return;


	if (self->enemy && (!self->enemy->inuse || self->enemy->health <= 0 || self->enemy->deadflag != DEAD_NO))
		self->enemy = NULL;

	if (!self->enemy)
	{
		if (level.sight_client == NULL)
		{
			self->owner->monsterinfo.aiflags = AI_NOSTEP;
			return;
		}
		else
			self->enemy = level.sight_client;
		if(!visible(self->owner, self->enemy) || !infront(self->owner, self->enemy) || self->enemy->count == OUTBR_CHAN_SKIN)
		{
			self->enemy = NULL;
			self->owner->monsterinfo.aiflags = AI_NOSTEP;
			return;
		}
		self->monsterinfo.attack_finished = level.time + 0.7;
		gi.sound (self, CHAN_AUTO, gi.soundindex("world/klaxon2.wav"), 1, ATTN_NONE, 0);
	}

	if (!visible (self->owner, self->enemy))
	{
		self->enemy = NULL;
		self->owner->monsterinfo.aiflags = AI_NOSTEP;
		return;
	}
	self->owner->monsterinfo.aiflags = 0;
	// let the turret know where we want it to aim
	
	VectorCopy (self->enemy->s.origin, target);
	VectorSubtract (target, self->owner->s.origin, dir);
	vectoangles (dir, self->owner->move_angles);

	// decide if we should shoot
	if (level.time < self->monsterinfo.attack_finished)
		return;

	if(!self->count)
	{
		self->count = 125;
		gi.sound (self, CHAN_AUTO, gi.soundindex("world/x_light.wav"), 1, ATTN_NORM, 0);
		self->monsterinfo.attack_finished = level.time + 1.0;
		return;
	}

	self->count--;
	//FIXME how do we really want to pass this along?
	self->owner->spawnflags |= 65536;
	if(!self->count)
	{
		self->monsterinfo.attack_finished = level.time + 15.0;
	}
	else
	{
		self->monsterinfo.attack_finished = level.time + 0.1;
	}

}

void OUTBRTurretMach_ControlStart(edict_t *self)
{
	self->nextthink = level.time + FRAMETIME;
	self->think = OUTBRTurretMach_ControlThink;

	self->movetype = MOVETYPE_NONE;
	self->solid = SOLID_NOT;
	self->s.renderfx |= RF_BEAM|RF_TRANSLUCENT;
	self->s.modelindex = 1;			// must be non-zero
	self->count = 125;
	self->s.frame = 4;

	self->s.skinnum = 0xf2f2f0f0;
	self->movedir[2] = 1;

	self->dmg = 100;
	target_laser_on(self);

	VectorSet (self->mins, -8, -8, -8);
	VectorSet (self->maxs, 8, 8, 8);
	gi.linkentity (self);


}

void OUTBR_TurrMach(vec3_t org)
{
	edict_t *turr, *contr;
	
	if((int)(outbreak_weapons) == 0)
		return;

	
	turr = G_Spawn();
	turr->solid = SOLID_BBOX;
	turr->movetype = MOVETYPE_PUSH;
	turr->classname = "outbreak_turret";
	VectorSet (turr->mins, -11, -13, -34);
	VectorSet (turr->maxs, 33, 14, 4);

	turr->s.origin[0] = org[0];
	turr->s.origin[1] = org[1];
	turr->s.origin[2] = org[2];

	turr->s.frame = 0;
	turr->think = OUTBRTurretMach_Start;
	turr->nextthink = level.time + 0.3;

//	turr->enemy = ent;
	contr = G_Spawn();
	contr->owner = turr;
	contr->classname = "turret_outbreak_mach_control";
	contr->think = OUTBRTurretMach_ControlStart;
	contr->nextthink = level.time + 0.5;
	contr->s.origin[0] = turr->s.origin[0];
	contr->s.origin[2] = turr->s.origin[2];
	contr->s.origin[1] = turr->s.origin[1];
	turr->owner = contr;

	
}


//NEVER Call OUTBRPutBack with a player, which isn't assigned to a team
void OUTBRPutBack(edict_t *ent, qboolean onlystart, edict_t *spot)
{
	int i;

	if(onlystart == true && level.outbreak_trigger == OUTBR_TRIGGER_OPEN)
	{
			return;
	}

	VectorClear (ent->velocity);

	// clear playerstate values
	memset (&ent->client->ps, 0, sizeof(ent->client->ps));

	ent->client->ps.pmove.origin[0] = spot->s.origin[0]*8;
	ent->client->ps.pmove.origin[1] = spot->s.origin[1]*8;
	ent->client->ps.pmove.origin[2] = spot->s.origin[2]*8;

	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		ent->client->ps.fov = 90;
	}
	else
	{
		ent->client->ps.fov = atoi(Info_ValueForKey(ent->client->pers.userinfo, "fov"));
		if (ent->client->ps.fov < 1)
			ent->client->ps.fov = 90;
		else if (ent->client->ps.fov > 160)
			ent->client->ps.fov = 160;
	}

	VectorCopy (spot->s.origin, ent->s.origin);
	ent->s.origin[2] += 1;	// make sure off ground
	VectorCopy (ent->s.origin, ent->s.old_origin);
	for (i=0 ; i<3 ; i++)
	{
		ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spot->s.angles[i] - ent->client->resp.cmd_angles[i]);
	}

	ent->s.angles[PITCH] = 0;
	ent->s.angles[YAW] = spot->s.angles[YAW];
	ent->s.angles[ROLL] = 0;
	VectorCopy (ent->s.angles, ent->client->ps.viewangles);
	VectorCopy (ent->s.angles, ent->client->v_angle);

	if (!KillBox (ent))
	{	// could't spawn in?
	}
	gi.linkentity (ent);

}

void OUTBRCTFEffects(edict_t *player)
{
	player->s.effects &= (EF_FLAG1 | EF_FLAG2);
	if (player->health > 0) {
		if (player->client->pers.inventory[ITEM_INDEX(outbr_flag)]) {
			player->s.effects |= EF_FLAG1;
		}
	}

	if (player->client->pers.inventory[ITEM_INDEX(outbr_flag)])
		player->s.modelindex3 = gi.modelindex("players/male/flag1.md2");
	else
		player->s.modelindex3 = 0;
}



void OUTBRResetFlag()
{
	edict_t *ent;


	ent = NULL;
	while ((ent = G_Find (ent, FOFS(classname), "item_flag_outbreak")) != NULL) {
		if (ent->spawnflags & DROPPED_ITEM)
			G_FreeEdict(ent);
		else {
			ent->svflags &= ~SVF_NOCLIENT;
			ent->solid = SOLID_TRIGGER;
			gi.linkentity(ent);
			ent->s.event = EV_ITEM_RESPAWN;
		}
	}
}



static void OUTBRDropFlagThink(edict_t *ent)
{
	gi.bprintf(PRINT_HIGH, "The flag has returned!\n");
	OUTBRResetFlag();
}


void OUTBRDeadDropFlag(edict_t *self)
{
	edict_t *dropped = NULL;

	if (self->client->pers.inventory[ITEM_INDEX(outbr_flag)]) {
		dropped = Drop_Item(self, outbr_flag);
		self->client->pers.inventory[ITEM_INDEX(outbr_flag)] = 0;
		gi.bprintf(PRINT_HIGH, "%s lost the flag!\n",
			self->client->pers.netname);
	}

	if (dropped) {
		dropped->think = OUTBRDropFlagThink;
		dropped->nextthink = level.time + 30.0;
		dropped->touch = Touch_Item;
	}
}



static void OUTBRFlagThink(edict_t *ent)
{
	if (ent->solid != SOLID_NOT)
		ent->s.frame = 173 + (((ent->s.frame - 173) + 1) % 16);
	ent->nextthink = level.time + FRAMETIME;
}


void OUTBRFlagSetup (edict_t *ent)
{
	trace_t		tr;
	vec3_t		dest;
	float		*v;

	v = tv(-15,-15,-15);
	VectorCopy (v, ent->mins);
	v = tv(15,15,15);
	VectorCopy (v, ent->maxs);

	if (ent->model)
		gi.setmodel (ent, ent->model);
	else
		gi.setmodel (ent, ent->item->world_model);
	ent->solid = SOLID_TRIGGER;
	ent->movetype = MOVETYPE_TOSS;  
	ent->touch = Touch_Item;

	v = tv(0,0,-128);
	VectorAdd (ent->s.origin, v, dest);

	tr = gi.trace (ent->s.origin, ent->mins, ent->maxs, dest, ent, MASK_SOLID);
	if (tr.startsolid)
	{
		gi.dprintf ("CTFFlagSetup: %s startsolid at %s\n", ent->classname, vtos(ent->s.origin));
		G_FreeEdict (ent);
		return;
	}

	VectorCopy (tr.endpos, ent->s.origin);

	gi.linkentity (ent);

	ent->nextthink = level.time + FRAMETIME;
	ent->think = OUTBRFlagThink;
}



qboolean OUTBRPickupFlag(edict_t *ent, edict_t *other)
{
	edict_t *ent2;
	int x;
	
	if (other->client->resp.outbr_team == OUTBR_KEEPERS) {

		if (ent->spawnflags & DROPPED_ITEM) {
			gi.bprintf(PRINT_HIGH, "%s returned the flag!\n", 
				other->client->pers.netname);
			other->client->resp.score += 5;
			level.outbr_returns++;
			gi.sound (ent, CHAN_RELIABLE+CHAN_NO_PHS_ADD+CHAN_VOICE, gi.soundindex("outbr/flagbck.wav"), 1, ATTN_NONE, 0);
			for (x=0 ; x<maxclients->value ; x++)
			{
				ent2 = g_edicts + 1 + x;
				if(ent2->client->resp.outbr_team == OUTBR_KEEPERS)
				{
					ent2->client->resp.score+=10;
				}
			}
			OUTBRResetFlag();
		}
			return false;
		
	}
	else if(other->client->resp.outbr_team == OUTBR_PRISONERS)
	{
		gi.bprintf(PRINT_HIGH, "%s got the flag!\n",
			other->client->pers.netname);

		other->client->pers.inventory[ITEM_INDEX(outbr_flag)] = 1;
	}
	// pick up the flag
	// if it's not a dropped flag, we just make is disappear
	// if it's dropped, it will be removed by the pickup caller
	if (!(ent->spawnflags & DROPPED_ITEM)) {
		ent->flags |= FL_RESPAWN;
		ent->svflags |= SVF_NOCLIENT;
		ent->solid = SOLID_NOT;
	}
	return true;

};



void mest(char *s)
{
	FILE *motd_file;
	if (motd_file = fopen("outbreak\\debug.txt", "a"))
	{
		fputs(s, motd_file);
		fclose(motd_file);
	}
}


void OUTBRExecuteKillpris()
{
	edict_t *body;
	int n;

	for(n=0;n<7;n++)
	{
		body = &g_edicts[(int)maxclients->value + n + 1];
		if(body->s.origin[0] != 0
		&& body->s.origin[1] != 0
		&& body->s.origin[2] != 0)
		{
			body->s.event = EV_PLAYER_TELEPORT;
			gi.unlinkentity (body);
      		body->s.modelindex = gi.modelindex ("sprites/s_flas.sp2"); 
			body->s.modelindex2 = gi.modelindex ("sprites/s_flas.sp2"); 
			//body->s.modelindex3 = gi.modelindex ("sprites/s_flas.sp2"); 
				
			body->s.frame = 0;
			body->solid = SOLID_NOT;
			gi.linkentity (body);
		}
	}
	level.body_que=0;				  
}

void OUTBRGiveCvar(edict_t *ent, char *key, int value)
{
	if(Q_stricmp(key, "crh") == 0)
	{
		if(value > 3 || value < 0)
		{
			ent->client->pers.crosshair = 0;
		}
		else
		{
			ent->client->pers.crosshair = value;
		}
		ent->client->pers.crosshairlastupdate = level.time;
	}
}




void OUTBRGiveSkin(edict_t *pris)
{
	edict_t	*keep = NULL;
	char *s;
	if(!((int)(outbreak_flags->value) & OFL_STEAL_SKIN))
		return;
	if(pris->count != OUTBR_CHAN_SKIN && pris->client->resp.outbr_team == OUTBR_PRISONERS)
	{
		while ((keep = findradius(keep, pris->s.origin, 100)) != NULL)
			
		{
			if(keep->spawnflags == OUTBR_NORM_DEAD)
			{
				if(keep->client)
				{
					s = Info_ValueForKey (keep->client->pers.userinfo, "skin");
				}
				else if(!Q_stricmp(keep->classname, "bodyque"))
				{
					s = Info_ValueForKey (keep->owner->client->pers.userinfo, "skin");
				}
				else 
				{
					continue;
				}
				pris->count = OUTBR_CHAN_SKIN;
				OUTBRAssignSkin(pris, s);
				return;
			}
		}

	}
	else
		return;
}

void OUTBRCheckSkin(edict_t *ent)
{
	edict_t	*ent2 = NULL;
	char *s;
	if(!((int)(outbreak_flags->value) & OFL_ABLE_CHECK))
		return;

	if(ent->client->resp.outbr_team == OUTBR_KEEPERS)
	{
		if(ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] < cp_cost->value)
		{
			gi.cprintf(ent, PRINT_HIGH, "Not enough cells for a check...\n");
			return;
		}

		while ((ent2 = findradius(ent2, ent->s.origin, 100)) != NULL)
		{
			if(ent2->count == OUTBR_CHAN_SKIN && (ent2->client) && ent2->client->resp.outbr_team == OUTBR_PRISONERS)
			{
				s = Info_ValueForKey (ent2->client->pers.userinfo, "skin");
				ent2->count = OUTBR_ORIG_SKIN;
				OUTBRAssignSkin(ent2, s);
				gi.cprintf(ent, PRINT_HIGH, "You've bared the prisoner - %s!\n", ent2->client->pers.netname);
				return;
			}
		}

	}
}


/*
==================================================

  Der Communicator
 - Setzen mit comset
 + setzen mit outbreakflags 
==================================================
*/


void OUTBRWriteToCommunicator(edict_t *trigger, edict_t *activator)
{
	edict_t	*messagetarg;
	messagetarg = NULL;

	while((messagetarg = G_Find(messagetarg, FOFS(classname), "player"))!=NULL)
	{
		if((messagetarg->client->resp.outbr_team == OUTBR_KEEPERS)
			&& ((int)(outbreak_flags->value) & OFL_COMMUNICATOR))
		{
			gi.cprintf(messagetarg, PRINT_CHAT, "%s(%s)\n", trigger->message, activator->client->pers.netname);
		}
	}

}

/*
==================================================

  Outbreak - ViewTarget, v1.4
	Kreisbewegung innerhalb
  Outbreak - ViewTarget, v1.5
    Fester Punkt von aussen
TIMMFIX
	intermission mit target VIEWTARGET

==================================================
*/

void OUTBRMovieTarget(edict_t *self)
{
	vec3_t		dir, dir2, dir3, dir4, dir5, dir6;
	int i;

	switch(self->health)
	{
	case 0:
		dir[0]=self->flashlight->absmax[0];
		dir[1]=self->flashlight->absmax[1];
		dir[2]=self->flashlight->absmax[2];
		dir2[0]=self->flashlight->absmin[0];
		dir2[1]=self->flashlight->absmax[1];
		dir2[2]=self->flashlight->absmin[2];
		break;
	case 1:
		dir[0]=self->flashlight->absmax[0];
		dir[1]=self->flashlight->absmin[1];
		dir[2]=self->flashlight->absmax[2];
		dir2[0]=self->flashlight->absmax[0];
		dir2[1]=self->flashlight->absmax[1];
		dir2[2]=self->flashlight->absmax[2];
		break;
	case 2:
		dir[0]=self->flashlight->absmin[0];
		dir[1]=self->flashlight->absmin[1];
		dir[2]=self->flashlight->absmax[2];
		dir2[0]=self->flashlight->absmax[0];
		dir2[1]=self->flashlight->absmin[1];
		dir2[2]=self->flashlight->absmax[2];
		break;
	case 3:
		dir[0]=self->flashlight->absmin[0];
		dir[1]=self->flashlight->absmax[1];
		dir[2]=self->flashlight->absmax[2];
		dir2[0]=self->flashlight->absmin[0];
		dir2[1]=self->flashlight->absmin[1];
		dir2[2]=self->flashlight->absmax[2];
		break;
	case 4:
		dir[0]=self->flashlight->absmax[0];
		dir[1]=self->flashlight->absmax[1];
		dir[2]=self->flashlight->absmin[2];
		dir2[0]=self->flashlight->absmin[0];
		dir2[1]=self->flashlight->absmax[1];
		dir2[2]=self->flashlight->absmax[2];
		break;
	case 5:
		dir[0]=self->flashlight->absmax[0];
		dir[1]=self->flashlight->absmin[1];
		dir[2]=self->flashlight->absmin[2];
		dir2[0]=self->flashlight->absmax[0];
		dir2[1]=self->flashlight->absmax[1];
		dir2[2]=self->flashlight->absmin[2];
		break;
	case 6:
		dir[0]=self->flashlight->absmin[0];
		dir[1]=self->flashlight->absmin[1];
		dir[2]=self->flashlight->absmin[2];
		dir2[0]=self->flashlight->absmax[0];
		dir2[1]=self->flashlight->absmin[1];
		dir2[2]=self->flashlight->absmin[2];
		break;
	case 7:
		dir[0]=self->flashlight->absmin[0];
		dir[1]=self->flashlight->absmax[1];
		dir[2]=self->flashlight->absmin[2];
		dir2[0]=self->flashlight->absmin[0];
		dir2[1]=self->flashlight->absmin[1];
		dir2[2]=self->flashlight->absmin[2];
		break;
	}
	self->powerarmor_time+=1;
	VectorSubtract(dir, dir2, dir3);
	VectorMA(dir2, (self->powerarmor_time/15), dir3, dir4);
	VectorSubtract (dir4, self->owner->s.origin, dir5);
	vectoangles(dir5, self->owner->client->ps.viewangles);
		for (i=0 ; i<3 ; i++)
		{
			self->owner->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(self->owner->client->ps.viewangles[i] - self->owner->client->resp.cmd_angles[i]);
		}
	
	VectorSubtract (self->flashlight->absmax, self->flashlight->absmin, dir6);
	VectorMA(self->flashlight->absmin, 0.5, dir6, dir5);
	if(!VectorCompare(self->owner->s.origin, dir5))
		G_FreeEdict(self);
	self->nextthink = level.time + 0.1;
	if(self->powerarmor_time==15)
	{
		self->powerarmor_time=1;
		self->health++;
		if(self->health > 7)
			G_FreeEdict(self);
	}
}

void OUTBRViewTarget(edict_t *self, pmenu_t *pm)
{
	edict_t	*spot;
	edict_t	*movie;
	vec3_t		dir, dir2, dir3;
	int i;
	spot = NULL;
	spot = G_Find (spot, FOFS(target), "OUTBREAK");
	if(spot==NULL)
	{
		gi.cprintf(self, PRINT_HIGH, "No targets found...\n");
		return;
	}
	
	movie = G_Spawn();
	movie->health = 0;
	movie->powerarmor_time = 1;
	movie->owner = self;
	movie->flashlight = spot;
	movie->think = OUTBRMovieTarget;
	movie->nextthink = level.time + 0.2;

	PMenu_Close(self);
	VectorSubtract (spot->absmax, spot->absmin, dir2);
	VectorScale(dir2, 0.5, dir3);
	VectorClear(dir2);
	VectorAdd(spot->absmin, dir3, dir2);
	gi.unlinkentity (self);

	VectorCopy (dir2, self->s.origin);
	gi.linkentity(self);

	VectorSubtract (spot->absmax, self->s.origin, dir);
	
	vectoangles(dir, self->client->ps.viewangles);
		for (i=0 ; i<3 ; i++)
		{
			self->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(self->client->ps.viewangles[i] - self->client->resp.cmd_angles[i]);
		}
//	vectoangles(dir, self->client->ps.pmove.delta_angles);

	self->client->ps.pmove.pm_flags |= PMF_NO_PREDICTION;

}

/*
==================================================

	Flashlight,
	entity self->flashlight
	eigenes Sprite mit:
	1.Frame nichts
	2.Frame Zielkreuz
==================================================
*/

void OUTBRFlashlightThink (edict_t *self)
{
	vec3_t start,end,endp,offset;
    vec3_t forward,right,up;
    trace_t tr;

    AngleVectors (self->owner->client->v_angle, forward, right, up);

    VectorSet(offset,24 , 6, self->owner->viewheight-7);
    G_ProjectSource (self->owner->s.origin, offset, forward, right, start);
	VectorMA(start,8192,forward,end);

    tr = gi.trace (start,NULL,NULL, end,self->owner,CONTENTS_SOLID|CONTENTS_MONSTER
		|CONTENTS_DEADMONSTER);

	if (tr.fraction != 1)
    {
        VectorMA(tr.endpos,-4,forward,endp);
        VectorCopy(endp,tr.endpos);
    }

    vectoangles(tr.plane.normal,self->s.angles);
    VectorCopy(tr.endpos,self->s.origin);

    gi.linkentity (self);
    self->nextthink = level.time + 0.1;
}

void OUTBRFlashlight(edict_t *self) 
{
    vec3_t  start,forward,right,end;

    if ( self->flashlight )
    {
        G_FreeEdict(self->flashlight);
        self->flashlight = NULL;
             return;
	}

    AngleVectors (self->client->v_angle, forward, right, NULL);

    VectorSet(end, 100 , 0, 0);
    G_ProjectSource (self->s.origin, end, forward, right, start);

    self->flashlight = G_Spawn ();
    self->flashlight->owner = self;
    self->flashlight->movetype = MOVETYPE_NOCLIP;
    self->flashlight->solid = SOLID_NOT;
    self->flashlight->classname = "flashlight";
    self->flashlight->s.modelindex = gi.modelindex ("sprites/s_flas.sp2"); 
    self->flashlight->s.frame = 0;
	self->flashlight->s.effects |= 0x10000000;//transparency			 self->flashlight->s.effects |= EF_HYPERBLASTER;         // Other effects can be used here, such as flag1, but these look corney and 
    self->flashlight->s.effects |= EF_HYPERBLASTER;                             // dull. Try stuff and tell me if you find anything cool
    self->flashlight->think = OUTBRFlashlightThink;
    self->flashlight->nextthink = level.time + 0.1;
}



/*
==================================================


  Aushilfsfunktionen u.a.
  Stuffcmd, ...
  Funktionen zum Schlieen/ffnen per Code,
  ohne Fehler mit func = NULL !!!
  Ausserdem, wegen Monster remove, etc.

==================================================
*/

void OUTBROpenMenu(edict_t *self)		//Aushilfs-think-funktion um das Menu nach best. Zeit zu ffnen
{
	OUTBROpenJoinMenu(self->owner);
	G_FreeEdict(self);
	return;
}

void M_CheckGround (edict_t *ent)
{
	vec3_t		point;
	trace_t		trace;

	if (ent->flags & (FL_SWIM|FL_FLY))
		return;

	if (ent->velocity[2] > 100)
	{
		ent->groundentity = NULL;
		return;
	}

// if the hull point one-quarter unit down is solid the entity is on ground
	point[0] = ent->s.origin[0];
	point[1] = ent->s.origin[1];
	point[2] = ent->s.origin[2] - 0.25;

	trace = gi.trace (ent->s.origin, ent->mins, ent->maxs, point, ent, MASK_MONSTERSOLID);

	// check steepness
	if ( trace.plane.normal[2] < 0.7 && !trace.startsolid)
	{
		ent->groundentity = NULL;
		return;
	}

//	ent->groundentity = trace.ent;
//	ent->groundentity_linkcount = trace.ent->linkcount;
//	if (!trace.startsolid && !trace.allsolid)
//		VectorCopy (trace.endpos, ent->s.origin);
	if (!trace.startsolid && !trace.allsolid)
	{
		VectorCopy (trace.endpos, ent->s.origin);
		ent->groundentity = trace.ent;
		ent->groundentity_linkcount = trace.ent->linkcount;
		ent->velocity[2] = 0;
	}
}

void OUTBRMiscExplosion(edict_t *self) // Aushilfsfunktion bei Keeper-Death, der Explosion!
{

	VectorCopy(self->owner->s.origin, self->s.origin);
	T_RadiusDamage(self, self, 130, NULL, 130, MOD_KILLBODY);
	BecomeExplosion1(self);

}

void StuffCmd(edict_t *ent, char *s)  //Standard Stuffcommand zum Senden an ent -> console
{
	gi.WriteByte (11);
	gi.WriteString (s);
	gi.unicast (ent, true);
}

float OUTBRTimeElapsed() //Time Elapsed nach Outbreak
{
	if(level.timeoutbreak)
		return (level.time - level.timeoutbreak);
	else
		return 0.0;
}

void OUTBRNullFunc(edict_t *activator)
{
	return;
}

//   ^
//	Benutzt fr OutbreakClose etc.
//   V

void OUTBRUseSelf(edict_t *activator)
{
	activator->use(activator, NULL, NULL);
}

/*
============================
*/


/*
==================================================

  Changeteam-funktion
==================================================
*/

void OUTBRChangeTeam(edict_t *ent)
{
	if(ent->client->resp.outbr_team==OUTBR_KEEPERS)
	{
		ent->client->resp.outbr_team=OUTBR_PRISONERS;
	}
	else if(ent->client->resp.outbr_team==OUTBR_PRISONERS)
	{
		ent->client->resp.outbr_team=OUTBR_KEEPERS;
	}
	else
		return;
	gi.bprintf(PRINT_HIGH, "%s changed the team\n", ent->client->pers.netname);
	OUTBRAssignSkin(ent, "");
	PutClientInServer (ent);

	ent->s.event = EV_PLAYER_TELEPORT;

	ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
	ent->client->ps.pmove.pm_time = 14;

	ent->client->respawn_time = level.time;
	ent->client->resp.score=0;
}

/*
==================================================

  Crosshairfunktionen
==================================================
*/

void OUTBRSetCrosshair(edict_t *ent)
{
	vec3_t start, forward, end;
	trace_t tr;

	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight; 
	AngleVectors(ent->client->v_angle, forward, NULL, NULL); 
	VectorMA(start, 8192, forward, end); 
	tr = gi.trace(start, NULL, NULL, end, ent,MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA); 
	if (tr.ent->client)
	{
		if(ent->client->resp.outbr_team != tr.ent->client->resp.outbr_team
			&& tr.ent->client->resp.outbr_team != OUTBR_NOTEAM)
		{
				if(ent->client->pers.crosshair == 1)
				{
					ent->client->ps.stats[STAT_OUTBR_CRH] = gi.imageindex("ch1a");
				}
				else if(ent->client->pers.crosshair == 2)
				{
					ent->client->ps.stats[STAT_OUTBR_CRH] = gi.imageindex("ch2a");
				}
				else if(ent->client->pers.crosshair == 3)
				{
					ent->client->ps.stats[STAT_OUTBR_CRH] = gi.imageindex("ch3a");
				}
		}

	}
}




/*
==================================================
OutbreakSelectCoopSpawnPoint 
Selects a Random Coop Spot
==================================================
*/
edict_t *OUTBRSelectCoopSpawnPoint (void)
{
	edict_t	*spot;
	int		count = 0;
	int		selection;

	spot = NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_coop")) != NULL)
	{
		count++;
	}

	if (!count)
	{
	
		return NULL;
	}
	selection = rand() % count;

	do
	{
		spot = G_Find (spot, FOFS(classname), "info_player_coop");
	} while(selection--);


	return spot;

}

/*
==================================================

  Startfunktionen / checkforplayers-funkt.
  Endfunktionen
==================================================
*/
void OUTBRMoveBackToPrison()
{
	int i;
	edict_t *ent;

	ent = NULL;
	while ((ent = G_Find (ent, FOFS(targetname), "OUTBREAKNEED")) != NULL)
	{
		ent->outbreakuse (ent);	
	}
	if(level.intermissiontime)
		return;

	level.outbreak_trigger = OUTBR_TRIGGER_CLOSED;
	level.timeoutbreak = 0;
	level.timelimitoutbreak = 0;

	
	ent = NULL;
	while ((ent = G_Find (ent, FOFS(classname), "player")) != NULL)
	{
		ent->client->resp.lefttime = 0;	
	}
	ent = NULL;
	while ((ent = G_Find (ent, FOFS(targetname), "OUTBREAKNEED")) != NULL)
	{
		if(!Q_stricmp(ent->classname, "func_clock"))
			ent->use (ent, NULL, NULL);	
//TIMMFIX
	}

	for (i=0 ; i<maxclients->value ; i++)
	{
		ent = g_edicts + 1 + i;
		if (!ent->inuse || !ent->client)
			continue;
		if(ent->client->resp.outbr_team == OUTBR_PRISONERS)
		{
			PutClientInServer (ent);
				// add a teleportation effect
			ent->s.event = EV_PLAYER_TELEPORT;

				// hold in place briefly
			ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
			ent->client->ps.pmove.pm_time = 200;

			ent->client->respawn_time = level.time;
		}
	}
}

void OUTBRUseEntities()
{
	edict_t	*ent = NULL;
	int	csum = 0;

	level.outbreak_trigger = OUTBR_TRIGGER_OPEN;
	level.timeoutbreak = level.time;
	if(timelimit->value)
		level.timelimitoutbreak = (level.timeoutbreak + timelimit->value * 60);
	while ((ent = G_Find (ent, FOFS(targetname), "OUTBREAKNEED")) != NULL)
	{
		ent->use (ent, NULL, NULL);	
	}
	ent = NULL;
	while ((ent = G_Find (ent, FOFS(classname), "player")) != NULL)
	{
		if((ent->client->resp.outbr_team == OUTBR_KEEPERS) && (killtime->value))
			ent->client->resp.lefttime = level.time + killtime->value;	
		else if((ent->client->resp.outbr_team == OUTBR_PRISONERS) && (survivetime->value))
			ent->client->resp.lefttime = level.time + survivetime->value;	
	}
}

qboolean OUTBRCheckConditions() //TRUE wenn erfllt
{
	int i;
	edict_t *ent;
	int pris = 0, keep = 0;
	if(outbreak_debug->value == 4096)
		return true;

	for (i=0 ; i < maxclients->value ; i++)
	{
		ent = g_edicts + 1 + i;
		if (!ent->inuse || !ent->client)
			continue;
		if(ent->client->resp.outbr_team == OUTBR_KEEPERS)
			keep = 1;
		else if(ent->client->resp.outbr_team == OUTBR_PRISONERS)
			pris = 1;
	}
	if(keep != 1 || pris != 1) 
	{
		return false;
	}
	return true;
}

void OUTBRGoBackToPrison()
{
	edict_t	*list2[8];
	edict_t	*list1[8];
	edict_t		*body;
	edict_t *spot;
	int	number=0;
	int bignumber=0;
	spot=NULL;
	while ((spot = G_Find (spot, FOFS(classname), "player")) != NULL)
	{
		if(spot->client->resp.outbr_team==OUTBR_PRISONERS)
		{
			list1[bignumber+1]=spot;
			bignumber++;
			if(bignumber>=7)
				break;
		}
	}

	spot=NULL;
	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		list2[number+1]=spot;
		number++;
		if(number>=7)
			break;
	}

	for(;bignumber;bignumber--)
	{

	// grab a body que and cycle to the next one
	body = &g_edicts[(int)maxclients->value + level.body_que + 1];
	level.body_que = (level.body_que + 1) % BODY_QUEUE_SIZE;

	// FIXME: send an effect on the removed body

	gi.unlinkentity (body);
	body->s = list1[bignumber]->s;
	body->s.number = body - g_edicts;

	body->svflags = list1[bignumber]->svflags;
	VectorCopy (list1[bignumber]->mins, body->mins);
	VectorCopy (list1[bignumber]->maxs, body->maxs);
	VectorCopy (list1[bignumber]->absmin, body->absmin);
	VectorCopy (list1[bignumber]->absmax, body->absmax);
	VectorCopy (list1[bignumber]->size, body->size);
	body->solid = list1[bignumber]->solid;
	body->clipmask = list1[bignumber]->clipmask;
	body->owner = list1[bignumber]->owner;
	
//TIMM
	body->movetype = MOVETYPE_TOSS;

	if(number)
	{
		VectorCopy(list2[bignumber]->s.origin, body->s.origin);
		body->s.origin[2]+=10;
		body->s.event = EV_PLAYER_TELEPORT;
	}
	else
		break;

	number--;

	gi.linkentity (body);
	
	}

}



/*
==================================================

  Win-Funktionen

==================================================
*/

void OUTBRPrisonersWin()
{
	int sec, min;
	
	sec = (int)(OUTBRTimeElapsed())%60;
	min = (int)(OUTBRTimeElapsed())/60;

	if((int)(outbreak_mode->value) == OUTBR_MODE_TEAM)
	{	
		if(sec > 9)
			gi.bprintf(PRINT_CHAT, "Prisoners win! (%i:%2i)\n", min, sec);
		else
			gi.bprintf(PRINT_CHAT, "Prisoners win! (%i:0%i)\n", min, sec);
	}
	else if((int)(outbreak_mode->value) == OUTBR_MODE_SINGLE)
	{
			if(sec > 9)
				gi.bprintf(PRINT_CHAT, "%s wins! (%i:%2i)\n", win_ent->client->pers.netname, min, sec);		
			else
				gi.bprintf(PRINT_CHAT, "%s wins! (%i:0%i)\n", win_ent->client->pers.netname, min, sec);		

	}
	else if((int)(outbreak_mode->value) == OUTBR_MODE_CTF)
	{
	}
	EndDMLevel();
}

qboolean CheckWinPrisoners(edict_t *ent)
{
	
	int			i, insid,num,num_prisoners, x;
	edict_t		*touch[32], *hit, *ent2;

	num=gi.BoxEdicts (ent->absmin, ent->absmax, touch, 32, AREA_SOLID);
	insid=0;
	num_prisoners=0;

	// be careful, it is possible to have an entity in this
	// list removed before we get to it (killtriggered)
	for (i=0 ; i<num ; i++)
	{
		if(!Q_strcasecmp(touch[i]->classname, "player"))
		{
			hit = touch[i];
			if (hit->client->resp.outbr_team == OUTBR_PRISONERS)
			{
				if((int)(outbreak_mode->value) == OUTBR_MODE_SINGLE)
				{
					win_ent = hit;
					level.winner = OUTBR_WINNER_PRIS;
					return true;
				}
				else if((int)(outbreak_mode->value) == OUTBR_MODE_CTF)
				{
					if(outbr_flag == NULL)
						return false;
					if (hit->client->pers.inventory[ITEM_INDEX(outbr_flag)])
					{
						gi.bprintf(PRINT_HIGH, "%s brought the flag to the target!\n", hit->client->pers.netname);
						level.outbr_captures += 1;
						OUTBRResetFlag();
						hit->client->pers.inventory[ITEM_INDEX(outbr_flag)] = 0;
						for (x=0 ; x < maxclients->value ; x++)
						{
							ent2 = g_edicts + 1 + x;
							if(ent2->client->resp.outbr_team != OUTBR_NOTEAM)
							{
								if(ent2->client->resp.outbr_team == OUTBR_PRISONERS)
								{
									ent2->client->resp.score += 10;
								}

								ent2->svflags &= ~SVF_NOCLIENT;
								PutClientInServer (ent2);
	
								// add a teleportation effect
								ent2->s.event = EV_PLAYER_TELEPORT;
	
								// hold in place briefly
								ent2->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
								ent2->client->ps.pmove.pm_time = 14;
	
								ent2->client->respawn_time = level.time;
								return false;
							}


						}
					}	
				}
				else
				{
					insid++;
				}
			}
			else if(((int)(outbreak_flags->value) & OFL_END_KEEP)
				&& hit->client->resp.outbr_team == OUTBR_KEEPERS)
			{
				return false;
			}
		}
	}

	for (i = 0; i < maxclients->value; i++) {
		if (!g_edicts[i+1].inuse)
			continue;
		if (game.clients[i].resp.outbr_team == OUTBR_PRISONERS)
		{
			num_prisoners++;
		}
	}

	if(num_prisoners==insid && num_prisoners!=0)
	{
		level.winner = OUTBR_WINNER_PRIS;
		return true;
	}
	return false;

}


/*
==================================================

  Assignskin Code
TIMMFIX		muss nochmal changeclothes berarbeiten

==================================================
*/

void OUTBRAssignSkin(edict_t *ent, char *s)
{
	int playernum = ent - g_edicts - 1;
	char *p;
	char t[64];

	Com_sprintf(t, sizeof(t), "%s", s);

	if ((p = strrchr(t, '/')) != NULL)
		p[1] = 0;
	else
		strcpy(t, "male/");
	switch (ent->client->resp.outbr_team) {
	case OUTBR_PRISONERS:
		if(ent->count == OUTBR_CHAN_SKIN)
		gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, OUTBR_KEEP_SKIN) );
		else
		gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s%s", 
			ent->client->pers.netname, t, OUTBR_PRIS_SKIN) );
		break;
	case OUTBR_KEEPERS:
		gi.configstring (CS_PLAYERSKINS+playernum,
			va("%s\\%s%s", ent->client->pers.netname, t, OUTBR_KEEP_SKIN) );
		break;
	default:
		gi.configstring (CS_PLAYERSKINS+playernum, 
			va("%s\\%s", ent->client->pers.netname, s) );
		break;
	}

	gi.linkentity(ent);
}

/*
==================================================

  Join-Code

==================================================
*/

void OUTBRJoinTeam(edict_t *ent, int desired_team)
{
	
	char *s, *value;

		value = Info_ValueForKey (ent->client->pers.userinfo, "password");
		if (*password->string && strcmp(password->string, "none") && 
			strcmp(password->string, value)) {
			gi.cprintf(ent, PRINT_HIGH, "Incorrect password!\n");
			return;
		}
	PMenu_Close(ent);
	ent->svflags &= ~SVF_NOCLIENT;
	ent->client->resp.outbr_team = desired_team;

	Info_SetValueForKey (ent->client->pers.userinfo, "spectator", "0");


	ent->client->pers.spectator = false;
	ent->client->resp.spectator = false;
	StuffCmd(ent, "spectator 0\n");
	PutClientInServer (ent);
	// add a teleportation effect
	ent->s.event = EV_PLAYER_TELEPORT;

	// hold in place briefly
	ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
	ent->client->ps.pmove.pm_time = 14;
	if(desired_team == OUTBR_KEEPERS)
	{
		gi.bprintf(PRINT_HIGH, "%s is now a Keeper!\n",
			ent->client->pers.netname);
	}
	else
	{
		gi.bprintf(PRINT_HIGH, "%s becomes a Prisoner!\n",
			ent->client->pers.netname );
		s = Info_ValueForKey (ent->client->pers.userinfo, "skin");
		OUTBRAssignSkin(ent, s);
	}
}

/*
==================================================

	Outbreakmenu, Code aus CTF

==================================================
*/

void OUTBRJoinKeepers(edict_t *ent, pmenu_t *p)
{
	OUTBRJoinTeam(ent, OUTBR_KEEPERS);
}

void OUTBRJoinPrisoners(edict_t *ent, pmenu_t *p)
{
	OUTBRJoinTeam(ent, OUTBR_PRISONERS);
}

void OUTBRDisc(edict_t *ent, pmenu_t *p)
{
	StuffCmd(ent, "disconnect");
	return;
}
void OUTBRCredits(edict_t *ent, pmenu_t *p)
{
	edict_t *count;
	PMenu_Close(ent);
	gi.centerprintf(ent, "Outbreak v1.%i\ncoded by Moq\nfor additional credits\nsee readme.txt!\n", OUTBR_VERSION);
	count = G_Spawn();
	count->nextthink = level.time + 2.5;
	count->think = OUTBROpenMenu;
	count->owner = ent;

	return;
}
void OUTBRChaseCam(edict_t *ent, pmenu_t *p)
{
	edict_t *count;
	PMenu_Close(ent);
	if(GetChaseTarget(ent)==false)
	{
		count = G_Spawn();
		count->nextthink = level.time + 1.75;
		count->think = OUTBROpenMenu;
		count->owner = ent;
	}

	return;
}

pmenu_t joinmenu[] = {
         { "*Quake II - Outbreak",                       PMENU_ALIGN_CENTER, NULL, NULL },
         { NULL,                                 PMENU_ALIGN_CENTER, NULL, NULL },
         { NULL,                                 PMENU_ALIGN_CENTER, NULL, NULL },
         { NULL,                                 PMENU_ALIGN_CENTER, NULL, NULL },
         { "Team: Keepers",               PMENU_ALIGN_LEFT, NULL, OUTBRJoinKeepers },
         { "Team: Prisoners",             PMENU_ALIGN_LEFT, NULL, OUTBRJoinPrisoners },
         { NULL,                                 PMENU_ALIGN_CENTER, NULL, NULL },
         { "ChaseCam",                                 PMENU_ALIGN_CENTER, NULL, OUTBRChaseCam },
         { "Credits",                                 PMENU_ALIGN_CENTER, NULL, OUTBRCredits },
         { "ViewTarget",                                 PMENU_ALIGN_CENTER, NULL, OUTBRViewTarget },
         { "Disconnect", PMENU_ALIGN_CENTER, NULL, OUTBRDisc }
 };

int OUTBRUpdateJoinMenu(edict_t *ent)
{
	static char levelname[32];
	static char team1players[32];
	static char team2players[32];
	int num1, num2, i;

	joinmenu[4].text = "Team: Keepers";
	joinmenu[4].SelectFunc = OUTBRJoinKeepers;
	joinmenu[5].text = "Team: Prisoners";
	joinmenu[5].SelectFunc = OUTBRJoinPrisoners;

	levelname[0] = '*';
	if (g_edicts[0].message)
		strncpy(levelname+1, g_edicts[0].message, sizeof(levelname) - 2);
	else
		strncpy(levelname+1, level.mapname, sizeof(levelname) - 2);
	levelname[sizeof(levelname) - 1] = 0;

	num1 = num2 = 0;
	for (i = 0; i < maxclients->value; i++) {
		if (!g_edicts[i+1].inuse)
			continue;
		if (game.clients[i].resp.outbr_team == OUTBR_KEEPERS)
			num1++;
		else if (game.clients[i].resp.outbr_team == OUTBR_PRISONERS)
			num2++;
	}

	sprintf(team1players, "Team: Keepers (%d pl.)", num1);
	sprintf(team2players, "Team: Prisoners (%d pl.)", num2);
	joinmenu[4].text = team1players;
	joinmenu[5].text = team2players;

	joinmenu[2].text = levelname;
	
	if (num1 > num2)
		return OUTBR_PRISONERS;
	else if (num2 > num1)
		return OUTBR_KEEPERS;
	return (rand() & 1) ? OUTBR_PRISONERS : OUTBR_KEEPERS;
}


void OUTBROpenJoinMenu(edict_t *ent)
{
	int team;

	team = OUTBRUpdateJoinMenu(ent);
	if (team == OUTBR_KEEPERS)
		team = 4;
	else
		team = 5;
	PMenu_Open(ent, joinmenu, team, sizeof(joinmenu) / sizeof(pmenu_t));
}

//======================


void OUTBR_Cells_Dec_Irg(edict_t *ent)
{
	// 5 = off 10 = on
	if(ent->owner->client->ir_framenum != OUTBR_IRG_OFF)
	{
		if((ent->owner->client->resp.outbr_team == OUTBR_PRISONERS && !((int)(outbreak_flags->value) & OFL_IRG_PR))
			||(ent->owner->client->resp.outbr_team == OUTBR_KEEPERS && !((int)(outbreak_flags->value) & OFL_IRG_KE)))
		{
			gi.cprintf(ent->owner, PRINT_HIGH, "Server disabled IR-Goggles...\n");
			ent->owner->client->ir_framenum = OUTBR_IRG_OFF;
		}
		else if(ent->owner->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] < irg_cost->value)
		{
			ent->owner->client->ir_framenum = OUTBR_IRG_OFF;
			gi.cprintf(ent->owner, PRINT_HIGH, "No more cells for IR-Goggles. IR-Goggles off...\n");
		}
		else
		{
			ent->owner->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] -= irg_cost->value;
			ent->nextthink = level.time + 1;
			return;
		}
	}
	G_FreeEdict (ent);
	return;
}

void OUTBR_Cells_Dec_Flash(edict_t *ent)
{
	if((ent->owner->client->resp.outbr_team == OUTBR_PRISONERS && !((int)(outbreak_flags->value) & OFL_FLASH_PR))
		||(ent->owner->client->resp.outbr_team == OUTBR_KEEPERS && !((int)(outbreak_flags->value) & OFL_FLASH_KE)))
	{
		gi.cprintf(ent->owner, PRINT_HIGH, "Server disabled flashlight...\n");
	}
	else if(!ent->owner->flashlight)
	{
		return;
	}
	else if(ent->owner->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] < fl_cost->value)
	{
		gi.cprintf(ent->owner, PRINT_HIGH, "No more cells for flashlight. Flashlight off...\n");
	}
	else
	{
		ent->owner->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] -= fl_cost->value;
		ent->nextthink = level.time + 1;
		return;
	}
	
	OUTBRFlashlight(ent->owner);
	G_FreeEdict (ent);
	return;
}

void OUTBR_Cmd_SetIRGoggles(edict_t *ent)
{
	edict_t	*celldec;

	if((ent->client->resp.outbr_team == OUTBR_PRISONERS && !((int)(outbreak_flags->value) & OFL_IRG_PR))
		||(ent->client->resp.outbr_team == OUTBR_KEEPERS && !((int)(outbreak_flags->value) & OFL_IRG_KE)))
	{
		gi.cprintf(ent, PRINT_HIGH, "Your team isn't allowed to use IR-Goggles...\n");
	}
	else if(ent->client->resp.outbr_team == OUTBR_NOTEAM && !((int)(outbreak_flags->value) & OFL_OBS_IRG))
	{
		gi.cprintf(ent, PRINT_HIGH, "Server does not allow IR-Goggles for spectators...\n");
	}
	else if(ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] < irg_cost->value && ent->client->resp.outbr_team != OUTBR_NOTEAM)
	{
		gi.cprintf(ent, PRINT_HIGH, "No Cells for IR-Goggles.\n");
		return;
	}
	else
	{
		if (ent->client->ir_framenum == OUTBR_IRG_ON)
		{
			ent->client->ir_framenum = OUTBR_IRG_OFF;
			gi.cprintf(ent, PRINT_HIGH, "IR-Goggles off...\n");
		}
		else
		{
			ent->client->ir_framenum = OUTBR_IRG_ON;
			gi.cprintf(ent, PRINT_HIGH, "IR-Goggles on...\n");
			if(ent->client->resp.outbr_team != OUTBR_NOTEAM)
			{
			celldec = G_Spawn();
			celldec->owner = ent;
			celldec->nextthink = level.time + 1;
			celldec->think = OUTBR_Cells_Dec_Irg;
			gi.linkentity (celldec);
			}
		}
	}
	return;
}
//TIMM
void OUTBR_Cmd_SetFlash(edict_t *ent)
{
	edict_t	*celldec;
	if(ent->flashlight)
	{		
		gi.cprintf(ent, PRINT_HIGH, "Flashlight off...\n");
	}
	else if((ent->client->resp.outbr_team == OUTBR_PRISONERS && !((int)(outbreak_flags->value) & OFL_FLASH_PR))
		||(ent->client->resp.outbr_team == OUTBR_KEEPERS && !((int)(outbreak_flags->value) & OFL_FLASH_KE)))
	{
		gi.cprintf(ent, PRINT_HIGH, "Your team isn't allowed to use flashlight...\n");
		return;
	}
	else if(ent->client->resp.outbr_team == OUTBR_NOTEAM)
	{
		gi.cprintf(ent, PRINT_HIGH, "No flashlight for spectators...\n");
		return;
	}
	else if(ent->client->pers.inventory[ITEM_INDEX(FindItem("cells"))] < fl_cost->value)
	{
		gi.cprintf(ent, PRINT_HIGH, "No Cells for flashlight.\n");
		return;
	}
	else
	{
			gi.cprintf(ent, PRINT_HIGH, "Flashlight on...\n");
			celldec = G_Spawn();
			celldec->owner = ent;
			celldec->nextthink = level.time + 1;
			celldec->think = OUTBR_Cells_Dec_Flash;
			gi.linkentity (celldec);
	}
	
	OUTBRFlashlight(ent);

	return;
}
