(**************************************************************************
MPQ Input
Creates Quake and Quake 2 reviews for use at Multiplayer Quake
http://www.planetquake.com/mpq/
Also creates reviews for Inspection
http://www.planetquake.com/inspection/

Copyright (C) 1999 Paul Healey

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Paul Healey by e-mail:
phealey@planetquake.com
paulhealey@lineone.net

Program:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput.zip
Source code:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput_src.zip
Inspection Pak (Review Graphics):
http://asp.planetquake.com/dl/dl.asp?mpq/ins-pak.zip
**************************************************************************)

unit quakeU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  TfmQuake = class(TForm)
    v: TPanel;
    txtMapName: TEdit;
    txtFileSize: TEdit;
    txtPlayers: TEdit;
    txtAuthor: TEdit;
    ReviewMemo: TMemo;
    txtDownload: TEdit;
    txtAuthorEmail: TEdit;
    ComboBox1: TComboBox;
    txtSmall1: TEdit;
    txtLarge1: TEdit;
    txtSmall2: TEdit;
    txtLarge2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    txtFilename: TEdit;
    Label13: TLabel;
    SpeedButton2: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    OpenDialog1: TOpenDialog;
    txtDirTo: TEdit;
    txtExtTo: TEdit;
    bnDone: TBitBtn;

    bnView: TBitBtn;
    Label15: TLabel;
    bnSave: TBitBtn;
    bnClear: TBitBtn;
    txtCaption1: TEdit;
    Label16: TLabel;
    txtCaption2: TEdit;
    Label17: TLabel;
    Label18: TLabel;
    txtAuthorWeb: TEdit;
    Label19: TLabel;
    bnIndex: TBitBtn;
    Label20: TLabel;
    txtReviewer: TEdit;
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure bnDoneClick(Sender: TObject);
    procedure bnClearClick(Sender: TObject);
    procedure bnViewClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bnSaveClick(Sender: TObject);
    procedure bnIndexClick(Sender: TObject);
    procedure ReviewMemoDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  fmQuake: TfmQuake;

implementation

uses codeU, mainU, OldRvwU;

{$R *.DFM}

procedure TfmQuake.SpeedButton3Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    txtSmall1.text := OpenDialog1.FileName;
end;

procedure TfmQuake.SpeedButton2Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    txtLarge1.text := OpenDialog1.FileName;
end;

procedure TfmQuake.SpeedButton4Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    txtSmall2.text := OpenDialog1.FileName;
end;

procedure TfmQuake.SpeedButton1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    txtLarge2.text := OpenDialog1.FileName;
end;

procedure TfmQuake.FormShow(Sender: TObject);
begin
     fmMain.Caption := 'Main Menu : Create a Quake review';
     codeU.x1 := -1;
     txtDirTo.text := fmMain.sDirToQuake;
     txtExtTo.text := fmMain.sExtToQuake;
     txtReviewer.text := fmMain.sReviewer;
//     if fmMain.bnQuake2.enabled = true then
//        fmMain.bnQuake2.enabled := false;
end;

procedure TfmQuake.bnDoneClick(Sender: TObject);
begin
     fmOldRvw.which := 1;
     fmOldRvw.ShowModal;
     fmOldRvw.which := 0;
end;

procedure TfmQuake.bnClearClick(Sender: TObject);
begin
{ Clear boxes for new review }
   inc(codeU.i1);
   txtFilename.text := '';
   txtMapName.text := '';
   txtDownload.text := '';
   txtAuthor.text := '';
   txtAuthorEmail.text := '';
   txtAuthorWeb.text := '';
   txtPlayers.Text := '';
   txtFileSize.text := '';
   ReviewMemo.clear;
   txtCaption1.text := '';
   txtCaption2.text := '';
   txtSmall1.text := 'Quake/';
   txtLarge1.text := 'Quake/';
   txtSmall2.text := 'Quake/';
   txtLarge2.text := 'Quake/';
   codeU.x1 := -1;
   txtDirTo.text := fmMain.sDirToQuake;
   txtExtTo.text := fmMain.sExtToQuake;
   txtFilename.SetFocus;
end;

procedure TfmQuake.bnViewClick(Sender: TObject);
begin
     ReviewPreview(Sender);
end;

procedure TfmQuake.FormDestroy(Sender: TObject);
begin
          fmMain.sDirToQuake := txtDirTo.text;
          fmMain.sExtToQuake := txtExtTo.text;
          fmMain.sReviewer := txtReviewer.text;
end;

procedure TfmQuake.bnSaveClick(Sender: TObject);
begin
     if Length(txtCaption1.text) > 31 then
     begin
          MessageDlg(('Caption length in Caption 1 Input box is greater than 31 characters' + #13 + #10 + 'Please shorten caption'),
          mtWarning, [mbOk], 0);
          exit;
     end;
     if Length(txtCaption2.text) > 31 then
     begin
          MessageDlg(('Caption length in Caption 2 Input box is greater than 31 characters' + #13 + #10 + 'Please shorten caption'),
          mtWarning, [mbOk], 0);
          exit;
     end;
     if bnClear.Enabled = false then
        bnClear.Enabled := true;

     if fmMain.RBHTML.Checked = True then
        CreateHTML(Sender, 1)
     else if fmMain.RBCSS.Checked = True then
        CreateHTML(Sender, 2);

     SaveSession(1);
end;

procedure TfmQuake.bnIndexClick(Sender: TObject);
begin
     CreateTableFile(Sender);
     ReviewPreview(Sender);
end;

procedure TfmQuake.ReviewMemoDblClick(Sender: TObject);
begin
     ReviewMemo.Lines.Add('Don''t forgot the <a href="http://www.planetquake.com/dl/dl.asp?skorpion/routes/?_ent.zip">Omcrion route file,</a> provided by <a href="http://www.planetquake.com/skorpion/news.html">Skorpion</a>');
end;

end.
