(**************************************************************************
MPQ Input
Creates Quake and Quake 2 reviews for use at Multiplayer Quake
http://www.planetquake.com/mpq/
Also creates reviews for Inspection
http://www.planetquake.com/inspection/

Copyright (C) 1999 Paul Healey

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Paul Healey by e-mail:
phealey@planetquake.com
paulhealey@lineone.net

Program:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput.zip
Source code:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput_src.zip
Inspection Pak (Review Graphics):
http://asp.planetquake.com/dl/dl.asp?mpq/ins-pak.zip
**************************************************************************)

unit mainU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, FormCont, StdCtrls, Buttons, jpeg;

type
  TfmMain = class(TForm)
    FormContainer1: TFormContainer;
    SidePanel: TPanel;
    bnClose: TBitBtn;
    bnQuake: TBitBtn;
    bnQuake2: TBitBtn;
    bnAbout: TBitBtn;
    Image1: TImage;
    RBHTML: TRadioButton;
    RBCSS: TRadioButton;
    CBYour: TCheckBox;
    BitBtn1: TBitBtn;
    procedure bnQuakeClick(Sender: TObject);
    procedure bnQuake2Click(Sender: TObject);
    procedure bnAboutClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    sDirToQuake, sExtToQuake, sDirToQuake2, sExtToQuake2, sReviewer,
    sDirToInspection, sExtToInspection, sInsReviewer : string;
  end;

var
  fmMain: TfmMain;

implementation

uses quakeU, quake2U, AboutU, codeU, inspectionU;

{$R *.DFM}

procedure TfmMain.bnQuakeClick(Sender: TObject);
begin
     if fmMain.FormContainer1.Form <> fmQuake then
     begin
          fmQuake := TfmQuake(fmMain.FormContainer1.CreateForm(TfmQuake));
          fmMain.FormContainer1.ShowForm(fmQuake, True);
     end;
end;

procedure TfmMain.bnQuake2Click(Sender: TObject);
begin
     if fmMain.FormContainer1.Form <> fmQuake2 then
     begin
          fmQuake2 := TfmQuake2(fmMain.FormContainer1.CreateForm(TfmQuake2));
          fmMain.FormContainer1.ShowForm(fmQuake2, True);
     end;
end;

procedure TfmMain.bnAboutClick(Sender: TObject);
begin
     AboutBox.ShowModal;
end;

procedure TfmMain.FormShow(Sender: TObject);
begin
{ Load up reviews from DAT files}
     LoadSession;
{
     if FileExists('Quake.DAT') then
        bnQuake2.Enabled := False;
     if FileExists('Quake2.DAT') then
        bnQuake.Enabled := False;
}
end;

procedure TfmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
{ Save ini settings}
     CloseUpIni;

end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
{ Load ini settings}
     LoadUpINI;
     codeU.what1 := false;
     codeU.what2 := false;
     codeU.what3 := false;
end;

procedure TfmMain.BitBtn1Click(Sender: TObject);
begin
     if fmMain.FormContainer1.Form <> fmInspection then
     begin
          fmInspection := TfmInspection(fmMain.FormContainer1.CreateForm(TfmInspection));
          fmMain.FormContainer1.ShowForm(fmInspection, True);
     end;

end;

end.
