(**************************************************************************
MPQ Input
Creates Quake and Quake 2 reviews for use at Multiplayer Quake
http://www.planetquake.com/mpq/
Also creates reviews for Inspection
http://www.planetquake.com/inspection/

Copyright (C) 1999 Paul Healey

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Paul Healey by e-mail:
phealey@planetquake.com
paulhealey@lineone.net

Program:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput.zip
Source code:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput_src.zip
Inspection Pak (Review Graphics):
http://asp.planetquake.com/dl/dl.asp?mpq/ins-pak.zip
**************************************************************************)

unit inspectionU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ExtCtrls;

type
  TfmInspection = class(TForm)
    v: TPanel;
    bnDone: TBitBtn;
    bnClear: TBitBtn;
    bnView: TBitBtn;
    bnSave: TBitBtn;
    bnIndex: TBitBtn;
    OpenDialog1: TOpenDialog;
    OpenDialog2: TOpenDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Label19: TLabel;
    Label15: TLabel;
    Label7: TLabel;
    Label20: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label6: TLabel;
    Label18: TLabel;
    Label9: TLabel;
    Label8: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label12: TLabel;
    Label14: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    txtMapName: TEdit;
    txtFileSize: TEdit;
    txtAuthor: TEdit;
    txtDownload: TEdit;
    txtAuthorEmail: TEdit;
    txtFilename: TEdit;
    txtAuthorWeb: TEdit;
    txtExtTo: TEdit;
    txtDirTo: TEdit;
    txtReviewer: TEdit;
    txtCaption1: TEdit;
    txtSmall1: TEdit;
    txtLarge1: TEdit;
    txtCaption2: TEdit;
    txtLarge2: TEdit;
    txtSmall2: TEdit;
    txtCaption3: TEdit;
    txtSmall3: TEdit;
    txtLarge3: TEdit;
    txtCaption4: TEdit;
    txtLarge4: TEdit;
    txtSmall4: TEdit;
    TabSheet2: TTabSheet;
    Label23: TLabel;
    AuthorMemo: TMemo;
    ArchMemo: TMemo;
    Label24: TLabel;
    TexMemo: TMemo;
    Label25: TLabel;
    TabSheet3: TTabSheet;
    WalkMemo: TMemo;
    Label26: TLabel;
    GameplayMemo: TMemo;
    Label27: TLabel;
    Label28: TLabel;
    ConclusionMemo: TMemo;
    cbReview: TComboBox;
    Label29: TLabel;
    txtPlayers: TEdit;
    Label30: TLabel;
    TabSheet4: TTabSheet;
    ExcessusMemo: TMemo;
    Label31: TLabel;
    procedure bnSaveClick(Sender: TObject);
    procedure bnViewClick(Sender: TObject);
    procedure bnDoneClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure bnClearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmInspection: TfmInspection;

implementation

uses codeU, OldRvwU, mainU;

{$R *.DFM}

procedure TfmInspection.bnSaveClick(Sender: TObject);
begin
     if Length(txtCaption1.text) > 31 then
     begin
          MessageDlg(('Caption length in Caption 1 Input box is greater than 31 characters' + #13 + #10 + 'Please shorten caption'),
          mtWarning, [mbOk], 0);
          exit;
     end;
     if Length(txtCaption2.text) > 31 then
     begin
          MessageDlg(('Caption length in Caption 2 Input box is greater than 31 characters' + #13 + #10 + 'Please shorten caption'),
          mtWarning, [mbOk], 0);
          exit;
     end;
     if Length(txtCaption3.text) > 31 then
     begin
          MessageDlg(('Caption length in Caption 3 Input box is greater than 31 characters' + #13 + #10 + 'Please shorten caption'),
          mtWarning, [mbOk], 0);
          exit;
     end;
     if Length(txtCaption4.text) > 31 then
     begin
          MessageDlg(('Caption length in Caption 4 Input box is greater than 31 characters' + #13 + #10 + 'Please shorten caption'),
          mtWarning, [mbOk], 0);
          exit;
     end;

     if bnClear.Enabled = false then
        bnClear.Enabled := true;


     CreateHTML(Sender, 1);
     SaveSession(5);
end;

procedure TfmInspection.bnViewClick(Sender: TObject);
begin
     ReviewPreview(Sender);
end;

procedure TfmInspection.bnDoneClick(Sender: TObject);
begin
     fmOldRvw.which := 5;
     fmOldRvw.ShowModal;
     fmOldRvw.which := 0;
end;

procedure TfmInspection.FormDestroy(Sender: TObject);
begin
          fmMain.sDirToInspection := txtDirTo.text;
          fmMain.sExtToInspection := txtExtTo.text;
          fmMain.sInsReviewer := txtReviewer.text;

end;

procedure TfmInspection.FormShow(Sender: TObject);
begin
     fmMain.Caption := 'Main Menu : Create an Inspection review';
     codeU.x3 := -1;
     txtDirTo.text := fmMain.sDirToInspection;
     txtExtTo.text := fmMain.sExtToInspection;
     txtReviewer.text := fmMain.sInsReviewer;
     PageControl1.Activepage := Tabsheet1;     
end;

procedure TfmInspection.bnClearClick(Sender: TObject);
begin
{ Clear boxes for new review }
   inc(codeU.i3);
   txtFilename.text := '';
   txtMapName.text := '';
   txtDownload.text := '';
   txtAuthor.text := '';
   txtAuthorEmail.text := '';
   txtAuthorWeb.text := '';
//   txtPlayers.Text := '';
   txtFileSize.text := '';
   AuthorMemo.clear;
   ArchMemo.clear;
   TexMemo.clear;
   WalkMemo.clear;
   GameplayMemo.clear;
   ConclusionMemo.clear;
   ExcessusMemo.clear;
   ExcessusMemo.Lines.Add('<br><b>');
   ExcessusMemo.Lines.Add('');
   ExcessusMemo.Lines.Add('</b>');

   txtCaption1.text := '';
   txtCaption2.text := '';
   txtCaption4.text := '';
   txtCaption3.text := '';

   txtPlayers.text := '';

   txtSmall1.text := '';
   txtLarge1.text := '';
   txtSmall2.text := '';
   txtLarge2.text := '';
   txtSmall3.text := '';
   txtLarge3.text := '';
   txtSmall4.text := '';
   txtLarge4.text := '';

   codeU.x3 := -1;
   txtDirTo.text := fmMain.sDirToInspection;
   txtExtTo.text := fmMain.sExtToInspection;
   PageControl1.Activepage := Tabsheet1;
   txtFilename.SetFocus;

end;

end.
