(**************************************************************************
MPQ Input
Creates Quake and Quake 2 reviews for use at Multiplayer Quake
http://www.planetquake.com/mpq/
Also creates reviews for Inspection
http://www.planetquake.com/inspection/

Copyright (C) 1999 Paul Healey

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Paul Healey by e-mail:
phealey@planetquake.com
paulhealey@lineone.net

Program:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput.zip
Source code:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput_src.zip
Inspection Pak (Review Graphics):
http://asp.planetquake.com/dl/dl.asp?mpq/ins-pak.zip
**************************************************************************)

{
 This file contains all the procedures used to run the program. All forms link to this code in
 one way or another.
}

unit codeU;

interface

uses
    quakeU, quake2U, MainU, inspectionU, OldRvwU, progressU, sysutils, ShellAPI, windows, Inifiles,
{ not all of these are needed but I'm lazy so here they are! }
     Messages,  Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;
const
     MAX = 150;
     VER = '0.602';

type
    TReview = record
// which = type of game
// currently  1 = Quake, 2 = Quake 2 (not used but 3 = Quake 3 Arena)
// 4 reserved!
// 5 Inspection reviews
        which, nolines, nolines2, nolines3, nolines4, nolines5, nolines6, nolines7, iIndex1, iIndex2 : integer;
// nolines variables, number of lines for the various arrTypes
        sFileName : string; // HTML filename
        sDirTo : string; // directory to save to
        sExtTo : string; // extension to use
        sAuthor : string; // map author
        sAuthorEmail : string; // map author email
        sAuthorWeb : string; // map author website
        sMapName : string; // map name
        sFileSize : string; // map zip file size

        sCaption1 : string; // picture captions (used by all the Quake 2 reviewers, I have no use for them)
        sCaption2 : string;
// two extra for inspection
        sCaption3: string;
        sCaption4: string;

        sSmall1 : string; // links to review screenshots. Small - 200x150 piccys, Large - res game runs in
        sLarge1 : string;
        sSmall2 : string;
        sLarge2 : string;
// extra inspecton
        sSmall3 : string;
        sLarge3 : string;
        sSmall4 : string;
        sLarge4 : string;

        sScore : string; // map score. used in various different ways.
                         // [MPQ] Quake - 5.0/5 type score
                         // [MPQ] Quake 2 - B - letter
                         // [Inspection] - Used for game type, ie Quake, Quake2, Quake 3 Arena
        sSign : string;  // [MPQ] - Quake 2 reviews, + / -
        sPlayers : string; // [MPQ] Number of players. [Inspection] Where the Omicron Bot Route file is
        sDownload : string; // Download link
        arrReview : array [0..MAX] of string; //[MPQ] The review text

//inspection stuff
        arrAuthor : array [0..MAX] of string; // Author Info
        arrArch : array [0..MAX] of string; // Architecture
        arrTex : array [0..MAX] of string; // Texturing and Lighting
        arrWalk : array [0..MAX] of string; // Walk Through
        arrGameplay : array [0..MAX] of string; // Gameplay
        arrConclusion : array [0..MAX] of string; // Conclusion
        arrExcessus : array [0..MAX] of string; //Excessus's intro
        sReviewer : string; // [Inspection only] map reviewers

        time : string; // time last saved
        date : string; // date last saved
   end;

// Used for all reviews. Copies all info from Form objects to TReview record
procedure CreateHTML(Sender: TObject; iType : integer);
// MPQ Review creation. normal review style. just html
procedure DoReviewHTML(Rvw : array of TReview; sReviewer : String; i : integer);
// Inspection review! The commented out procedures are part of the DoReview procedure.
procedure DoReviewInspection(Rvw : array of TReview; i : integer);
{
procedure WriteReview(lines : integer; reviewtext : array of string);
procedure WriteTitle(sTitle : string);
}
// MPQ Review creation. uses CSS for formatting
procedure DoReviewCSS(Rvw : array of TReview; sReviewer : String; i : integer);
// Creates the list of reviews done for the reviews done screen
procedure GiveIt(which : integer);
// Used when you double click on the reviews done box. This copies the review
// from the arrays to the screen.
procedure RetrieveReview(which : integer);
// Save all the reviews to the DAT files
procedure SaveSession(which : integer);
// Load up all the reviews from the DAT files
procedure LoadSession;
// For MPQ reviews. Creates HTML table of all reviews.
procedure CreateTableFile(Sender : TObject);
// Loads review up into web browser
procedure ReviewPreview(Sender : TObject);
// Load up INI file settings
procedure LoadUpIni;
// Close and save all INI file settings
procedure CloseUpIni;
// [MPQ Only] Delete a review
procedure DeleteReview(which : integer);
// [MPQ Only] Used in DeleteReview. The reviews are backed up first, this does that job.
procedure CopyFile(File1, File2 : String);

var
   ininame : string; // ini file name
   i1, i2, i3, x1, x2, x3 : integer; // array counters
   what1, what2, what3 : boolean; // are there any reviews?
   Rvw1, Rvw2, Rvw3 : array [0..MAX] of TReview; // 1 = Quake MPQ, 2 = Quake 2 MPQ, 3 = Inspection
   iOut1, iOut2, iOut3 : array [0..MAX] of integer;

implementation

procedure CreateHTML(Sender: TObject; iType : integer);
{
 This mess of a procedure moves the screen input to the Rvw arrays.
 Works out who called it and goes to the appropriate area.
 Either Quake/Quake 2 review in HTML or CSS format
        Inspection review
}
var
   counter, tempi1, tempi2, tempi3 : integer;
begin
// checking if there are any reviews already in the Rvw arrays
     tempi1 := -1;
     if what1 = false then
     begin
        i1 := 0;
        what1 := true;
     end;
     if (x1 <> -1) then
     begin
        tempi1 := i1;
        i1 := x1;
     end;

     tempi2 := -1;
     if what2 = false then
     begin
        i2 := 0;
        what2 := true;
     end;
     if (x2 <> -1) then
     begin
        tempi2 := i2;
        i2 := x2;
     end;

     tempi3 := -1;
     if what3 = false then
     begin
        i3 := 0;
        what3 := true;
     end;
     if (x3 <> -1) then
     begin
        tempi3 := i3;
        i3 := x3;
     end;


     if Sender = fmQuake.bnSave then
     begin
          // [MPQ] Quake
        Rvw1[i1].which := 1;
        Rvw1[i1].sFileName := fmQuake.txtFileName.text;
        if (Rvw1[i1].sFileName = '') then
           Rvw1[i1].sFileName := 'q1review';
        Rvw1[i1].sDirTo := fmQuake.txtDirTo.text;
        Rvw1[i1].sExtTo := fmQuake.txtExtTo.text;
        Rvw1[i1].sMapName := fmQuake.txtMapName.text;
        Rvw1[i1].sAuthor := fmQuake.txtAuthor.text;
        Rvw1[i1].sFileSize := fmQuake.txtFileSize.text;
        Rvw1[i1].sPlayers := fmQuake.txtPlayers.text;
        Rvw1[i1].nolines := fmQuake.ReviewMemo.Lines.Count -1;
        for counter := 0 to Rvw1[i1].nolines do
        begin
             Rvw1[i1].arrReview[counter] := fmQuake.ReviewMemo.Lines[counter];
        end;
        Rvw1[i1].sCaption1 := fmQuake.txtCaption1.text;
        Rvw1[i1].sCaption2 := fmQuake.txtCaption2.text;
        Rvw1[i1].sSmall1 := fmQuake.txtSmall1.text;
        Rvw1[i1].sLarge1 := fmQuake.txtLarge1.text;
        Rvw1[i1].sSmall2 := fmQuake.txtSmall2.text;
        Rvw1[i1].sLarge2 := fmQuake.txtLarge2.text;
        Rvw1[i1].sAuthorEmail := fmQuake.txtAuthorEmail.text;
        Rvw1[i1].sAuthorWeb := fmQuake.txtAuthorWeb.text;
        Rvw1[i1].sDownload  := fmQuake.txtDownload.text;
        Rvw1[i1].iIndex1 := fmQuake.ComboBox1.ItemIndex;
        Rvw1[i1].sScore := fmQuake.ComboBox1.Items[fmQuake.ComboBox1.ItemIndex];
        Rvw1[i1].Time := TimeToStr(Time);
        Rvw1[i1].Date := DateToStr(Date);

        if iType = 1 then
           DoReviewHTML(Rvw1, fmQuake.txtReviewer.text, i1)
        else if iType = 2 then
           DoReviewCSS(Rvw1, fmQuake.txtReviewer.text, i1);

     end
     else if Sender = fmQuake2.bnSave then
     begin
          // [MPQ] Quake 2
        Rvw2[i2].which := 2;
        Rvw2[i2].sFileName := fmQuake2.txtFileName.text;
        if (Rvw2[i2].sFileName = '') then
           Rvw2[i2].sFileName := 'q2review';
        Rvw2[i2].sDirTo := fmQuake2.txtDirTo.text;
        Rvw2[i2].sExtTo := fmQuake2.txtExtTo.text;
        Rvw2[i2].sMapName := fmQuake2.txtMapName.text;
        Rvw2[i2].sAuthor := fmQuake2.txtAuthor.text;
        Rvw2[i2].sFileSize := fmQuake2.txtFileSize.text;
        Rvw2[i2].sPlayers := fmQuake2.txtPlayers.text;
        Rvw2[i2].nolines := fmQuake2.ReviewMemo.Lines.Count -1;
        for counter := 0 to Rvw2[i2].nolines do
        begin
             Rvw2[i2].arrReview[counter] := fmQuake2.ReviewMemo.Lines[counter];
        end;
        Rvw2[i2].sCaption1 := fmQuake2.txtCaption1.text;
        Rvw2[i2].sCaption2 := fmQuake2.txtCaption2.text;
        Rvw2[i2].sSmall1 := fmQuake2.txtSmall1.text;
        Rvw2[i2].sLarge1 := fmQuake2.txtLarge1.text;
        Rvw2[i2].sSmall2 := fmQuake2.txtSmall2.text;
        Rvw2[i2].sLarge2 := fmQuake2.txtLarge2.text;
        Rvw2[i2].sAuthorEmail := fmQuake2.txtAuthorEmail.text;
        Rvw2[i2].sAuthorWeb := fmQuake2.txtAuthorWeb.text;
        Rvw2[i2].sDownload  := fmQuake2.txtDownload.text;
        Rvw2[i2].iIndex1 := fmQuake2.ComboBox1.ItemIndex;
        Rvw2[i2].iIndex2 := fmQuake2.ComboBox2.ItemIndex;
        Rvw2[i2].sScore := fmQuake2.ComboBox1.Items[fmQuake2.ComboBox1.ItemIndex];
        Rvw2[i2].sSign :=  fmQuake2.ComboBox2.Items[fmQuake2.ComboBox2.ItemIndex];
        Rvw2[i2].Time := TimeToStr(Time);
        Rvw2[i2].Date := DateToStr(Date);

        if iType = 1 then
           DoReviewHTML(Rvw2, fmQuake2.txtReviewer.text, i2)
        else if iType = 2 then
           DoReviewCSS(Rvw2, fmQuake2.txtReviewer.text, i2);

     end
     else if Sender = fmInspection.bnSave then
     begin
          // [Inspection]
        Rvw3[i3].which := 5;
        Rvw3[i3].sFileName := fmInspection.txtFileName.text;
        if (Rvw3[i3].sFileName = '') then
           Rvw3[i3].sFileName := 'inspection';
        Rvw3[i3].sDirTo := fmInspection.txtDirTo.text;
        Rvw3[i3].sExtTo := fmInspection.txtExtTo.text;
        Rvw3[i3].sMapName := fmInspection.txtMapName.text;
        Rvw3[i3].sAuthor := fmInspection.txtAuthor.text;
        Rvw3[i3].sFileSize := fmInspection.txtFileSize.text;
        Rvw3[i3].sPlayers := fmInspection.txtPlayers.text;

        Rvw3[i3].nolines := fmInspection.AuthorMemo.Lines.Count -1;
        for counter := 0 to Rvw3[i3].nolines do
        begin
             Rvw3[i3].arrAuthor[counter] := fmInspection.AuthorMemo.Lines[counter];
        end;

        Rvw3[i3].nolines2 := fmInspection.ArchMemo.Lines.Count -1;
        for counter := 0 to Rvw3[i3].nolines2 do
        begin
             Rvw3[i3].arrArch[counter] := fmInspection.ArchMemo.Lines[counter];
        end;

        Rvw3[i3].nolines3 := fmInspection.TexMemo.Lines.Count -1;
        for counter := 0 to Rvw3[i3].nolines3 do
        begin
             Rvw3[i3].arrTex[counter] := fmInspection.TexMemo.Lines[counter];
        end;

        Rvw3[i3].nolines4 := fmInspection.WalkMemo.Lines.Count -1;
        for counter := 0 to Rvw3[i3].nolines4 do
        begin
             Rvw3[i3].arrWalk[counter] := fmInspection.WalkMemo.Lines[counter];
        end;

        Rvw3[i3].nolines5 := fmInspection.GameplayMemo.Lines.Count -1;
        for counter := 0 to Rvw3[i3].nolines5 do
        begin
             Rvw3[i3].arrGameplay[counter] := fmInspection.GameplayMemo.Lines[counter];
        end;

        Rvw3[i3].nolines6 := fmInspection.ConclusionMemo.Lines.Count -1;
        for counter := 0 to Rvw3[i3].nolines6 do
        begin
             Rvw3[i3].arrConclusion[counter] := fmInspection.ConclusionMemo.Lines[counter];
        end;

        Rvw3[i3].nolines7 := fmInspection.ExcessusMemo.Lines.Count -1;
        for counter := 0 to Rvw3[i3].nolines7 do
        begin
             Rvw3[i3].arrExcessus[counter] := fmInspection.ExcessusMemo.Lines[counter];
        end;

        Rvw3[i3].sCaption1 := fmInspection.txtCaption1.text;
        Rvw3[i3].sCaption2 := fmInspection.txtCaption2.text;
        Rvw3[i3].sCaption3 := fmInspection.txtCaption3.text;
        Rvw3[i3].sCaption4 := fmInspection.txtCaption4.text;

        Rvw3[i3].sSmall1 := fmInspection.txtSmall1.text;
        Rvw3[i3].sLarge1 := fmInspection.txtLarge1.text;
        Rvw3[i3].sSmall2 := fmInspection.txtSmall2.text;
        Rvw3[i3].sLarge2 := fmInspection.txtLarge2.text;
        Rvw3[i3].sSmall3 := fmInspection.txtSmall3.text;
        Rvw3[i3].sLarge3 := fmInspection.txtLarge3.text;
        Rvw3[i3].sSmall4 := fmInspection.txtSmall4.text;
        Rvw3[i3].sLarge4 := fmInspection.txtLarge4.text;

        Rvw3[i3].sAuthorEmail := fmInspection.txtAuthorEmail.text;
        Rvw3[i3].sAuthorWeb := fmInspection.txtAuthorWeb.text;
        Rvw3[i3].sDownload  := fmInspection.txtDownload.text;
        Rvw3[i3].iIndex1 := fmInspection.cbReview.ItemIndex;
//        Rvw3[i3].iIndex2 := fmInspection.ComboBox2.ItemIndex;
        Rvw3[i3].sScore := fmInspection.cbReview.Items[fmInspection.cbReview.ItemIndex];
//        Rvw3[i3].sSign :=  fmInspection.ComboBox2.Items[fmQuake2.ComboBox2.ItemIndex];
        Rvw3[i3].Time := TimeToStr(Time);
        Rvw3[i3].Date := DateToStr(Date);
        Rvw3[i3].sReviewer := fmInspection.txtReviewer.text;
        DoReviewInspection(Rvw3, i3)

     end
     else
     begin
//          MessageBox('Could not create file!', MB_OK);
         exit;
     end;
     if tempi1 <> -1 then
          i1 := tempi1;
     if tempi2 <> -1 then
          i2 := tempi2;
     if tempi3 <> -1 then
          i3 := tempi3;

end;

{***************************
 Creates MPQ HTML Reviews
****************************}
procedure DoReviewHTML(Rvw : array of TReview; sReviewer : String; i : integer);
var
   MyTextFile: TextFile;
   Counter : integer;
begin
{
     for counter := 3 downto 0 do
     begin
          arrFix[counter] :=
     end;
}
// store record in array of details

     AssignFile(MyTextFile, (Rvw[i].sDirTo + Rvw[i].sFileName + Rvw[i].sExtTo));
     Rewrite(MyTextFile);
     try
// Top bit. Standard file info
        WriteLn(MyTextFile, '<!doctype html public "-//w3c//dtd html 4.0 transitional//en">');
        WriteLn(MyTextFile, '<html><head>');
        WriteLn(MyTextFile, '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
        Write(MyTextFile, '<meta name="Author" content="Paul">');
        WriteLn(MyTextFile, '<meta name="GENERATOR" content="MPQ Input Version:' + VER + '">');
// type of review. Your Review, or Quake/Quake2
        if fmMain.CBYour.State = cbChecked then
           WriteLn(MyTextFile, '<title>Your Reviews</title>')
        else if fmMain.CBYour.State = cbUnChecked then
        begin
             if Rvw[i].Which = 1 then
                WriteLn(MyTextFile, '<title>Quake Reviews</title>')
             else if Rvw[i].Which = 2 then
                WriteLn(MyTextFile, '<title>Quake 2 Reviews</title>');
        end;

        WriteLn(MyTextFile, '<style type="text/css"><!--A:link, A:visited, A:active {text-decoration: none} A:hover {text-decoration: underline}--></style>');
        WriteLn(MyTextFile, '</head>');
        WriteLn(MyTextFile, '<body text="#FFFFFF" bgcolor="#000000" link="#FF6600" vlink="#FF6600" alink="#FF0000">');
        WriteLn(MyTextFile, '');

// Quake review logo
        if fmMain.CBYour.State = cbChecked then
           WriteLn(MyTextFile, '<div align=right><img SRC="yr.gif" NOSAVE height=50 width=325></div>')
        else if fmMain.CBYour.State = cbUnChecked then
        begin
             if Rvw[i].Which = 1 then
                WriteLn(MyTextFile, '<div align=right><img SRC="q1.gif" NOSAVE height=50 width=150></div>')
             else if Rvw[i].Which = 2 then
             WriteLn(MyTextFile, '<div align=right><img SRC="q2.gif" NOSAVE height=50 width=160></div>');
        end;
        WriteLn(MyTextFile, '<font color="#000000">..</font>');

        WriteLn(MyTextFile, '<center><table BORDER=0 CELLSPACING=0 CELLPADDING=0 COLS=1 WIDTH="100%" BGCOLOR="#21428C" >');
        WriteLn(MyTextFile, '<tr><td><font face="Verdana"><font size=-1><b><font color="#FF6600">');
// Map Name
        WriteLn(MyTextFile, Rvw[i].sMapName);
        WriteLn(MyTextFile, '</font></b><font color="#FFCC33">');
// File Size
        WriteLn(MyTextFile, '(' + Rvw[i].sFileSize + 'kb)');
        WriteLn(MyTextFile, '</font><b><font color="#FFFFFF">');
// Author Name
        WriteLn(MyTextFile, 'by ' + Rvw[i].sAuthor);
        WriteLn(MyTextFile, '</font></b></font></font></td>');
        WriteLn(MyTextFile, '</tr></table></center>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<font face="Verdana"><font color="#FFCC33"><font size=-1>');
//Number of players
        WriteLn(MyTextFile, Rvw[i].sPlayers);
        WriteLn(MyTextFile, '</font></font></font>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<br><font face="Verdana"><font color="#FFFFFF"><font size=-1>');
// Print out review
        for counter := 0 to Rvw[i].nolines do
        begin
             if Rvw[i].arrReview[counter] = '' then
             begin
// If its a blank line in the review do <p> next paragraph
                  WriteLn(MyTextFile, '<p>');
             end
             else
             WriteLn(MyTextFile, Rvw[i].arrReview[counter]);
        end;

        WriteLn(MyTextFile, '</font></font></font><br>');
        WriteLn(MyTextFile, '');
        WriteLn(MyTextFile, '<font face="Verdana"><font color="#FFFFFF"><font size=-1>' + sReviewer + '</font></font></font>');
        WriteLn(MyTextFile, '');

        if Rvw[i].which = 2 then
        begin
// Review score for Quake 2 review
// Grade logo
         Write(MyTextFile, '<DIV ALIGN=right><IMG SRC="grade.gif" NOSAVE HEIGHT=50 WIDTH=150>');
//letter
         if Rvw[i].sScore = 'A' then //A
           Write(MyTextFile, '<IMG SRC="a.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'B' then //B
           Write(MyTextFile, '<IMG SRC="b.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'C' then //C
           Write(MyTextFile, '<IMG SRC="c.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'D' then //D
           Write(MyTextFile, '<IMG SRC="d.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'E' then //E
           Write(MyTextFile, '<IMG SRC="e.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'F' then //F
           Write(MyTextFile, '<IMG SRC="f.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>');

//sign, if needed
         if Rvw[i].sSign = '-' then //- sign
         begin
           Write(MyTextFile, '<IMG SRC="-.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>');
           WriteLn(MyTextFile, '</DIV>');
           end
         else if Rvw[i].sSign = '+' then //+ sign
         begin
           Write(MyTextFile, '<IMG SRC="+.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>');
           WriteLn(MyTextFile, '</DIV>');
         end
         else if Rvw[i].sSign = 'Blank' then //
         begin
            WriteLn(MyTextFile, '</DIV>');
         end;
         WriteLn(MyTextFile, '');
        end; {if which = 2 then}

        WriteLn(MyTextFile, '<table BORDER=0 CELLSPACING=0 CELLPADDING=2 COLS=2 WIDTH="100%" BGCOLOR="#666666" >');
        WriteLn(MyTextFile, '<tr><td BGCOLOR="#333333"><center><font face="Verdana"><font color="#FFFFFF"><font size=-1>');

// if we're doing a short review then the large text boxes must be empty.
// if they are it does not create the top row of the table, just the bottom with
// the download link, author email and website
        if (Rvw[i].sLarge1 <> '') and (Rvw[i].sLarge2 <> '') then
        begin
             if Rvw[i].sCaption1 = '' then
                WriteLn(MyTextFile, 'Click for larger image.')
             else
                 WriteLn(MyTextFile, Rvw[i].sCaption1);

             WriteLn(MyTextFile, '</font></font></font><br>');
             WriteLn(MyTextFile, '');
// 1st set of Images
           WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge1 + '" target="_parent"><img SRC="' + Rvw[i].sSmall1 + '" NOSAVE BORDER=0 height=150 width=200></a></center></td>');
           WriteLn(MyTextFile, '');

           WriteLn(MyTextFile, '<td BGCOLOR="#333333"><center><font face="Verdana"><font color="#FFFFFF"><font size=-1>');
// 2nd set of Images
// Theres not always a second image so give blank text!
          if Rvw[i].sLarge2 = '' then
          begin
             WriteLn(MyTextFile, 'No second image.</font></font></font><br></a></center></td></tr>');
          end
          else
          begin
             if Rvw[i].sCaption2 = '' then
                WriteLn(MyTextFile, 'Click for larger image.</font></font></font><br>')
             else
                 WriteLn(MyTextFile, Rvw[i].sCaption2 + '</font></font></font><br>');
             WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge2 + '" target="_parent"><img SRC="' + Rvw[i].sSmall2 + '" NOSAVE BORDER=0 height=150 width=200></a></center></td></tr>');
          end; {if Rvw[i].sLarge2 = '' then }

          WriteLn(MyTextFile, '');
          WriteLn(MyTextFile, '<tr><td BGCOLOR="#333333"><center><font face="Verdana"><font color="#FFFFFF"><font size=-1>');

        end; {if (Rvw[i].sLarge1 <> '') and (Rvw[i].sLarge2 <> '') then}

// Download link
        WriteLn(MyTextFile, '<b><a href="' + Rvw[i].sDownload + '">Download it!</a></font></font></font></b>');
        WriteLn(MyTextFile, '');

// Author Email address for a Quake review
        if Rvw[i].which = 1 then
        begin
           WriteLn(MyTextFile, '<br><b><font face="Verdana"><font color="#FFFFFF"><font size=-1>');
           WriteLn(MyTextFile, '<a href="mailto:' + Rvw[i].sAuthorEmail + '">Email the Author</a>');
           WriteLn(MyTextFile, '</font></font></font></b>');
           WriteLn(MyTextFile, '');
        end;
// Author Website

        if (StrComp(PChar(Rvw[i].sAuthorweb),  '') > 0) then
        begin
             WriteLn(MyTextFile, '<br><b><font face="Verdana"><font color="#FFFFFF"><font size=-1>');
           WriteLn(MyTextFile, '<a href="' + Rvw[i].sAuthorweb + '" target="_parent">Visit the Authors Website</a>');
           WriteLn(MyTextFile, '</font></font></font></b>');
        end;
        WriteLn(MyTextFile, '</center></td>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<td BGCOLOR="#333333"><center>');
// if its a Quake 2 review then we put the authors email address the end column, otherwises it would be empty
        if Rvw[i].which = 2 then
        begin
           WriteLn(MyTextFile, '<center><b><font face="Verdana"><font color="#FFFFFF"><font size=-1>');
           WriteLn(MyTextFile, '<a href="mailto:' + Rvw[i].sAuthorEmail + '">Email the Author</a></font></font></font></b></center>');
           WriteLn(MyTextFile, '');
        end;

//Review score for Quake review
        if Rvw[i].which = 1 then
        begin
             if Rvw[i].sScore = '0.5' then //0.5
                WriteLn(MyTextFile, '<img SRC="halfstarsolo.gif" height=45 width=28>')
             else if Rvw[i].sScore = '1.0' then //1.0
                  WriteLn(MyTextFile, '<img SRC="fullstarsolo.gif" height=45 width=39>')
             else if Rvw[i].sScore = '1.5' then //1.5
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="halfstarright.gif" NOSAVE height=45 width=24>')
             else if Rvw[i].sScore = '2.0' then //2.0
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarright.gif" NOSAVE height=45 width=35>')
             else if Rvw[i].sScore = '2.5' then //2.5
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="halfstarright.gif" NOSAVE height=45 width=24>')
             else if Rvw[i].sScore = '3.0' then //3.0
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarright.gif" NOSAVE height=45 width=35>')
             else if Rvw[i].sScore = '3.5' then //3.5
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="halfstarright.gif" NOSAVE height=45 width=24>')
             else if Rvw[i].sScore = '4.0' then //4.0
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarright.gif" NOSAVE height=45 width=35>')
//max limit of 255 characters a string so I've had to split the line up.
            else if Rvw[i].sScore = '4.5' then //4.5
            begin
                 Write(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30>');
                 WriteLn(MyTextFile, '<img SRC="halfstarright.gif" NOSAVE height=45 width=24>');
            end
            else if Rvw[i].sScore = '5.0' then //5.0
            begin
                 Write(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30>');
                 WriteLn(MyTextFile, '<img SRC="fullstarright.gif" NOSAVE height=45 width=35>');
            end; {if sScore = '0.5' then}
            WriteLn(MyTextFile, '');
        end; {if which = 1}

        WriteLn(MyTextFile, '</center></td></tr></table><font color="#000000">..</font></body></html>');
     finally
            CloseFile(MyTextFile);
     end; {Rewrite(MyTextFile); .. try}
//     if tempi = -1 then
//        inc(i)
     {else }

end;

{***************************
 Inspection Review
****************************}
procedure DoReviewInspection(Rvw : array of TReview; i : integer);
var
   MyTextFile : TextFile;
   sTemp1, sTemp2 : string;
{
 Couple of extra procedures.
}
   procedure WriteReview(lines : integer; reviewtext : array of string);
   {
    Writes the actual review sections
   }
   var
      counter : integer;
   begin
        WriteLn(MyTextFile, '<font face="Arial,Helvetica"><font color="#FFFFFF"><font size=-1>');
        for counter := 0 to lines do
        begin
             if reviewtext[counter] = '' then
             begin
   // If its a blank line in the review do <p> next paragraph
                  WriteLn(MyTextFile, '<p>');
             end
             else if reviewtext[counter] = '<x>' then
             begin
   // If it equals <x>, then its the other reviewer so switch to different font colour
                  WriteLn(MyTextFile, '</font></font></font>');
                  WriteLn(MyTextFile, '<font face="Arial,Helvetica"><font color="#999999"><font size=-1>');
             end
             else if reviewtext[counter] = '</x>' then
             begin
   // If it equals </x>, then its the end of the other reviewers text, so switch font colour back to white
                  WriteLn(MyTextFile, '</font></font></font>');
                  WriteLn(MyTextFile, '<font face="Arial,Helvetica"><font color="#FFFFFF"><font size=-1>');
             end
             else
             WriteLn(MyTextFile, reviewtext[counter]);
        end;
        WriteLn(MyTextFile, '</font></font></font>');
   end;

   procedure WriteTitle(sTitle : string);
   {
    Writes title heading, given title
   }
   begin
        Write(MyTextFile, '<p><a href="#Summary"><img SRC="../images/top.gif" NOSAVE BORDER=0 height=15 width=15></a><b><font face="Arial,Helvetica"><font color="#FF9900"><font size=-1>');
        WriteLn(MyTextFile, sTitle + '</font></font></font></b><br>');
   end;

begin
     AssignFile(MyTextFile, (Rvw[i].sDirTo + Rvw[i].sFileName + Rvw[i].sExtTo));
     Rewrite(MyTextFile);
     try
// Top bit. Standard file info
        WriteLn(MyTextFile, '<!doctype html public "-//w3c//dtd html 4.0 transitional//en">');
        WriteLn(MyTextFile, '<html><head>');
        WriteLn(MyTextFile, '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
        Write(MyTextFile, '<meta name="Author" content="Paul">');
        WriteLn(MyTextFile, '<meta name="GENERATOR" content="MPQ Input Version:' + VER + '">');

        WriteLn(MyTextFile, '   <title>i n s p e c t i o n - review</title>');
        WriteLn(MyTextFile, '<link rel=stylesheet href="../css/style.css" type="text/css">');
        WriteLn(MyTextFile, '</head>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<body text="#000000" bgcolor="#000000" link="#FFCC00" vlink="#FFCC00" alink="#FFCC00" background="../images/bg1.gif" nosave>');
        WriteLn(MyTextFile, '<font face="Arial,Helvetica"><font size=-1></font></font>&nbsp;');

        WriteLn(MyTextFile, '<center><table BORDER=0 WIDTH="80%" ><tr><td><div align=right><a NAME="Summary"></a>');
// Review logo, Quake/Quake2/Q3A
        if Rvw[i].iIndex1 = 0 then
           WriteLn(MyTextFile, '<img SRC="../images/quake.gif" NOSAVE BORDER=0 height=50 width=200>')
        else if Rvw[i].iIndex1 = 1 then
           WriteLn(MyTextFile, '<img SRC="../images/quake2.gif" NOSAVE BORDER=0 height=50 width=200>')
        else if Rvw[i].iIndex1 = 3 then
           WriteLn(MyTextFile, '<img SRC="../images/q3a.gif" NOSAVE BORDER=0 height=50 width=250>');

        WriteLn(MyTextFile, '</div></td></tr></table></center>');
        WriteLn(MyTextFile, '<font face="Arial,Helvetica"><font size=-1></font></font>');
// review table starts
// its 3 by 3. so 9 bits.
        WriteLn(MyTextFile, '<center><table BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH="80%" NOSAVE >');
// top row of review table starts
        WriteLn(MyTextFile, '<tr><td WIDTH="22" HEIGHT="22" BACKGROUND="../images/corner.gif" NOSAVE><font face="Arial,Helvetica"><font size=-1>&nbsp;&nbsp;&nbsp;&nbsp;</font></font></td>');

        WriteLn(MyTextFile, '<td HEIGHT="22" BACKGROUND="../images/verbar1.gif" NOSAVE><font face="Arial,Helvetica"><font size=-1>&nbsp;</font></font></td>');
        WriteLn(MyTextFile, '<td WIDTH="22" HEIGHT="22" BACKGROUND="../images/corner.gif" NOSAVE><font face="Arial,Helvetica"><font size=-1>&nbsp;&nbsp;&nbsp;&nbsp;</font></font></td></tr>');
// top row of review table ends
// middle row of review table starts
        WriteLn(MyTextFile, '<tr><td WIDTH="22" BACKGROUND="../images/horbar1.gif" NOSAVE><font face="Arial,Helvetica"><font size=-1>&nbsp;</font></font></td>');

// middle coloumn of the middle row of review table starts, this is the bit which contains the review
        WriteLn(MyTextFile, '<td BACKGROUND="../images/bg2.gif" NOSAVE><center><font face="Arial,Helvetica"><font size=-1><font color="#FF9933">');

// Intro. Map name, download link, Map FileSize, Map author, author email address, Author website address
        WriteLn(MyTextFile, '<a href="' + Rvw[i].sDownload + '">' + Rvw[i].sMapName + '</a> </font>');
        WriteLn(MyTextFile, '<font color="#FF9900"><b>(' + Rvw[i].sFileSize + 'Kb)</b> - By </font>');
        WriteLn(MyTextFile, '<font color="#0080FF"><a href="mailto:' + Rvw[i].sAuthorEmail + '">' + Rvw[i].sAuthor + '</a></font>');
        WriteLn(MyTextFile, '<font color="#FF9900">[ <a href="' + Rvw[i].sAuthorWeb + '" target="_blank">Author Website</a> ]</font></font></font>');
// Omicron route file (if there is one)
        if (Rvw[i].iIndex1 = 0) and (Rvw[i].sPlayers <> '') then
        begin
             WriteLn(MyTextFile, '<br><font face="Arial,Helvetica"><font color="#0080FF"><font size=-1><a href="');
             WriteLn(MyTextFile, Rvw[i].sPlayers + '">Omicron Bot Route File</a></font></font></font>');
        end;

// who wrote the review
// take the sReviewer variable then split it up
// the first reviewer is up to ;
// the second reviewer is after the ;
        sTemp1 := Copy(Rvw[i].sReviewer, 0, (Pos(';', Rvw[i].sReviewer) - 1));
        sTemp2 := Copy(Rvw[i].sReviewer, (Pos(';', Rvw[i].sReviewer) + 1), Length(Rvw[i].sReviewer));
        Write(MyTextFile, '<p><font face="Arial,Helvetica"><font size=-1><font color="#FFFFFF">Reviewed by ');
        Write(MyTextFile, sTemp1);
        Write(MyTextFile, ' (white) and ');
        Write(MyTextFile, sTemp2);
        WriteLn(MyTextFile, '</font><font color="#999999"> (grey)</font></font></font></center> <font face="Arial,Helvetica"><font size=-1></font></font>');

// Excessus's magical intro's
        if Rvw[i].nolines7 > 0 then
           WriteReview(Rvw[i].nolines7, Rvw[i].arrExcessus);

// Now for the review
// Start with author info and architecture sections.
// Note that we use the procedures "WriteTitle" and "WriteReview" for the actual HTML crap.
        WriteTitle('Author Info');
        WriteReview(Rvw[i].nolines, Rvw[i].arrAuthor);
        WriteTitle('Architecture');
        WriteReview(Rvw[i].nolines2, Rvw[i].arrArch);

        WriteLn(MyTextFile, '<br><font face="Arial,Helvetica"><font size=-1></font></font>&nbsp;');

// Now the first set of 2 graphics in a table
        WriteLn(MyTextFile, '<table BORDER=0 CELLSPACING=0 CELLPADDING=2 COLS=2 WIDTH="100%" >');
        WriteLn(MyTextFile, '<tr><td><center>');
        WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge1 + '" target="_blank"><img SRC="' + Rvw[i].sSmall1 + '" HSPACE=2 VSPACE=2 NOSAVE BORDER=0 height=150 width=200>');
        WriteLn(MyTextFile, '</a></center></td>');

        WriteLn(MyTextFile, '<td><center>');
        WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge2 + '" target="_blank"><img SRC="' + Rvw[i].sSmall2 + '" HSPACE=2 VSPACE=2 NOSAVE BORDER=0 height=150 width=200>');
        WriteLn(MyTextFile, '</a></center></td></tr></table>');

//<font face="Arial,Helvetica"><font size=-1></font></font>
// Middle section of the review.
// Texturing and Lighting, Walk Through and Gameplay
        WriteTitle('Texturing &amp; Lighting');
        WriteReview(Rvw[i].nolines3, Rvw[i].arrTex);
        WriteTitle('Walk Through');
        WriteReview(Rvw[i].nolines4, Rvw[i].arrWalk);
        WriteTitle('Gameplay');
        WriteReview(Rvw[i].nolines5, Rvw[i].arrGameplay);

// 2nd batch of 2 screenies
        WriteLn(MyTextFile, '<table BORDER=0 CELLSPACING=0 CELLPADDING=2 COLS=2 WIDTH="100%" >');
        WriteLn(MyTextFile, '<tr><td><center>');
        WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge3 + '" target="_blank"><img SRC="' + Rvw[i].sSmall3 + '" HSPACE=2 VSPACE=2 NOSAVE BORDER=0 height=150 width=200>');
        WriteLn(MyTextFile, '</a></center></td>');

        WriteLn(MyTextFile, '<td><center>');
        WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge4 + '" target="_blank"><img SRC="' + Rvw[i].sSmall4 + '" HSPACE=2 VSPACE=2 NOSAVE BORDER=0 height=150 width=200>');
        WriteLn(MyTextFile, '</a></center></td></tr></table>');

//<font face="Arial,Helvetica"><font size=-1></font></font>

// Final bit of the review, the conclusion!
        WriteTitle('Conclusion');
        WriteReview(Rvw[i].nolines6, Rvw[i].arrConclusion);

// right hand side of the table
        WriteLn(MyTextFile, '<br><font face="Arial,Helvetica"><font size=-1>&nbsp;</font></font></td>');

// bottom row of the table
        WriteLn(MyTextFile, '<td WIDTH="22" BACKGROUND="../images/horbar1.gif" NOSAVE><font face="Arial,Helvetica"><font color="#FFFFFF"><font size=-1>&nbsp;</font></font></font></td></tr>');
        WriteLn(MyTextFile, '<tr><td WIDTH="22" HEIGHT="22" BACKGROUND="../images/corner.gif" NOSAVE><font face="Arial,Helvetica"><font color="#FFFFFF"><font size=-1>&nbsp;</font></font></font></td>');
        WriteLn(MyTextFile, '<td HEIGHT="22" BACKGROUND="../images/verbar1.gif" NOSAVE><font face="Arial,Helvetica"><font color="#FFFFFF"><font size=-1>&nbsp;</font></font></font></td>');
        WriteLn(MyTextFile, '<td WIDTH="22" HEIGHT="22" BACKGROUND="../images/corner.gif" NOSAVE><font face="Arial,Helvetica"><font color="#FFFFFF"><font size=-1>&nbsp;</font></font></font></td>');
        WriteLn(MyTextFile, '</tr></table></center>');
// close up table

// finish the html off
        WriteLn(MyTextFile, '<font face="Arial,Helvetica"><font size=-1></font></font>');
        WriteLn(MyTextFile, '<br><font face="Arial,Helvetica"><font size=-1></font></font>&nbsp;');
        WriteLn(MyTextFile, '</body>');
        WriteLn(MyTextFile, '</html>');
// Tada! One inspection review!
     finally
            CloseFile(MyTextFile);
     end; {Rewrite(MyTextFile); .. try}
//     if tempi = -1 then
//        inc(i)
     {else }

end;//inspection

{***************************
 Creates MPQ CSS Reviews
****************************}
procedure DoReviewCSS(Rvw : array of TReview; sReviewer : String; i : integer);
{
 This mess of a procedure creates a review file.
 It first works out what called the procedure, which will either be the Quake or Quake 2 form.
 Now creates HTML files which use CSS.
}
var
   MyTextFile: TextFile;
   counter : integer;
begin


     AssignFile(MyTextFile, (Rvw[i].sDirTo + Rvw[i].sFileName + Rvw[i].sExtTo));
     Rewrite(MyTextFile);
     try
// Top bit. Standard file info
        WriteLn(MyTextFile, '<!doctype html public "-//w3c//dtd html 4.0 transitional//en">');
        WriteLn(MyTextFile, '<html><head>');
        WriteLn(MyTextFile, '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
        WriteLn(MyTextFile, '<meta name="Author" content="Paul Healey">');
        WriteLn(MyTextFile, '<meta name="GENERATOR" content="MPQ Input Version:' + VER + '">');
        if fmMain.CBYour.State = cbChecked then
           WriteLn(MyTextFile, '<title>Your Reviews</title>')
        else if fmMain.CBYour.State = cbUnChecked then
        begin
             if Rvw[i].Which = 1 then
                WriteLn(MyTextFile, '<title>Quake Reviews</title>')
             else if Rvw[i].Which = 2 then
                WriteLn(MyTextFile, '<title>Quake 2 Reviews</title>');
        end;
        WriteLn(MyTextFile, '<link rel=stylesheet href="review.css" type="text/css">');
        WriteLn(MyTextFile, '</head><body>');
        WriteLn(MyTextFile, '<body text="#FFFFFF" bgcolor="#000000" link="#FF6600" vlink="#FF6600" alink="#FF0000">');
        WriteLn(MyTextFile, '<font face="Verdana,Arial,Helvetica" color="#FFFFFF" size=-1>');
        WriteLn(MyTextFile, '');

// Quake review logo
        if fmMain.CBYour.State = cbChecked then
           WriteLn(MyTextFile, '<div align=right><img SRC="yr.gif" NOSAVE height=50 width=325></div>')
        else if fmMain.CBYour.State = cbUnChecked then
        begin
             if Rvw[i].Which = 1 then
                WriteLn(MyTextFile, '<div align=right><img SRC="q1.gif" NOSAVE height=50 width=150></div>')
             else if Rvw[i].Which = 2 then
             WriteLn(MyTextFile, '<div align=right><img SRC="q2.gif" NOSAVE height=50 width=160></div>');
        end;

        WriteLn(MyTextFile, '<center><table BORDER=0 CELLSPACING=0 CELLPADDING=0 COLS=1 WIDTH="100%" BGCOLOR="#21428C" >');
        WriteLn(MyTextFile, '<tr><td>');
        WriteLn(MyTextFile, '<b CLASS="mapname">');
// Map Name
        WriteLn(MyTextFile, Rvw[i].sMapName);
        WriteLn(MyTextFile, '</b>');
// File Size
        WriteLn(MyTextFile, '<b CLASS=filesize>');
        WriteLn(MyTextFile, '(' + Rvw[i].sFileSize + 'kb)');
        WriteLn(MyTextFile, '</b>');
// Author Name
        WriteLn(MyTextFile, '<b CLASS=author>');
        WriteLn(MyTextFile, 'by ' + Rvw[i].sAuthor);
        WriteLn(MyTextFile, '</code>');
        WriteLn(MyTextFile, '</td></tr></table></center>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<b CLASS=players>');
//Number of players
        WriteLn(MyTextFile, Rvw[i].sPlayers);
        WriteLn(MyTextFile, '</b><br>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<b CLASS=review>');
// Print out review
        for counter := 0 to Rvw[i].nolines do
        begin
             if Rvw[i].arrReview[counter] = '' then
             begin
// If its a blank line in the review do <p> next paragraph
                  WriteLn(MyTextFile, '<p>');
             end
             else
             WriteLn(MyTextFile, Rvw[i].arrReview[counter]);
        end;

        WriteLn(MyTextFile, '<br>');
        WriteLn(MyTextFile, '');
        WriteLn(MyTextFile, sReviewer);
        WriteLn(MyTextFile, '</b>');

        if Rvw[i].which = 2 then
        begin
// Review score for Quake 2 review
// Grade logo
         Write(MyTextFile, '<DIV ALIGN=right><IMG SRC="grade.gif" NOSAVE HEIGHT=50 WIDTH=150>');
//letter
         if Rvw[i].sScore = 'A' then //A
           Write(MyTextFile, '<IMG SRC="a.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'B' then //B
           Write(MyTextFile, '<IMG SRC="b.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'C' then //C
           Write(MyTextFile, '<IMG SRC="c.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'D' then //D
           Write(MyTextFile, '<IMG SRC="d.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'E' then //E
           Write(MyTextFile, '<IMG SRC="e.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>')
         else if Rvw[i].sScore = 'F' then //F
           Write(MyTextFile, '<IMG SRC="f.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>');

//sign, if needed
         if Rvw[i].sSign = '-' then //- sign
         begin
           Write(MyTextFile, '<IMG SRC="-.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>');
           WriteLn(MyTextFile, '</DIV>');
           end
         else if Rvw[i].sSign = '+' then //+ sign
         begin
           Write(MyTextFile, '<IMG SRC="+.gif" NOSAVE BORDER=0 HEIGHT=50 WIDTH=50>');
           WriteLn(MyTextFile, '</DIV>');
         end
         else if Rvw[i].sSign = 'Blank' then //
         begin
            WriteLn(MyTextFile, '</DIV>');
         end;
         WriteLn(MyTextFile, '');
        end; {if which = 2 then}

        WriteLn(MyTextFile, '<table BORDER=0 CELLSPACING=0 CELLPADDING=2 COLS=2 WIDTH="100%" BGCOLOR="#333333" >');
        WriteLn(MyTextFile, '<tr><td><center><b CLASS=link>');
        if Rvw[i].sCaption1 = '' then
           WriteLn(MyTextFile, 'Click for larger image.')
        else
           WriteLn(MyTextFile, Rvw[i].sCaption1);

        WriteLn(MyTextFile, '</b><br>');
        WriteLn(MyTextFile, '');
// 1st set of Images
        WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge1 + '" target="_parent"><img SRC="' + Rvw[i].sSmall1 + '" NOSAVE BORDER=0 height=150 width=200></a></center></td>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<td><center><b CLASS=link>');
// 2nd set of Images
// Theres not always a second image so give blank text!
        if Rvw[i].sLarge2 = '' then
        begin
             WriteLn(MyTextFile, 'No second image.</b><br></center></td></tr>');
        end
        else
        begin
             if Rvw[i].sCaption2 = '' then
                WriteLn(MyTextFile, 'Click for larger image.</b><br>')
             else
                 WriteLn(MyTextFile, Rvw[i].sCaption2 + '</b><br>');
             WriteLn(MyTextFile, '<a href="' + Rvw[i].sLarge2 + '" target="_parent"><img SRC="' + Rvw[i].sSmall2 + '" NOSAVE BORDER=0 height=150 width=200></a></center></td></tr>');
        end;
        WriteLn(MyTextFile, '');
// Download link
        WriteLn(MyTextFile, '<tr><td><center>');
        WriteLn(MyTextFile, '<a href="' + Rvw[i].sDownload + '">Download it!</a>');
        WriteLn(MyTextFile, '');

// Author Email address for a Quake review
        if Rvw[i].which = 1 then
        begin
           WriteLn(MyTextFile, '<br>');
           WriteLn(MyTextFile, '<a href="mailto:' + Rvw[i].sAuthorEmail + '">Email the Author</a>');
           WriteLn(MyTextFile, '');
        end;
// Author Website

        if (StrComp(PChar(Rvw[i].sAuthorweb),  '') > 0) then
        begin
             WriteLn(MyTextFile, '<br>');
           WriteLn(MyTextFile, '<a href="' + Rvw[i].sAuthorweb + '" target="_parent">Visit the Authors Website</a>');
        end;
        WriteLn(MyTextFile, '</center></td>');
        WriteLn(MyTextFile, '');

        WriteLn(MyTextFile, '<td><center>');
// if its a Quake 2 review then we put the authors email address the end column, otherwises it would be empty
        if Rvw[i].which = 2 then
        begin
           WriteLn(MyTextFile, '<center>');
           WriteLn(MyTextFile, '<a href="mailto:' + Rvw[i].sAuthorEmail + '">Email the Author</a></font></font></font></b></center>');
           WriteLn(MyTextFile, '');
        end;

//Review score for Quake review
        if Rvw[i].which = 1 then
        begin
             if Rvw[i].sScore = '0.5' then //0.5
                WriteLn(MyTextFile, '<img SRC="halfstarsolo.gif" height=45 width=28>')
             else if Rvw[i].sScore = '1.0' then //1.0
                  WriteLn(MyTextFile, '<img SRC="fullstarsolo.gif" height=45 width=39>')
             else if Rvw[i].sScore = '1.5' then //1.5
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="halfstarright.gif" NOSAVE height=45 width=24>')
             else if Rvw[i].sScore = '2.0' then //2.0
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarright.gif" NOSAVE height=45 width=35>')
             else if Rvw[i].sScore = '2.5' then //2.5
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="halfstarright.gif" NOSAVE height=45 width=24>')
             else if Rvw[i].sScore = '3.0' then //3.0
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarright.gif" NOSAVE height=45 width=35>')
             else if Rvw[i].sScore = '3.5' then //3.5
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="halfstarright.gif" NOSAVE height=45 width=24>')
             else if Rvw[i].sScore = '4.0' then //4.0
                  WriteLn(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarright.gif" NOSAVE height=45 width=35>')
//max limit of 255 characters a string so I've had to split the line up.
            else if Rvw[i].sScore = '4.5' then //4.5
            begin
                 Write(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30>');
                 WriteLn(MyTextFile, '<img SRC="halfstarright.gif" NOSAVE height=45 width=24>');
            end
            else if Rvw[i].sScore = '5.0' then //5.0
            begin
                 Write(MyTextFile, '<img SRC="fullstarleft.gif" height=45 width=35><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30><img SRC="fullstarcenter.gif" NOSAVE height=45 width=30>');
                 WriteLn(MyTextFile, '<img SRC="fullstarright.gif" NOSAVE height=45 width=35>');
            end; {if sScore = '0.5' then}
            WriteLn(MyTextFile, '');
        end; {if which = 1}

        WriteLn(MyTextFile, '</center></td></tr></table>');
        WriteLn(MyTextFile, '</font><br>');
        WriteLn(MyTextFile, '</body></html>');
     finally
            CloseFile(MyTextFile);
     end; {Rewrite(MyTextFile); .. try}
//     if tempi = -1 then
//        inc(i)
     {else }
end;

procedure GiveIt(which : integer);
{
 This produces the quick list of reviews done on the Reviews Done screen
}
var
   counter, counter2 : integer;
   sOutput, sTemp : string;
begin
        counter2 := 0;
        for counter := 0 to MAX do
        begin
            iOut1[counter] := -1;
            iOut2[counter] := -1;
            iOut3[counter] := -1;
        end;
{ go through all the records... }
        for counter := 0 to MAX do
        begin
             if which = 1 then
             begin
                  iOut1[counter2] := counter;
                  Str((counter2 + 1), sTemp); //numbered list.
                  if Rvw1[Counter].Date <> '' then
                  begin
                       sOutput := sTemp + '. ' + Rvw1[Counter].Date + ' - ' + Rvw1[Counter].Time + ' : ' + Rvw1[Counter].sMapName + ' by ' + Rvw1[Counter].sAuthor;
                       fmOldRvw.ListBox1.Items.Add(sOutput);
                       inc(Counter2);
                  end;

             end
             else if which = 2 then
             begin
                  iOut2[counter2] := counter;
                  Str((counter2 + 1), sTemp); //numbered list.
                  if Rvw2[Counter].Date <> '' then
                  begin
                       sOutput := sTemp + '. ' + Rvw2[Counter].Date + ' - ' + Rvw2[Counter].Time + ' : ' + Rvw2[Counter].sMapName + ' by ' + Rvw2[Counter].sAuthor;
                       fmOldRvw.ListBox1.Items.Add(sOutput);
                       inc(Counter2);
                  end;
             end
             else if which = 5 then
             begin
                  iOut3[counter2] := counter;
                  Str((counter2 + 1), sTemp); //numbered list.
                  if Rvw3[Counter].Date <> '' then
                  begin
                       sOutput := sTemp + '. ' + Rvw3[Counter].Date + ' - ' + Rvw3[Counter].Time + ' : ' + Rvw3[Counter].sMapName + ' by ' + Rvw3[Counter].sAuthor;
                       fmOldRvw.ListBox1.Items.Add(sOutput);
                       inc(Counter2);
                  end;
             end;

{ if the which value (game type) matches the one inputted then print quick list}
        end;
end;

procedure RetrieveReview(which : integer);
{
 When you double click or click on the copy review button this retrieves the review from the array of them
 and copies them to the screen.
}
var
   counter : integer;
begin
     x1 := fmOldRvw.ListBox1.ItemIndex;
     x2 := fmOldRvw.ListBox1.ItemIndex;
     x3 := fmOldRvw.ListBox1.ItemIndex;
     if which = 1 then
     begin
        fmQuake.txtDirTo.text := '';
        fmQuake.txtExtTo.text := '';
        fmQuake.txtFileName.text := Rvw1[x1].sFileName;
        fmQuake.txtDirTo.text := Rvw1[x1].sDirTo;
        fmQuake.txtExtTo.text := Rvw1[x1].sExtTo;
        fmQuake.txtMapName.text := Rvw1[x1].sMapName;
        fmQuake.txtAuthor.text := Rvw1[x1].sAuthor;
        fmQuake.txtFileSize.text := Rvw1[x1].sFileSize;
        fmQuake.txtPlayers.text := Rvw1[x1].sPlayers;
        fmQuake.ReviewMemo.Clear;
        for counter := 0 to Rvw1[x1].nolines do
        begin
             fmQuake.ReviewMemo.Lines.Add(Rvw1[x1].arrReview[counter]);
        end;
        fmQuake.txtCaption1.text := Rvw1[x1].sCaption1;
        fmQuake.txtCaption2.text := Rvw1[x1].sCaption2;
        fmQuake.txtSmall1.text := Rvw1[x1].sSmall1;
        fmQuake.txtLarge1.text := Rvw1[x1].sLarge1;
        fmQuake.txtSmall2.text := Rvw1[x1].sSmall2;
        fmQuake.txtLarge2.text := Rvw1[x1].sLarge2;
        fmQuake.txtAuthorEmail.text := Rvw1[x1].sAuthorEmail;
        fmQuake.txtAuthorWeb.text := Rvw1[x1].sAuthorWeb;
        fmQuake.txtDownload.text := Rvw1[x1].sDownload;
        fmQuake.ComboBox1.ItemIndex :=  Rvw1[x1].iIndex1;
     end
     else if which = 2 then
     begin
        fmQuake2.txtFileName.text := Rvw2[x2].sFileName;
        fmQuake2.txtDirTo.text := Rvw2[x2].sDirTo;
        fmQuake2.txtExtTo.text := Rvw2[x2].sExtTo;
        fmQuake2.txtMapName.text := Rvw2[x2].sMapName;
        fmQuake2.txtAuthor.text := Rvw2[x2].sAuthor;
        fmQuake2.txtFileSize.text := Rvw2[x2].sFileSize;
        fmQuake2.txtPlayers.text := Rvw2[x2].sPlayers;
        fmQuake2.ReviewMemo.Clear;
        for counter := 0 to Rvw2[x2].nolines do
        begin
             fmQuake2.ReviewMemo.Lines.Add(Rvw2[x2].arrReview[counter]);
        end;
        fmQuake2.txtCaption1.text := Rvw2[x2].sCaption1;
        fmQuake2.txtCaption2.text := Rvw2[x2].sCaption2;
        fmQuake2.txtSmall1.text := Rvw2[x2].sSmall1;
        fmQuake2.txtLarge1.text := Rvw2[x2].sLarge1;
        fmQuake2.txtSmall2.text := Rvw2[x2].sSmall2;
        fmQuake2.txtLarge2.text := Rvw2[x2].sLarge2;
        fmQuake2.txtAuthorEmail.text := Rvw2[x2].sAuthorEmail;
        fmQuake.txtAuthorWeb.text := Rvw2[x2].sAuthorWeb;
        fmQuake2.txtDownload.text := Rvw2[x2].sDownload;
        fmQuake2.ComboBox1.ItemIndex :=  Rvw2[x2].iIndex1;
        fmQuake2.ComboBox2.ItemIndex :=  Rvw2[x2].iIndex2;
     end
     else if which = 5 then
     begin
        fmInspection.txtFileName.text := Rvw3[x3].sFileName;
        fmInspection.txtDirTo.text := Rvw3[x3].sDirTo;
        fmInspection.txtExtTo.text := Rvw3[x3].sExtTo;
        fmInspection.txtMapName.text := Rvw3[x3].sMapName;
        fmInspection.txtAuthor.text := Rvw3[x3].sAuthor;
        fmInspection.txtFileSize.text := Rvw3[x3].sFileSize;
        fmInspection.txtPlayers.text := Rvw3[x3].sPlayers;
        fmInspection.txtReviewer.text := Rvw3[x3].sReviewer;
        fmInspection.ExcessusMemo.Clear;
        for counter := 0 to Rvw3[x3].nolines7 do
        begin
              fmInspection.ExcessusMemo.Lines.Add(Rvw3[x3].arrExcessus[counter]);
        end;
        fmInspection.AuthorMemo.Clear;
        for counter := 0 to Rvw3[x3].nolines do
        begin
              fmInspection.AuthorMemo.Lines.Add(Rvw3[x3].arrAuthor[counter]);
        end;
        fmInspection.ArchMemo.Clear;
        for counter := 0 to Rvw3[x3].nolines2 do
        begin
             fmInspection.ArchMemo.Lines.Add(Rvw3[x3].arrArch[counter]);
        end;
        fmInspection.TexMemo.Clear;
        for counter := 0 to Rvw3[x3].nolines3 do
        begin
             fmInspection.TexMemo.Lines.Add(Rvw3[x3].arrTex[counter]);
        end;
        fmInspection.WalkMemo.Clear;
        for counter := 0 to Rvw3[x3].nolines4 do
        begin
              fmInspection.WalkMemo.Lines.Add(Rvw3[x3].arrWalk[counter]);
        end;
        fmInspection.GameplayMemo.Clear;
        for counter := 0 to Rvw3[x3].nolines5 do
        begin
              fmInspection.GameplayMemo.Lines.Add(Rvw3[x3].arrGameplay[counter]);
        end;
        fmInspection.ConclusionMemo.Clear;
        for counter := 0 to Rvw3[x3].nolines6 do
        begin
             fmInspection.ConclusionMemo.Lines.Add(Rvw3[x3].arrConclusion[counter]);
        end;

        fmInspection.txtCaption1.text := Rvw3[x3].sCaption1;
        fmInspection.txtCaption2.text := Rvw3[x3].sCaption2;
        fmInspection.txtCaption3.text := Rvw3[x3].sCaption3;
        fmInspection.txtCaption4.text := Rvw3[x3].sCaption4;

        fmInspection.txtSmall1.text := Rvw3[x3].sSmall1;
        fmInspection.txtLarge1.text := Rvw3[x3].sLarge1;
        fmInspection.txtSmall2.text := Rvw3[x3].sSmall2;
        fmInspection.txtLarge2.text := Rvw3[x3].sLarge2;
        fmInspection.txtSmall3.text := Rvw3[x3].sSmall3;
        fmInspection.txtLarge3.text := Rvw3[x3].sLarge3;
        fmInspection.txtSmall4.text := Rvw3[x3].sSmall4;
        fmInspection.txtLarge4.text := Rvw3[x3].sLarge4;

        fmInspection.txtAuthorEmail.text := Rvw3[x3].sAuthorEmail;
        fmInspection.txtAuthorWeb.text := Rvw3[x3].sAuthorWeb;
        fmInspection.txtDownload.text := Rvw3[x3].sDownload;
        fmInspection.cbReview.ItemIndex := Rvw3[x3].iIndex1;
//        Rvw3[i3].sScore := fmInspection.cbReview.Items[fmInspection.cbReview.ItemIndex];
//        Rvw3[i3].Time := TimeToStr(Time);
//        Rvw3[i3].Date := DateToStr(Date);
        end;
end;

procedure SaveSession(which : integer);
{
 This procedure saves the session of reviews.
 It can either append it to an existing DAT file or create a new file. (overwrite)
 The DAT files are just text files.
}
var
   MyTextFile: TextFile;
   sSessionName : string;
   z, counter, counter2, counter3 : integer;
begin

{ We need to work out which reviews in the array of review records are of type which
  1 = Quake, 2 = Quake 2, 5 = Inspection
  The code below just runs through the array of reviews and copies the array positions to
  iOut if which matches. }

     for counter := 0 to MAX do
     begin
         iOut1[counter] := -1;
         iOut2[counter] := -1;
         iOut3[counter] := -1;
     end;

     counter2 := 0;
     for counter := 0 to MAX do
     begin
          if Rvw1[counter].which = which then
          begin
               iOut1[counter2] := counter;
               inc(Counter2);
          end;
     end;
     counter2 := 0;
     for counter := 0 to MAX do
     begin
          if Rvw2[counter].which = which then
          begin
               iOut2[counter2] := counter;
               inc(Counter2);
          end;
     end;

     counter2 := 0;
     for counter := 0 to MAX do
     begin
          if Rvw3[counter].which = which then
          begin
               iOut3[counter2] := counter;
               inc(Counter2);
          end;
     end;

{ Setup name for file }
     z := 0;
     if which = 1 then
        sSessionName := 'Quake.DAT'
     else if which = 2 then
          sSessionName := 'Quake2.DAT'
     else if which = 5 then
          sSessionName := 'Inspection.DAT';

     AssignFile(MyTextFile, sSessionName);

//     if (fmOldRvw.RadioButton1.Checked = True) and FileExists(sSessionName) then
//        Append(MyTextFile)
//     else
{ We just rewrite the file every time, I can't think why you'd want to append a session}
     Rewrite(MyTextFile);
     try
        if which = 1 then
        begin
           while iOut1[z] <> -1 do
           begin

                  WriteLn(MyTextFile, Rvw1[z].Which);
                  WriteLn(MyTextFile, Rvw1[z].sFileName);
                  WriteLn(MyTextFile, Rvw1[z].sDirTo);
                  WriteLn(MyTextFile, Rvw1[z].sExtTo);
                  WriteLn(MyTextFile, Rvw1[z].sMapName);
                  WriteLn(MyTextFile, Rvw1[z].sAuthor);
                  WriteLn(MyTextFile, Rvw1[z].sFileSize);
                  WriteLn(MyTextFile, Rvw1[z].sPlayers);
                  WriteLn(MyTextFile, Rvw1[z].nolines);
                  for counter := 0 to Rvw1[z].nolines do
                  begin
                       WriteLn(MyTextFile, Rvw1[z].arrReview[counter]);
                  end;
                  WriteLn(MyTextFile, Rvw1[z].sCaption1);
                  WriteLn(MyTextFile, Rvw1[z].sCaption2);
                  WriteLn(MyTextFile, Rvw1[z].sSmall1);
                  WriteLn(MyTextFile, Rvw1[z].sLarge1);
                  WriteLn(MyTextFile, Rvw1[z].sSmall2);
                  WriteLn(MyTextFile, Rvw1[z].sLarge2);
                  WriteLn(MyTextFile, Rvw1[z].sAuthorEmail);
                  WriteLn(MyTextFile, Rvw1[z].sAuthorWeb);
                  WriteLn(MyTextFile, Rvw1[z].sDownload);
                  WriteLn(MyTextFile, Rvw1[z].sScore);
                  WriteLn(MyTextFile, Rvw1[z].iIndex1);
                  WriteLn(MyTextFile, Rvw1[z].Time);
                  WriteLn(MyTextFile, Rvw1[z].Date);
                  inc(z);
             end;

        end;

        if which = 2 then
        begin
             while iOut2[z] <> -1 do
             begin
{ Print out the Quake 2 review }
                  WriteLn(MyTextFile, Rvw2[z].Which);
                  WriteLn(MyTextFile, Rvw2[z].sFileName);
                  WriteLn(MyTextFile, Rvw2[z].sDirTo);
                  WriteLn(MyTextFile, Rvw2[z].sExtTo);
                  WriteLn(MyTextFile, Rvw2[z].sMapName);
                  WriteLn(MyTextFile, Rvw2[z].sAuthor);
                  WriteLn(MyTextFile, Rvw2[z].sFileSize);
                  WriteLn(MyTextFile, Rvw2[z].sPlayers);
                  WriteLn(MyTextFile, Rvw2[z].nolines);
                  for counter := 0 to Rvw2[z].nolines do
                  begin
                       WriteLn(MyTextFile, Rvw2[z].arrReview[counter]);
                  end;
                  WriteLn(MyTextFile, Rvw2[z].sCaption1);
                  WriteLn(MyTextFile, Rvw2[z].sCaption2);
                  WriteLn(MyTextFile, Rvw2[z].sSmall1);
                  WriteLn(MyTextFile, Rvw2[z].sLarge1);
                  WriteLn(MyTextFile, Rvw2[z].sSmall2);
                  WriteLn(MyTextFile, Rvw2[z].sLarge2);
                  WriteLn(MyTextFile, Rvw2[z].sAuthorEmail);
                  WriteLn(MyTextFile, Rvw2[z].sAuthorWeb);
                  WriteLn(MyTextFile, Rvw2[z].sDownload);
                  WriteLn(MyTextFile, Rvw2[z].sScore);
                  WriteLn(MyTextFile, Rvw2[z].sSign);
                  WriteLn(MyTextFile, Rvw2[z].iIndex1);
                  WriteLn(MyTextFile, Rvw2[z].iIndex2);
                  WriteLn(MyTextFile, Rvw2[z].Time);
                  WriteLn(MyTextFile, Rvw2[z].Date);
                  inc(z);
             end;
        end; {while iOut[counter] <> -1 do}

        if which = 5 then
        begin
             while iOut3[z] <> -1 do
             begin
                  WriteLn(MyTextFile, Rvw3[z].which);
                  WriteLn(MyTextFile, Rvw3[z].sFileName);
                  WriteLn(MyTextFile, Rvw3[z].sDirTo);
                  WriteLn(MyTextFile, Rvw3[z].sExtTo);
                  WriteLn(MyTextFile, Rvw3[z].sMapName);
                  WriteLn(MyTextFile, Rvw3[z].sAuthor);
                  WriteLn(MyTextFile, Rvw3[z].sFileSize);

                  WriteLn(MyTextFile, Rvw3[z].nolines7);
                  for counter := 0 to Rvw3[z].nolines7 do
                  begin
                       WriteLn(MyTextFile, Rvw3[z].arrExcessus[counter]);
                  end;
                  WriteLn(MyTextFile, Rvw3[z].nolines);
                  for counter := 0 to Rvw3[z].nolines do
                  begin
                       WriteLn(MyTextFile, Rvw3[z].arrAuthor[counter]);
                  end;
                  WriteLn(MyTextFile, Rvw3[z].nolines2);
                  for counter := 0 to Rvw3[z].nolines2 do
                  begin
                       WriteLn(MyTextFile, Rvw3[z].arrArch[counter]);
                  end;

                  WriteLn(MyTextFile, Rvw3[z].nolines3);
                  for counter := 0 to Rvw3[z].nolines3 do
                  begin
                       WriteLn(MyTextFile, Rvw3[z].arrTex[counter]);
                  end;

                  WriteLn(MyTextFile, Rvw3[z].nolines4);
                  for counter := 0 to Rvw3[z].nolines4 do
                  begin
                       WriteLn(MyTextFile, Rvw3[z].arrWalk[counter]);
                  end;

                  WriteLn(MyTextFile, Rvw3[z].nolines5);
                  for counter := 0 to Rvw3[z].nolines5 do
                  begin
                       WriteLn(MyTextFile, Rvw3[z].arrGameplay[counter]);
                  end;

                  WriteLn(MyTextFile, Rvw3[z].nolines6);
                  for counter := 0 to Rvw3[z].nolines6 do
                  begin
                       WriteLn(MyTextFile, Rvw3[z].arrConclusion[counter]);
                  end;

                  WriteLn(MyTextFile, Rvw3[z].sCaption1);
                  WriteLn(MyTextFile, Rvw3[z].sCaption2);
                  WriteLn(MyTextFile, Rvw3[z].sCaption3);
                  WriteLn(MyTextFile, Rvw3[z].sCaption4);
                  WriteLn(MyTextFile, Rvw3[z].sSmall1);
                  WriteLn(MyTextFile, Rvw3[z].sLarge1);
                  WriteLn(MyTextFile, Rvw3[z].sSmall2);
                  WriteLn(MyTextFile, Rvw3[z].sLarge2);
                  WriteLn(MyTextFile, Rvw3[z].sSmall3);
                  WriteLn(MyTextFile, Rvw3[z].sLarge3);
                  WriteLn(MyTextFile, Rvw3[z].sSmall4);
                  WriteLn(MyTextFile, Rvw3[z].sLarge4);
                  WriteLn(MyTextFile, Rvw3[z].sAuthorEmail);
                  WriteLn(MyTextFile, Rvw3[z].sAuthorWeb);
                  WriteLn(MyTextFile, Rvw3[z].sDownload);
                  WriteLn(MyTextFile, Rvw3[z].iIndex1);
                  WriteLn(MyTextFile, Rvw3[z].sScore);
                  WriteLn(MyTextFile, Rvw3[z].Time);
                  WriteLn(MyTextFile, Rvw3[z].Date);
                  WriteLn(MyTextFile, Rvw3[z].sPlayers);
                  WriteLn(MyTextFile, Rvw3[z].sReviewer);
                  inc(z);
             end;
        end; {while iOut[counter] <> -1 do}



     finally
            CloseFile(MyTextFile);
     end;
end;

procedure LoadSession;
{
 When the program boots up we read in all the stored reviews from the DAT files
 If the files don't exist it doesn't bother, for obvious reasons!
}
var
   MyTextFile: TextFile;
   sSessionName : string;
   counter : integer;
begin
     i1 := 0;
     sSessionName := 'Quake.DAT';
     if FileExists(sSessionName) then
     begin

          AssignFile(MyTextFile, sSessionName);
          Reset(MyTextFile);
          try
             while not eof(MyTextFile) do
             begin
                  ReadLn(MyTextFile, Rvw1[i1].Which);
                  ReadLn(MyTextFile, Rvw1[i1].sFileName);
                  ReadLn(MyTextFile, Rvw1[i1].sDirTo);
                  ReadLn(MyTextFile, Rvw1[i1].sExtTo);
                  ReadLn(MyTextFile, Rvw1[i1].sMapName);
                  ReadLn(MyTextFile, Rvw1[i1].sAuthor);
                  ReadLn(MyTextFile, Rvw1[i1].sFileSize);
                  ReadLn(MyTextFile, Rvw1[i1].sPlayers);
                  ReadLn(MyTextFile, Rvw1[i1].nolines);
                  for counter := 0 to Rvw1[i1].nolines do
                  begin
                       ReadLn(MyTextFile, Rvw1[i1].arrReview[counter]);
                  end;
                  ReadLn(MyTextFile, Rvw1[i1].sCaption1);
                  ReadLn(MyTextFile, Rvw1[i1].sCaption2);
                  ReadLn(MyTextFile, Rvw1[i1].sSmall1);
                  ReadLn(MyTextFile, Rvw1[i1].sLarge1);
                  ReadLn(MyTextFile, Rvw1[i1].sSmall2);
                  ReadLn(MyTextFile, Rvw1[i1].sLarge2);
                  ReadLn(MyTextFile, Rvw1[i1].sAuthorEmail);
                  ReadLn(MyTextFile, Rvw1[i1].sAuthorWeb);
                  ReadLn(MyTextFile, Rvw1[i1].sDownload);
                  ReadLn(MyTextFile, Rvw1[i1].sScore);
                  ReadLn(MyTextFile, Rvw1[i1].iIndex1);
                  ReadLn(MyTextFile, Rvw1[i1].Time);
                  ReadLn(MyTextFile, Rvw1[i1].Date);
                  inc(i1);
             end;
          finally
            what1 := true;
            CloseFile(MyTextFile);
          end; {try}
     end; {if FileExists(sSessionName) then}      {Quake.DAT}

     i2 := 0;
     sSessionName := 'Quake2.DAT';
     if FileExists(sSessionName) then
     begin

          AssignFile(MyTextFile, sSessionName);
          Reset(MyTextFile);
          try
             while not eof(MyTextFile) do
             begin
                  ReadLn(MyTextFile, Rvw2[i2].Which);
                  ReadLn(MyTextFile, Rvw2[i2].sFileName);
                  ReadLn(MyTextFile, Rvw2[i2].sDirTo);
                  ReadLn(MyTextFile, Rvw2[i2].sExtTo);
                  ReadLn(MyTextFile, Rvw2[i2].sMapName);
                  ReadLn(MyTextFile, Rvw2[i2].sAuthor);
                  ReadLn(MyTextFile, Rvw2[i2].sFileSize);
                  ReadLn(MyTextFile, Rvw2[i2].sPlayers);
                  ReadLn(MyTextFile, Rvw2[i2].nolines);
                  for counter := 0 to Rvw2[i2].nolines do
                  begin
                       ReadLn(MyTextFile, Rvw2[i2].arrReview[counter]);
                  end;
                  ReadLn(MyTextFile, Rvw2[i2].sCaption1);
                  ReadLn(MyTextFile, Rvw2[i2].sCaption2);
                  ReadLn(MyTextFile, Rvw2[i2].sSmall1);
                  ReadLn(MyTextFile, Rvw2[i2].sLarge1);
                  ReadLn(MyTextFile, Rvw2[i2].sSmall2);
                  ReadLn(MyTextFile, Rvw2[i2].sLarge2);
                  ReadLn(MyTextFile, Rvw2[i2].sAuthorEmail);
                  ReadLn(MyTextFile, Rvw2[i2].sAuthorWeb);
                  ReadLn(MyTextFile, Rvw2[i2].sDownload);
                  ReadLn(MyTextFile, Rvw2[i2].sScore);
                  ReadLn(MyTextFile, Rvw2[i2].sSign);
                  ReadLn(MyTextFile, Rvw2[i2].iIndex1);
                  ReadLn(MyTextFile, Rvw2[i2].iIndex2);
                  ReadLn(MyTextFile, Rvw2[i2].Time);
                  ReadLn(MyTextFile, Rvw2[i2].Date);
                  inc(i2);
             end;
             finally
            what2 := true;
            CloseFile(MyTextFile);
          end; {try}
     end; {if FileExists(sSessionName) then}      {Quake2.DAT}

     i3 := 0;
     sSessionName := 'Inspection.DAT';
     if FileExists(sSessionName) then
     begin

          AssignFile(MyTextFile, sSessionName);
          Reset(MyTextFile);
          try
             while not eof(MyTextFile) do
             begin
                  ReadLn(MyTextFile, Rvw3[i3].which);
                  ReadLn(MyTextFile, Rvw3[i3].sFileName);
                  ReadLn(MyTextFile, Rvw3[i3].sDirTo);
                  ReadLn(MyTextFile, Rvw3[i3].sExtTo);
                  ReadLn(MyTextFile, Rvw3[i3].sMapName);
                  ReadLn(MyTextFile, Rvw3[i3].sAuthor);
                  ReadLn(MyTextFile, Rvw3[i3].sFileSize);

                  ReadLn(MyTextFile, Rvw3[i3].nolines7);
                  for counter := 0 to Rvw3[i3].nolines7 do
                  begin
                       ReadLn(MyTextFile, Rvw3[i3].arrExcessus[counter]);
                  end;

                  ReadLn(MyTextFile, Rvw3[i3].nolines);
                  for counter := 0 to Rvw3[i3].nolines do
                  begin
                       ReadLn(MyTextFile, Rvw3[i3].arrAuthor[counter]);
                  end;
                  ReadLn(MyTextFile, Rvw3[i3].nolines2);
                  for counter := 0 to Rvw3[i3].nolines2 do
                  begin
                       ReadLn(MyTextFile, Rvw3[i3].arrArch[counter]);
                  end;

                  ReadLn(MyTextFile, Rvw3[i3].nolines3);
                  for counter := 0 to Rvw3[i3].nolines3 do
                  begin
                       ReadLn(MyTextFile, Rvw3[i3].arrTex[counter]);
                  end;

                  ReadLn(MyTextFile, Rvw3[i3].nolines4);
                  for counter := 0 to Rvw3[i3].nolines4 do
                  begin
                       ReadLn(MyTextFile, Rvw3[i3].arrWalk[counter]);
                  end;

                  ReadLn(MyTextFile, Rvw3[i3].nolines5);
                  for counter := 0 to Rvw3[i3].nolines5 do
                  begin
                       ReadLn(MyTextFile, Rvw3[i3].arrGameplay[counter]);
                  end;

                  ReadLn(MyTextFile, Rvw3[i3].nolines6);
                  for counter := 0 to Rvw3[i3].nolines6 do
                  begin
                       ReadLn(MyTextFile, Rvw3[i3].arrConclusion[counter]);
                  end;

                  ReadLn(MyTextFile, Rvw3[i3].sCaption1);
                  ReadLn(MyTextFile, Rvw3[i3].sCaption2);
                  ReadLn(MyTextFile, Rvw3[i3].sCaption3);
                  ReadLn(MyTextFile, Rvw3[i3].sCaption4);
                  ReadLn(MyTextFile, Rvw3[i3].sSmall1);
                  ReadLn(MyTextFile, Rvw3[i3].sLarge1);
                  ReadLn(MyTextFile, Rvw3[i3].sSmall2);
                  ReadLn(MyTextFile, Rvw3[i3].sLarge2);
                  ReadLn(MyTextFile, Rvw3[i3].sSmall3);
                  ReadLn(MyTextFile, Rvw3[i3].sLarge3);
                  ReadLn(MyTextFile, Rvw3[i3].sSmall4);
                  ReadLn(MyTextFile, Rvw3[i3].sLarge4);
                  ReadLn(MyTextFile, Rvw3[i3].sAuthorEmail);
                  ReadLn(MyTextFile, Rvw3[i3].sAuthorWeb);
                  ReadLn(MyTextFile, Rvw3[i3].sDownload);
                  ReadLn(MyTextFile, Rvw3[i3].iIndex1);
                  ReadLn(MyTextFile, Rvw3[i3].sScore);
                  ReadLn(MyTextFile, Rvw3[i3].Time);
                  ReadLn(MyTextFile, Rvw3[i3].Date);
                  ReadLn(MyTextFile, Rvw3[i3].sPlayers);
                  ReadLn(MyTextFile, Rvw3[i3].sReviewer);
                  inc(i3);
             end;
             finally
            what3 := true;
            CloseFile(MyTextFile);
          end; {try}
     end; {if FileExists(sSessionName) then}      {Inspection.DAT}

// there is a reason for this, when the program loads you can automatically create a review.
//   inc(i);
end;

procedure CreateTableFile(Sender : TObject);
{
 This procedure creates the table file which you see on Quake review index page thingy bob
}
var
   counter, counter2, which : integer;
   MyTextFile : TextFile;
   Rvw : array [0..MAX] of TReview;
begin
     if FileExists('e:\mpq\news.htm') then
        AssignFile(MyTextFile, 'e:\mpq\review.htm')
     else
         AssignFile(MyTextFile, 'review.htm');

     Rewrite(MyTextFile);

     counter2 := 0;
     which := 0;

     if Sender = fmQuake.bnIndex then
     begin
        which := 1;
        for counter := 0 to MAX do
            Rvw[Counter] := Rvw1[Counter];
     end
     else if Sender = fmQuake2.bnIndex then
     begin
        which := 2;
        for counter := 0 to MAX do
            Rvw[Counter] := Rvw2[Counter];
     end;


// work out how many reviews there are
     for counter := 0 to MAX do
     begin
          if Rvw[counter].which = which then
             inc(Counter2);
     end;

     try
// standard page formatting crap, not really needed..
        WriteLn(MyTextFile, '<!doctype html public "-//w3c//dtd html 4.0 transitional//en">');
        WriteLn(MyTextFile, '<html><head>');
        WriteLn(MyTextFile, '<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
        WriteLn(MyTextFile, '<meta name="Author" content="Paul">');
        WriteLn(MyTextFile, '<meta name="GENERATOR" content="Mozilla/4.5 [en] (Win98; I) [Netscape]">');
        if Which = 1 then
           WriteLn(MyTextFile, '<title>Quake Review Index</title>')
        else if Which = 2 then
           WriteLn(MyTextFile, '<title>Quake 2 Review Index</title>');
        WriteLn(MyTextFile, '<style type="text/css"><!--A:link, A:visited, A:active {text-decoration: none} A:hover {text-decoration: underline}--></style>');
        WriteLn(MyTextFile, '</head><body text="#FFFFFF" bgcolor="#000000" link="#FF6600" vlink="#FF6600" alink="#FF0000">');

// start of the table
        WriteLn(MyTextFile, '<center><table BORDER=0 CELLSPACING=0 CELLPADDING=0 COLS=2 WIDTH="100%" BGCOLOR="#333333" >');
        WriteLn(MyTextFile, '<tr><td>');

// for the number of reviews create the table...
        for counter := 0 to (counter2 - 1) do
        begin
// do the left section of the table, which is the Map name and author
             if counter > 0 then
                WriteLn(MyTextFile, '<br>');
             WriteLn(MyTextFile, '<b><font face="Verdana"><font size=-1><font color="#FF6600">');
             Write(MyTextFile, '<a href="reviews/' + Rvw[counter].sFilename + Rvw[counter].sExtTo);
             Write(MyTextFile, '">' + Rvw[counter].sMapName + '</a></font><font color="#FFFFFF"> by ');
             WriteLn(MyTextFile, Rvw[counter].sAuthor + '</font></font></font></b>');
        end;
// end the left section of the table, and now start the right section
        if which = 1 then
           WriteLn(MyTextFile, '</td><td WIDTH="5%"><div align=right>')
        else if which = 2 then
           WriteLn(MyTextFile, '</td><td WIDTH="5%"><div align=left>');

        for counter := 0 to (counter2 - 1) do
        begin
             if counter > 0 then
                WriteLn(MyTextFile, '<br>');
// if its a Quake review then we print out the numbers
             if which = 1 then
             begin
                  Write(MyTextFile, '<b><font face="Verdana">');
// the font colour for a 5.0 is RED
                  if Rvw[counter].sScore = '5.0' then
                     Write(MyTextFile, '<font color="#FF0000">')
// the font colour for a 4.5 is ORANGE
                  else if Rvw[counter].sScore = '4.5' then
                     Write(MyTextFile, '<font color="#FF6600">')
// the font colour for a 4.0 is YELLOW
                  else if Rvw[counter].sScore = '4.0' then
                     Write(MyTextFile, '<font color="#FFFF00">')
// any score below 4.0 is in WHITE
                  else
                      Write(MyTextFile, '<font color="#FFFFFF">');

                  WriteLn(MyTextFile, '<font size=-1>' + Rvw[counter].sScore + '/5</font></font></font></b>');
             end;
// if its a Quake review then we print out the letter and sign
             if which = 2 then
             begin
                WriteLn(MyTextFile, '<b><font face="Verdana"><font color="#FFFFFF"><font size=-1>' + Rvw[counter].sScore + Rvw[counter].sSign + '</font></font></font></b>');
             end;
        end;

        WriteLn(MyTextFile, '</div></td></tr></table></center>');
        WriteLn(MyTextFile, '<font color="#000000">..</font></body></html>')
     finally
            CloseFile(MyTextFile);
     end; {try}

{
<center><table BORDER=0 CELLSPACING=0 CELLPADDING=0 COLS=2 WIDTH="100%" BGCOLOR="#333333" >
<tr>

<b><font face="Verdana"><font size=-1><font color="#FF6600">

<a href="Reviews/q-25-03-99-aard.htm#map1">Anticlan III</a></font>
<font color="#FFFFFF">by TiP</font></font></font></b>

<br><b><font face="Verdana"><font size=-1><font color="#FF6600"><a href="Reviews/q-25-03-99-aard.htm#map2">Da
Barrello</a> </font><font color="#FFFFFF">by _MadMax_</font></font></font></b>
<br><b><font face="Verdana"><font size=-1><font color="#FF6600"><a href="Reviews/q-25-03-99-aard.htm#map3">CDM2</a></font><font color="#FFFFFF">
by fasad</font></font></font></b>
<br><b><font face="Verdana"><font size=-1><font color="#FF6600"><a href="Reviews/q-25-03-99-aard.htm#map4">Embrion</a></font><font color="#FFFFFF">
by Andrzej "Dupeq" Lach</font></font></font></b>
<br><b><font face="Verdana"><font size=-1><font color="#FF6600"><a href="Reviews/q-25-03-99-aard.htm#map5">The
cLaW</a> </font><font color="#FFFFFF">by rocketman</font></font></font></b></td>

<td WIDTH="5%">
<div align=right>
<b><font face="Verdana"><font color="#FFFFFF"><font size=-1>3.0/5</font></font></font></b>
<br><b><font face="Verdana"><font color="#FFFFFF"><font size=-1>1.0/5</font></font></font></b>
<br><b><font face="Verdana"><font color="#FFFFFF"><font size=-1>3.5/5</font></font></font></b>
<br><b><font face="Verdana"><font color="#FFFFFF"><font size=-1>2.5/5</font></font></font></b>
<br><b><font face="Verdana"><font color="#FFFFFF"><font size=-1>2.0/5</font></font></font></b>
</div></td></tr></table></center>
}
end;

procedure ReviewPreview(Sender : TObject);
{
 Here we take the filename of the review and check if it exists.
 if it does we then execute Explorer with it.
 Explorer will then load up your default HTML browser with it(fingers crossed =P).
}
var
   sTempString, sFileName : string;
   SI: TStartupInfo;
   PI: TProcessInformation;
   WinDir : array[0..MAX] of Char;
begin

 if Sender = fmQuake.bnView then
      sFileName := fmQuake.txtDirTo.text + fmQuake.txtFileName.text + fmQuake.txtExtTo.text
 else if Sender = fmQuake2.bnView then
      sFileName := fmQuake2.txtDirTo.text + fmQuake2.txtFileName.text + fmQuake2.txtExtTo.text
 else if Sender = fmInspection.bnView then
      sFileName := fmInspection.txtDirTo.text + fmInspection.txtFileName.text + fmInspection.txtExtTo.text
 else if (Sender = fmQuake.bnIndex) or (Sender = fmQuake2.bnIndex) then
 begin
      if FileExists('e:\mpq\news.htm') then
         sFilename := 'e:\mpq\review.htm'
      else
      begin
         GetDir(0, sFilename);
         sFileName := sFileName + '\review.htm';
      end;
 end
 else
     exit;

 GetWindowsDirectory(WinDir, MAX);
 if FileExists(sFileName) then
 begin
      sTempString := WinDir + '\explorer.exe ' + sFileName;
      FillChar(SI, SizeOf(TStartUpInfo), 0);
      with SI do
      begin
           cb := SizeOf(TStartUpInfo);
           dwFlags := STARTF_USESHOWWINDOW;
           wShowWindow := SW_SHOWNORMAL;
      end;
      CreateProcess(nil, PChar(sTempString), nil, nil, False, NORMAL_PRIORITY_CLASS, nil, nil, SI, PI);
 end;

end;

procedure LoadUpIni;
{
 Procedure loads up the INI file.
 If it doesn't exist it creates one with default values.
}
var
   iTemp : integer;
begin
  IniName:= ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    fmMain.sDirToQuake := ReadString('Setup','SaveDirQuake','c:\temp\');
    fmMain.sDirToQuake2 := ReadString('Setup','SaveDirQuake2','c:\temp\');
    fmMain.sExtToQuake := ReadString('Setup','SaveExtQuake','.htm');
    fmMain.sExtToQuake2 := ReadString('Setup','SaveExtQuake2','.htm');
    fmMain.sReviewer := ReadString('Setup','SaveReviewer','<a href="mailto:yourname@planetquake.com">yourname</a>');
    iTemp :=  ReadInteger('Setup','SaveReviewType',1);
    if iTemp = 1 then
       fmMain.RBHTML.Checked := True
    else if iTemp = 2 then
       fmMain.RBCSS.Checked := True
    else
       fmMain.RBHTML.Checked := True;

    iTemp :=  ReadInteger('Setup','SaveYourReview',1);
    if iTemp = 1 then
       fmMain.CBYour.State := cbUnChecked
    else if iTemp = 2 then
       fmMain.CBYour.State := cbChecked
    else
       fmMain.CBYour.State := cbUnChecked;
    fmMain.sDirToInspection := ReadString('Setup','SaveDirIns','c:\temp\');
    fmMain.sExtToInspection := ReadString('Setup','SaveExtIns','.html');
    fmMain.sInsReviewer := ReadString('Setup','SaveReviewerIns','<a href="mailto:yourname1@planetquake.com">yourname1</a>;<a href="mailto:yourname2@planetquake.com">yourname2</a>');

  finally
  free;
  end;
end;

procedure CloseUpIni;
{
 Close up the INI file. Save all values.
}
var
   iTemp : integer;
begin
  with TIniFile.Create(IniName) do
  try
     if fmMain.FormContainer1.Form = fmQuake then
     begin
          fmMain.sDirToQuake := fmQuake.txtDirTo.text;
          fmMain.sExtToQuake := fmQuake.txtExtTo.text;
          fmMain.sReviewer := fmQuake.txtReviewer.text;
     end
     else if fmMain.FormContainer1.Form = fmQuake2 then
     begin
          fmMain.sDirToQuake2 := fmQuake2.txtDirTo.text;
          fmMain.sExtToQuake2 := fmQuake2.txtExtTo.text;
          fmMain.sReviewer := fmQuake2.txtReviewer.text;
     end
     else if fmMain.FormContainer1.Form = fmInspection then
     begin
          fmMain.sDirToInspection := fmInspection.txtDirTo.text;
          fmMain.sExtToInspection := fmInspection.txtExtTo.text;
          fmMain.sInsReviewer := fmInspection.txtReviewer.text;
     end;

     WriteString('Setup','SaveDirQuake',fmMain.sDirToQuake);
     WriteString('Setup','SaveDirQuake2',fmMain.sDirToQuake2);
     WriteString('Setup','SaveExtQuake',fmMain.sExtToQuake);
     WriteString('Setup','SaveExtQuake2',fmMain.sExtToQuake2);
     WriteString('Setup','SaveReviewer',fmMain.sReviewer);

     if fmMain.RBHTML.Checked = True then
        iTemp := 1
     else if fmMain.RBCSS.Checked = True then
        iTemp := 2
     else
        iTemp := 1;
     WriteInteger('Setup','SaveReviewType',iTemp);

     if fmMain.CBYour.State = cbUnChecked then
        iTemp := 1
     else if fmMain.CBYour.State = cbChecked then
        iTemp := 2
     else
        iTemp := 1;
     WriteInteger('Setup','SaveYourReview',iTemp);

     WriteString('Setup','SaveDirIns',fmMain.sDirToInspection);
     WriteString('Setup','SaveExtIns',fmMain.sExtToInspection);
     WriteString('Setup','SaveReviewerIns',fmMain.sInsReviewer);

  finally
    free;
  end;
end;

procedure DeleteReview(which : integer);
{
 When you click on Delete button on Reviews done screen this procedure is called.
 All it does is move all the records down 1, overwriting the one you didn't want.
 Its not prefect but it works!
}
var
   counter, counter2 : integer;
begin
     x1 := fmOldRvw.ListBox1.ItemIndex;
     x2 := fmOldRvw.ListBox1.ItemIndex;
     if which = 1 then
     begin
        for counter2 := 0 to MAX do
        begin
             if counter2 > x1 then
             begin
                  Rvw1[counter2 - 1].Which := Rvw1[counter2].Which;
                  Rvw1[counter2 - 1].sFileName := Rvw1[counter2].sFileName;
                  Rvw1[counter2 - 1].sDirTo := Rvw1[counter2].sDirTo;
                  Rvw1[counter2 - 1].sExtTo := Rvw1[counter2].sExtTo;
                  Rvw1[counter2 - 1].sMapName := Rvw1[counter2].sMapName;
                  Rvw1[counter2 - 1].sAuthor := Rvw1[counter2].sAuthor;
                  Rvw1[counter2 - 1].sFileSize := Rvw1[counter2].sFileSize;
                  Rvw1[counter2 - 1].sPlayers := Rvw1[counter2].sPlayers;
                  Rvw1[counter2 - 1].nolines := Rvw1[counter2].nolines;
                  for counter := 0 to Rvw1[counter2].nolines do
                  begin
                       Rvw1[counter2 - 1].arrReview[counter] := Rvw1[counter2].arrReview[counter];
                  end;
                  Rvw1[counter2 - 1].sCaption1 := Rvw1[counter2].sCaption1;
                  Rvw1[counter2 - 1].sCaption2 := Rvw1[counter2].sCaption2;
                  Rvw1[counter2 - 1].sSmall1 := Rvw1[counter2].sSmall1;
                  Rvw1[counter2 - 1].sLarge1 := Rvw1[counter2].sLarge1;
                  Rvw1[counter2 - 1].sSmall2 := Rvw1[counter2].sSmall2;
                  Rvw1[counter2 - 1].sLarge2 := Rvw1[counter2].sLarge2;
                  Rvw1[counter2 - 1].sAuthorEmail := Rvw1[counter2].sAuthorEmail;
                  Rvw1[counter2 - 1].sAuthorWeb := Rvw1[counter2].sAuthorWeb;
                  Rvw1[counter2 - 1].sDownload := Rvw1[counter2].sDownload;
                  Rvw1[counter2 - 1].sScore := Rvw1[counter2].sScore;
                  Rvw1[counter2 - 1].iIndex1 := Rvw1[counter2].iIndex1;
                  Rvw1[counter2 - 1].Time := Rvw1[counter2].Time;
                  Rvw1[counter2 - 1].Date := Rvw1[counter2].Date;
             end; { if counter2 > x1 then}
        end; { for counter2 := 0 to MAX do}
        i1 := i1 - 1;
     end
     else if which = 2 then
     begin
        for counter2 := 0 to MAX do
        begin
             if counter2 > x2 then
             begin
                  Rvw2[counter2 - 1].Which := Rvw2[counter2].Which;
                  Rvw2[counter2 - 1].sFileName := Rvw2[counter2].sFileName;
                  Rvw2[counter2 - 1].sDirTo := Rvw2[counter2].sDirTo;
                  Rvw2[counter2 - 1].sExtTo := Rvw2[counter2].sExtTo;
                  Rvw2[counter2 - 1].sMapName := Rvw2[counter2].sMapName;
                  Rvw2[counter2 - 1].sAuthor := Rvw2[counter2].sAuthor;
                  Rvw2[counter2 - 1].sFileSize := Rvw2[counter2].sFileSize;
                  Rvw2[counter2 - 1].sPlayers := Rvw2[counter2].sPlayers;
                  Rvw2[counter2 - 1].nolines := Rvw2[counter2].nolines;
                  for counter := 0 to Rvw2[counter2].nolines do
                  begin
                       Rvw2[counter2 - 1].arrReview[counter] := Rvw2[counter2].arrReview[counter];
                  end;
                  Rvw2[counter2 - 1].sCaption1 := Rvw2[counter2].sCaption1;
                  Rvw2[counter2 - 1].sCaption2 := Rvw2[counter2].sCaption2;
                  Rvw2[counter2 - 1].sSmall1 := Rvw2[counter2].sSmall1;
                  Rvw2[counter2 - 1].sLarge1 := Rvw2[counter2].sLarge1;
                  Rvw2[counter2 - 1].sSmall2 := Rvw2[counter2].sSmall2;
                  Rvw2[counter2 - 1].sLarge2 := Rvw2[counter2].sLarge2;
                  Rvw2[counter2 - 1].sAuthorEmail := Rvw2[counter2].sAuthorEmail;
                  Rvw2[counter2 - 1].sAuthorWeb := Rvw2[counter2].sAuthorWeb;
                  Rvw2[counter2 - 1].sDownload := Rvw2[counter2].sDownload;
                  Rvw2[counter2 - 1].sScore := Rvw2[counter2].sScore;
                  Rvw2[counter2 - 1].sSign := Rvw2[counter2].sSign;
                  Rvw2[counter2 - 1].iIndex1 := Rvw2[counter2].iIndex1;
                  Rvw2[counter2 - 1].iIndex2 := Rvw2[counter2].iIndex2;
                  Rvw2[counter2 - 1].Time := Rvw2[counter2].Time;
                  Rvw2[counter2 - 1].Date := Rvw2[counter2].Date;
             end; { if counter2 > x1 then}
        end; { for counter2 := 0 to MAX do}
        i2 := i2 - 1;
     end;
end;

procedure CopyFile(File1, File2 : String);
{
 No I didn't write this. Copied it from an example I have.
 Its used when you delete the reviews. The reviews are backup first.
}
var
  SrcFile, DestFile: File;
  BytesRead, BytesWritten, TotalRead: Integer;
  Buffer: array[1..500] of byte;
  FSize: Integer;
begin
  { Assign both the source and destination files to their
    respective file variables }
  fmProgress.show;
  fmProgress.Caption := 'Backing Up ' + File1;

//  fmProgress.ProgressBar1.Clear;
  AssignFile(SrcFile, File1);
  AssignFile(DestFile, File2);
  // Open the source file for read access.
  Reset(SrcFile, 1);
  try
    // Open destination file for write access.
    Rewrite(DestFile, 1);
    try
      { Encapsulate this into a try..except so that we can erase the file if
        an error occurs. }
      try
        // Initialize total bytes read to zero.
        TotalRead := 0;
        // Obtain the filesize of the source file
        FSize := FileSize(SrcFile);
        { Read SizeOf(Buffer) bytes from the source file
          and add these bytes to the destination file. Repeat this
          process until all bytes have been read from the source
          file. A progress bar is provided to show the progress of the
          copy operation. }
        repeat
          BlockRead(SrcFile, Buffer, SizeOf(Buffer), BytesRead);
          if BytesRead > 0 then
          begin
            BlockWrite(DestFile, Buffer, BytesRead, BytesWritten);
            if BytesRead <> BytesWritten then
              raise Exception.Create('Error copying file')
            else begin
              fmProgress.ProgressBar1.Position := Trunc(TotalRead / Fsize) * 100;
              fmProgress.ProgressBar1.Update;
            end;
          end
        until BytesRead = 0;
      except
        { On an exception, erase the destination file as it may be
          corrupt. Then re-raise the exception. }
        Erase(DestFile);
        raise;
      end;
    finally
      CloseFile(DestFile); // Close the destination file.
    end;
  finally
    CloseFile(SrcFile);   // Close the source file.
  end;
  fmProgress.hide;
end;

end.
