(**************************************************************************
MPQ Input
Creates Quake and Quake 2 reviews for use at Multiplayer Quake
http://www.planetquake.com/mpq/
Also creates reviews for Inspection
http://www.planetquake.com/inspection/

Copyright (C) 1999 Paul Healey

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Paul Healey by e-mail:
phealey@planetquake.com
paulhealey@lineone.net

Program:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput.zip
Source code:
http://asp.planetquake.com/dl/dl.asp?mpq/mpqinput_src.zip
Inspection Pak (Review Graphics):
http://asp.planetquake.com/dl/dl.asp?mpq/ins-pak.zip
**************************************************************************)

unit OldRvwU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TfmOldRvw = class(TForm)
    ListBox1: TListBox;
    Panel1: TPanel;
    bnClose: TBitBtn;
    bnCopy: TBitBtn;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    bnCreate: TBitBtn;
    bnDelete: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure bnCloseClick(Sender: TObject);
    procedure bnCopyClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure bnDeleteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    which : integer;
    procedure RetReview(iType : integer);
  end;

var
  fmOldRvw: TfmOldRvw;


implementation

uses codeU, quakeU, quake2U, inspectionU;

{$R *.DFM}
procedure TfmOldRvw.RetReview(iType : integer);
var
   sFileName1, sFileName2 : string;
begin
{
 iType ... 1 = Retrieve Review
           2 = Delete Review
}
     codeU.x1 := 1;
     codeU.x2 := 1;
     codeU.x3 := 1;
     if iType = 1 then
     begin
          RetrieveReview(which);
          if which = 1 then
          begin
                  if fmQuake.bnClear.Enabled = false then
                  begin
                       fmQuake.bnClear.Enabled := true;
                       codeU.i1 := codeU.i1 - 1;
                  end
          end
          else if which = 2 then
          begin
               if fmQuake2.bnClear.Enabled = false then
               begin
                    fmQuake2.bnClear.Enabled := true;
                    codeU.i2 := codeU.i2 - 1;
               end
          end
          else if which = 5 then
          begin
               if fmInspection.bnClear.Enabled = false then
               begin
                    fmInspection.bnClear.Enabled := true;
                    codeU.i3 := codeU.i3 - 1;
               end;
          end;

     end
     else if iType = 2 then
     begin
          if which = 1 then
          begin
               sFileName1 := 'Quake.DAT';
               sFileName2 := 'Quake.BAK';
          end
          else if which = 2 then
          begin
               sFileName1 := 'Quake2.DAT';
               sFileName2 := 'Quake2.BAK';
          end;

          CopyFile(sFileName1, sFileName2);
          DeleteReview(which);
          SaveSession(which);
     end;

end;

procedure TfmOldRvw.FormShow(Sender: TObject);
begin
     fmOldRvw.ListBox1.Clear;
     if which = 5 then
        bnDelete.Visible := false
     else
        bnDelete.Visible := true;

     GiveIt(which);
end;

procedure TfmOldRvw.bnCloseClick(Sender: TObject);
begin
     fmOldRvw.Close;
end;

procedure TfmOldRvw.bnCopyClick(Sender: TObject);
begin
    RetReview(1);
end;

procedure TfmOldRvw.ListBox1DblClick(Sender: TObject);
begin
     RetReview(1);
end;

procedure TfmOldRvw.bnDeleteClick(Sender: TObject);
begin
     RetReview(2);
     fmOldRvw.ListBox1.Clear;
     x1 := -1;
     x2 := -1;
     x3 := -1;
     GiveIt(which);

end;

end.
