/*
**  simple VECTOR class
**
**  (c) 1997, mike warren
**  mikeBot
**
*/

#ifndef _VECTOR_H_
#define _VECTOR_H_

#include "defines.h"

#define FPERROR 0.0001
#define _PI 3.1415926535897932846
#define _PI2 1.57079632679489661923

#define FABS(x) (((x) > (double)0.0) ? (x) : (-x))

class vector
{
public:
  double x, y, z;


public:
  vector() {}
  vector( int ) { x=(double)0; y=(double)0; z=(double)0; }  /* for stack compatability */
  vector( double a, double b, double c ) { x=a; y=b; z=c; }
//  vector( vector& a ) { x=a.x; y=a.y; z=a.z; }
  ~vector() {}

  vector operator + (vector &);	// wheee...add two vectors
  vector operator - (vector &);	// subtract two (duh)
  vector operator - ();		// unary minus (negate)
  double operator * (const vector &);	// dot product, really
  void operator /= ( double ); // divide by a scaler
  void operator *= ( double a ) { x *=a; y *= a; z *= a; }
  void operator += (vector &);
  void operator -= (vector &);
  vector X ( vector &);		// cross product

  void scale( double x );		// make the vector x long

  void normalize();		// normalize vector
  double length();		// get its length
  double length2();		// length squared

  void set( double a, double b, double c ) { x=a; y=b; z=c; }
  void setx( double a ) { x=a; }
  void sety( double a ) { y=a; }
  void setz( double a ) { z=a; }
  void setFromPY( double, double );

  int operator == (const vector & r) { return (x==r.x && y==r.y && z==r.z); }
  int operator != (vector & r) { return !( *this == r ); }
  int close (const vector & r) { return ( (FABS(x-r.x) < FPERROR) && (FABS(y-r.y) < FPERROR) && (FABS(z-r.z) < FPERROR) ); }
  int xequal (vector & r) { return( x==r.x ); }
  int yequal (vector & r) { return( y==r.y ); }
  int zequal (vector & r) { return( z==r.z ); }
  double getx(){ return x; }
  double gety(){ return y; }
  double getz(){ return z; }

  double getYaw();
  double getPitch();
  double getRoll(){return (double)0;}

				// this outputs like (%f, %f, %f)

				// these input/output compatable with vec3_t
				// in quake

  vector intersectWithPlane( vector &, vector &, vector & );

  void print();

};

#endif

  
