/*
**  simple VECTOR class
**
**  (c) 1997, mike warren
**  mikeBot
**
**
*/


#include "vector.h"
#include <math.h>		// for sqrt()
#include <stdio.h>

//
//  scale : makes the vector x units in length
//
//  TODO : make me better?
//

void vector::scale( double a )
{
  normalize();
  (*this) *= a;
}

//
//  makeFromPY : initializes the vector from the pitch, yaw passed
//

void vector::setFromPY( double p, double yy )
{
  double yaw = yy;
  double pitch = p;

  yaw += (double)180.0;
  yaw = (double)fmod( yaw, (double)360.0 );
  yaw = ((double)_PI/(double)180.0)*yaw;
  pitch = ((double)_PI/(double)180.0)*pitch;

  y = (double)sin( yaw );
  x = (double)cos( yaw );
  z = (double)0.0;

}


//
// print() to stdout
//

void vector::print()
{
  printf("(%f, %f, %f)", x, y, z);
}

//
//  operator + () : add two vectors
//

vector vector::operator + (vector & rhs)
{
  vector r;

  r.x = x+rhs.x;
  r.y = y+rhs.y;
  r.z = z+rhs.z;

  return r;
}

//
//  operator - () : substract *this from rhs
//

vector vector::operator - (vector & rhs)
{
  vector r;

  r.x = x - rhs.x;
  r.y = y - rhs.y;
  r.z = z - rhs.z;

  return r;
}

//
//  operator - () : negate vector
//


vector vector::operator - ( )
{
  return vector( -x, -y, -z );
}


//
//  operator * () : dot product
//

double vector::operator * (const vector & rhs)
{
  double r=(double)0;

  r += x * rhs.x;
  r += y * rhs.y;
  r += z * rhs.z;

  return r;
}


//
//  X() : return cross product of *this and rhs
//

vector vector::X( vector & rhs )
{
  vector r;

  r.x = (y * rhs.z) - (z * rhs.y);
  r.y = -((x * rhs.z) - (z * rhs.x));
  r.z = (x * rhs.y) - (y * rhs.x);

  return r;
}


//
// normalize() : normalized the current vector. no return value.
//

void vector::normalize()
{
  double length = this->length();

  x = x / length;
  y = y / length;
  z = z / length;
}

void vector::operator /= ( double n )
{
  if( n==0.0)
    return;
  x /= n;
  y /= n;
  z /= n;
}

void vector::operator += ( vector & v )
{
  x += v.x;
  y += v.y;
  z += v.z;
}

void vector::operator -= ( vector & v )
{
  x -= v.x;
  y -= v.y;
  z -= v.z;
}
  


//
// length() : duh
//

double vector::length()
{
  double length;
  length = x*x + y*y + z*z;
  length = (double)sqrt(length);
  return length;
}

//
//  length2() : length squared
//

double vector::length2()
{
	double r = x*x + y*y + z*z;
	if( r < (double)0.0 ) 
		r = -r;

	return r;
}

//
//  getYaw : returns yaw represented by vector. thanks to the terminator 
//	     code :)
//

double vector::getYaw()
{

  double yaw;
  int flipv=TRUE;
  int fliph=TRUE;
  double X=x,Y=y;

  if(Y<0) Y=-Y; else flipv=FALSE;
  if(X<0) X=-X; else fliph=FALSE;

  if(X<Y)        yaw = (double)_PI2 - (double)atan(X/Y);
  else if(X>0.0) yaw = (double)atan(Y/X);
  else           yaw = (double)0;
  if(fliph==TRUE) yaw = (double)_PI - yaw;
  if(flipv==TRUE) yaw = -yaw;
  yaw = (double)fmod(yaw, 2*(double)_PI);
  yaw = ((double)180/(double)_PI)*yaw;

	yaw += (double)180.0;
	yaw = (double)fmod( yaw, (double)360.0 );

  return yaw;

}

//
//  getPitch : returns the pitch represented by the vector. terminator again
//

double vector::getPitch()
{ 
  double tilt;
  int flipv=TRUE;
  double X=(double)sqrt(x*x+y*y);
  double Z=z;

  if(Z<0) Z=-Z; else flipv=FALSE;
  if(X<0) X=-X;
  if(X<Z)        tilt = (double)_PI2 - (double)atan(X/Z);
  else if(X>0.0) tilt = (double)atan(Z/X);
  else           tilt = (double)0;
  if(flipv==TRUE) tilt = -tilt;

  return ((double)180/(double)_PI) * tilt;

}

//
//  intersectWithPlane
//
//  assumes the vector is in the right direction
//

vector vector::intersectWithPlane( vector & p1, vector & p0, vector & n )
{
	double t = n.x*p0.x + n.y*p0.y + n.z*p0.z - n.x*p1.x - n.y*p1.y - n.z*p1.z;
	t /= ( n.x*x + n.y*y + n.z*z );

	vector r = p1;

	r.x += x*t;
	r.y += y*t;
	r.z += z*t;

	return r;
}

