/*
**
**  STACK
**
**  (c) 1997 mike warren
**  mikeBot
**
**  wheee, its a stack
**
*/


#ifndef _STACK_H_
#define _STACK_H_

#define STACK_SIZE 1024

#include "defines.h"

template< class T >
class stack
{
  int size;
  T * items;
  int maxSize;

  void growStack()
  {
	  T * n = new T[ maxSize+STACK_SIZE ];
	  for( int i=0; i < maxSize; i++ )
		  n[ i ] = items[ i ];
	  delete[] items;
	  items = n;
  }
  
public:

  stack() 
  { 
	  size=STACK_SIZE; 
	  items = new T[ STACK_SIZE ];
	  maxSize=STACK_SIZE; 
  }
  ~stack() { delete[] items; }

  int push( T x ) 
  { 
	  if( size>=maxSize) 
		  growStack();
	  items[size++]=x; 
	  return TRUE; 
  }
  T pop() 
  { 
	  if( !isEmpty() )
		  return items[--size]; 
	  return 0; 
  }
  T peek()
  { 
	  if( !isEmpty() ) 
		  return items[ size-1 ]; 
	  return 0; 
  }

  const int getSize() const { return size; }
  const int isEmpty() const { return (size==0); }
};


#endif
