/*
**
**  QPROXY
**
**  (c) 1997 mike warren
**  mikeBot
**
**
**  proxy communicates with client on its own socket...
**
**  TODO : fix reliable probs. lag problems, too?
**
*/


#ifndef _QPROXY_H_
#define _QPROXY_H_

#if QPROXY


#include "defines.h"
#include "qsocket.h"
#include "qpacket.h"
#include "csdefs.h"
#include "scdefs.h"
#include "qack.h"

struct qpclient
{
  qsocket * sock;		// this client's socket
  qack ackQueue;		// reliable packet queue
  int port;			// NOT 26000

  char name[ Q_MAX_STRING ];	// clients name (send during prespawn)

  int cl_particle;		// target particles on/off
  int cl_statusbar;		// status bar on/off
  int cl_lockview;		// locked view on/off

  int haveConnection;		// TRUE iff client has connected
  int sendable;			// TRUE if signonlevel == 3

  int outgoingUnreliable, outgoingReliable;
  int incomingUnreliable, incomingReliable;

  void reset()
    {
      if( sock )
	delete sock;
      sock = 0;
      port = 0;
      name[0]=0;
      outgoingUnreliable=outgoingReliable=incomingReliable=incomingUnreliable=0;
      haveConnection=sendable=FALSE;
      cl_particle=cl_statusbar=0;
      cl_lockview=TRUE;
      ackQueue.clear();
    }
  qpclient() 
    { 
      ackQueue.setTimeout( 80 );
      sock = 0;
      reset();
    }
  ~qpclient() { delete sock; }
};


class qproxy
{

  qsocket * sock;		// main listen socket (on port 26000)

  int connectedClients;		// number connected
  int maxClients;		// maximum (CHANGEME)
  int cc;			// current client (to ease parameters)
  int masterClient;		// this client controls status bar,etc

  qpclient clients[ QX_MAX_CLIENTS ];

  struct in_addr client;
  char * serverIP;
  char clientIP[ Q_MAX_STRING ];
  hostent * clientName;

  qpacket inPacket;
  qpacket outPacket;
  qpacket spawn1;
  qpacket spawn2;
  qpacket spawn3;
  
  int numPrespawns;

  qproxy( qproxy & );		// copying is a no-no

  int receive( char * b, int s ){ return sock->receive( b, s); }
  int clientReceive( char * b, int s ){ return clients[cc].sock->receive( b, s); }

  int sendToAll( qpacket & qp );
  int sendToClient( int client, qpacket & qp );
  int splitAndSend( int, qpacket & );

  int decodePacket( qpacket & );
  int decodeControl( qpacket & );
  int decodeReliable( qpacket & );
  int decodeUnreliable( qpacket & );
  int decodeAcknowledge( qpacket & );

public:

  qproxy( int max, int port=26000 );
  ~qproxy() { delete sock; }

  void update();

  void prespawn1( qpacket & q ) { spawn1.copy(q); numPrespawns=1; }
  void prespawn2( qpacket & q ) { spawn2.copy(q); numPrespawns=2; }
  void prespawn3( qpacket & q ) { spawn3.copy(q); numPrespawns=3; }
  
  int connected() { return connectedClients; }
  int freeClient() { return (connectedClients < QX_MAX_CLIENTS); }
  int findOpenClient() { for( int i=0; i < QX_MAX_CLIENTS; i++ ) if( !clients[i].haveConnection ) return i; return -1; }

  int clientParticle() { if( masterClient >= 0 ) return clients[masterClient].cl_particle; else return FALSE; }
  int clientStatus() { if( masterClient >= 0 ) return clients[masterClient].cl_statusbar; else return FALSE; }
  int clientLockview() { if( masterClient >= 0 ) return clients[masterClient].cl_lockview; else return FALSE; }

				// this sends to ALL connected clients
				// use for update packets

  int send( qpacket & qp );
  int sendReliable( qpacket & qp );
  void sayClient( char * x );
  void dumpClients();		// prints info on each client
  void kickClient( int );
  void destroyClient( int );
  char * getClientName( int x ) { if( x < QX_MAX_CLIENTS ) return clients[x].name; return ""; }

};

#endif

#endif
  




