/*
**
**  QPACKET class : mikeBot : mike warren, 1997
**
**  handles construction and deconstruction (with endianess) of packets. 
**
**  readLE<type>() returns a <type> assuming it was in little-endain order
**  readBE<type>() ditto, but assumes the data at current position is big-endian
**
**  addLE<type>( arg ) adds a <type> thinking arg should go in in little endian
**  addBE<type>( arg ) same, but puts it in in big-endian order.
**
**  other add* and read* (addString, addByte, etc.) don't require endianess
**  convertion.
**
*/


#ifndef _QPACKET_H_
#define _QPACKET_H_

#include <stdio.h>
#include <memory.h>		// memcpy
#include <string.h>

#include "defines.h"
#include "vector.h"

class qsocket;

class qpacket
{
public:

  enum type { control, reliableFragment, reliableEnd, acknowledge,
	      unreliable, unknown };

private:

  int size;		// total size of **data ONLY**
  int maxSize;		// total size of allocated memory in *data
  int readPos;		// where in data are we (for read()s)
  int writePos;		// for write()'s
  unsigned char * data;		// the actual data (duh)
  type pType;		// the type of packet

  unsigned char t1[ 4 ];		// used for endianess convertions
  unsigned char t2[ 4 ];		// ditto

public:

  qpacket( int x=QP_MAX_PACKET_DATA );	// ctor
  void copy( qpacket & );			// copy ctor
  ~qpacket() { delete[] data; }		// dtor

  void reset () { size=0; readPos=4; writePos=4; pType = unknown; }

  int write( FILE *, int x, vector & );

  int init();			// updates pType and size from the data
				// in the packet. USE ONLY AFTER FILLING
				// THE *DATA from, say, a socket read
  int update();			// adds header to packet (i.e. makes it
				// ready to send; uses pType)
  type getType() { return pType; }	// qpacket::type

  void dumpHex() { for( int i=0; i < size+4; i++) printf("%02x ", data[i] ); }
  void dumpChar() { for( int i=0; i < size+4; i++) printf("%c", data[i] ); }

  void changeType( type x ) { pType = x; }
  void setReadPos( int x ) { if (x < maxSize) readPos = x; }
  void setWritePos( int x ) { if (x < maxSize) writePos = x; }
  void ffwd() { writePos = size+4; }


		///
		///  ! WARNING ! : DO NOT use this unless you know EXACTLY what
		///	               you are doing...
		///

  void changeSize( int x ) { size += x; }
  void truncate() { size = writePos; }

			// send the packet. CALLS UPDATE() INTERNALLY

  int send( qsocket * );

  int getSize() { return size; }
  int getReadPos() { return readPos; }
  int getWritePos() { return writePos; }
  int getMaxSize() { return maxSize; }
  unsigned char * getBuffer() { return data; }
  int getNumber();
  int changeNumber( int );

  void updateData( unsigned char *, int );

		// read functions grab the next 1 to 4 bytes and return
		// ready-to-use numbers, adjusted according to endianess 
		// *LE*() functions read the data assuming it is in little
		// endian order in the network stream, and fix it depending
		// on what the host system is

  int readLEint();
  int readBEint();
  short readLEshort();
  short readBEshort();
  float readLEfloat();
  float readBEfloat();
//  char readByte() { return (readPos<size+4) ? data[ readPos++ ] : (char)-1; }
  unsigned char readByte() 
  { 
	  if( readPos < maxSize ) 
		  return (unsigned char)data[ readPos++ ]; 
	  else 
	  { 
		  return 0; 
	  } 
  }
  float readAngle();
  float readCoord();

  char * readString();    // `delete' char * when you're done with it:
			  // (i.e. printf( qpacket::readString() ); will
			  // leak memory...)
  
		// add{BL}E* functions work basically the same as the read fn's

  void addLEint( int );
  void addBEint( int );
  void addLEshort( short );
  void addBEshort( short );
  void addLEfloat( float );
  void addBEfloat( float );
  void addByte( unsigned char x ) 
	{ 
	  if( writePos < maxSize ) 
	  { 
		  data[writePos++] = x; size++;
	  } 
    }
  void addData( unsigned char * x, int s );
  void addAngle( float );
  void addCoord( float );
  void addString( char * );

  qpacket & operator += ( qpacket & );		// WARNING - see doc

};



  
	
	


#endif
