/*
**
**  QENTITY class
**
**  (c) 1997, mike warren
**  mikeBot
**
**  keeps track of where, what different entities are.
**
*/

#ifndef _QENTITY_H_
#define _QENTITY_H_

#include "defines.h"
#include "vector.h"

//
//  TODO : convert the index into a type through the modeltable[] entry
//

class qentity
{
public:

  int index;			// into modeltable[]
  int default_index;
  int frame;			// model's frame (usefull for determing
						// weather player is dead)
  int skin;				// good for determining armour type
  
  vector origin;		// center of entity
  vector facing;		// which way is it looking?
  vector velocity;		// how fast, which direction moving?

  int spawned;			// TRUE/FALSE if spawnbaseline recieved for this

  float lastTime;		// last timestamp update received

  float rate;			// for MBNAV and MBFIRE
  float rateMultiplier; // for MBNAV
  int shootable;		// used by MBFIRE


  qentity() { index=-1;frame=0;skin=0;origin.set((float)0,(float)0,(float)0);facing.set((float)0,(float)0,(float)0);lastTime=(float)0.0; rate=(float)0.0; rateMultiplier=(float)0.0; spawned=FALSE; shootable=FALSE; }
	  
  void updateOrigin( vector & v, float t1, float t2 ) { velocity = v - origin; origin = v; velocity /= (t2 - t1); }

};


#endif
