/*
**  QACK class
**
**  (c) 1997, mike warren
**  mikeBot
**
**  handles resending of reliable client-server packets. Call QACK::resend()
**  every second or so...#defined as QACK_TIMEOUT
**
**
*/

#ifndef _QACK_H_
#define _QACK_H_

#include "qpacket.h"
#include "qsocket.h"

#if !WIN32
#include <sys/time.h>
#endif

class qack
{

  qpacket packets[ QACK_MAX ];
  int packetNumbers[ QACK_MAX ];
  int size;
  int tail;
  int head;

  int MaxTimeout;
  
  int lastSend;
  int current;

  int deletePacket();

public:

  qack();
  ~qack(){}

  int addPacket( qpacket &, qsocket * );
  int gotAck( int, qsocket * );
  int resend( qsocket * );
  void clear() { head=0; tail=0; size=0; }

  void setTimeout( int x ) { MaxTimeout=x; }
  
  int isEmpty() { return (size==0); }
#if DEBUG & DQACK
  void dumpPacketNumbers();
#endif

};


#endif
