


#include "polygon.h"
#include <math.h>
#include <stdio.h>

/*
**  ctor
**
*/

polygon::polygon()
{
	oldVertices = -1;
	numVertices = 0;
	maxVertices = 8;
	vertices = new vector[ 8 ];
}

void polygon::realloc()
{
	vector * t = vertices;

	maxVertices += 8;
	if( maxVertices < 0 )
		printf("realloc: maxvertices < 0 \n");
	vertices = new vector[ maxVertices ];

	for( int i=0; i < maxVertices-8; i++ )
		vertices[ i ] = t[ i ];

	delete[] t;
}


/*
**  addVertex 
**
**  adds a new vertex
*/

void polygon::addVertex( vector & x )
{
	x.setz( (float)0.0 );

	if( oldVertices != numVertices-1 )
		fprintf(stderr, "polygon::addVertex(): numVertices inc'd > 1 (%d->%d)\n", oldVertices, numVertices );

	while( numVertices >= (maxVertices-1) )
	{
		realloc();
	}

	vertices[ numVertices ] = x;
	oldVertices = numVertices;
	numVertices++;
}

/*
**  dumpPoly
**
**  prints all polygon vertices.
*/

void polygon::dumpPoly()
{
  printf("dumpPoly(): %d points: ", numVertices );

  for( int i=0; i < numVertices; i++ )
	  vertices[ i ].print();

  printf("\n");
}

/*
**  pointIn
**
**  returns TRUE iff the point is inside the polygon
*/
	

int polygon::pointIn( vector & x )
{
  int r = pointInWithLine( x );

  if( r == 1 )
    return TRUE;
  else if ( r == 0 )
    return FALSE;
  else
    r = pointInByTurning( x );

  return r;
}

int polygon::pointInWithLine( vector & x )
{
  if( numVertices < 3 )
    return 0;

  vector start;
  vector end;
  int crossed=0;

  end = vertices[ numVertices-1 ];

  for( int i=0; i < numVertices; i++ )
    {
      start = end;
      end = vertices[ i ];

      if( x.gety() == start.gety() )		// vertex crossed
		  return 2;

      if( x.gety() > start.gety() && x.gety() < end.gety() )
	  {
		  if( x.getx() < start.getx() || x.getx() < start.gety() )
			  crossed++;
	  }
    }

  //  printf("polygon::pointInWithLine(): %d\n", crossed);

  if( crossed==1 )
    return 1;

  return 0;
}

int polygon::pointInByTurning( vector & x )
{
  if( numVertices < 3 )
    return FALSE;

  vector fv, lv;
  double angle=0.0, delta;
  
  fv = vertices[ numVertices-1 ] - x;

  for( int i=0; i < numVertices; i++ )
    {
      lv = vertices[ i ] - x;
      delta = ((fv * lv) / (fv.length() * lv.length()));
      //      printf("delta = %f\n", delta );
      angle += acos( delta );
      fv = lv;
    }

  if( angle > 6.28 && angle < 6.29 )
    return TRUE;

  return FALSE;
}

/*
**  getOrigin
**
**  returns the center of the polygon
**
*/


vector polygon::getOrigin()
{
	vector o;
	float n=(float)0.0;

	for( int i=0; i < numVertices; i++)
	{
		o += vertices[ i ];
		n += (float)1.0;
	}

	o /= n;

	return o;
}


