/*
**  options
**  mike warren 1997
**  mikeBot
**
*/




#include "options.h"

/*
**  ctor 
**
*/

options::options( int x )
{
  table = new char*[ x ];
  values = new int[ x ];
  elements = 0;
  tableSize = x;

  for( int i=0; i < x; i++ )
    table[ i ] = (char *)0;
}

/*
**  getHashValue
**
*/

int options::getHashValue( char * x )
{
  unsigned int r = 1;

  for( int i=0; x[ i ]; i++ )
    r *= (unsigned int)x[i];

  r = r % tableSize;
  
  return r;
}

/*
**  add
**
**  Add or change a value
**
*/

int options::add( char * x, int val )
{

  if( elements >= (tableSize-2) )
    return FALSE;
  else
    elements++;

  int r = getHashValue( x );

  if( table[ r ] == (char *)0 )
    {
      table[ r ] = new char[ strlen( x )+1 ];
      strcpy( table[r], x );
      values[ r ] = val;
      return TRUE;
    }

  while( table[ r ] != (char *)0 )
    {
      if( !(strcmp( table[ r ], x )) )
	{
	  values[ r ] = val;
	  return TRUE;
	}
      r++;
      r = r % tableSize;
    }


  table[ r ] = new char[ strlen( x )+1 ];
  strcpy( table[r], x );
  values[ r ] = val;

  return TRUE;
}

/*
**  find
**
**  find and return a value TRUE/FLASE is returned if value found or not
**
*/


int options::find( char * x, int * val )
{
  int r = getHashValue( x );

  while( 1 )
    {
      if( table[ r ] == (char *)0 )
	return -1;
      if( !(strcmp( table[ r ], x )) )
	{
	  if( val )
	    *val = values[ r ];
	  return r;
	}
      r++;
      r = r % tableSize;
    }
}

/*
**  remove
**
**  Erases a key-value pair
**
*/


int options::remove( char * x )
{
  int r;

  if( (r=find( x )) == -1 )
    return FALSE;

  delete table[r];
  table[r] = (char *)0;
  return TRUE;
}


/*
**  dumpToFile
**
**  Prints all strings and values to the file specified
**
*/

void options::dumpToFile( FILE * fp )
{
	fprintf( fp, "options\n{\n" );
	for( int i=0; i < tableSize; i++ )
	{
		if( table[ i ] )
		{
			fprintf( fp, "%s = %d\n", table[i], values[ i ] );
		}
	}
	fprintf( fp, "}\n");

}