/*
**  support class for bspFile
**  (c) 1997 mike warren
**
**  this code is *not* freeware. See the file ``README'' or contact
**  mbwarren@acs.ucalgary.ca
**
**  (excuse the rather long ::read() inlined functions, but i didn't feel like
**   having lotsa .cc files :) )
**
*/



#ifndef _NODES_H_
#define _NODES_H_


#include "defines.h"
#include "vector.h"
#include "mfile.h"


class bspNode
{
  int planeId;
  unsigned short front;
  unsigned short back;
  char frontIsLeaf;
  char backIsLeaf;
  vector bboxMin;
  vector bboxMax;
  unsigned short faceId;
  unsigned short faceNum;

  bspNode(){}

public:

  bspNode( mFile & mf ) { read( mf ); }

  void read( mFile & mf ) { planeId=mf.readLEint(); front=mf.readLEushort(); back=mf.readLEushort(); bboxMin.setx( (float)mf.readLEshort() ); bboxMin.sety( (float)mf.readLEshort() ); bboxMin.setz( (float)mf.readLEshort() ); bboxMax.setx( (float)mf.readLEshort() ); bboxMax.sety( (float)mf.readLEshort() ); bboxMax.setz( (float)mf.readLEshort() ); faceId=mf.readLEushort(); faceNum=mf.readLEushort(); if( front & 0x8000 ) { front = ~front; frontIsLeaf=TRUE;} else frontIsLeaf=FALSE; if( back & 0x8000 ) { back = ~back; backIsLeaf=TRUE; } else backIsLeaf=FALSE; }

  int getPlaneId() { return planeId; }
  int getFront() { return (int)front; }
  int getBack() { return (int)back; }
  vector getBboxMin() { return bboxMin; }
  vector getBboxMax() { return bboxMax; }
  int getFaceId() { return (int)faceId; }
  int getFaceNum() { return (int)faceNum; }
  int isFrontLeaf() { return frontIsLeaf; }
  int isBackLeaf() { return backIsLeaf; }

  void dump() { printf("%d %c:%d %c:%d ", planeId, (frontIsLeaf?'L':'N'), front, (backIsLeaf?'L':'N'), back); printf("%d %d\n", faceId, faceNum); }

};

class bspNodes
{
  bspNode ** nodes;
  int nodesLoaded;

  bspNodes(){}

public:
  
  bspNodes( mFile & mf, int n ) { nodes=new bspNode*[ n ]; for( int i=0; i < n; i++ ) nodes[i]=0; nodesLoaded=0; read( mf, n ); }
  ~bspNodes() { for( int i=0; i < nodesLoaded; i++) delete nodes[i]; delete[] nodes; }

  void read( mFile & mf, int n ) { for( int i=0; i < n; i++ ) nodes[i] = new bspNode( mf ); nodesLoaded=n; }

  bspNode * getNode( int x ) {if ( x>= 0 && x < nodesLoaded ) return nodes[x]; else return 0;}
  int getNum() { return nodesLoaded; }

  void dump() { for( int i=0; i < nodesLoaded; i++ ) nodes[i]->dump(); }
  

};


#endif
  
