/*
**  mpack
**  mike warren 1997
**
**  .PAK file reading capabilities. Makes use of mFile class, which
**  handles endianess convertion and buffering.
**
*/


#ifndef _MPACK_H_
#define _MPACK_H_

#include "defines.h"
#include "mfile.h"
#include "m_list.h"

class packEntry
{
protected:
  char * filename;
  int offset;
  int size;

  packEntry(){}

public:
  
  packEntry( mFile & mf ) { filename=0; read( mf ); }
  ~packEntry(){ delete filename; }

  void read( mFile & mf ) 
  { 
	  filename=(char *)mf.readChunk(0x38); 
	  offset=mf.readLEint(); 
	  size=mf.readLEint(); 
  }

  const char * getFilename() const { return filename; }
  const int getOffset() const { return offset; }
  const int getSize() const { return size; }

};



class packHeader
{
protected:
  int magic;
  int directoryOffset;
  int directorySize;

  packHeader(){}

public:
  packHeader( mFile & mf ) { read( mf ); }

  void read( mFile & mf ) 
  { 
	  magic=mf.readLEint(); 
	  directoryOffset=mf.readLEint(); 
	  directorySize=mf.readLEint(); 
	  if( magic != 0x4b434150 )			// magic is "PACK"
		  printf("not pack file\n"); 
  }

  const int getOffset() const { return directoryOffset; }
  const int getSize() const { return directorySize; }

};

class packFile
{
  int fd;			// file descriptor

  packHeader * ph;
  packEntry ** entries;
  int numDirEntries;

  packFile(){}

public:
  
  packFile( char * fname );
  ~packFile()
  { 
	  delete ph; 
	  for( int i=0; i < numDirEntries; i++) 
		  delete entries[i]; 
	  delete [] entries; 
  }

  mFile * getFile( char * );
  int getNum() { return numDirEntries; }

  void dumpDirectory(); 

};



class packList
{
private:
	m_list< packFile * > m_filelist; 

public:
	packList() {}
	~packList() {}

	int addPack( char * fname );

	mFile * getFile( char * fname )
	{
		mFile * file;
		if( !m_filelist.isEmpty() )
		{
			m_filelist.reset();
			do {
				file = (*m_filelist)->getFile( fname );
				if( file )
					return file;
			} while( ++m_filelist );
		}
		return (mFile *)0;
	}

};

#endif