/*
**
**  MBNAV class 
**
**  (c) 1997, mike warren
**  mikeBot
**
** 
**  NAVIGATION SKELETON CLASS: 
**
**    This class just picks the closest ammo or health and chases it; really
**    dumb, but hey; this stuff is free ;) Of course, *all* mikeBot code
**    will eventually be released.
**
**    If mbfire is targeting something, it'll chase that instead. Note that
**    navigation doesn't have to concern itself with what firecontrol is up
**    to, as the low-level routines take care of the nitty-gritty.
**
**  SUGGESTIONS FOR IMPROVEMENT:
**
**  . Directed-graph navigation
**  . Behavioral-based low-level routines (see 
**    http://www.cpsc.ucalgary.ca/~mwarren/bass for a bunch of behavioral
**    animation links).
**  . Probabilistic entity-tracking: give each entity a probability
**    of being present, from 0.0 (for definitly not there) to 1.0 (for
**    definitly there) and multiply target-ratings by this value.
**  . Make better target-rating scheme (i.e. the skeleton scheme just
**    makes the rating the inverse of the distance).
**
*/

#include "defines.h"
#include "mbnav.h"
#include <math.h>		// fmod()
#include <stdio.h>

/*
**  ctor
**
*/

mbnav::mbnav()
{ 
	mbn_facing.set( (double)0.0,(double)0.0,(double)0.0 ); 

	mbn_jump=10; 

	mbn_target = 0;
	mbn_oldTarget = 0;
}

/*
**  aimAt 
**
**  Changes facing to target the point passed
**
*/


int mbnav::aimAt( vector & v )
{
   mbn_facing = entities[myEntityNumber].origin - v;
   return TRUE;
}

/*
**  update 
**
**  picks a target and goes for it. If mbfire is tracking something, it
**  uses that as the target, otherwise picks the closest ammo or health.
**
**  As an added bonus, this also stops if lava is in the way.
**
*/

void mbnav::update()
{
  updateRatings();			// rate all visible targets
  aquireTarget();			// pick something interesting

  mbn_velocity = (double)320.0;

  b_avoidlava();			// stops if lava ahead.

			//
			//  attempt to jump if the target is above me
			//

  if( entities[mbn_target].origin.getz() - entities[myEntityNumber].origin.getz()  > 80.0 )
    if( !opts.get( "no-jump" ) )
      jump();	

			//
			// check for water
			//

  if( map.getCurrentLeafType() == 2 )
    if( !opts.get( "no-swim" ) )
      jump();

			//
			//  possibly cancel all the above stuff ;)
			//

  if( opts.get("no-move" ) )
    mbn_velocity = (double)0.0;

}

/*
**  updateRatings
**
**  Recalculates all the .rate and .rateMultiplier varaibles for every
**  entity;
**
**
*/

void mbnav::updateRatings()
{
  double rate;
  int i;
  vector tv0, tv1;

  for( i=info.maxPlayers; i < QCS_MAX_ENTITIES; i++ )
  {
	  rate = (double)0.0;
	  if(  isVisible( i ) && (isHealth( i ) || isAmmo( i ))  )
	  {
		  rate = (double)100.0;
	  }
	  else
		  rate = (double)0.0;

	  entities[ i ].rateMultiplier = (float)1.0;
	  entities[ i ].rate = (float)rate;
  }

}


/*
**  aquireTarget
**
**  gets a nav target. If fireTarget != 0, then it will only
**  go after something else if health/ammo low
**
**  CALL UPDATE RATINGS FIRST
**
*/


void mbnav::aquireTarget()
{
  double bestRate, rate;
  int bestTarget = 0;
  int i;

			//
			//  if firecontrol is targeting something, target the
			//  same thing
			//

  if( mbf_target )
  {
	  mbn_target = mbf_target;
	  return;
  }

  for( i=info.maxPlayers; i < QCS_MAX_ENTITIES; i++ )
  {
	  rate = entities[ i ].rate;

	  if( rate > bestRate )
	  {
		  bestRate=rate;
		  bestTarget = i;
	  }
  }

  if( bestTarget != mbn_target && bestTarget )
  {
	  mbn_oldTarget = mbn_target;
	  mbn_target = bestTarget;
#if DEBUG & DMBN
	  printf("mbnav::selectTarget(): new target `%s'\n", modeltable[ entities[mbn_target ].index ] );
#endif
  }
}




/*
**
**       BEHAVIOURS
**
**
*/

/*
**  b_avoidlava
**
**  Sets mbn_velocity to 0 if lava is ahead.
**
*/

void mbnav::b_avoidlava()
{
   vector tv0 = mbn_facing;
   vector tv1 = mbn_facing;

   tv0.normalize();
   tv0 *= (double)-64.0;
   tv0.setz( (double)0.0 );
   tv0 += entities[myEntityNumber].origin;
   vector tv02 = tv0;
   tv02.setz( -(double)32700.0 );
      
   tv1.normalize();
   tv1 *= (double)-96.0;
   tv1.setz( (double)0.0 );
   tv1 += entities[myEntityNumber].origin;
   vector tv12 = tv1;
   tv12.setz( -(double)32700.0 );
      
   if( map.isLineBlockedFluid( tv0, tv02, 0, opts.get( "avoid-water" ) ) ||
	   map.isLineBlockedFluid( tv1, tv12, 0, opts.get( "avoid-water" ) )   )
   {
	   // this is set to negative 'cause then if the bot is in the air,
	   // it'll stop forward motion (otherwise it won't). Really useful
	   // on e1m8

	   mbn_velocity = (double) -1.0;
   }
   
}

/*
**  cmd
**
**  see qcs::cmd()
**
*/

int mbnav::cmd( char * in )
{
	switch( in[0] )
	{
	case 'j':
		printf("Jump\n");
		forceJump();
		return TRUE;
		break;

		
    case 't':
		printf("Target : mbfire : ");
		mbf_printTarget();
		printf(" : mbnav : ");
		mbn_printTarget();
		printf("\n");
		return TRUE;
	    break;
	}

		
	return mbfire::cmd( in );
}